/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import java.util.ArrayList;

public class SegmentIntersector {
    private ArrayList<IntersectionPart> m_input_segments;
    private ArrayList<IntersectionPart> m_result_segments_1;
    private ArrayList<IntersectionPart> m_result_segments_2;
    private ArrayList<IntersectionPart> m_recycled_intersection_parts;
    private ArrayList<SegmentBuffer> m_recycled_segments;
    private double[] m_param_1 = new double[15];
    private double[] m_param_2 = new double[15];
    private Point m_point = new Point();
    private int m_used_recycled_segments = 0;
    private double m_tolerance = 0.0;

    private void recycle_(ArrayList<IntersectionPart> parts) {
        if (parts == null) {
            return;
        }
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            this.recycle_(parts.get(i));
        }
        parts.clear();
    }

    private void recycle_(IntersectionPart part) {
        part.seg = null;
        this.m_recycled_intersection_parts.add(part);
    }

    private IntersectionPart newIntersectionPart_(Segment _seg) {
        if (this.m_recycled_intersection_parts.isEmpty()) {
            IntersectionPart part = new IntersectionPart(_seg);
            return part;
        }
        IntersectionPart part = this.m_recycled_intersection_parts.get(this.m_recycled_intersection_parts.size() - 1);
        part.seg = _seg;
        this.m_recycled_intersection_parts.remove(this.m_recycled_intersection_parts.size() - 1);
        return part;
    }

    private IntersectionPart getResultPart_(int input_segment_index, int segment_index) {
        if (input_segment_index == 0) {
            return this.m_result_segments_1.get(segment_index);
        }
        assert (input_segment_index == 1);
        return this.m_result_segments_2.get(segment_index);
    }

    private SegmentBuffer newSegmentBuffer_() {
        if (this.m_used_recycled_segments >= this.m_recycled_segments.size()) {
            this.m_recycled_segments.add(new SegmentBuffer());
        }
        SegmentBuffer p = this.m_recycled_segments.get(this.m_used_recycled_segments);
        ++this.m_used_recycled_segments;
        return p;
    }

    public SegmentIntersector() {
        this.m_input_segments = new ArrayList();
        this.m_result_segments_1 = new ArrayList();
        this.m_result_segments_2 = new ArrayList();
        this.m_recycled_intersection_parts = new ArrayList();
        this.m_recycled_segments = new ArrayList();
    }

    public void clear() {
        this.recycle_(this.m_input_segments);
        this.recycle_(this.m_result_segments_1);
        this.recycle_(this.m_result_segments_2);
        this.m_used_recycled_segments = 0;
    }

    public int pushSegment(Segment seg) {
        assert (this.m_input_segments.size() < 2);
        this.m_input_segments.add(this.newIntersectionPart_(seg));
        return this.m_input_segments.size() - 1;
    }

    public void setRankAndWeight(int input_segment_index, double start_weight, int start_rank, double end_weight, int end_rank, int interior_rank) {
        IntersectionPart part = this.m_input_segments.get(input_segment_index);
        part.rank_end = end_rank;
        part.weight_start = start_weight;
        part.weight_end = end_weight;
        part.rank_start = start_rank;
        part.rank_end = end_rank;
        part.rank_interior = interior_rank;
    }

    public int getResultSegmentCount(int input_segment_index) {
        if (input_segment_index == 0) {
            return this.m_result_segments_1.size();
        }
        assert (input_segment_index == 1);
        return this.m_result_segments_2.size();
    }

    public Segment getResultSegment(int input_segment_index, int segment_index) {
        return this.getResultPart_((int)input_segment_index, (int)segment_index).seg;
    }

    public Point getResultPoint() {
        return this.m_point;
    }

    public boolean intersect(double tolerance, boolean b_intersecting) {
        if (this.m_input_segments.size() != 2) {
            throw GeometryException.GeometryInternalError();
        }
        this.m_tolerance = tolerance;
        double small_tolerance_sqr = MathUtils.sqr(tolerance * 0.01);
        boolean bigmove = false;
        IntersectionPart part1 = this.m_input_segments.get(0);
        IntersectionPart part2 = this.m_input_segments.get(1);
        if (b_intersecting || (part1.seg._isIntersecting(part2.seg, tolerance, true) & 5) != 0) {
            if (part1.seg.getType().value() == 322) {
                Line line_1 = (Line)part1.seg;
                if (part2.seg.getType().value() == 322) {
                    Line line_2 = (Line)part2.seg;
                    int count = Line._intersectLineLine(line_1, line_2, null, this.m_param_1, this.m_param_2, tolerance);
                    if (count == 0) {
                        assert (count > 0);
                        throw GeometryException.GeometryInternalError();
                    }
                    Point2D[] points = new Point2D[9];
                    for (int i = 0; i < count; ++i) {
                        double ptWeight;
                        Point2D pt_1;
                        double t1 = this.m_param_1[i];
                        double t2 = this.m_param_2[i];
                        int rank1 = part1.rank_interior;
                        double weight1 = 1.0;
                        if (t1 == 0.0) {
                            rank1 = part1.rank_start;
                            weight1 = part1.weight_start;
                        } else if (t1 == 1.0) {
                            rank1 = part1.rank_end;
                            weight1 = part1.weight_end;
                        }
                        int rank2 = part2.rank_interior;
                        double weight2 = 1.0;
                        if (t2 == 0.0) {
                            rank2 = part2.rank_start;
                            weight2 = part2.weight_start;
                        } else if (t2 == 1.0) {
                            rank2 = part2.rank_end;
                            weight2 = part2.weight_end;
                        }
                        Point2D pt = new Point2D();
                        if (rank1 == rank2) {
                            pt_1 = new Point2D();
                            line_1.getCoord2D(t1, pt_1);
                            Point2D pt_2 = new Point2D();
                            line_2.getCoord2D(t2, pt_2);
                            ptWeight = weight1 + weight2;
                            double t = weight2 / ptWeight;
                            MathUtils.lerp(pt_1, pt_2, t, pt);
                            if (Point2D.sqrDistance(pt, pt_1) + Point2D.sqrDistance(pt, pt_2) > small_tolerance_sqr) {
                                bigmove = true;
                            }
                        } else if (rank1 > rank2) {
                            line_1.getCoord2D(t1, pt);
                            ptWeight = weight1;
                            Point2D pt_2 = new Point2D();
                            line_2.getCoord2D(t2, pt_2);
                            if (Point2D.sqrDistance(pt, pt_2) > small_tolerance_sqr) {
                                bigmove = true;
                            }
                        } else {
                            line_2.getCoord2D(t2, pt);
                            ptWeight = weight2;
                            pt_1 = new Point2D();
                            line_1.getCoord2D(t1, pt_1);
                            if (Point2D.sqrDistance(pt, pt_1) > small_tolerance_sqr) {
                                bigmove = true;
                            }
                        }
                        points[i] = pt;
                    }
                    double t0 = 0.0;
                    int i0 = -1;
                    int i = 0;
                    while (i <= count) {
                        double t;
                        double d = t = i < count ? this.m_param_1[i] : 1.0;
                        if (t != t0) {
                            SegmentBuffer seg_buffer = this.newSegmentBuffer_();
                            line_1.cut(t0, t, seg_buffer);
                            if (i0 != -1) {
                                seg_buffer.get().setStartXY(points[i0]);
                            }
                            if (i != count) {
                                seg_buffer.get().setEndXY(points[i]);
                            }
                            t0 = t;
                            this.m_result_segments_1.add(this.newIntersectionPart_(seg_buffer.get()));
                        }
                        i0 = i++;
                    }
                    int[] indices = new int[9];
                    for (int i2 = 0; i2 < count; ++i2) {
                        indices[i2] = i2;
                    }
                    if (count > 1 && this.m_param_2[0] > this.m_param_2[1]) {
                        double t = this.m_param_2[0];
                        this.m_param_2[0] = this.m_param_2[1];
                        this.m_param_2[1] = t;
                        int i3 = indices[0];
                        indices[0] = indices[1];
                        indices[1] = i3;
                    }
                    t0 = 0.0;
                    i0 = -1;
                    int i4 = 0;
                    while (i4 <= count) {
                        double t;
                        double d = t = i4 < count ? this.m_param_2[i4] : 1.0;
                        if (t != t0) {
                            int ind;
                            SegmentBuffer seg_buffer = this.newSegmentBuffer_();
                            line_2.cut(t0, t, seg_buffer);
                            if (i0 != -1) {
                                ind = indices[i0];
                                seg_buffer.get().setStartXY(points[ind]);
                            }
                            if (i4 != count) {
                                ind = indices[i4];
                                seg_buffer.get().setEndXY(points[ind]);
                            }
                            t0 = t;
                            this.m_result_segments_2.add(this.newIntersectionPart_(seg_buffer.get()));
                        }
                        i0 = i4++;
                    }
                    return bigmove;
                }
                throw GeometryException.GeometryInternalError();
            }
            throw GeometryException.GeometryInternalError();
        }
        return false;
    }

    public void intersect(double tolerance, Point pt_intersector_point, int point_rank, double point_weight, boolean b_intersecting) {
        pt_intersector_point.copyTo(this.m_point);
        if (this.m_input_segments.size() != 1) {
            throw GeometryException.GeometryInternalError();
        }
        this.m_tolerance = tolerance;
        IntersectionPart part1 = this.m_input_segments.get(0);
        if (b_intersecting || part1.seg._isIntersectingPoint(pt_intersector_point.getXY(), tolerance, true)) {
            if (part1.seg.getType().value() == 322) {
                double ptWeight;
                double t1;
                Line line_1 = (Line)part1.seg;
                this.m_param_1[0] = t1 = line_1.getClosestCoordinate(pt_intersector_point.getXY(), false);
                int rank1 = part1.rank_interior;
                double weight1 = 1.0;
                if (t1 == 0.0) {
                    rank1 = part1.rank_start;
                    weight1 = part1.weight_start;
                } else if (t1 == 1.0) {
                    rank1 = part1.rank_end;
                    weight1 = part1.weight_end;
                }
                int rank2 = point_rank;
                double weight2 = point_weight;
                Point2D pt = new Point2D();
                if (rank1 == rank2) {
                    Point2D pt_1 = new Point2D();
                    line_1.getCoord2D(t1, pt_1);
                    Point2D pt_2 = pt_intersector_point.getXY();
                    ptWeight = weight1 + weight2;
                    double t = weight2 / ptWeight;
                    MathUtils.lerp(pt_1, pt_2, t, pt);
                } else if (rank1 > rank2) {
                    pt = new Point2D();
                    line_1.getCoord2D(t1, pt);
                    ptWeight = weight1;
                } else {
                    pt = pt_intersector_point.getXY();
                    ptWeight = weight2;
                }
                double t0 = 0.0;
                int i0 = -1;
                int count = 1;
                int i = 0;
                while (i <= count) {
                    double t;
                    double d = t = i < count ? this.m_param_1[i] : 1.0;
                    if (t != t0) {
                        SegmentBuffer seg_buffer = this.newSegmentBuffer_();
                        line_1.cut(t0, t, seg_buffer);
                        if (i0 != -1) {
                            seg_buffer.get().setStartXY(pt);
                        }
                        if (i != count) {
                            seg_buffer.get().setEndXY(pt);
                        }
                        t0 = t;
                        this.m_result_segments_1.add(this.newIntersectionPart_(seg_buffer.get()));
                    }
                    i0 = i++;
                }
                this.m_point.setXY(pt);
                return;
            }
            throw GeometryException.GeometryInternalError();
        }
    }

    public double get_tolerance_() {
        return this.m_tolerance;
    }

    private static class IntersectionPart {
        public Segment seg;
        public double weight_start;
        public double weight_end;
        public int rank_start;
        public int rank_end;
        public int rank_interior;

        IntersectionPart(Segment _seg) {
            this.seg = _seg;
            this.weight_start = 1.0;
            this.weight_end = 1.0;
            this.rank_start = 0;
            this.rank_end = 0;
            this.rank_interior = 0;
        }
    }
}

