/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.Boundary;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKPublic
public abstract class Segment
extends Geometry
implements Serializable {
    VertexDescription m_description;
    protected double m_xStart = 0.0;
    protected double m_yStart = 0.0;
    protected double m_xEnd = 0.0;
    protected double m_yEnd = 0.0;
    protected double[] m_attributes = null;

    @HadoopSDKPublic
    public Point2D getStartXY() {
        return Point2D.construct(this.m_xStart, this.m_yStart);
    }

    @HadoopSDKPublic
    public void getStartXY(Point2D pt) {
        pt.x = this.m_xStart;
        pt.y = this.m_yStart;
    }

    @HadoopSDKPublic
    public void setStartXY(Point2D pt) {
        this._setXY(0, pt);
    }

    @HadoopSDKPublic
    public void setStartXY(double x, double y) {
        this._setXY(0, x, y);
    }

    @HadoopSDKPublic
    public Point3D getStartXYZ() {
        return this._getXYZ(0);
    }

    public void getStartXYZ(Point3D pt) {
        this._getXYZ(0, pt);
    }

    @HadoopSDKPublic
    public void setStartXYZ(Point3D pt) {
        this._setXYZ(0, pt);
    }

    @HadoopSDKPublic
    public void setStartXYZ(double x, double y, double z) {
        this._setXYZ(0, Point3D.construct(x, y, z));
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryStart(Point dstPoint) {
        this._get(0, dstPoint);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setStart(Point srcPoint) {
        this._set(0, srcPoint);
    }

    @HadoopSDKPublic
    public double getStartAttributeAsDbl(int semantics, int ordinate) {
        return this._getAttributeAsDbl(0, semantics, ordinate);
    }

    @HadoopSDKPublic
    public int getStartAttributeAsInt(int semantics, int ordinate) {
        return this._getAttributeAsInt(0, semantics, ordinate);
    }

    @HadoopSDKPublic
    public void setStartAttribute(int semantics, int ordinate, double value) {
        this._setAttribute(0, semantics, ordinate, value);
    }

    @HadoopSDKPublic
    public void setStartAttribute(int semantics, int ordinate, int value) {
        this._setAttribute(0, semantics, ordinate, value);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getStartX() {
        return this.m_xStart;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getStartY() {
        return this.m_yStart;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getEndX() {
        return this.m_xEnd;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getEndY() {
        return this.m_yEnd;
    }

    @HadoopSDKPublic
    public Point2D getEndXY() {
        return Point2D.construct(this.m_xEnd, this.m_yEnd);
    }

    @HadoopSDKPublic
    public void getEndXY(Point2D pt) {
        pt.x = this.m_xEnd;
        pt.y = this.m_yEnd;
    }

    @HadoopSDKPublic
    public void setEndXY(Point2D pt) {
        this._setXY(1, pt);
    }

    @HadoopSDKPublic
    public void setEndXY(double x, double y) {
        this._setXY(1, x, y);
    }

    @HadoopSDKPublic
    public Point3D getEndXYZ() {
        return this._getXYZ(1);
    }

    @HadoopSDKPublic
    public void getEndXYZ(Point3D pt) {
        this._getXYZ(1, pt);
    }

    @HadoopSDKPublic
    public void setEndXYZ(Point3D pt) {
        this._setXYZ(1, pt);
    }

    @HadoopSDKPublic
    public void setEndXYZ(double x, double y, double z) {
        this._setXYZ(1, Point3D.construct(x, y, z));
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryEnd(Point dstPoint) {
        this._get(1, dstPoint);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setEnd(Point srcPoint) {
        this._set(1, srcPoint);
    }

    @HadoopSDKPublic
    public double getEndAttributeAsDbl(int semantics, int ordinate) {
        return this._getAttributeAsDbl(1, semantics, ordinate);
    }

    @HadoopSDKPublic
    public int getEndAttributeAsInt(int semantics, int ordinate) {
        return this._getAttributeAsInt(1, semantics, ordinate);
    }

    @HadoopSDKPublic
    public void setEndAttribute(int semantics, int ordinate, double value) {
        this._setAttribute(1, semantics, ordinate, value);
    }

    @HadoopSDKPublic
    public void setEndAttribute(int semantics, int ordinate, int value) {
        this._setAttribute(1, semantics, ordinate, value);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public final int getDimension() {
        return 1;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public final boolean isEmpty() {
        return this.isEmptyImpl();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public final void setEmpty() {
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double calculateArea2D() {
        return 0.0;
    }

    int intersect(Segment other, Point2D[] intersectionPoints, double[] paramThis, double[] paramOther, double tolerance) {
        return this._intersect(other, intersectionPoints, paramThis, paramOther, tolerance);
    }

    @HadoopSDKPublic
    public boolean isIntersecting(Segment other, double tolerance) {
        return this._isIntersecting(other, tolerance, false) != 0;
    }

    @HadoopSDKPublic
    public boolean isIntersecting(Point2D pt, double tolerance) {
        return this._isIntersectingPoint(pt, tolerance, false);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isEmptyImpl() {
        return false;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Segment() {
    }

    void _resizeAttributes(int newSize) {
        if (this.m_attributes == null && newSize > 0) {
            this.m_attributes = new double[newSize * 2];
        } else if (this.m_attributes != null && this.m_attributes.length < newSize * 2) {
            double[] newbuffer = new double[newSize * 2];
            System.arraycopy(this.m_attributes, 0, newbuffer, 0, this.m_attributes.length);
            this.m_attributes = newbuffer;
        }
    }

    static void _attributeCopy(double[] src, int srcStart, double[] dst, int dstStart, int count) {
        if (count > 0) {
            System.arraycopy(src, srcStart, dst, dstStart, count);
        }
    }

    private void _setXY(int endPoint, Point2D pt) {
        if (endPoint != 0) {
            this.m_xEnd = pt.x;
            this.m_yEnd = pt.y;
        } else {
            this.m_xStart = pt.x;
            this.m_yStart = pt.y;
        }
    }

    private void _setXY(int endPoint, double x, double y) {
        if (endPoint != 0) {
            this.m_xEnd = x;
            this.m_yEnd = y;
        } else {
            this.m_xStart = x;
            this.m_yStart = y;
        }
    }

    private Point3D _getXYZ(int endPoint) {
        Point3D pt = new Point3D();
        this._getXYZ(endPoint, pt);
        return pt;
    }

    private void _getXYZ(int endPoint, Point3D pt) {
        if (endPoint != 0) {
            pt.x = this.m_xEnd;
            pt.y = this.m_yEnd;
        } else {
            pt.x = this.m_xStart;
            pt.y = this.m_yStart;
        }
        pt.z = this.m_description.hasZ() ? this.m_attributes[Segment._getEndPointOffset(this.m_description, endPoint)] : VertexDescription.getDefaultValue(1);
    }

    private void _setXYZ(int endPoint, Point3D pt) {
        boolean bHasZ = this.hasAttribute(1);
        if (!bHasZ && !VertexDescription.isDefaultValue(1, pt.z)) {
            this.addAttribute(1);
            bHasZ = true;
        }
        if (endPoint != 0) {
            this.m_xEnd = pt.x;
            this.m_yEnd = pt.y;
        } else {
            this.m_xStart = pt.x;
            this.m_yStart = pt.y;
        }
        if (bHasZ) {
            this.m_attributes[Segment._getEndPointOffset((VertexDescription)this.m_description, (int)endPoint)] = pt.z;
        }
    }

    private final void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        if (this.m_attributes == null) {
            this.m_description = newDescription;
            return;
        }
        int[] mapping = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
        double[] newAttributes = new double[(newDescription.getTotalComponentCount() - 2) * 2];
        int old_offset0 = Segment._getEndPointOffset(this.m_description, 0);
        int old_offset1 = Segment._getEndPointOffset(this.m_description, 1);
        int new_offset0 = Segment._getEndPointOffset(newDescription, 0);
        int new_offset1 = Segment._getEndPointOffset(newDescription, 1);
        int j = 0;
        int n = newDescription.getAttributeCount();
        for (int i = 1; i < n; ++i) {
            int ord;
            int semantics = newDescription.getSemantics(i);
            int nords = VertexDescription.getComponentCount(semantics);
            if (mapping[i] == -1) {
                double d = VertexDescription.getDefaultValue(semantics);
                for (ord = 0; ord < nords; ++ord) {
                    newAttributes[new_offset0 + j] = d;
                    newAttributes[new_offset1 + j] = d;
                    ++j;
                }
                continue;
            }
            int m = mapping[i];
            int offset = this.m_description._getPointAttributeOffset(m) - 2;
            for (ord = 0; ord < nords; ++ord) {
                newAttributes[new_offset0 + j] = this.m_attributes[old_offset0 + offset];
                newAttributes[new_offset1 + j] = this.m_attributes[old_offset1 + offset];
                ++j;
                ++offset;
            }
        }
        this.m_attributes = newAttributes;
        this.m_description = newDescription;
    }

    private void _get(int endPoint, Point outPoint) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("empty geometry");
        }
        outPoint.assignVertexDescription(this.m_description);
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description.getSemantics(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = this._getAttributeAsDbl(endPoint, semantics, icomp);
                outPoint.setAttribute(semantics, icomp, v);
            }
        }
    }

    private void _set(int endPoint, Point src) {
        Point point = src;
        if (src.isEmptyImpl()) {
            throw new GeometryException("empty_Geometry");
        }
        VertexDescription vdin = point.getDescription();
        int nattrib = vdin.getAttributeCount();
        for (int attributeIndex = 0; attributeIndex < nattrib; ++attributeIndex) {
            int semantics = vdin.getSemantics(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = point.getAttributeAsDbl(semantics, icomp);
                this._setAttribute(endPoint, semantics, icomp, v);
            }
        }
    }

    double _getAttributeAsDbl(int endPoint, int semantics, int ordinate) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
        if (semantics == 0) {
            if (endPoint != 0) {
                return ordinate != 0 ? this.m_yEnd : this.m_xEnd;
            }
            return ordinate != 0 ? this.m_yStart : this.m_xStart;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            if (this.m_attributes != null) {
                this._resizeAttributes(this.m_description.getTotalComponentCount() - 2);
            }
            return this.m_attributes[Segment._getEndPointOffset(this.m_description, endPoint) + this.m_description._getPointAttributeOffset(attributeIndex) - 2 + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    protected final void queryOrds_(int endPoint, int semantics, double[] value) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
        if (semantics == 0) {
            if (endPoint != 0) {
                value[0] = this.m_xEnd;
                value[1] = this.m_yEnd;
            } else {
                value[0] = this.m_xStart;
                value[1] = this.m_yStart;
            }
            return;
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (attributeIndex >= 0) {
            int index = Segment._getEndPointOffset(this.m_description, endPoint) + this.m_description._getPointAttributeOffset(attributeIndex) - 2;
            value[0] = this.m_attributes[index];
            for (int i = 1; i < ncomps; ++i) {
                value[i] = this.m_attributes[index + i];
            }
        } else {
            double v;
            value[0] = v = VertexDescription.getDefaultValue(semantics);
            for (int i = 1; i < ncomps; ++i) {
                value[i] = v;
            }
        }
    }

    private int _getAttributeAsInt(int endPoint, int semantics, int ordinate) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("Empty_Geometry.");
        }
        return (int)this._getAttributeAsDbl(endPoint, semantics, ordinate);
    }

    void _setAttribute(int endPoint, int semantics, int ordinate, double value) {
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex < 0) {
            this.addAttribute(semantics);
            attributeIndex = this.m_description.getAttributeIndex(semantics);
        }
        if (semantics == 0) {
            if (endPoint != 0) {
                if (ordinate != 0) {
                    this.m_yEnd = value;
                } else {
                    this.m_xEnd = value;
                }
            } else if (ordinate != 0) {
                this.m_yStart = value;
            } else {
                this.m_xStart = value;
            }
            return;
        }
        if (this.m_attributes == null) {
            this._resizeAttributes(this.m_description.getTotalComponentCount() - 2);
        }
        this.m_attributes[Segment._getEndPointOffset((VertexDescription)this.m_description, (int)endPoint) + this.m_description._getPointAttributeOffset((int)attributeIndex) - 2 + ordinate] = value;
    }

    void _setAttribute(int endPoint, int semantics, int ordinate, int value) {
        this._setAttribute(endPoint, semantics, ordinate, (double)value);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void copyTo(Geometry dst) {
        if (dst.getType() != this.getType()) {
            throw new IllegalArgumentException();
        }
        Segment segDst = (Segment)dst;
        segDst.m_description = this.m_description;
        segDst._resizeAttributes(this.m_description.getTotalComponentCount() - 2);
        Segment._attributeCopy(this.m_attributes, 0, segDst.m_attributes, 0, (this.m_description.getTotalComponentCount() - 2) * 2);
        segDst.m_xStart = this.m_xStart;
        segDst.m_yStart = this.m_yStart;
        segDst.m_xEnd = this.m_xEnd;
        segDst.m_yEnd = this.m_yEnd;
        this._copyToImpl(segDst);
    }

    @Override
    @HadoopSDKPublic
    public void queryInterval(int semantics, int ordinate, Envelope1D dst) {
        if (this.isEmptyImpl()) {
            dst.setEmpty();
            return;
        }
        dst.vmax = dst.vmin = this._getAttributeAsDbl(0, semantics, ordinate);
        dst.mergeNE(this._getAttributeAsDbl(1, semantics, ordinate));
    }

    void queryCoord(double t, Point point) {
        point.assignVertexDescription(this.m_description);
        point.setXY(this.getCoord2D(t));
        int nattrib = this.m_description.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = this.m_description.getSemantics(iattrib);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomp; ++iord) {
                double value = this.getAttributeAsDbl(t, semantics, iord);
                point.setAttribute(semantics, iord, value);
            }
        }
    }

    boolean _equalsImpl(Segment other) {
        if (this.m_description != other.m_description) {
            return false;
        }
        if (this.m_xStart != other.m_xStart || this.m_xEnd != other.m_xEnd || this.m_yStart != other.m_yStart || this.m_yEnd != other.m_yEnd) {
            return false;
        }
        for (int i = 0; i < (this.m_description.getTotalComponentCount() - 2) * 2; ++i) {
            if (NumberUtils.isEqualNonIEEE(this.m_attributes[i], other.m_attributes[i])) continue;
            return false;
        }
        return true;
    }

    boolean _equalsImpl(Segment other, double tol) {
        if (this.m_description != other.m_description) {
            return false;
        }
        if (this.m_xStart != other.m_xStart || this.m_xEnd != other.m_xEnd || this.m_yStart != other.m_yStart || this.m_yEnd != other.m_yEnd) {
            return false;
        }
        for (int i = 0; i < (this.m_description.getTotalComponentCount() - 2) * 2; ++i) {
            if (NumberUtils.isEqualNonIEEE(this.m_attributes[i], other.m_attributes[i], tol)) continue;
            return false;
        }
        return true;
    }

    boolean isClosed() {
        return this.m_xStart == this.m_xEnd && this.m_yStart == this.m_yEnd;
    }

    void reverse() {
        double origyEnd;
        double origxEnd;
        this._reverseImpl();
        double origxStart = this.m_xStart;
        this.m_xStart = origxEnd = this.m_xEnd;
        this.m_xEnd = origxStart;
        double origyStart = this.m_yStart;
        this.m_yStart = origyEnd = this.m_yEnd;
        this.m_yEnd = origyStart;
        int n = this.m_description.getAttributeCount();
        for (int i = 1; i < n; ++i) {
            int semantics = this.m_description.getSemantics(i);
            int nord = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < nord; ++iord) {
                double v1 = this._getAttributeAsDbl(0, semantics, iord);
                double v2 = this._getAttributeAsDbl(1, semantics, iord);
                this._setAttribute(0, semantics, iord, v2);
                this._setAttribute(1, semantics, iord, v1);
            }
        }
    }

    int _isIntersecting(Segment other, double tolerance, boolean bExcludeExactEndpoints) {
        int gtThis = this.getType().value();
        int gtOther = other.getType().value();
        switch (gtThis) {
            case 322: {
                if (gtOther == 322) {
                    return Line._isIntersectingLineLine((Line)this, (Line)other, tolerance, bExcludeExactEndpoints);
                }
                throw GeometryException.GeometryInternalError();
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    int _intersect(Segment other, Point2D[] intersectionPoints, double[] paramThis, double[] paramOther, double tolerance) {
        int gtThis = this.getType().value();
        int gtOther = other.getType().value();
        switch (gtThis) {
            case 322: {
                if (gtOther == 322) {
                    return Line._intersectLineLine((Line)this, (Line)other, intersectionPoints, paramThis, paramOther, tolerance);
                }
                throw GeometryException.GeometryInternalError();
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    abstract double _calculateArea2DHelper(double var1, double var3);

    static int _getEndPointOffset(VertexDescription vd, int endPoint) {
        return endPoint * (vd.getTotalComponentCount() - 2);
    }

    @HadoopSDKPublic
    public Point2D getCoord2D(double t) {
        Point2D pt = new Point2D();
        this.getCoord2D(t, pt);
        return pt;
    }

    @HadoopSDKPublic
    public abstract void getCoord2D(double var1, Point2D var3);

    @HadoopSDKPublic
    public abstract double getClosestCoordinate(Point2D var1, boolean var2);

    abstract int getYMonotonicParts(SegmentBuffer[] var1);

    @AndroidSDKPublic
    @HadoopSDKPublic
    public abstract int intersectionWithAxis2D(boolean var1, double var2, double[] var4, double[] var5);

    void _reverseImpl() {
    }

    abstract boolean isDegenerate(double var1);

    public abstract boolean isCurve();

    abstract Point2D _getTangent(double var1);

    abstract boolean _isDegenerate(double var1);

    double _calculateSubLength(double t) {
        return this.tToLength(t);
    }

    double _calculateSubLength(double t1, double t2) {
        return this.tToLength(t2) - this.tToLength(t1);
    }

    abstract void _copyToImpl(Segment var1);

    @HadoopSDKPublic
    public abstract Segment cut(double var1, double var3);

    abstract void cut(double var1, double var3, SegmentBuffer var5);

    @HadoopSDKPublic
    public abstract double getAttributeAsDbl(double var1, int var3, int var4);

    public abstract void queryAttributeAsDbl(double var1, int var3, double[] var4);

    abstract boolean _isIntersectingPoint(Point2D var1, double var2, boolean var4);

    abstract double intersectionOfYMonotonicWithAxisX(double var1, double var3);

    abstract double tToLength(double var1);

    abstract double lengthToT(double var1);

    @HadoopSDKPublic
    public double distance(Segment otherSegment, boolean bSegmentsKnownDisjoint) {
        if (!bSegmentsKnownDisjoint && this._isIntersecting(otherSegment, 0.0, false) != 0) {
            return 0.0;
        }
        double minDistance = NumberUtils.doubleMax();
        Point2D inputPoint = new Point2D();
        Point2D subPoint = new Point2D();
        this.getStartXY(inputPoint);
        double t = otherSegment.getClosestCoordinate(inputPoint, false);
        otherSegment.getCoord2D(t, subPoint);
        inputPoint.sub(subPoint);
        double distance = inputPoint.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        this.getEndXY(inputPoint);
        t = otherSegment.getClosestCoordinate(inputPoint, false);
        otherSegment.getCoord2D(t, subPoint);
        inputPoint.sub(subPoint);
        distance = inputPoint.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        otherSegment.getStartXY(inputPoint);
        t = this.getClosestCoordinate(inputPoint, false);
        this.getCoord2D(t, subPoint);
        inputPoint.sub(subPoint);
        distance = inputPoint.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        otherSegment.getEndXY(inputPoint);
        t = this.getClosestCoordinate(inputPoint, false);
        this.getCoord2D(t, subPoint);
        inputPoint.sub(subPoint);
        distance = inputPoint.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        return minDistance;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry getBoundary() {
        return Boundary.calculate(this, null);
    }

    abstract void calculateWeightedCentroid2D(Point2D var1);

    @Override
    @HadoopSDKPublic
    public VertexDescription getDescription() {
        return this.m_description;
    }

    @Override
    @HadoopSDKPublic
    public void assignVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        this._assignVertexDescriptionImpl(src);
    }

    @Override
    @HadoopSDKPublic
    public void mergeVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        if (this.m_description.hasAttributesFrom(src)) {
            return;
        }
        this._mergeVertexDescriptionImpl(src);
    }

    @Override
    @HadoopSDKPublic
    public boolean hasAttribute(int semantics) {
        return this.m_description.hasAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void addAttribute(int semantics) {
        if (this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.getMergedVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    @HadoopSDKPublic
    public void dropAttribute(int semantics) {
        if (!this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.removeSemanticsFromVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    @HadoopSDKPublic
    public void dropAllAttributes() {
        VertexDescription newvd = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        if (newvd == this.m_description) {
            return;
        }
        this.assignVertexDescription(newvd);
    }
}

