/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.QuadTreeImpl;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

@HadoopSDKPublic
public class QuadTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private QuadTreeImpl m_impl;

    @HadoopSDKPublic
    public QuadTree(Envelope2D extent, int height) {
        this.m_impl = new QuadTreeImpl(extent, height);
    }

    @HadoopSDKPublic
    public QuadTree(Envelope2D extent, int height, boolean bStoreDuplicates) {
        this.m_impl = new QuadTreeImpl(extent, height, bStoreDuplicates);
    }

    @HadoopSDKPublic
    public int insert(int element, Envelope2D boundingBox) {
        return this.m_impl.insert(element, boundingBox);
    }

    @HadoopSDKPublic
    public int insert(int element, Envelope2D boundingBox, int hintIndex) {
        return this.m_impl.insert(element, boundingBox, hintIndex);
    }

    @HadoopSDKPublic
    public void removeElement(int elementHandle) {
        this.m_impl.removeElement(elementHandle);
    }

    @HadoopSDKPublic
    public int getElement(int elementHandle) {
        return this.m_impl.getElement(elementHandle);
    }

    @HadoopSDKPublic
    public Envelope2D getElementExtent(int elementHandle) {
        return this.m_impl.getElementExtent(elementHandle);
    }

    @HadoopSDKPublic
    public Envelope2D getDataExtent() {
        return this.m_impl.getDataExtent();
    }

    @HadoopSDKPublic
    public Envelope2D getQuadTreeExtent() {
        return this.m_impl.getQuadTreeExtent();
    }

    @HadoopSDKPublic
    public int getSubTreeElementCount(int quadHandle) {
        return this.m_impl.getSubTreeElementCount(quadHandle);
    }

    @HadoopSDKPublic
    public int getContainedSubTreeElementCount(int quadHandle) {
        return this.m_impl.getContainedSubTreeElementCount(quadHandle);
    }

    @HadoopSDKPublic
    public int getIntersectionCount(Envelope2D query, double tolerance, int maxCount) {
        return this.m_impl.getIntersectionCount(query, tolerance, maxCount);
    }

    @HadoopSDKPublic
    public boolean hasData(Envelope2D query, double tolerance) {
        return this.m_impl.hasData(query, tolerance);
    }

    @HadoopSDKPublic
    public int getHeight(int quadHandle) {
        return this.m_impl.getHeight(quadHandle);
    }

    @HadoopSDKPublic
    public int getMaxHeight() {
        return this.m_impl.getMaxHeight();
    }

    @HadoopSDKPublic
    public Envelope2D getExtent(int quadHandle) {
        return this.m_impl.getExtent(quadHandle);
    }

    @HadoopSDKPublic
    public int getQuad(int elementHandle) {
        return this.m_impl.getQuad(elementHandle);
    }

    @HadoopSDKPublic
    public int getElementCount() {
        return this.m_impl.getElementCount();
    }

    @HadoopSDKPublic
    public QuadTreeIterator getIterator(Geometry query, double tolerance) {
        QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
        return new QuadTreeIterator(iterator, false);
    }

    @HadoopSDKPublic
    public QuadTreeIterator getIterator(Envelope2D query, double tolerance) {
        QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
        return new QuadTreeIterator(iterator, false);
    }

    @HadoopSDKPublic
    public QuadTreeIterator getIterator() {
        QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator();
        return new QuadTreeIterator(iterator, false);
    }

    @HadoopSDKPublic
    public QuadTreeIterator getIterator(Geometry query, double tolerance, boolean bSorted) {
        if (!bSorted) {
            QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
            return new QuadTreeIterator(iterator, false);
        }
        QuadTreeImpl.QuadTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator(query, tolerance);
        return new QuadTreeIterator(iterator, true);
    }

    @HadoopSDKPublic
    public QuadTreeIterator getIterator(Envelope2D query, double tolerance, boolean bSorted) {
        if (!bSorted) {
            QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
            return new QuadTreeIterator(iterator, false);
        }
        QuadTreeImpl.QuadTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator(query, tolerance);
        return new QuadTreeIterator(iterator, true);
    }

    @HadoopSDKPublic
    public QuadTreeIterator getIterator(boolean bSorted) {
        if (!bSorted) {
            QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator();
            return new QuadTreeIterator(iterator, false);
        }
        QuadTreeImpl.QuadTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator();
        return new QuadTreeIterator(iterator, true);
    }

    Object getImpl_() {
        return this.m_impl;
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    @HadoopSDKPublic
    public static final class QuadTreeIterator {
        private Object m_impl;
        private boolean m_b_sorted;

        @HadoopSDKPublic
        public void resetIterator(Geometry query, double tolerance) {
            if (!this.m_b_sorted) {
                ((QuadTreeImpl.QuadTreeIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            } else {
                ((QuadTreeImpl.QuadTreeSortedIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            }
        }

        @HadoopSDKPublic
        public void resetIterator(Envelope2D query, double tolerance) {
            if (!this.m_b_sorted) {
                ((QuadTreeImpl.QuadTreeIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            } else {
                ((QuadTreeImpl.QuadTreeSortedIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            }
        }

        @HadoopSDKPublic
        public int next() {
            if (!this.m_b_sorted) {
                return ((QuadTreeImpl.QuadTreeIteratorImpl)this.m_impl).next();
            }
            return ((QuadTreeImpl.QuadTreeSortedIteratorImpl)this.m_impl).next();
        }

        Object getImpl_() {
            return this.m_impl;
        }

        private QuadTreeIterator(Object obj, boolean bSorted) {
            this.m_impl = obj;
            this.m_b_sorted = bSorted;
        }
    }
}

