/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.PointInPolygonHelper;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.SpatialReference;

public final class PolygonUtils {
    public static PiPResult isPointInPolygon2D(Polygon polygon, Point inputPoint, double tolerance) {
        int res = PointInPolygonHelper.isPointInPolygon(polygon, inputPoint, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPBoundary;
    }

    public static PiPResult isPointInPolygon2D(Polygon polygon, Point2D inputPoint, double tolerance) {
        int res = PointInPolygonHelper.isPointInPolygon(polygon, inputPoint, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPBoundary;
    }

    static Point2D getFirstPoint(Geometry geom) {
        if (!geom.isEmpty()) {
            int gt = geom.getType().value();
            if (Geometry.isMultiVertex(gt)) {
                MultiVertexGeometry mvg = (MultiVertexGeometry)geom;
                return mvg.getXY(0);
            }
            if (gt == 33) {
                return ((Point)geom).getXY();
            }
            if (gt == 197) {
                return new Point2D(((Envelope)geom).getXMin(), ((Envelope)geom).getYMin());
            }
            if (Geometry.isSegment(gt)) {
                return ((Segment)geom).getStartXY();
            }
            throw new GeometryException("internal error");
        }
        Point2D nanPoint = new Point2D();
        nanPoint.setNaN();
        return nanPoint;
    }

    public static Point2D uniqueIntersectionPointOfNonDisjointGeometries(Geometry g1, Geometry g2, SpatialReference sr) {
        Polygon polygon;
        boolean g2Polygon;
        if (g1.isEmpty() || g2.isEmpty()) {
            Point2D nanPoint = new Point2D();
            nanPoint.setNaN();
            return nanPoint;
        }
        int g1Type = g1.getType().value();
        int g2Type = g2.getType().value();
        if (g1Type == 33) {
            return PolygonUtils.getFirstPoint(g1);
        }
        if (g2Type == 33) {
            return PolygonUtils.getFirstPoint(g2);
        }
        Geometry g1Test = g1;
        Geometry g2Test = g2;
        boolean g1Polygon = g1Type == 1736;
        boolean bl = g2Polygon = g2Type == 1736;
        if (g1Polygon || g2Polygon) {
            Point2D p;
            if (g1Polygon && PolygonUtils.isPointInPolygon2D((Polygon)g1Test, p = PolygonUtils.getFirstPoint(g2Test), 0.0) != PiPResult.PiPOutside) {
                return p;
            }
            if (g2Polygon && PolygonUtils.isPointInPolygon2D((Polygon)g2Test, p = PolygonUtils.getFirstPoint(g1), 0.0) != PiPResult.PiPOutside) {
                return p;
            }
        }
        if (g1Type == 197) {
            polygon = new Polygon();
            polygon.addEnvelope((Envelope)g1Test, false);
            g1Test = polygon;
        }
        if (g2Type == 197) {
            polygon = new Polygon();
            polygon.addEnvelope((Envelope)g2Test, false);
            g2Test = polygon;
        }
        GeometryCursor gc = OperatorIntersection.local().execute(new SimpleGeometryCursor(g1Test), new SimpleGeometryCursor(g2Test), sr, null, 7);
        Geometry res = gc.next();
        while (res != null) {
            if (!res.isEmpty()) {
                return PolygonUtils.getFirstPoint(res);
            }
            res = gc.next();
        }
        Point2D nanPoint = new Point2D();
        nanPoint.setNaN();
        return nanPoint;
    }

    static PiPResult isPointInPolygon2D(Polygon polygon, double inputPointXVal, double inputPointYVal, double tolerance) {
        int res = PointInPolygonHelper.isPointInPolygon(polygon, inputPointXVal, inputPointYVal, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPBoundary;
    }

    public static PiPResult isPointInRing2D(Polygon polygon, int iRing, Point2D inputPoint, double tolerance) {
        MultiPathImpl polygonImpl = (MultiPathImpl)polygon._getImpl();
        int res = PointInPolygonHelper.isPointInRing(polygonImpl, iRing, inputPoint, tolerance, null);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPInside;
    }

    public static PiPResult isPointInAnyOuterRing(Polygon polygon, Point2D inputPoint, double tolerance) {
        int res = PointInPolygonHelper.isPointInAnyOuterRing(polygon, inputPoint, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPInside;
    }

    public static void testPointsInPolygon2D(Polygon polygon, Point2D[] inputPoints, int count, double tolerance, PiPResult[] testResults) {
        if (inputPoints.length < count || testResults.length < count) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < count; ++i) {
            testResults[i] = PolygonUtils.isPointInPolygon2D(polygon, inputPoints[i], tolerance);
        }
    }

    static void testPointsInPolygon2D(Polygon polygon, double[] xyStreamBuffer, int pointCount, double tolerance, PiPResult[] testResults) {
        if (xyStreamBuffer.length / 2 < pointCount || testResults.length < pointCount) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < pointCount; ++i) {
            testResults[i] = PolygonUtils.isPointInPolygon2D(polygon, xyStreamBuffer[i * 2], xyStreamBuffer[i * 2 + 1], tolerance);
        }
    }

    public static void testPointsInArea2D(Geometry polygon, Point2D[] inputPoints, int count, double tolerance, PiPResult[] testResults) {
        if (polygon.getType() == Geometry.Type.Polygon) {
            PolygonUtils.testPointsInPolygon2D((Polygon)polygon, inputPoints, count, tolerance, testResults);
        } else if (polygon.getType() == Geometry.Type.Envelope) {
            Envelope2D env2D = new Envelope2D();
            ((Envelope)polygon).queryEnvelope2D(env2D);
            PolygonUtils._testPointsInEnvelope2D(env2D, inputPoints, count, tolerance, testResults);
        } else {
            throw new GeometryException("invalid_call");
        }
    }

    public static void testPointsInArea2D(Geometry polygon, double[] xyStreamBuffer, int count, double tolerance, PiPResult[] testResults) {
        if (polygon.getType() == Geometry.Type.Polygon) {
            PolygonUtils.testPointsInPolygon2D((Polygon)polygon, xyStreamBuffer, count, tolerance, testResults);
        } else if (polygon.getType() == Geometry.Type.Envelope) {
            Envelope2D env2D = new Envelope2D();
            ((Envelope)polygon).queryEnvelope2D(env2D);
            PolygonUtils._testPointsInEnvelope2D(env2D, xyStreamBuffer, count, tolerance, testResults);
        } else {
            throw new GeometryException("invalid_call");
        }
    }

    private static void _testPointsInEnvelope2D(Envelope2D env2D, Point2D[] inputPoints, int count, double tolerance, PiPResult[] testResults) {
        if (inputPoints.length < count || testResults.length < count) {
            throw new IllegalArgumentException();
        }
        if (env2D.isEmpty()) {
            for (int i = 0; i < count; ++i) {
                testResults[i] = PiPResult.PiPOutside;
            }
            return;
        }
        Envelope2D envIn = env2D;
        envIn.inflate(-tolerance * 0.5, -tolerance * 0.5);
        Envelope2D envOut = env2D;
        envOut.inflate(tolerance * 0.5, tolerance * 0.5);
        for (int i = 0; i < count; ++i) {
            testResults[i] = envIn.contains(inputPoints[i]) ? PiPResult.PiPInside : (!envOut.contains(inputPoints[i]) ? PiPResult.PiPOutside : PiPResult.PiPBoundary);
        }
    }

    private static void _testPointsInEnvelope2D(Envelope2D env2D, double[] xyStreamBuffer, int pointCount, double tolerance, PiPResult[] testResults) {
        if (xyStreamBuffer.length / 2 < pointCount || testResults.length < pointCount) {
            throw new IllegalArgumentException();
        }
        if (env2D.isEmpty()) {
            for (int i = 0; i < pointCount; ++i) {
                testResults[i] = PiPResult.PiPOutside;
            }
            return;
        }
        Envelope2D envIn = env2D;
        envIn.inflate(-tolerance * 0.5, -tolerance * 0.5);
        Envelope2D envOut = env2D;
        envOut.inflate(tolerance * 0.5, tolerance * 0.5);
        for (int i = 0; i < pointCount; ++i) {
            testResults[i] = envIn.contains(xyStreamBuffer[i * 2], xyStreamBuffer[i * 2 + 1]) ? PiPResult.PiPInside : (!envIn.contains(xyStreamBuffer[i * 2], xyStreamBuffer[i * 2 + 1]) ? PiPResult.PiPOutside : PiPResult.PiPBoundary);
        }
    }

    static void testPointsOnSegment_(Segment seg, Point2D[] input_points, int count, double tolerance, PiPResult[] test_results) {
        for (int i = 0; i < count; ++i) {
            test_results[i] = seg.isIntersecting(input_points[i], tolerance) ? PiPResult.PiPBoundary : PiPResult.PiPOutside;
        }
    }

    static void testPointsOnPolyline2D_(Polyline poly, Point2D[] input_points, int count, double tolerance, PiPResult[] test_results) {
        int i;
        MultiPathImpl mp_impl = (MultiPathImpl)poly._getImpl();
        GeometryAccelerators accel = mp_impl._getAccelerators();
        RasterizedGeometry2D rgeom = null;
        if (accel != null) {
            rgeom = accel.getRasterizedGeometry();
        }
        int pointsLeft = count;
        for (i = 0; i < count; ++i) {
            test_results[i] = PiPResult.PiPInside;
            if (rgeom == null) continue;
            Point2D input_point = input_points[i];
            RasterizedGeometry2D.HitType hit = rgeom.queryPointInGeometry(input_point.x, input_point.y);
            if (hit != RasterizedGeometry2D.HitType.Outside) continue;
            test_results[i] = PiPResult.PiPOutside;
            --pointsLeft;
        }
        if (pointsLeft != 0) {
            SegmentIteratorImpl iter = mp_impl.querySegmentIterator();
            while (iter.nextPath() && pointsLeft != 0) {
                while (iter.hasNextSegment() && pointsLeft != 0) {
                    Segment segment = iter.nextSegment();
                    for (int i2 = 0; i2 < count && pointsLeft != 0; ++i2) {
                        if (test_results[i2] != PiPResult.PiPInside || !segment.isIntersecting(input_points[i2], tolerance)) continue;
                        test_results[i2] = PiPResult.PiPBoundary;
                        --pointsLeft;
                    }
                }
            }
        }
        for (i = 0; i < count; ++i) {
            if (test_results[i] != PiPResult.PiPInside) continue;
            test_results[i] = PiPResult.PiPOutside;
        }
    }

    static void testPointsOnLine2D(Geometry line, Point2D[] input_points, int count, double tolerance, PiPResult[] test_results) {
        Geometry.Type gt = line.getType();
        if (gt == Geometry.Type.Polyline) {
            PolygonUtils.testPointsOnPolyline2D_((Polyline)line, input_points, count, tolerance, test_results);
        } else if (Geometry.isSegment(gt.value())) {
            PolygonUtils.testPointsOnSegment_((Segment)line, input_points, count, tolerance, test_results);
        } else {
            throw new GeometryException("Invalid call.");
        }
    }

    public static enum PiPResult {
        PiPOutside,
        PiPInside,
        PiPBoundary;

    }
}

