/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKPublic
public class Point
extends Geometry
implements Serializable {
    VertexDescription m_description;
    private double x;
    private double y;
    private double[] m_attributes = null;
    private static final int hard_attribs = 2;

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setEmpty();
    }

    @HadoopSDKPublic
    public Point(VertexDescription vd) {
        if (vd == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = vd;
        this.setEmpty();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point(double x_, double y_) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.x = x_;
        this.y = y_;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point(Point2D pt) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.x = pt.x;
        this.y = pt.y;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point(double x_, double y_, double z_) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor3D();
        this.m_attributes = new double[1];
        this.x = x_;
        this.y = y_;
        this.m_attributes[0] = z_;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point(Point3D pt) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor3D();
        this.m_attributes = new double[1];
        this.x = pt.x;
        this.y = pt.y;
        this.m_attributes[0] = pt.z;
    }

    @HadoopSDKPublic
    public Point(Point pt) {
        this.m_description = pt.getDescription();
        this.x = pt.x;
        this.y = pt.y;
        if (pt.m_attributes != null) {
            this.m_attributes = (double[])pt.m_attributes.clone();
        }
    }

    @HadoopSDKPublic
    public final Point2D getXY() {
        Point2D pt = new Point2D();
        pt.setCoords(this.x, this.y);
        return pt;
    }

    @HadoopSDKPublic
    public final void getXY(Point2D pt) {
        pt.setCoords(this.x, this.y);
    }

    @HadoopSDKPublic
    public final void setXY(Point2D pt) {
        this.setXY(pt.x, pt.y);
    }

    @HadoopSDKPublic
    public Point3D getXYZ() {
        Point3D pt = new Point3D();
        pt.x = this.x;
        pt.y = this.y;
        pt.z = this.m_description.hasZ() ? this.m_attributes[0] : VertexDescription.getDefaultValue(1);
        return pt;
    }

    @HadoopSDKPublic
    public void getXYZ(Point3D pt) {
        pt.x = this.x;
        pt.y = this.y;
        pt.z = this.m_description.hasZ() ? this.m_attributes[0] : VertexDescription.getDefaultValue(1);
    }

    @HadoopSDKPublic
    public void setXYZ(Point3D pt) {
        this.addAttribute(1);
        this.x = pt.x;
        this.y = pt.y;
        this.m_attributes[0] = pt.z;
    }

    @HadoopSDKPublic
    public void setXYZ(double x_, double y_, double z_) {
        this.addAttribute(1);
        this.x = x_;
        this.y = y_;
        this.m_attributes[0] = z_;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getX() {
        return this.x;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setX(double x_) {
        this.x = x_;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getY() {
        return this.y;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setY(double y_) {
        this.y = y_;
    }

    @HadoopSDKPublic
    public double getZ() {
        if (this.m_description.hasZ()) {
            return this.m_attributes[0];
        }
        return VertexDescription.getDefaultValue(1);
    }

    @HadoopSDKPublic
    public void setZ(double z) {
        this.addAttribute(1);
        this.m_attributes[0] = z;
    }

    @HadoopSDKPublic
    public double getM() {
        return this.getAttributeAsDbl(2, 0);
    }

    @HadoopSDKPublic
    public void setM(double m) {
        this.setAttribute(2, 0, m);
    }

    @HadoopSDKPublic
    public int getID() {
        return this.getAttributeAsInt(3, 0);
    }

    @HadoopSDKPublic
    public void setID(int id) {
        this.setAttribute(3, 0, id);
    }

    @HadoopSDKPublic
    public double getAttributeAsDbl(int semantics, int ordinate) {
        if (semantics == 0) {
            if (ordinate == 0) {
                return this.x;
            }
            if (ordinate == 1) {
                return this.y;
            }
            throw new IndexOutOfBoundsException();
        }
        if (semantics == 1) {
            if (ordinate > 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.m_description.hasAttribute(1)) {
                return this.m_attributes[0];
            }
            return VertexDescription.getDefaultValue(1);
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return this.m_attributes[this.m_description._getPointAttributeOffset(attributeIndex) + ordinate - 2];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    @HadoopSDKPublic
    public int getAttributeAsInt(int semantics, int ordinate) {
        if (semantics == 0) {
            if (ordinate == 0) {
                return (int)this.x;
            }
            if (ordinate == 1) {
                return (int)this.y;
            }
            throw new IndexOutOfBoundsException();
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return (int)this.m_attributes[this.m_description._getPointAttributeOffset(attributeIndex) + ordinate - 2];
        }
        return (int)VertexDescription.getDefaultValue(semantics);
    }

    @HadoopSDKPublic
    public void setAttribute(int semantics, int ordinate, double value) {
        int ncomps;
        if (semantics == 0) {
            if (ordinate == 0) {
                this.x = value;
            } else if (ordinate == 1) {
                this.y = value;
            } else {
                throw new IndexOutOfBoundsException();
            }
            return;
        }
        if (semantics == 1) {
            if (ordinate > 0) {
                throw new IndexOutOfBoundsException();
            }
            this.addAttribute(semantics);
            this.m_attributes[0] = value;
        }
        if ((ncomps = VertexDescription.getComponentCount(semantics)) < ordinate) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex < 0) {
            this.addAttribute(semantics);
            attributeIndex = this.m_description.getAttributeIndex(semantics);
        }
        this.m_attributes[this.m_description._getPointAttributeOffset((int)attributeIndex) - 2 + ordinate] = value;
    }

    @HadoopSDKPublic
    public void setAttribute(int semantics, int ordinate, int value) {
        this.setAttribute(semantics, ordinate, (double)value);
    }

    void setAttributes(int semantics, double[] value) {
        if (semantics == 0) {
            this.x = value[0];
            this.y = value[1];
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex < 0) {
            this.addAttribute(semantics);
            attributeIndex = this.m_description.getAttributeIndex(semantics);
        }
        int ind = this.m_description._getPointAttributeOffset(attributeIndex) - 2;
        this.m_attributes[ind] = value[0];
        for (int i = 1; i < ncomps; ++i) {
            this.m_attributes[ind + i] = value[i];
        }
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry.Type getType() {
        return Geometry.Type.Point;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getDimension() {
        return 0;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setEmpty() {
        this.x = Double.NaN;
        this.y = Double.NaN;
        int cnt = this.m_description.getTotalComponentCount() - 2;
        if (cnt > 0) {
            if (this.m_attributes == null) {
                this.m_attributes = new double[cnt];
            }
            Point._attributeCopy(this.m_description._getDefaultPointAttributes(), 2, this.m_attributes, 0, cnt);
        }
    }

    void setDefaultAttributeValues() {
        int cnt = this.m_description.getTotalComponentCount() - 2;
        if (cnt > 0) {
            if (this.m_attributes == null) {
                this.m_attributes = new double[cnt];
            }
            Point._attributeCopy(this.m_description._getDefaultPointAttributes(), 2, this.m_attributes, 0, cnt);
        }
    }

    private final void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        int[] new_to_old = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
        double[] newAttributes = null;
        if (newDescription.getTotalComponentCount() - 2 > 0) {
            newAttributes = new double[newDescription.getTotalComponentCount() - 2];
            Point._attributeCopy(newDescription._getDefaultPointAttributes(), 2, newAttributes, 0, newAttributes.length);
        }
        int n = newDescription.getAttributeCount();
        for (int i = 1; i < n; ++i) {
            int oldIndex = new_to_old[i];
            if (oldIndex == -1) continue;
            int oldind = this.m_description.getPointAttributeOffset_(oldIndex) - 2;
            int newind = newDescription.getPointAttributeOffset_(i) - 2;
            int ncomp = VertexDescription.getComponentCount(newDescription.getSemantics(i));
            Point._attributeCopy(this.m_attributes, oldind, newAttributes, newind, ncomp);
        }
        this.m_attributes = newAttributes;
        this.m_description = newDescription;
    }

    private void ensureAttributes_() {
        int sz = this.m_description.getTotalComponentCount() - 2;
        if (sz > 0 && this.m_attributes == null) {
            this.m_attributes = new double[sz];
            Point._attributeCopy(this.m_description._getDefaultPointAttributes(), 2, this.m_attributes, 0, sz);
        }
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void applyTransformation(Transformation2D transform) {
        if (this.isEmptyImpl()) {
            return;
        }
        Point2D pt = this.getXY();
        transform.transform(pt, pt);
        this.setXY(pt);
    }

    @Override
    public void applyTransformation(Transformation3D transform) {
        if (this.isEmptyImpl()) {
            return;
        }
        this.addAttribute(1);
        Point3D pt = this.getXYZ();
        this.setXYZ(transform.transform(pt));
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void copyTo(Geometry dst) {
        if (dst.getType() != Geometry.Type.Point) {
            throw new IllegalArgumentException();
        }
        Point pointDst = (Point)dst;
        if (this == pointDst) {
            return;
        }
        pointDst.assignVertexDescription(this.m_description);
        Point._attributeCopy(this.m_attributes, 0, pointDst.m_attributes, 0, this.m_description.getTotalComponentCount() - 2);
        pointDst.x = this.x;
        pointDst.y = this.y;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry createInstance() {
        Point point = new Point(this.m_description);
        return point;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isEmpty() {
        return this.isEmptyImpl();
    }

    final boolean isEmptyImpl() {
        return NumberUtils.isNaN(this.x) || NumberUtils.isNaN(this.y);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryEnvelope(Envelope env) {
        env.setEmpty();
        if (this.m_description != env.m_description) {
            env.assignVertexDescription(this.m_description);
        }
        env.merge(this);
    }

    @Override
    @HadoopSDKPublic
    public void queryLooseEnvelope2D(Envelope2D env) {
        env.setCoords(this.x, this.y, this.x, this.y);
    }

    @Override
    @HadoopSDKPublic
    public void queryEnvelope2D(Envelope2D env) {
        env.setCoords(this.x, this.y, this.x, this.y);
    }

    @Override
    @HadoopSDKPublic
    public void queryEnvelope3D(Envelope3D env) {
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return;
        }
        double z = this.getZ();
        env.xmin = this.x;
        env.ymin = this.y;
        env.zmin = z;
        env.xmax = this.x;
        env.ymax = this.y;
        env.zmax = z;
    }

    @Override
    @HadoopSDKPublic
    public void queryInterval(int semantics, int ordinate, Envelope1D dst) {
        double s;
        if (this.isEmptyImpl()) {
            dst.setEmpty();
        }
        dst.vmin = s = this.getAttributeAsDbl(semantics, ordinate);
        dst.vmax = s;
    }

    private static void _attributeCopy(double[] src, int srcPos, double[] dst, int dstPos, int count) {
        if (count > 0) {
            System.arraycopy(src, srcPos, dst, dstPos, count);
        }
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setXY(double x_, double y_) {
        this.x = x_;
        this.y = y_;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Point)) {
            return false;
        }
        Point otherPt = (Point)_other;
        if (this.m_description != otherPt.m_description) {
            return false;
        }
        if (this.isEmptyImpl() != otherPt.isEmptyImpl()) {
            return false;
        }
        if (this.isEmptyImpl()) {
            return true;
        }
        if (this.x != otherPt.x || this.y != otherPt.y) {
            return false;
        }
        int n = this.m_description.getTotalComponentCount() - 2;
        for (int i = 0; i < n; ++i) {
            if (NumberUtils.isEqualNonIEEE(this.m_attributes[i], otherPt.m_attributes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Geometry _other, double tol) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Point)) {
            return false;
        }
        Point otherPt = (Point)_other;
        if (this.m_description != otherPt.m_description) {
            return false;
        }
        if (this.isEmptyImpl() != otherPt.isEmptyImpl()) {
            return false;
        }
        if (this.isEmptyImpl()) {
            return true;
        }
        if (Math.abs(this.x - otherPt.x) > tol) {
            return false;
        }
        if (Math.abs(this.y - otherPt.y) > tol) {
            return false;
        }
        int n = this.m_description.getTotalComponentCount() - 2;
        for (int i = 0; i < n; ++i) {
            if (NumberUtils.isEqualNonIEEE(this.m_attributes[i], otherPt.m_attributes[i], tol)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualXY(Point2D ptOther) {
        return ptOther.x == this.x && ptOther.y == this.y;
    }

    public boolean isEqualXY(double x_, double y_) {
        return x_ == this.x && y_ == this.y;
    }

    public boolean isEqualXY(Point2D ptOther, double tol) {
        return Math.abs(ptOther.x - this.x) <= tol && Math.abs(ptOther.y - this.y) <= tol;
    }

    public boolean isEqualXY(double x_, double y_, double tol) {
        return Math.abs(x_ - this.x) <= tol && Math.abs(y_ - this.y) <= tol;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int hashCode() {
        int hashCode = this.m_description.hashCode();
        if (!this.isEmptyImpl()) {
            long bits = Double.doubleToLongBits(this.x);
            int hc = (int)(bits ^ bits >>> 32);
            hashCode = NumberUtils.hash(hashCode, hc);
            bits = Double.doubleToLongBits(this.y);
            hc = (int)(bits ^ bits >>> 32);
            hashCode = NumberUtils.hash(hashCode, hc);
            int n = this.m_description.getTotalComponentCount() - 2;
            for (int i = 0; i < n; ++i) {
                long bits2 = Double.doubleToLongBits(this.m_attributes[i]);
                int hc2 = (int)(bits2 ^ bits2 >>> 32);
                hashCode = NumberUtils.hash(hashCode, hc2);
            }
        }
        return hashCode;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry getBoundary() {
        return null;
    }

    @Override
    @HadoopSDKPublic
    public void replaceNaNs(int semantics, double value) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        for (int i = 0; i < ncomps; ++i) {
            double v = this.getAttributeAsDbl(semantics, i);
            if (!Double.isNaN(v)) continue;
            this.setAttribute(semantics, i, value);
        }
    }

    void copyCommonAttributesTo_(Point dst) {
        assert (!this.isEmpty());
        dst.x = this.x;
        dst.y = this.y;
        VertexDescription vdin = dst.getDescription();
        if (vdin == this.m_description) {
            if (this.m_attributes != null) {
                System.arraycopy(this.m_attributes, 0, dst.m_attributes, 0, this.m_description.getTotalComponentCount() - 2);
            }
        } else {
            int dstComp = 0;
            int nattr = vdin.getAttributeCount();
            for (int iattr = 1; iattr < nattr; ++iattr) {
                int ncomps;
                int semantics = vdin.getSemantics(iattr);
                if (this.m_description.hasAttribute(semantics)) {
                    int offset = this.m_description._getPointAttributeOffset(this.m_description.getAttributeIndex(semantics)) - 2;
                    for (ncomps = VertexDescription.getComponentCount(semantics); ncomps != 0; --ncomps) {
                        dst.m_attributes[dstComp++] = this.m_attributes[offset++];
                    }
                    continue;
                }
                double v = VertexDescription.getDefaultValue(semantics);
                while (ncomps != 0) {
                    dst.m_attributes[dstComp++] = v;
                    --ncomps;
                }
            }
        }
    }

    private final void queryOrds_(int semantics, double[] value) {
        if (semantics == 0) {
            value[0] = this.x;
            value[1] = this.y;
            return;
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (attributeIndex >= 0) {
            int index = this.m_description._getPointAttributeOffset(attributeIndex) - 2;
            value[0] = this.m_attributes[index];
            for (int i = 1; i < ncomps; ++i) {
                value[i] = this.m_attributes[index + i];
            }
        } else {
            double v;
            value[0] = v = VertexDescription.getDefaultValue(semantics);
            for (int i = 1; i < ncomps; ++i) {
                value[i] = v;
            }
        }
    }

    @HadoopSDKPublic
    public void lerp(Point start, Point end, double t) {
        if (start.getDescription() != end.getDescription()) {
            throw new IllegalArgumentException("Point::lerp");
        }
        this.assignVertexDescription(start.getDescription());
        if (start.isEmpty() || end.isEmpty()) {
            this.setEmpty();
            return;
        }
        this.ensureAttributes_();
        double[] v1 = VertexDescription.createComponentArray();
        double[] v2 = VertexDescription.createComponentArray();
        int nattrib = this.m_description.getAttributeCount();
        for (int attrib = 0; attrib < nattrib; ++attrib) {
            int semantics = this.m_description.getSemantics(attrib);
            start.queryOrds_(semantics, v1);
            end.queryOrds_(semantics, v2);
            int interpolation = VertexDescription.getInterpolation(semantics);
            int ncomps = VertexDescription.getComponentCount(semantics);
            MathUtils.interpolate(semantics, interpolation, v1, v2, t, v1, ncomps);
            this.setAttributes(semantics, v1);
        }
    }

    @HadoopSDKPublic
    public static double sqrDistance2D(Point pt1, Point pt2) {
        double dx = pt1.x - pt2.x;
        double dy = pt1.y - pt2.y;
        return dx * dx + dy * dy;
    }

    @Override
    @HadoopSDKPublic
    public VertexDescription getDescription() {
        return this.m_description;
    }

    @Override
    @HadoopSDKPublic
    public void assignVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        this._assignVertexDescriptionImpl(src);
    }

    @Override
    @HadoopSDKPublic
    public void mergeVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        if (this.m_description.hasAttributesFrom(src)) {
            return;
        }
        this._mergeVertexDescriptionImpl(src);
    }

    @Override
    @HadoopSDKPublic
    public boolean hasAttribute(int semantics) {
        return this.m_description.hasAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void addAttribute(int semantics) {
        if (this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.getMergedVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    @HadoopSDKPublic
    public void dropAttribute(int semantics) {
        if (!this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.removeSemanticsFromVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    @HadoopSDKPublic
    public void dropAllAttributes() {
        VertexDescription newvd = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        if (newvd == this.m_description) {
            return;
        }
        this.assignVertexDescription(newvd);
    }
}

