/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.sde.sdk.pe.engine.PeCSTransformations;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeGCSExtent;
import com.esri.sde.sdk.pe.engine.PeGTTransformations;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeGeogtran;
import com.esri.sde.sdk.pe.engine.PeInteger;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeProjectionException;
import com.esri.sde.sdk.pe.factory.PeFactory;
import com.esri.sde.sdk.pe.factory.PeGTlistExtended;
import com.esri.sde.sdk.pe.factory.PeGTlistExtendedEntry;
import com.esri.sde.sdk.pe.factory.PeGTlistExtendedGTs;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
@HadoopSDKExcluded
class PETransformer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ConcurrentHashMap<Integer, PeCoordsys> cache = new ConcurrentHashMap();

    PETransformer() {
    }

    public double[] transform(double[] coords, int numCoords, int from, int to, Envelope extent) throws PeProjectionException {
        if (coords == null || numCoords < 1) {
            throw new IllegalArgumentException("Invalid parameters.");
        }
        PeCoordsys cs1 = this.toCoordsys(from);
        PeCoordsys cs2 = this.toCoordsys(to);
        double[][] tmp = this.to2D(coords);
        PETransformer.project(tmp, numCoords, cs1, cs2, this.toPEExtent(extent));
        return this.to1D(tmp);
    }

    public double[] transform(double x, double y, int numCoords, int from, int to, Envelope extent) throws PeProjectionException {
        double[][] ret = new double[][]{{x, y}};
        PeCoordsys cs1 = this.toCoordsys(from);
        PeCoordsys cs2 = this.toCoordsys(to);
        PETransformer.project(ret, numCoords, cs1, cs2, this.toPEExtent(extent));
        return ret[0];
    }

    double[][] to2D(double[] src) {
        double[][] ret = new double[src.length / 2][2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i][0] = src[i * 2];
            ret[i][1] = src[i * 2 + 1];
        }
        return ret;
    }

    double[] to1D(double[][] src) {
        double[] ret = new double[src.length * 2];
        for (int i = 0; i < src.length; ++i) {
            ret[i * 2] = src[i][0];
            ret[i * 2 + 1] = src[i][1];
        }
        return ret;
    }

    private PeCoordsys toCoordsys(int code) throws PeProjectionException {
        Integer c = code;
        PeCoordsys ret = cache.get(c);
        if (ret == null) {
            ret = PeFactory.coordsys((int)code);
            cache.put(c, ret);
        }
        return ret;
    }

    private PeGCSExtent toPEExtent(Envelope ext) {
        if (ext != null) {
            throw new UnsupportedOperationException("doesn't support extent yet");
        }
        return null;
    }

    static void project(double[][] coords, int numCoords, PeCoordsys cs1, PeCoordsys cs2, PeGCSExtent extent) throws PeProjectionException {
        PeProjcs p2;
        if (cs1.isEqual(cs2)) {
            return;
        }
        PeGeogcs g1 = cs1 instanceof PeGeogcs ? (PeGeogcs)cs1 : null;
        PeGeogcs g2 = cs2 instanceof PeGeogcs ? (PeGeogcs)cs2 : null;
        PeProjcs p1 = cs1 instanceof PeProjcs ? (PeProjcs)cs1 : null;
        PeProjcs peProjcs = p2 = cs2 instanceof PeProjcs ? (PeProjcs)cs2 : null;
        if (g1 != null && g2 != null) {
            PETransformer.projectGCS(coords, numCoords, g1, g2, extent);
            return;
        }
        if (g1 != null && p2 != null) {
            PETransformer.projectGCS(coords, numCoords, g1, p2.getGeogcs(), extent);
            PeCSTransformations.geogToProj((PeProjcs)p2, (int)numCoords, (double[][])coords);
            return;
        }
        if (p1 != null && g2 != null) {
            PeCSTransformations.projToGeog((PeProjcs)p1, (int)numCoords, (double[][])coords);
            PETransformer.projectGCS(coords, numCoords, p1.getGeogcs(), g2, extent);
            return;
        }
        if (p1 != null && p2 != null) {
            PeCSTransformations.projToGeog((PeProjcs)p1, (int)numCoords, (double[][])coords);
            PETransformer.projectGCS(coords, numCoords, p1.getGeogcs(), p2.getGeogcs(), extent);
            PeCSTransformations.geogToProj((PeProjcs)p2, (int)numCoords, (double[][])coords);
        }
    }

    static void projectGCS(double[][] coords, int numCoords, PeGeogcs gcs1, PeGeogcs gcs2, PeGCSExtent extent) throws PeProjectionException {
        if (gcs1.isEqual(gcs2)) {
            return;
        }
        PeGeogtran geogtran = PETransformer.findGeogTran(gcs1, gcs2, extent);
        PeGTTransformations.geogToGeog((PeGeogtran)geogtran, (int)numCoords, (double[][])coords, null, (int)0);
    }

    static PeGeogtran findGeogTran(PeGeogcs gcs1, PeGeogcs gcs2, PeGCSExtent extent) {
        PeGTlistExtendedGTs[] gts;
        PeGTlistExtendedEntry[] codes = PeGTlistExtended.getGTlist((PeCoordsys)gcs1, (PeCoordsys)gcs2, (int)2, (int)1, (PeGCSExtent)extent, (PeInteger)new PeInteger(0));
        PeGeogtran ret = null;
        if (codes != null && codes.length > 0 && (gts = codes[0].getEntries()) != null && gts.length > 0) {
            PeGTlistExtendedGTs gt;
            PeGTlistExtendedGTs[] peGTlistExtendedGTsArray = gts;
            int n = peGTlistExtendedGTsArray.length;
            for (int i = 0; i < n && (ret = (gt = peGTlistExtendedGTsArray[i]).getGeogtran()) == null; ++i) {
            }
        }
        return ret;
    }
}

