/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.TopologicalOperations;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;

final class OperatorUnionCursor
extends GeometryCursor {
    private GeometryCursor m_inputGeoms;
    private ProgressTracker m_progress_tracker;
    private SpatialReferenceImpl m_spatial_reference;
    private int m_index = -1;
    private boolean m_b_done = false;
    private boolean[] m_had_geometry = new boolean[4];
    private int[] m_dim_geom_counts = new int[4];
    private boolean m_b_union_all_dimensions = false;
    private int m_max_dimension = -1;
    private int m_added_geoms = 0;
    private int m_current_dim = -1;
    private int m_options;
    ArrayList<TreeMap<Integer, Bin_type>> m_union_bins = new ArrayList();

    OperatorUnionCursor(GeometryCursor inputGeoms1, SpatialReference sr, ProgressTracker progress_tracker, int options) {
        this.m_inputGeoms = inputGeoms1;
        this.m_spatial_reference = (SpatialReferenceImpl)sr;
        this.m_progress_tracker = progress_tracker;
        this.m_options = options;
    }

    private Geometry get_result_geometry(int dim) {
        assert (this.m_dim_geom_counts[dim] > 0);
        TreeMap<Integer, Bin_type> map = this.m_union_bins.get(dim);
        Map.Entry<Integer, Bin_type> e = map.firstEntry();
        Bin_type bin = e.getValue();
        Geometry resG = bin.geom_to_union().geom;
        boolean unioned = bin.geom_to_union().unioned;
        map.remove(e.getKey());
        if (unioned) {
            if ((this.m_options & 1) == 0) {
                resG = OperatorSimplify.local().execute(resG, (SpatialReference)this.m_spatial_reference, false, this.m_progress_tracker);
            }
            if (dim == 0 && resG.getType() == Geometry.Type.Point) {
                MultiPoint mp = new MultiPoint(resG.getDescription());
                if (!resG.isEmpty()) {
                    mp.add((Point)resG);
                }
                resG = mp;
            }
        }
        return resG;
    }

    @Override
    public Geometry next() {
        if (this.m_b_done && this.m_current_dim == this.m_max_dimension) {
            return null;
        }
        while (!this.step_()) {
        }
        if (this.m_max_dimension == -1) {
            return null;
        }
        if (this.m_b_union_all_dimensions) {
            ++this.m_current_dim;
            do {
                if (this.m_current_dim <= this.m_max_dimension && this.m_current_dim >= 0) continue;
                throw GeometryException.GeometryInternalError();
            } while (!this.m_had_geometry[this.m_current_dim]);
            ++this.m_index;
            return this.get_result_geometry(this.m_current_dim);
        }
        this.m_index = 0;
        assert (this.m_max_dimension >= 0);
        this.m_current_dim = this.m_max_dimension;
        return this.get_result_geometry(this.m_max_dimension);
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private boolean step_() {
        int dim;
        if (this.m_b_done) {
            return true;
        }
        Geometry geom = null;
        if (this.m_inputGeoms != null && (geom = this.m_inputGeoms.next()) == null) {
            this.m_b_done = true;
            this.m_inputGeoms = null;
        }
        if (geom != null) {
            dim = geom.getDimension();
            this.m_had_geometry[dim] = true;
            if (dim >= this.m_max_dimension && !this.m_b_union_all_dimensions) {
                this.add_geom(dim, false, geom);
                if (dim > this.m_max_dimension && !this.m_b_union_all_dimensions) {
                    this.remove_all_bins_with_lower_dimension(dim);
                }
            }
        }
        if (this.m_added_geoms > 0) {
            block0: for (dim = 0; dim <= this.m_max_dimension; ++dim) {
                while (this.m_dim_geom_counts[dim] > 1) {
                    ArrayList<Geometry> batch_to_union = this.collectGeometriesToUnion(dim);
                    boolean serial_execution = true;
                    if (batch_to_union == null) continue block0;
                    Geometry geom_dis = null;
                    geom_dis = (this.m_options & 1) == 0 ? TopologicalOperations.dissolveDirty(batch_to_union, this.m_spatial_reference, this.m_progress_tracker, this.m_options) : TopologicalOperations.dissolve(batch_to_union, this.m_spatial_reference, this.m_progress_tracker, this.m_options);
                    this.add_geom(dim, true, geom_dis);
                }
            }
        }
        return this.m_b_done;
    }

    private ArrayList<Geometry> collectGeometriesToUnion(int dim) {
        ArrayList<Geometry> batch_to_union = null;
        if ((this.m_options & 1) != 0 && !this.m_b_done) {
            return null;
        }
        ArrayList<Map.Entry<Integer, Bin_type>> entriesToRemove = null;
        Set<Map.Entry<Integer, Bin_type>> set = this.m_union_bins.get(dim).entrySet();
        int counter = 0;
        for (Map.Entry<Integer, Bin_type> iter : set) {
            boolean union_batch;
            ++counter;
            Bin_type bin = iter.getValue();
            int c_binVertexThreshold = 5000;
            int c_min_geom_count = 4;
            boolean bl = union_batch = bin.bin_vertex_count > 5000 && bin.geom_count() >= 4;
            if (!this.m_b_done && !union_batch) continue;
            int counter1 = 0;
            for (Map.Entry<Integer, Bin_type> it : set) {
                if (counter == ++counter1) break;
                Bin_type bin1 = it.getValue();
                int n = dim;
                this.m_dim_geom_counts[n] = this.m_dim_geom_counts[n] - bin1.geom_count();
                this.m_added_geoms -= bin1.geom_count();
                while (bin1.geom_count() > 0) {
                    if (batch_to_union == null) {
                        batch_to_union = new ArrayList();
                    }
                    batch_to_union.add(bin1.geom_to_union().geom);
                    bin1.pop_pair();
                }
                if (entriesToRemove == null) {
                    entriesToRemove = new ArrayList();
                }
                entriesToRemove.add(it);
            }
            int n = dim;
            this.m_dim_geom_counts[n] = this.m_dim_geom_counts[n] - bin.geom_count();
            this.m_added_geoms -= bin.geom_count();
            while (bin.geometries.size() > 0) {
                if (batch_to_union == null) {
                    batch_to_union = new ArrayList<Geometry>();
                }
                batch_to_union.add(bin.geom_to_union().geom);
                bin.pop_pair();
            }
            if (entriesToRemove == null) {
                entriesToRemove = new ArrayList<Map.Entry<Integer, Bin_type>>();
            }
            entriesToRemove.add(iter);
            if (this.m_b_done) continue;
            break;
        }
        if (entriesToRemove != null) {
            set.removeAll(entriesToRemove);
        }
        return batch_to_union;
    }

    private void remove_all_bins_with_lower_dimension(int dim) {
        for (int i = 0; i < dim; ++i) {
            this.m_union_bins.get(i).clear();
            this.m_added_geoms -= this.m_dim_geom_counts[i];
            this.m_dim_geom_counts[i] = 0;
        }
    }

    private void add_geom(int dimension, boolean unioned, Geometry geom) {
        Bin_type bin;
        int sz;
        Geom_pair pair = new Geom_pair();
        pair.init();
        pair.geom = geom;
        pair.vertex_count = sz = OperatorUnionCursor.get_vertex_count_(geom);
        Envelope2D env = new Envelope2D();
        geom.queryEnvelope2D(env);
        pair.locx = sz > 0 ? (float)env.getCenterX() : 0.0f;
        pair.locy = sz > 0 ? (float)env.getCenterY() : 0.0f;
        int level = OperatorUnionCursor.get_level_(sz);
        if (dimension + 1 > this.m_union_bins.size()) {
            int n = Math.max(2, dimension + 1);
            for (int i = 0; i < n; ++i) {
                this.m_union_bins.add(new TreeMap());
            }
        }
        if ((bin = this.m_union_bins.get(dimension).get(level)) == null) {
            bin = new Bin_type();
            this.m_union_bins.get(dimension).put(level, bin);
        }
        pair.unioned = unioned;
        bin.add_pair(pair);
        int n = dimension;
        this.m_dim_geom_counts[n] = this.m_dim_geom_counts[n] + 1;
        ++this.m_added_geoms;
        this.m_max_dimension = Math.max(this.m_max_dimension, dimension);
    }

    private static int get_level_(int sz) {
        return sz > 0 ? (int)(Math.log(sz) / Math.log(4.0) + 0.5) : 0;
    }

    private static int get_vertex_count_(Geometry geom) {
        int gt = geom.getType().value();
        if (Geometry.isMultiVertex(gt)) {
            return ((MultiVertexGeometry)geom).getPointCount();
        }
        if (gt == 33) {
            return 1;
        }
        if (gt == 197) {
            return 4;
        }
        if (Geometry.isSegment(gt)) {
            return 2;
        }
        throw GeometryException.GeometryInternalError();
    }

    @Override
    public boolean tock() {
        return this.step_();
    }

    static final class Bin_type {
        private int bin_vertex_count = 0;
        private PriorityQueue<Geom_pair> geometries = new PriorityQueue<Geom_pair>(16, new Comparator<Geom_pair>(){

            @Override
            public int compare(Geom_pair p1, Geom_pair p2) {
                return p1.compare(p2);
            }
        });

        Bin_type() {
        }

        public void add_pair(Geom_pair geom) {
            this.bin_vertex_count += geom.vertex_count;
            this.geometries.add(geom);
        }

        public void pop_pair() {
            this.bin_vertex_count -= this.geometries.peek().vertex_count;
            this.geometries.poll();
        }

        public int size() {
            return this.geometries.size();
        }

        public Geom_pair geom_to_union() {
            return this.geometries.peek();
        }

        public int geom_count() {
            return this.geometries.size();
        }

        public int get_bin_vertex_count() {
            return this.bin_vertex_count;
        }
    }

    private static final class Geom_pair {
        Geometry geom;
        float locx;
        float locy;
        int vertex_count;
        boolean unioned;

        private Geom_pair() {
        }

        public void init() {
            this.geom = null;
            this.vertex_count = -1;
            this.unioned = false;
            this.locx = 0.0f;
            this.locy = 0.0f;
        }

        public int compare(Geom_pair other) {
            return Point2D.compareZOrder(this.locx, this.locy, other.locx, other.locy);
        }
    }
}

