/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorIntersectionCursor;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.SpatialReference;

class OperatorIntersectionLocal
extends OperatorIntersection {
    OperatorIntersectionLocal() {
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeometries, GeometryCursor intersector, SpatialReference sr, ProgressTracker progressTracker) {
        return new OperatorIntersectionCursor(inputGeometries, intersector, sr, progressTracker, -1);
    }

    @Override
    public GeometryCursor execute(GeometryCursor input_geometries, GeometryCursor intersector, SpatialReference sr, ProgressTracker progress_tracker, int dimensionMask) {
        return new OperatorIntersectionCursor(input_geometries, intersector, sr, progress_tracker, dimensionMask);
    }

    @Override
    public Geometry execute(Geometry inputGeometry, Geometry intersector, SpatialReference sr, ProgressTracker progressTracker) {
        if (inputGeometry.getType() == Geometry.Type.Point && intersector.getType() == Geometry.Type.Point) {
            return OperatorIntersectionCursor.intersect_points_((Point)inputGeometry, (Point)intersector, sr);
        }
        SimpleGeometryCursor inputGeomCurs = new SimpleGeometryCursor(inputGeometry);
        SimpleGeometryCursor intersectorCurs = new SimpleGeometryCursor(intersector);
        GeometryCursor geometryCursor = this.execute(inputGeomCurs, intersectorCurs, sr, progressTracker);
        return geometryCursor.next();
    }

    @Override
    public boolean accelerateGeometry(Geometry geometry, SpatialReference spatialReference, Geometry.GeometryAccelerationDegree accelDegree) {
        if (!this.canAccelerateGeometry(geometry)) {
            return false;
        }
        double tol = InternalUtils.calculateToleranceFromGeometryForOp(spatialReference, geometry, true);
        boolean accelerated = ((MultiVertexGeometryImpl)geometry._getImpl())._buildQuadTreeAccelerator(accelDegree);
        return accelerated |= ((MultiVertexGeometryImpl)geometry._getImpl())._buildRasterizedGeometryAccelerator(tol, accelDegree);
    }

    @Override
    public boolean canAccelerateGeometry(Geometry geometry) {
        return RasterizedGeometry2D.canUseAccelerator(geometry);
    }
}

