/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorGeodeticLength;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.ShapePreservingLength;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.sde.sdk.pe.engine.PeDouble;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLineType;
import com.esri.sde.sdk.pe.engine.PeSpheroid;

@HadoopSDKExcluded
class OperatorGeodeticLengthLocal
extends OperatorGeodeticLength {
    OperatorGeodeticLengthLocal() {
    }

    @Override
    public double execute(Geometry geometry, SpatialReference sr, int geodeticCurveType, ProgressTracker progressTracker) {
        MultiPath tmpPolyline;
        if (sr == null || sr.getCoordinateSystemType() == SpatialReference.Type.Local || sr.getCoordinateSystemType() == SpatialReference.Type.Image) {
            throw new IllegalArgumentException("");
        }
        if (geometry.isEmpty() || geometry.getDimension() < 1) {
            return 0.0;
        }
        if (geodeticCurveType == 4) {
            return new ShapePreservingLength(sr, progressTracker).execute(geometry);
        }
        SpatialReference gcs = sr.getGCS();
        PeGeogcs pegeogcs = (PeGeogcs)((SpatialReferenceImpl)gcs).getPECoordSys();
        PeSpheroid spheroid = pegeogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        double a = spheroid.getAxis();
        double e_squared = flattening * (2.0 - flattening);
        double rpu = ((SpatialReferenceImpl)gcs).getUnit().getUnitToBaseFactor();
        Geometry.Type type = geometry.getType();
        if (type == Geometry.Type.Polygon || type == Geometry.Type.Envelope) {
            tmpPolyline = (MultiPath)geometry.getBoundary();
        } else if (Geometry.isSegment(type.value())) {
            tmpPolyline = new Polyline(geometry.getDescription());
            tmpPolyline.addSegment((Segment)geometry, true);
        } else {
            tmpPolyline = (MultiPath)geometry;
        }
        if (gcs != sr) {
            MultiPath gcsPolyline;
            ProjectionTransformation transform = ((SpatialReferenceImpl)sr).getSRToGCSTransform();
            if (sr.isPannable()) {
                tmpPolyline = (MultiPath)ProjectionUtils.clipGeometryFromTopAndBottom(tmpPolyline, sr);
                if (type == Geometry.Type.Polyline && tmpPolyline == geometry) {
                    tmpPolyline = (MultiPath)Geometry._clone(geometry);
                }
                Envelope1D period = new Envelope1D();
                sr.getPannableExtent().queryIntervalX(period);
                Point2D pt = new Point2D();
                int npoints = tmpPolyline.getPointCount();
                for (int ipoint = 0; ipoint < npoints; ++ipoint) {
                    tmpPolyline.getXY(ipoint, pt);
                    pt.x = ProjectionUtils.normalizeX(pt.x, period);
                    tmpPolyline.setXY(ipoint, pt);
                }
            }
            tmpPolyline = ProjectionUtils.projectMultiPathVerticesPCSToGCS(transform, tmpPolyline, gcsPolyline = (MultiPath)tmpPolyline.createInstance(), progressTracker) ? gcsPolyline : (MultiPath)OperatorProject.local().execute(tmpPolyline, transform, progressTracker);
        }
        return this.executeMultiPathGeodeticLength(tmpPolyline, geodeticCurveType, a, e_squared, rpu);
    }

    double executeMultiPathGeodeticLength(MultiPath multiPath, int geodeticCurveType, double a, double eSquared, double rpu) {
        PeDouble peDouble = new PeDouble();
        double geodeticLength = 0.0;
        SegmentIterator iter = multiPath.querySegmentIterator();
        Point2D pt_start = new Point2D();
        Point2D pt_end = new Point2D();
        while (iter.nextPath()) {
            while (iter.hasNextSegment()) {
                Segment segment = iter.nextSegment();
                segment.getStartXY(pt_start);
                segment.getEndXY(pt_end);
                pt_start.scale(rpu);
                pt_end.scale(rpu);
                PeLineType.geodetic_distance((double)a, (double)eSquared, (double)pt_start.x, (double)pt_start.y, (double)pt_end.x, (double)pt_end.y, (PeDouble)peDouble, null, null, (int)geodeticCurveType);
                geodeticLength += peDouble.val;
            }
        }
        return geodeticLength;
    }
}

