/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeodeticAreaCalculator;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorGeodeticArea;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ShapePreservingArea;
import com.esri.core.geometry.SpatialReference;
import java.util.ArrayList;

@HadoopSDKExcluded
class OperatorGeodeticAreaLocal
extends OperatorGeodeticArea {
    OperatorGeodeticAreaLocal() {
    }

    @Override
    public double execute(Geometry geom, SpatialReference sr, int geodeticCurveType, ProgressTracker progressTracker) {
        if (geodeticCurveType == 4) {
            return new ShapePreservingArea(sr, progressTracker).execute(geom);
        }
        GeodeticAreaCalculator geogAreaCalcul = new GeodeticAreaCalculator(sr, geodeticCurveType, progressTracker);
        return geogAreaCalcul.calculate(geom);
    }

    ArrayList<Envelope2D> _getClippingEnvelopes(Envelope2D _envelope, AttributeStreamOfDbl lonLatArray) {
        Envelope2D envelope = new Envelope2D();
        envelope.setCoords(_envelope);
        if (envelope.ymin > 1.3089969389957472 || envelope.ymax < -1.3089969389957472) {
            return null;
        }
        double maxWidth = 6.283010774254387;
        double width = envelope.getWidth();
        if (envelope.ymin > -0.08726646259971647 || envelope.ymax < 0.08726646259971647) {
            if (width <= maxWidth) {
                return null;
            }
            ArrayList<Envelope2D> clipEnvelopesArray = new ArrayList<Envelope2D>(0);
            envelope.inflate(1.0E-5, 1.0E-5);
            width = envelope.getWidth();
            int cEnvelopes = (int)Math.ceil(width / maxWidth);
            double xmin = envelope.xmin;
            double ymin = envelope.ymin;
            double ymax = envelope.ymax;
            for (int i = 0; i < cEnvelopes; ++i) {
                if (i != 0) {
                    lonLatArray.add(xmin);
                }
                Envelope2D clipEnvelope = new Envelope2D();
                clipEnvelope.setCoords(xmin, ymin, xmin + maxWidth, ymax);
                clipEnvelopesArray.add(clipEnvelope);
                xmin = clipEnvelope.xmax;
            }
            return clipEnvelopesArray;
        }
        if (envelope.ymax <= 0.7853981633974483 && envelope.ymin >= -0.7853981633974483) {
            return null;
        }
        ArrayList<Envelope2D> clipEnvelopesArray = new ArrayList<Envelope2D>();
        envelope.inflate(1.0E-5, 1.0E-5);
        width = envelope.getWidth();
        lonLatArray.add(NumberUtils.NaN());
        int cEnvelopeColums = (int)Math.ceil(width / maxWidth);
        if (cEnvelopeColums == 1) {
            Envelope2D clipEnvelope = new Envelope2D();
            clipEnvelope.setCoords(envelope.xmin, 0.0, envelope.xmax, envelope.ymax);
            clipEnvelopesArray.add(clipEnvelope);
            clipEnvelope = new Envelope2D();
            clipEnvelope.setCoords(envelope.xmin, envelope.ymin, envelope.xmax, 0.0);
            clipEnvelopesArray.add(clipEnvelope);
            return clipEnvelopesArray;
        }
        double xmin = envelope.xmin;
        double ymin = 0.0;
        double ymax = envelope.ymax;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < cEnvelopeColums; ++j) {
                if (j != 0) {
                    lonLatArray.add(xmin);
                }
                Envelope2D clipEnvelope = new Envelope2D();
                clipEnvelope.setCoords(xmin, ymin, xmin + maxWidth, ymax);
                clipEnvelopesArray.add(clipEnvelope);
                xmin = clipEnvelope.xmax;
            }
            xmin = envelope.xmin;
            ymin = envelope.ymin;
            ymax = 0.0;
        }
        return clipEnvelopesArray;
    }

    Polygon _insertGeodeticPoints(Polygon polygon, double x) {
        Polygon newPolygon = new Polygon();
        MultiPathImpl mpImplNew = (MultiPathImpl)newPolygon._getImpl();
        boolean equator = NumberUtils.isNaN(x);
        MultiVertexGeometryImpl vertexGeometryImpl = (MultiVertexGeometryImpl)polygon._getImpl();
        AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)vertexGeometryImpl.getAttributeStreamRef(0);
        int cParts = polygon.getPathCount();
        Point2D pt1 = new Point2D();
        Point2D pt2 = new Point2D();
        Point2D pt = new Point2D();
        Point2D firstPointInPart = new Point2D();
        int i1 = polygon.getPathStart(0);
        for (int iPart = 0; iPart < cParts; ++iPart) {
            xyStream.read(i1 << 1, firstPointInPart);
            pt1.setCoords(firstPointInPart);
            newPolygon.startPath(firstPointInPart);
            int i2 = polygon.getPathEnd(iPart);
            for (int i = i1 + 1; i <= i2; ++i) {
                if (i < i2) {
                    xyStream.read(i << 1, pt2);
                } else {
                    pt2.setCoords(firstPointInPart);
                }
                if (equator) {
                    if ((pt1.y != 0.0 || pt2.y != 0.0) && (pt1.y < 0.0 && pt2.y > 0.0 || pt1.y > 0.0 && pt2.y < 0.0)) {
                        pt.x = pt1.x + (pt2.x - pt1.x) * (0.0 - pt1.y) / (pt2.y - pt1.y);
                        pt.y = 0.0;
                        mpImplNew.lineTo(pt);
                    }
                } else if (pt1.x < x && pt2.x > x || pt1.x > x && pt2.x < x) {
                    pt.x = x;
                    pt.y = pt1.y + (pt2.y - pt1.y) * (x - pt1.x) / (pt2.x - pt1.x);
                    mpImplNew.lineTo(pt);
                }
                mpImplNew.lineTo(pt2);
                pt1.setCoords(pt2);
            }
            i1 = i2;
        }
        return newPolygon;
    }
}

