/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.JsonParserReader;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorBoundaryLocal;
import com.esri.core.geometry.OperatorBufferLocal;
import com.esri.core.geometry.OperatorCentroid2DLocal;
import com.esri.core.geometry.OperatorClipLocal;
import com.esri.core.geometry.OperatorContainsLocal;
import com.esri.core.geometry.OperatorConvexHullLocal;
import com.esri.core.geometry.OperatorCrossesLocal;
import com.esri.core.geometry.OperatorCutLocal;
import com.esri.core.geometry.OperatorDensifyByLengthLocal;
import com.esri.core.geometry.OperatorDifferenceLocal;
import com.esri.core.geometry.OperatorDisjointLocal;
import com.esri.core.geometry.OperatorDistanceLocal;
import com.esri.core.geometry.OperatorEqualsLocal;
import com.esri.core.geometry.OperatorExportToESRIShape;
import com.esri.core.geometry.OperatorExportToESRIShapeLocal;
import com.esri.core.geometry.OperatorExportToGeoJsonLocal;
import com.esri.core.geometry.OperatorExportToJson;
import com.esri.core.geometry.OperatorExportToJsonLocal;
import com.esri.core.geometry.OperatorExportToWkbLocal;
import com.esri.core.geometry.OperatorExportToWkt;
import com.esri.core.geometry.OperatorExportToWktLocal;
import com.esri.core.geometry.OperatorFactory;
import com.esri.core.geometry.OperatorGeneralizeLocal;
import com.esri.core.geometry.OperatorGeodesicBufferLocal;
import com.esri.core.geometry.OperatorGeodeticAreaLocal;
import com.esri.core.geometry.OperatorGeodeticDensifyLocal;
import com.esri.core.geometry.OperatorGeodeticLengthLocal;
import com.esri.core.geometry.OperatorGraphicBufferLocal;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.OperatorImportFromESRIShapeLocal;
import com.esri.core.geometry.OperatorImportFromGeoJsonLocal;
import com.esri.core.geometry.OperatorImportFromJson;
import com.esri.core.geometry.OperatorImportFromJsonLocal;
import com.esri.core.geometry.OperatorImportFromWkb;
import com.esri.core.geometry.OperatorImportFromWkbLocal;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.OperatorImportFromWktLocal;
import com.esri.core.geometry.OperatorIntersectionLocal;
import com.esri.core.geometry.OperatorIntersectsLocal;
import com.esri.core.geometry.OperatorLabelPointLocal;
import com.esri.core.geometry.OperatorLocateAlongLocal;
import com.esri.core.geometry.OperatorLocateBetweenLocal;
import com.esri.core.geometry.OperatorOffsetLocal;
import com.esri.core.geometry.OperatorOverlapsLocal;
import com.esri.core.geometry.OperatorProjectLocal;
import com.esri.core.geometry.OperatorProximity2DLocal;
import com.esri.core.geometry.OperatorRelateLocal;
import com.esri.core.geometry.OperatorShapePreservingDensifyLocal;
import com.esri.core.geometry.OperatorSimplifyLocal;
import com.esri.core.geometry.OperatorSimplifyOGCLocal;
import com.esri.core.geometry.OperatorSubCurveLocal;
import com.esri.core.geometry.OperatorSymmetricDifferenceLocal;
import com.esri.core.geometry.OperatorTouchesLocal;
import com.esri.core.geometry.OperatorUnionLocal;
import com.esri.core.geometry.OperatorWithinLocal;
import com.esri.core.geometry.SpatialReference;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;

@HadoopSDKPublic
public class OperatorFactoryLocal
extends OperatorFactory {
    private static final OperatorFactoryLocal INSTANCE = new OperatorFactoryLocal();
    private static final HashMap<Operator.Type, Operator> st_supportedOperators = new HashMap();
    static OperatorProjectLocal st_project = new OperatorProjectLocal();
    static OperatorSimplifyLocal st_simplify;
    static OperatorCentroid2DLocal st_centroid2D;
    static OperatorLabelPointLocal st_labelPoint;
    static OperatorDistanceLocal st_distance;
    static OperatorUnionLocal st_union;
    static OperatorDisjointLocal st_disjoint;
    static OperatorRelateLocal st_relate;
    static OperatorIntersectsLocal st_intersects;
    static OperatorIntersectionLocal st_intersection;
    static OperatorSimplifyOGCLocal st_simplifyOGC;
    static OperatorLocateAlongLocal st_locateAlong;
    static OperatorLocateBetweenLocal st_locateBetween;
    static OperatorImportFromJsonLocal st_importFromJson;
    static OperatorImportFromESRIShapeLocal st_importFromEsriShape;
    static OperatorExportToJsonLocal st_exportToJson;
    static OperatorImportFromWkbLocal st_importFromWkb;
    static OperatorGeodeticLengthLocal st_geodeticLength;
    static OperatorGeodeticAreaLocal st_geodeticArea;
    static OperatorOffsetLocal st_offset;
    static OperatorGeneralizeLocal st_generalize;
    static OperatorSymmetricDifferenceLocal st_symDif;
    static OperatorDifferenceLocal st_difference;
    static OperatorBufferLocal st_buffer;
    static OperatorGraphicBufferLocal st_graphicBuffer;
    static OperatorClipLocal st_clip;
    static OperatorSubCurveLocal st_subcurve;

    private OperatorFactoryLocal() {
    }

    @HadoopSDKPublic
    public static OperatorFactoryLocal getInstance() {
        return INSTANCE;
    }

    @Override
    @HadoopSDKPublic
    public Operator getOperator(Operator.Type type) {
        if (st_supportedOperators.containsKey((Object)type)) {
            return st_supportedOperators.get((Object)type);
        }
        throw new IllegalArgumentException();
    }

    @Override
    @HadoopSDKPublic
    public boolean isOperatorSupported(Operator.Type type) {
        return st_supportedOperators.containsKey((Object)type);
    }

    @HadoopSDKPublic
    public static void saveJSONToTextFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        OperatorFactoryLocal engine = OperatorFactoryLocal.getInstance();
        OperatorExportToJson exporterJSON = (OperatorExportToJson)engine.getOperator(Operator.Type.ExportToJson);
        String jsonString = exporterJSON.execute(spatial_ref, geometry);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @HadoopSDKPublic
    public static MapGeometry loadGeometryFromJSONFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            stream.close();
            jsonString = builder.toString();
        }
        catch (Exception stream) {
            // empty catch block
        }
        MapGeometry mapGeom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, JsonParserReader.createFromString(jsonString));
        return mapGeom;
    }

    @HadoopSDKPublic
    public static MapGeometry loadGeometryFromJSONStringDbg(String json) {
        if (json == null) {
            throw new IllegalArgumentException();
        }
        MapGeometry mapGeom = null;
        try {
            mapGeom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        return mapGeom;
    }

    @HadoopSDKPublic
    public static Geometry loadGeometryFromEsriShapeDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            FileInputStream stream = new FileInputStream(file_name);
            FileChannel fchan = stream.getChannel();
            ByteBuffer bb = ByteBuffer.allocate((int)fchan.size());
            fchan.read(bb);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            Geometry g = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, bb);
            fchan.close();
            stream.close();
            return g;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    @HadoopSDKPublic
    public static void saveGeometryToEsriShapeDbg(String file_name, Geometry geometry) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer bb = OperatorExportToESRIShape.local().execute(0, geometry);
            FileOutputStream outfile = new FileOutputStream(file_name);
            FileChannel fchan = outfile.getChannel();
            fchan.write(bb);
            fchan.close();
            outfile.close();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    @HadoopSDKPublic
    public static void saveToWKTFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = OperatorExportToWkt.local().execute(0, geometry, null);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @HadoopSDKPublic
    public static Geometry loadGeometryFromWKTFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String s = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            stream.close();
            s = builder.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, s, null);
    }

    @HadoopSDKPublic
    public static Geometry loadGeometryFromWKBDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            FileInputStream stream = new FileInputStream(file_name);
            FileChannel fchan = stream.getChannel();
            ByteBuffer bb = ByteBuffer.allocate((int)fchan.size());
            fchan.read(bb);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            Geometry g = OperatorImportFromWkb.local().execute(0, Geometry.Type.Unknown, bb, null);
            fchan.close();
            stream.close();
            return g;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    static {
        st_supportedOperators.put(Operator.Type.Project, st_project);
        st_exportToJson = new OperatorExportToJsonLocal();
        st_supportedOperators.put(Operator.Type.ExportToJson, st_exportToJson);
        st_importFromJson = new OperatorImportFromJsonLocal();
        st_supportedOperators.put(Operator.Type.ImportFromJson, st_importFromJson);
        st_supportedOperators.put(Operator.Type.ExportToESRIShape, new OperatorExportToESRIShapeLocal());
        st_importFromEsriShape = new OperatorImportFromESRIShapeLocal();
        st_supportedOperators.put(Operator.Type.ImportFromESRIShape, st_importFromEsriShape);
        st_supportedOperators.put(Operator.Type.Proximity2D, new OperatorProximity2DLocal());
        st_supportedOperators.put(Operator.Type.DensifyByLength, new OperatorDensifyByLengthLocal());
        st_relate = new OperatorRelateLocal();
        st_supportedOperators.put(Operator.Type.Relate, st_relate);
        st_supportedOperators.put(Operator.Type.Equals, new OperatorEqualsLocal());
        st_disjoint = new OperatorDisjointLocal();
        st_supportedOperators.put(Operator.Type.Disjoint, st_disjoint);
        st_intersects = new OperatorIntersectsLocal();
        st_supportedOperators.put(Operator.Type.Intersects, st_intersects);
        st_supportedOperators.put(Operator.Type.Within, new OperatorWithinLocal());
        st_supportedOperators.put(Operator.Type.Contains, new OperatorContainsLocal());
        st_supportedOperators.put(Operator.Type.Crosses, new OperatorCrossesLocal());
        st_supportedOperators.put(Operator.Type.Touches, new OperatorTouchesLocal());
        st_supportedOperators.put(Operator.Type.Overlaps, new OperatorOverlapsLocal());
        st_simplifyOGC = new OperatorSimplifyOGCLocal();
        st_supportedOperators.put(Operator.Type.SimplifyOGC, st_simplifyOGC);
        st_simplify = new OperatorSimplifyLocal();
        st_supportedOperators.put(Operator.Type.Simplify, st_simplify);
        st_offset = new OperatorOffsetLocal();
        st_supportedOperators.put(Operator.Type.Offset, st_offset);
        st_supportedOperators.put(Operator.Type.GeodeticDensifyByLength, new OperatorGeodeticDensifyLocal());
        st_supportedOperators.put(Operator.Type.ShapePreservingDensify, new OperatorShapePreservingDensifyLocal());
        st_supportedOperators.put(Operator.Type.GeodesicBuffer, new OperatorGeodesicBufferLocal());
        st_geodeticLength = new OperatorGeodeticLengthLocal();
        st_supportedOperators.put(Operator.Type.GeodeticLength, st_geodeticLength);
        st_geodeticArea = new OperatorGeodeticAreaLocal();
        st_supportedOperators.put(Operator.Type.GeodeticArea, st_geodeticArea);
        st_buffer = new OperatorBufferLocal();
        st_supportedOperators.put(Operator.Type.Buffer, st_buffer);
        st_graphicBuffer = new OperatorGraphicBufferLocal();
        st_supportedOperators.put(Operator.Type.GraphicBuffer, st_graphicBuffer);
        st_distance = new OperatorDistanceLocal();
        st_supportedOperators.put(Operator.Type.Distance, st_distance);
        st_intersection = new OperatorIntersectionLocal();
        st_supportedOperators.put(Operator.Type.Intersection, st_intersection);
        st_difference = new OperatorDifferenceLocal();
        st_supportedOperators.put(Operator.Type.Difference, st_difference);
        st_symDif = new OperatorSymmetricDifferenceLocal();
        st_supportedOperators.put(Operator.Type.SymmetricDifference, st_symDif);
        st_clip = new OperatorClipLocal();
        st_supportedOperators.put(Operator.Type.Clip, st_clip);
        st_supportedOperators.put(Operator.Type.Cut, new OperatorCutLocal());
        st_supportedOperators.put(Operator.Type.ExportToWkb, new OperatorExportToWkbLocal());
        st_importFromWkb = new OperatorImportFromWkbLocal();
        st_supportedOperators.put(Operator.Type.ImportFromWkb, st_importFromWkb);
        st_supportedOperators.put(Operator.Type.ExportToWkt, new OperatorExportToWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromWkt, new OperatorImportFromWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromGeoJson, new OperatorImportFromGeoJsonLocal());
        st_supportedOperators.put(Operator.Type.ExportToGeoJson, new OperatorExportToGeoJsonLocal());
        st_union = new OperatorUnionLocal();
        st_supportedOperators.put(Operator.Type.Union, st_union);
        st_generalize = new OperatorGeneralizeLocal();
        st_supportedOperators.put(Operator.Type.Generalize, st_generalize);
        st_supportedOperators.put(Operator.Type.ConvexHull, new OperatorConvexHullLocal());
        st_supportedOperators.put(Operator.Type.Boundary, new OperatorBoundaryLocal());
        st_centroid2D = new OperatorCentroid2DLocal();
        st_supportedOperators.put(Operator.Type.Centroid, st_centroid2D);
        st_labelPoint = new OperatorLabelPointLocal();
        st_supportedOperators.put(Operator.Type.LabelPoint, st_labelPoint);
        st_locateAlong = new OperatorLocateAlongLocal();
        st_supportedOperators.put(Operator.Type.LocateAlong, st_locateAlong);
        st_locateBetween = new OperatorLocateBetweenLocal();
        st_supportedOperators.put(Operator.Type.LocateBetween, st_locateBetween);
        st_subcurve = new OperatorSubCurveLocal();
        st_supportedOperators.put(Operator.Type.Subcurve, st_subcurve);
    }
}

