/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.BucketSort;
import com.esri.core.geometry.ClassicSort;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.StridedIndexTypeCollection;
import java.util.ArrayList;

@HadoopSDKExcluded
class OctTreeImpl {
    private Envelope3D m_extent;
    private Envelope3D m_data_extent;
    private StridedIndexTypeCollection m_oct_tree_nodes;
    private StridedIndexTypeCollection m_element_nodes;
    private ArrayList<Data> m_data;
    private AttributeStreamOfInt32 m_free_data;
    private int m_root;
    private int m_height;
    private boolean m_b_store_duplicates;
    private int m_octant_mask = 7;
    private int m_height_bit_shift = 3;
    private int m_flushing_count = 9;

    OctTreeImpl(Envelope3D extent, int height) {
        this.m_oct_tree_nodes = new StridedIndexTypeCollection(14);
        this.m_element_nodes = new StridedIndexTypeCollection(4);
        this.m_data = new ArrayList(0);
        this.m_free_data = new AttributeStreamOfInt32(0);
        this.m_b_store_duplicates = false;
        this.m_extent = new Envelope3D();
        this.m_data_extent = new Envelope3D();
        this.reset_(extent, height);
    }

    OctTreeImpl(Envelope3D extent, int height, boolean b_store_duplicates) {
        this.m_oct_tree_nodes = b_store_duplicates ? new StridedIndexTypeCollection(15) : new StridedIndexTypeCollection(14);
        this.m_element_nodes = new StridedIndexTypeCollection(4);
        this.m_data = new ArrayList(0);
        this.m_free_data = new AttributeStreamOfInt32(0);
        this.m_b_store_duplicates = b_store_duplicates;
        this.m_extent = new Envelope3D();
        this.m_data_extent = new Envelope3D();
        this.reset_(extent, height);
    }

    void reset(Envelope3D extent, int height) {
        this.m_oct_tree_nodes.deleteAll(false);
        this.m_element_nodes.deleteAll(false);
        this.m_data.clear();
        this.m_free_data.clear(false);
        this.reset_(extent, height);
    }

    int insert(int element, Envelope3D bounding_box) {
        if (this.m_root == -1) {
            this.create_root_();
        }
        if (this.m_b_store_duplicates) {
            int success = this.insert_duplicates_(element, bounding_box, 0, this.m_extent, this.m_root, false, -1);
            if (success != -1) {
                if (this.m_data_extent.isEmpty()) {
                    this.m_data_extent.setCoords(bounding_box);
                } else {
                    this.m_data_extent.merge(bounding_box);
                }
            }
            return success;
        }
        int element_handle = this.insert_(element, bounding_box, 0, this.m_extent, this.m_root, false, -1);
        if (element_handle != -1) {
            if (this.m_data_extent.isEmpty()) {
                this.m_data_extent.setCoords(bounding_box);
            } else {
                this.m_data_extent.merge(bounding_box);
            }
        }
        return element_handle;
    }

    int insert(int element, Envelope3D bounding_box, int hint_index) {
        Envelope3D oct_extent;
        if (this.m_root == -1) {
            this.create_root_();
        }
        if (this.m_b_store_duplicates) {
            int success = this.insert_duplicates_(element, bounding_box, 0, this.m_extent, this.m_root, false, -1);
            if (success != -1) {
                if (this.m_data_extent.isEmpty()) {
                    this.m_data_extent.setCoords(bounding_box);
                } else {
                    this.m_data_extent.merge(bounding_box);
                }
            }
            return success;
        }
        int oct_handle = hint_index == -1 ? this.m_root : this.get_octant_(hint_index);
        int oct_height = this.getHeight(oct_handle);
        int element_handle = this.insert_(element, bounding_box, oct_height, oct_extent = this.getExtent(oct_handle), oct_handle, false, -1);
        if (element_handle != -1) {
            if (this.m_data_extent.isEmpty()) {
                this.m_data_extent.setCoords(bounding_box);
            } else {
                this.m_data_extent.merge(bounding_box);
            }
        }
        return element_handle;
    }

    void removeElement(int element_handle) {
        if (this.m_b_store_duplicates) {
            throw new GeometryException("invalid call");
        }
        int oct_handle = this.get_octant_(element_handle);
        this.disconnect_element_handle_(element_handle);
        this.free_element_and_box_node_(element_handle);
        int q = oct_handle;
        while (q != -1) {
            this.set_sub_tree_element_count_(q, this.get_sub_tree_element_count_(q) - 1);
            int parent = this.get_parent_(q);
            if (this.get_sub_tree_element_count_(q) == 0) {
                assert (this.get_local_element_count_(q) == 0);
                if (q != this.m_root) {
                    int octant_encoding = this.get_octant_encoding_(q);
                    this.m_oct_tree_nodes.deleteElement(q);
                    this.set_child_(parent, octant_encoding, -1);
                }
            }
            q = parent;
        }
    }

    int getElement(int element_handle) {
        return this.get_element_value_(this.get_data_(element_handle));
    }

    int getElementAtIndex(int i) {
        return this.m_data.get((int)i).element;
    }

    Envelope3D getElementExtent(int element_handle) {
        int data_handle = this.get_data_(element_handle);
        return this.get_bounding_box_value_(data_handle);
    }

    Envelope3D getElementExtentAtIndex(int i) {
        return this.m_data.get((int)i).box;
    }

    Envelope3D getDataExtent() {
        return this.m_data_extent;
    }

    Envelope3D getOctTreeExtent() {
        return this.m_extent;
    }

    int getHeight(int oct_handle) {
        return this.get_height_(oct_handle);
    }

    int getMaxHeight() {
        return this.m_height;
    }

    Envelope3D getExtent(int oct_handle) {
        Envelope3D oct_extent = new Envelope3D();
        oct_extent.setCoords(this.m_extent);
        if (oct_handle == this.m_root) {
            return oct_extent;
        }
        AttributeStreamOfInt32 octant_encodings = new AttributeStreamOfInt32(0);
        int q = oct_handle;
        do {
            octant_encodings.add(this.get_octant_encoding_(q));
        } while ((q = this.get_parent_(q)) != this.m_root);
        int sz = octant_encodings.size();
        assert (sz == this.getHeight(oct_handle));
        for (int i = 0; i < sz; ++i) {
            int child = octant_encodings.getLast();
            octant_encodings.removeLast();
            if (child == 0) {
                oct_extent.xmin = 0.5 * (oct_extent.xmin + oct_extent.xmax);
                oct_extent.ymin = 0.5 * (oct_extent.ymin + oct_extent.ymax);
                oct_extent.zmin = 0.5 * (oct_extent.zmin + oct_extent.zmax);
                continue;
            }
            if (child == 1) {
                oct_extent.xmax = 0.5 * (oct_extent.xmin + oct_extent.xmax);
                oct_extent.ymin = 0.5 * (oct_extent.ymin + oct_extent.ymax);
                oct_extent.zmin = 0.5 * (oct_extent.zmin + oct_extent.zmax);
                continue;
            }
            if (child == 2) {
                oct_extent.xmax = 0.5 * (oct_extent.xmin + oct_extent.xmax);
                oct_extent.ymax = 0.5 * (oct_extent.ymin + oct_extent.ymax);
                oct_extent.zmin = 0.5 * (oct_extent.zmin + oct_extent.zmax);
                continue;
            }
            if (child == 3) {
                oct_extent.xmin = 0.5 * (oct_extent.xmin + oct_extent.xmax);
                oct_extent.ymax = 0.5 * (oct_extent.ymin + oct_extent.ymax);
                oct_extent.zmin = 0.5 * (oct_extent.zmin + oct_extent.zmax);
                continue;
            }
            if (child == 4) {
                oct_extent.xmin = 0.5 * (oct_extent.xmin + oct_extent.xmax);
                oct_extent.ymin = 0.5 * (oct_extent.ymin + oct_extent.ymax);
                oct_extent.zmax = 0.5 * (oct_extent.zmin + oct_extent.zmax);
                continue;
            }
            if (child == 5) {
                oct_extent.xmax = 0.5 * (oct_extent.xmin + oct_extent.xmax);
                oct_extent.ymin = 0.5 * (oct_extent.ymin + oct_extent.ymax);
                oct_extent.zmax = 0.5 * (oct_extent.zmin + oct_extent.zmax);
                continue;
            }
            if (child == 6) {
                oct_extent.xmax = 0.5 * (oct_extent.xmin + oct_extent.xmax);
                oct_extent.ymax = 0.5 * (oct_extent.ymin + oct_extent.ymax);
                oct_extent.zmax = 0.5 * (oct_extent.zmin + oct_extent.zmax);
                continue;
            }
            oct_extent.xmin = 0.5 * (oct_extent.xmin + oct_extent.xmax);
            oct_extent.ymax = 0.5 * (oct_extent.ymin + oct_extent.ymax);
            oct_extent.zmax = 0.5 * (oct_extent.zmin + oct_extent.zmax);
        }
        return oct_extent;
    }

    int getOctant(int element_handle) {
        return this.get_octant_(element_handle);
    }

    int getElementCount() {
        if (this.m_root == -1) {
            return 0;
        }
        assert (this.get_sub_tree_element_count_(this.m_root) == this.m_data.size());
        return this.get_sub_tree_element_count_(this.m_root);
    }

    int getSubTreeElementCount(int oct_handle) {
        return this.get_sub_tree_element_count_(oct_handle);
    }

    int getContainedSubTreeElementCount(int oct_handle) {
        if (!this.m_b_store_duplicates) {
            return this.get_sub_tree_element_count_(oct_handle);
        }
        return this.get_contained_sub_tree_element_count_(oct_handle);
    }

    int getIntersectionCount(Envelope3D query, double tolerance, int max_count) {
        if (this.m_root == -1) {
            return 0;
        }
        Envelope3D query_inflated = new Envelope3D();
        query_inflated.setCoords(query);
        query_inflated.inflate(tolerance, tolerance, tolerance);
        AttributeStreamOfInt32 octants_stack = new AttributeStreamOfInt32(0);
        ArrayList<Envelope3D> extents_stack = new ArrayList<Envelope3D>(0);
        octants_stack.add(this.m_root);
        extents_stack.add(new Envelope3D(this.m_extent.xmin, this.m_extent.ymin, this.m_extent.zmin, this.m_extent.xmax, this.m_extent.ymax, this.m_extent.zmax));
        Envelope3D[] child_extents = new Envelope3D[]{new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D()};
        Envelope3D current_extent = new Envelope3D();
        int intersection_count = 0;
        while (octants_stack.size() > 0) {
            boolean b_subdivide = false;
            int current_oct_handle = octants_stack.getLast();
            current_extent.setCoords((Envelope3D)extents_stack.get(extents_stack.size() - 1));
            octants_stack.removeLast();
            extents_stack.remove(extents_stack.size() - 1);
            if (query_inflated.contains(current_extent)) {
                if (max_count > 0 && (intersection_count += this.getSubTreeElementCount(current_oct_handle)) >= max_count) {
                    return max_count;
                }
            } else if (query_inflated.isIntersecting(current_extent)) {
                int element_handle = this.get_first_element_(current_oct_handle);
                while (element_handle != -1) {
                    int data_handle = this.get_data_(element_handle);
                    Envelope3D env = this.get_bounding_box_value_(data_handle);
                    if (env.isIntersecting(query_inflated) && max_count > 0 && ++intersection_count >= max_count) {
                        return max_count;
                    }
                    element_handle = this.get_next_element_(element_handle);
                }
                boolean bl = b_subdivide = this.getHeight(current_oct_handle) + 1 <= this.m_height;
            }
            if (!b_subdivide) continue;
            OctTreeImpl.set_child_extents_(current_extent, child_extents);
            for (int i = 0; i < 8; ++i) {
                boolean b_is_intersecting;
                int child_handle = this.get_child_(current_oct_handle, i);
                if (child_handle == -1 || this.getSubTreeElementCount(child_handle) <= 0 || !(b_is_intersecting = query_inflated.isIntersecting(child_extents[i]))) continue;
                octants_stack.add(child_handle);
                extents_stack.add(new Envelope3D(child_extents[i].xmin, child_extents[i].ymin, child_extents[i].zmin, child_extents[i].xmax, child_extents[i].ymax, child_extents[i].zmax));
            }
        }
        return intersection_count;
    }

    boolean hasData(Envelope3D query, double tolerance) {
        int count = this.getIntersectionCount(query, tolerance, 1);
        return count >= 1;
    }

    OctTreeIteratorImpl getIterator(Geometry query, double tolerance) {
        return new OctTreeIteratorImpl(this, query, tolerance);
    }

    OctTreeIteratorImpl getIterator(Envelope3D query, double tolerance) {
        return new OctTreeIteratorImpl(this, query, tolerance);
    }

    OctTreeIteratorImpl getIterator() {
        return new OctTreeIteratorImpl(this);
    }

    OctTreeSortedIteratorImpl getSortedIterator(Geometry query, double tolerance) {
        return new OctTreeSortedIteratorImpl(this.getIterator(query, tolerance));
    }

    OctTreeSortedIteratorImpl getSortedIterator(Envelope3D query, double tolerance) {
        return new OctTreeSortedIteratorImpl(this.getIterator(query, tolerance));
    }

    OctTreeSortedIteratorImpl getSortedIterator() {
        return new OctTreeSortedIteratorImpl(this.getIterator());
    }

    private void reset_(Envelope3D extent, int height) {
        if (height < 0 || height > 127) {
            throw new IllegalArgumentException("invalid height");
        }
        this.m_height = height;
        this.m_extent.setCoords(extent);
        this.m_root = this.m_oct_tree_nodes.newElement();
        this.m_data_extent.setEmpty();
        this.m_root = -1;
    }

    private int insert_(int element, Envelope3D bounding_box, int height, Envelope3D oct_extent, int oct_handle, boolean b_flushing, int flushed_element_handle) {
        int current_height;
        if (!oct_extent.contains(bounding_box)) {
            assert (!b_flushing);
            if (height == 0) {
                return -1;
            }
            return this.insert_(element, bounding_box, 0, this.m_extent, this.m_root, b_flushing, flushed_element_handle);
        }
        if (!b_flushing) {
            int q = oct_handle;
            while (q != -1) {
                this.set_sub_tree_element_count_(q, this.get_sub_tree_element_count_(q) + 1);
                q = this.get_parent_(q);
            }
        }
        Envelope3D current_extent = new Envelope3D();
        current_extent.setCoords(oct_extent);
        int current_oct_handle = oct_handle;
        Envelope3D[] child_extents = new Envelope3D[]{new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D()};
        for (current_height = height; current_height < this.m_height && this.can_push_down_(current_oct_handle); ++current_height) {
            OctTreeImpl.set_child_extents_(current_extent, child_extents);
            boolean b_contains = false;
            for (int i = 0; i < 8; ++i) {
                if (!child_extents[i].contains(bounding_box)) continue;
                b_contains = true;
                int child_handle = this.get_child_(current_oct_handle, i);
                if (child_handle == -1) {
                    child_handle = this.create_child_(current_oct_handle, i);
                }
                this.set_sub_tree_element_count_(child_handle, this.get_sub_tree_element_count_(child_handle) + 1);
                current_oct_handle = child_handle;
                current_extent.setCoords(child_extents[i]);
                break;
            }
            if (!b_contains) break;
        }
        return this.insert_at_octant_(element, bounding_box, current_height, current_extent, current_oct_handle, b_flushing, oct_handle, flushed_element_handle, -1);
    }

    private int insert_duplicates_(int element, Envelope3D bounding_box, int height, Envelope3D oct_extent, int oct_handle, boolean b_flushing, int flushed_element_handle) {
        assert (b_flushing || this.m_root == oct_handle);
        if (!b_flushing) {
            if (!oct_extent.contains(bounding_box)) {
                return -1;
            }
            this.set_sub_tree_element_count_(oct_handle, this.get_sub_tree_element_count_(oct_handle) + 1);
            this.set_contained_sub_tree_element_count_(oct_handle, this.get_contained_sub_tree_element_count_(oct_handle) + 1);
        }
        double bounding_box_max_dim = Math.max(bounding_box.getWidth(), bounding_box.getHeight());
        bounding_box_max_dim = Math.max(bounding_box_max_dim, bounding_box.getDepth());
        int element_handle = -1;
        AttributeStreamOfInt32 octants_stack = new AttributeStreamOfInt32(0);
        ArrayList<Envelope3D> extents_stack = new ArrayList<Envelope3D>(0);
        AttributeStreamOfInt32 heights_stack = new AttributeStreamOfInt32(0);
        octants_stack.add(oct_handle);
        extents_stack.add(new Envelope3D(oct_extent.xmin, oct_extent.ymin, oct_extent.zmin, oct_extent.xmax, oct_extent.ymax, oct_extent.zmax));
        heights_stack.add(height);
        Envelope3D[] child_extents = new Envelope3D[]{new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D()};
        Envelope3D current_extent = new Envelope3D();
        while (octants_stack.size() > 0) {
            boolean b_subdivide = false;
            int current_oct_handle = octants_stack.getLast();
            current_extent.setCoords((Envelope3D)extents_stack.get(extents_stack.size() - 1));
            int current_height = heights_stack.getLast();
            octants_stack.removeLast();
            extents_stack.remove(extents_stack.size() - 1);
            heights_stack.removeLast();
            if (current_height + 1 < this.m_height && this.can_push_down_(current_oct_handle)) {
                double current_extent_max_dim = Math.max(current_extent.getWidth(), current_extent.getHeight());
                if (bounding_box_max_dim <= (current_extent_max_dim = Math.max(current_extent_max_dim, current_extent.getDepth())) / 2.0) {
                    b_subdivide = true;
                }
            }
            if (b_subdivide) {
                int i;
                OctTreeImpl.set_child_extents_(current_extent, child_extents);
                boolean b_contains = false;
                for (i = 0; i < 8; ++i) {
                    b_contains = child_extents[i].contains(bounding_box);
                    if (!b_contains) continue;
                    int child_handle = this.get_child_(current_oct_handle, i);
                    if (child_handle == -1) {
                        child_handle = this.create_child_(current_oct_handle, i);
                    }
                    octants_stack.add(child_handle);
                    extents_stack.add(new Envelope3D(child_extents[i].xmin, child_extents[i].ymin, child_extents[i].zmin, child_extents[i].xmax, child_extents[i].ymax, child_extents[i].zmax));
                    heights_stack.add(current_height + 1);
                    this.set_sub_tree_element_count_(child_handle, this.get_sub_tree_element_count_(child_handle) + 1);
                    this.set_contained_sub_tree_element_count_(child_handle, this.get_contained_sub_tree_element_count_(child_handle) + 1);
                    break;
                }
                if (b_contains) continue;
                for (i = 0; i < 8; ++i) {
                    boolean b_intersects = child_extents[i].isIntersecting(bounding_box);
                    if (!b_intersects) continue;
                    int child_handle = this.get_child_(current_oct_handle, i);
                    if (child_handle == -1) {
                        child_handle = this.create_child_(current_oct_handle, i);
                    }
                    octants_stack.add(child_handle);
                    extents_stack.add(new Envelope3D(child_extents[i].xmin, child_extents[i].ymin, child_extents[i].zmin, child_extents[i].xmax, child_extents[i].ymax, child_extents[i].zmax));
                    heights_stack.add(current_height + 1);
                    this.set_sub_tree_element_count_(child_handle, this.get_sub_tree_element_count_(child_handle) + 1);
                }
                continue;
            }
            element_handle = this.insert_at_octant_(element, bounding_box, current_height, current_extent, current_oct_handle, b_flushing, oct_handle, flushed_element_handle, element_handle);
            b_flushing = false;
        }
        return 0;
    }

    private int insert_at_octant_(int element, Envelope3D bounding_box, int current_height, Envelope3D current_extent, int current_oct_handle, boolean b_flushing, int oct_handle, int flushed_element_handle, int duplicate_element_handle) {
        int head_element_handle = this.get_first_element_(current_oct_handle);
        int tail_element_handle = this.get_last_element_(current_oct_handle);
        int element_handle = -1;
        if (b_flushing) {
            assert (flushed_element_handle != -1);
            if (current_oct_handle == oct_handle) {
                return flushed_element_handle;
            }
            this.disconnect_element_handle_(flushed_element_handle);
            element_handle = flushed_element_handle;
        } else if (duplicate_element_handle == -1) {
            element_handle = this.create_element_();
            this.set_data_values_(this.get_data_(element_handle), element, bounding_box);
        } else {
            assert (this.m_b_store_duplicates);
            element_handle = this.create_element_from_duplicate_(duplicate_element_handle);
        }
        assert (!b_flushing || element_handle == flushed_element_handle);
        this.set_oct_(element_handle, current_oct_handle);
        if (tail_element_handle != -1) {
            this.set_prev_element_(element_handle, tail_element_handle);
            this.set_next_element_(tail_element_handle, element_handle);
        } else {
            assert (head_element_handle == -1);
            this.set_first_element_(current_oct_handle, element_handle);
        }
        this.set_last_element_(current_oct_handle, element_handle);
        this.set_local_element_count_(current_oct_handle, this.get_local_element_count_(current_oct_handle) + 1);
        if (this.can_flush_(current_oct_handle)) {
            this.flush_(current_height, current_extent, current_oct_handle);
        }
        return element_handle;
    }

    private static void set_child_extents_(Envelope3D current_extent, Envelope3D[] child_extents) {
        double x_mid = 0.5 * (current_extent.xmin + current_extent.xmax);
        double y_mid = 0.5 * (current_extent.ymin + current_extent.ymax);
        double z_mid = 0.5 * (current_extent.zmin + current_extent.zmax);
        child_extents[0].setCoords(x_mid, y_mid, z_mid, current_extent.xmax, current_extent.ymax, current_extent.zmax);
        child_extents[1].setCoords(current_extent.xmin, y_mid, z_mid, x_mid, current_extent.ymax, current_extent.zmax);
        child_extents[2].setCoords(current_extent.xmin, current_extent.ymin, z_mid, x_mid, y_mid, current_extent.zmax);
        child_extents[3].setCoords(x_mid, current_extent.ymin, z_mid, current_extent.xmax, y_mid, current_extent.zmax);
        child_extents[4].setCoords(x_mid, y_mid, current_extent.zmin, current_extent.xmax, current_extent.ymax, z_mid);
        child_extents[5].setCoords(current_extent.xmin, y_mid, current_extent.zmin, x_mid, current_extent.ymax, z_mid);
        child_extents[6].setCoords(current_extent.xmin, current_extent.ymin, current_extent.zmin, x_mid, y_mid, z_mid);
        child_extents[7].setCoords(x_mid, current_extent.ymin, current_extent.zmin, current_extent.xmax, y_mid, z_mid);
    }

    private void disconnect_element_handle_(int element_handle) {
        assert (element_handle != -1);
        int oct_handle = this.get_octant_(element_handle);
        int head_element_handle = this.get_first_element_(oct_handle);
        int tail_element_handle = this.get_last_element_(oct_handle);
        int prev_element_handle = this.get_prev_element_(element_handle);
        int next_element_handle = this.get_next_element_(element_handle);
        assert (head_element_handle != -1 && tail_element_handle != -1);
        if (head_element_handle == element_handle) {
            if (next_element_handle != -1) {
                this.set_prev_element_(next_element_handle, -1);
            } else {
                assert (head_element_handle == tail_element_handle);
                assert (this.get_local_element_count_(oct_handle) == 1);
                this.set_last_element_(oct_handle, -1);
            }
            this.set_first_element_(oct_handle, next_element_handle);
        } else if (tail_element_handle == element_handle) {
            assert (prev_element_handle != -1);
            assert (this.get_local_element_count_(oct_handle) >= 2);
            this.set_next_element_(prev_element_handle, -1);
            this.set_last_element_(oct_handle, prev_element_handle);
        } else {
            assert (next_element_handle != -1 && prev_element_handle != -1);
            assert (this.get_local_element_count_(oct_handle) >= 3);
            this.set_prev_element_(next_element_handle, prev_element_handle);
            this.set_next_element_(prev_element_handle, next_element_handle);
        }
        this.set_prev_element_(element_handle, -1);
        this.set_next_element_(element_handle, -1);
        this.set_local_element_count_(oct_handle, this.get_local_element_count_(oct_handle) - 1);
        assert (this.get_local_element_count_(oct_handle) >= 0);
    }

    private boolean can_flush_(int oct_handle) {
        return this.get_local_element_count_(oct_handle) == this.m_flushing_count && !this.has_children_(oct_handle);
    }

    private void flush_(int height, Envelope3D extent, int oct_handle) {
        Envelope3D bounding_box = new Envelope3D();
        assert (oct_handle != -1);
        int element_handle = this.get_first_element_(oct_handle);
        int next_handle = -1;
        int data_handle = -1;
        assert (element_handle != -1);
        do {
            data_handle = this.get_data_(element_handle);
            int element = this.get_element_value_(data_handle);
            bounding_box.setCoords(this.get_bounding_box_value_(data_handle));
            next_handle = this.get_next_element_(element_handle);
            if (!this.m_b_store_duplicates) {
                this.insert_(element, bounding_box, height, extent, oct_handle, true, element_handle);
                continue;
            }
            this.insert_duplicates_(element, bounding_box, height, extent, oct_handle, true, element_handle);
        } while ((element_handle = next_handle) != -1);
    }

    private boolean can_push_down_(int oct_handle) {
        return this.get_local_element_count_(oct_handle) >= this.m_flushing_count || this.has_children_(oct_handle);
    }

    private boolean has_children_(int parent) {
        return this.get_child_(parent, 0) != -1 || this.get_child_(parent, 1) != -1 || this.get_child_(parent, 2) != -1 || this.get_child_(parent, 3) != -1 || this.get_child_(parent, 4) != -1 || this.get_child_(parent, 5) != -1 || this.get_child_(parent, 6) != -1 || this.get_child_(parent, 7) != -1;
    }

    private int create_child_(int parent, int octant_encoding) {
        int child = this.m_oct_tree_nodes.newElement();
        this.set_child_(parent, octant_encoding, child);
        this.set_sub_tree_element_count_(child, 0);
        this.set_local_element_count_(child, 0);
        this.set_parent_(child, parent);
        this.set_height_and_octant_encoding_(child, this.get_height_(parent) + 1, octant_encoding);
        if (this.m_b_store_duplicates) {
            this.set_contained_sub_tree_element_count_(child, 0);
        }
        return child;
    }

    private void create_root_() {
        this.m_root = this.m_oct_tree_nodes.newElement();
        this.set_sub_tree_element_count_(this.m_root, 0);
        this.set_local_element_count_(this.m_root, 0);
        this.set_height_and_octant_encoding_(this.m_root, 0, 0);
        if (this.m_b_store_duplicates) {
            this.set_contained_sub_tree_element_count_(this.m_root, 0);
        }
    }

    private int create_element_() {
        int data_handle;
        int element_handle = this.m_element_nodes.newElement();
        if (this.m_free_data.size() > 0) {
            data_handle = this.m_free_data.get(this.m_free_data.size() - 1);
            this.m_free_data.removeLast();
        } else {
            data_handle = this.m_data.size();
            this.m_data.add(null);
        }
        this.set_data_(element_handle, data_handle);
        return element_handle;
    }

    private int create_element_from_duplicate_(int duplicate_element_handle) {
        int element_handle = this.m_element_nodes.newElement();
        int data_handle = this.get_data_(duplicate_element_handle);
        this.set_data_(element_handle, data_handle);
        return element_handle;
    }

    private void free_element_and_box_node_(int element_handle) {
        int data_handle = this.get_data_(element_handle);
        this.m_free_data.add(data_handle);
        this.m_element_nodes.deleteElement(element_handle);
    }

    private int get_child_(int oct_handle, int octant_encoding) {
        return this.m_oct_tree_nodes.getField(oct_handle, octant_encoding);
    }

    private void set_child_(int parent, int octant, int child) {
        this.m_oct_tree_nodes.setField(parent, octant, child);
    }

    private int get_first_element_(int oct_handle) {
        return this.m_oct_tree_nodes.getField(oct_handle, 8);
    }

    private void set_first_element_(int oct_handle, int head) {
        this.m_oct_tree_nodes.setField(oct_handle, 8, head);
    }

    private int get_last_element_(int oct_handle) {
        return this.m_oct_tree_nodes.getField(oct_handle, 9);
    }

    private void set_last_element_(int oct_handle, int tail) {
        this.m_oct_tree_nodes.setField(oct_handle, 9, tail);
    }

    private int get_octant_encoding_(int oct_handle) {
        int height_octant_encoding_hybrid = this.m_oct_tree_nodes.getField(oct_handle, 10);
        int octant_encoding = height_octant_encoding_hybrid & this.m_octant_mask;
        return octant_encoding;
    }

    private int get_height_(int oct_handle) {
        int height_octant_encoding_hybrid = this.m_oct_tree_nodes.getField(oct_handle, 10);
        int height = height_octant_encoding_hybrid >> this.m_height_bit_shift;
        return height;
    }

    private void set_height_and_octant_encoding_(int oct_handle, int height, int octant_encoding) {
        assert (octant_encoding >= 0 && octant_encoding <= 7);
        int height_octant_encoding_hybrid = height << this.m_height_bit_shift | octant_encoding;
        this.m_oct_tree_nodes.setField(oct_handle, 10, height_octant_encoding_hybrid);
    }

    private int get_local_element_count_(int oct_handle) {
        return this.m_oct_tree_nodes.getField(oct_handle, 11);
    }

    private void set_local_element_count_(int oct_handle, int count) {
        this.m_oct_tree_nodes.setField(oct_handle, 11, count);
    }

    private int get_sub_tree_element_count_(int oct_handle) {
        return this.m_oct_tree_nodes.getField(oct_handle, 12);
    }

    private void set_sub_tree_element_count_(int oct_handle, int count) {
        this.m_oct_tree_nodes.setField(oct_handle, 12, count);
    }

    private int get_parent_(int child) {
        return this.m_oct_tree_nodes.getField(child, 13);
    }

    private void set_parent_(int child, int parent) {
        this.m_oct_tree_nodes.setField(child, 13, parent);
    }

    private int get_contained_sub_tree_element_count_(int oct_handle) {
        return this.m_oct_tree_nodes.getField(oct_handle, 14);
    }

    private void set_contained_sub_tree_element_count_(int oct_handle, int count) {
        this.m_oct_tree_nodes.setField(oct_handle, 14, count);
    }

    private int get_data_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 0);
    }

    private void set_data_(int element_handle, int data_handle) {
        this.m_element_nodes.setField(element_handle, 0, data_handle);
    }

    private int get_prev_element_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 1);
    }

    private int get_next_element_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 2);
    }

    private void set_prev_element_(int element_handle, int prev_handle) {
        this.m_element_nodes.setField(element_handle, 1, prev_handle);
    }

    private void set_next_element_(int element_handle, int next_handle) {
        this.m_element_nodes.setField(element_handle, 2, next_handle);
    }

    private int get_octant_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 3);
    }

    private void set_oct_(int element_handle, int parent) {
        this.m_element_nodes.setField(element_handle, 3, parent);
    }

    private int get_element_value_(int data_handle) {
        return this.m_data.get((int)data_handle).element;
    }

    private Envelope3D get_bounding_box_value_(int data_handle) {
        return this.m_data.get((int)data_handle).box;
    }

    private void set_data_values_(int data_handle, int element, Envelope3D bounding_box) {
        this.m_data.set(data_handle, new Data(element, bounding_box));
    }

    static final class Data {
        int element;
        Envelope3D box;

        Data(int element_, Envelope3D box_) {
            this.element = element_;
            this.box = new Envelope3D();
            this.box.setCoords(box_);
        }
    }

    static final class OctTreeSortedIteratorImpl {
        private BucketSort m_bucket_sort = new BucketSort();
        private AttributeStreamOfInt32 m_sorted_handles = new AttributeStreamOfInt32(0);
        private OctTreeIteratorImpl m_oct_tree_iterator_impl;
        int m_index;

        void resetIterator(Geometry query, double tolerance) {
            this.m_oct_tree_iterator_impl.resetIterator(query, tolerance);
            this.m_sorted_handles.resize(0);
            this.m_index = -1;
        }

        void resetIterator(Envelope3D query, double tolerance) {
            this.m_oct_tree_iterator_impl.resetIterator(query, tolerance);
            this.m_sorted_handles.resize(0);
            this.m_index = -1;
        }

        int next() {
            if (this.m_index == -1) {
                int element_handle = -1;
                while ((element_handle = this.m_oct_tree_iterator_impl.next()) != -1) {
                    this.m_sorted_handles.add(element_handle);
                }
                this.m_bucket_sort.sort(this.m_sorted_handles, 0, this.m_sorted_handles.size(), new Sorter(this.m_oct_tree_iterator_impl.m_oct_tree));
            }
            if (this.m_index == this.m_sorted_handles.size() - 1) {
                return -1;
            }
            ++this.m_index;
            return this.m_sorted_handles.get(this.m_index);
        }

        OctTreeSortedIteratorImpl(OctTreeIteratorImpl oct_tree_iterator_impl) {
            this.m_oct_tree_iterator_impl = oct_tree_iterator_impl;
            this.m_index = -1;
        }

        private class Sorter
        extends ClassicSort {
            private OctTreeImpl m_oct_tree;

            public Sorter(OctTreeImpl oct_tree) {
                this.m_oct_tree = oct_tree;
            }

            @Override
            public void userSort(int begin, int end, AttributeStreamOfInt32 indices) {
                indices.sort(begin, end);
            }

            @Override
            public double getValue(int e) {
                return this.m_oct_tree.getElement(e);
            }
        }
    }

    static final class OctTreeIteratorImpl {
        private Envelope3D m_query_box;
        private int m_current_element_handle;
        private int m_next_element_handle;
        private OctTreeImpl m_oct_tree;
        private AttributeStreamOfInt32 m_octants_stack;
        private ArrayList<Envelope3D> m_extents_stack;

        void resetIterator(Geometry query, double tolerance) {
            this.m_octants_stack.resize(0);
            this.m_extents_stack.clear();
            this.m_current_element_handle = -1;
            query.queryLooseEnvelope3D(this.m_query_box);
            this.m_query_box.inflate(tolerance, tolerance, tolerance);
            if (this.m_oct_tree.m_root != -1 && this.m_query_box.isIntersecting(this.m_oct_tree.m_extent)) {
                this.m_octants_stack.add(this.m_oct_tree.m_root);
                this.m_extents_stack.add(this.m_oct_tree.m_extent);
                this.m_next_element_handle = this.m_oct_tree.get_first_element_(this.m_oct_tree.m_root);
            } else {
                this.m_next_element_handle = -1;
            }
        }

        void resetIterator(Envelope3D query, double tolerance) {
            this.m_octants_stack.resize(0);
            this.m_extents_stack.clear();
            this.m_current_element_handle = -1;
            this.m_query_box.setCoords(query);
            this.m_query_box.inflate(tolerance, tolerance, tolerance);
            if (this.m_oct_tree.m_root != -1 && this.m_query_box.isIntersecting(this.m_oct_tree.m_extent)) {
                this.m_octants_stack.add(this.m_oct_tree.m_root);
                this.m_extents_stack.add(this.m_oct_tree.m_extent);
                this.m_next_element_handle = this.m_oct_tree.get_first_element_(this.m_oct_tree.m_root);
            } else {
                this.m_next_element_handle = -1;
            }
        }

        int next() {
            if (this.m_octants_stack.size() == 0) {
                return -1;
            }
            this.m_current_element_handle = this.m_next_element_handle;
            Envelope3D[] child_extents = null;
            boolean b_found_hit = false;
            while (!b_found_hit) {
                while (this.m_current_element_handle != -1) {
                    int current_data_handle = this.m_oct_tree.get_data_(this.m_current_element_handle);
                    Envelope3D bounding_box = this.m_oct_tree.get_bounding_box_value_(current_data_handle);
                    if (bounding_box.isIntersecting(this.m_query_box)) {
                        b_found_hit = true;
                        break;
                    }
                    this.m_current_element_handle = this.m_oct_tree.get_next_element_(this.m_current_element_handle);
                }
                if (this.m_current_element_handle != -1) continue;
                int current_oct = this.m_octants_stack.getLast();
                Envelope3D current_extent = this.m_extents_stack.get(this.m_extents_stack.size() - 1);
                if (child_extents == null) {
                    child_extents = new Envelope3D[]{new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D(), new Envelope3D()};
                }
                OctTreeImpl.set_child_extents_(current_extent, child_extents);
                this.m_octants_stack.removeLast();
                this.m_extents_stack.remove(this.m_extents_stack.size() - 1);
                for (int octant_encoding = 0; octant_encoding < 8; ++octant_encoding) {
                    int child_handle = this.m_oct_tree.get_child_(current_oct, octant_encoding);
                    if (child_handle == -1 || this.m_oct_tree.getSubTreeElementCount(child_handle) <= 0 || !child_extents[octant_encoding].isIntersecting(this.m_query_box)) continue;
                    Envelope3D child_extent = new Envelope3D();
                    child_extent.setCoords(child_extents[octant_encoding]);
                    this.m_octants_stack.add(child_handle);
                    this.m_extents_stack.add(child_extent);
                }
                assert (this.m_octants_stack.size() <= 8 * (this.m_oct_tree.m_height - 1));
                if (this.m_octants_stack.size() == 0) {
                    return -1;
                }
                this.m_current_element_handle = this.m_oct_tree.get_first_element_(this.m_octants_stack.get(this.m_octants_stack.size() - 1));
            }
            this.m_next_element_handle = this.m_oct_tree.get_next_element_(this.m_current_element_handle);
            return this.m_current_element_handle;
        }

        OctTreeIteratorImpl(OctTreeImpl oct_tree_impl, Geometry query, double tolerance) {
            this.m_oct_tree = oct_tree_impl;
            this.m_query_box = new Envelope3D();
            this.m_octants_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
            this.resetIterator(query, tolerance);
        }

        OctTreeIteratorImpl(OctTreeImpl oct_tree_impl, Envelope3D query, double tolerance) {
            this.m_oct_tree = oct_tree_impl;
            this.m_query_box = new Envelope3D();
            this.m_octants_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
            this.resetIterator(query, tolerance);
        }

        OctTreeIteratorImpl(OctTreeImpl oct_tree_impl) {
            this.m_oct_tree = oct_tree_impl;
            this.m_query_box = new Envelope3D();
            this.m_octants_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
        }
    }
}

