/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.HadoopSDKPublic;

@HadoopSDKPublic
public class NumberUtils {
    public static final double TheNaN = Double.NaN;
    private static final int[] c_high_bit4 = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};

    @HadoopSDKPublic
    public static int snap(int v, int minv, int maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    @HadoopSDKPublic
    public static long snap(long v, long minv, long maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    @HadoopSDKPublic
    public static double snap(double v, double minv, double maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    public static int sizeOf(double v) {
        return 8;
    }

    public static int sizeOfDouble() {
        return 8;
    }

    public static int sizeOf(int v) {
        return 4;
    }

    public static int sizeOf(long v) {
        return 8;
    }

    public static int sizeOf(byte v) {
        return 1;
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(float d) {
        return Float.isNaN(d);
    }

    public static double NaN() {
        return Double.NaN;
    }

    @HadoopSDKPublic
    public static int hashCombine(int hash1, int hash2) {
        return hash1 * 31 + hash2 & Integer.MAX_VALUE;
    }

    public static int hash(int n) {
        int hash = 5381;
        hash = (hash << 5) + hash + (n & 0xFF);
        hash = (hash << 5) + hash + (n >> 8 & 0xFF);
        hash = (hash << 5) + hash + (n >> 16 & 0xFF);
        hash = (hash << 5) + hash + (n >> 24 & 0xFF);
        return hash &= Integer.MAX_VALUE;
    }

    public static int hash(double d) {
        long bits = Double.doubleToLongBits(d);
        int hc = (int)(bits ^ bits >>> 32);
        return NumberUtils.hash(hc);
    }

    public static int hash(int hashIn, int n) {
        int hash = (hashIn << 5) + hashIn + (n & 0xFF);
        hash = (hash << 5) + hash + (n >> 8 & 0xFF);
        hash = (hash << 5) + hash + (n >> 16 & 0xFF);
        hash = (hash << 5) + hash + (n >> 24 & 0xFF);
        return hash &= Integer.MAX_VALUE;
    }

    public static int hash(int hash, double d) {
        long bits = Double.doubleToLongBits(d);
        int hc = (int)(bits ^ bits >>> 32);
        return NumberUtils.hash(hash, hc);
    }

    public static long doubleToInt64Bits(double d) {
        return Double.doubleToLongBits(d);
    }

    public static double negativeInf() {
        return Double.NEGATIVE_INFINITY;
    }

    public static double positiveInf() {
        return Double.POSITIVE_INFINITY;
    }

    public static int intMax() {
        return Integer.MAX_VALUE;
    }

    public static double doubleEps() {
        return 2.220446049250313E-16;
    }

    public static double doubleMax() {
        return Double.MAX_VALUE;
    }

    static long doubleFraction(double value) {
        return Double.doubleToRawLongBits(value) & 0xFFFFFFFFFFFFFL;
    }

    static short doubleExponent(double value) {
        return (short)((Double.doubleToRawLongBits(value) & 0x7FF0000000000000L) >>> 52);
    }

    public static int nextRand(int prevRand) {
        return 1103515245 * prevRand + 12345 & NumberUtils.intMax();
    }

    public static boolean isEqualNonIEEE(double a, double b) {
        return a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static boolean isEqualNonIEEE(double a, double b, double tolerance) {
        return a == b || Math.abs(a - b) <= tolerance || Double.isNaN(a) && Double.isNaN(b);
    }

    public static boolean isEqualNonIEEE(float a, float b) {
        return a == b || Float.isNaN(a) && Float.isNaN(b);
    }

    public static int compareWithNaNs(double a, double b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        assert (Double.isNaN(a) || Double.isNaN(b));
        boolean nan_a = Double.isNaN(a);
        boolean nan_b = Double.isNaN(b);
        return !nan_a && nan_b ? -1 : (nan_a && !nan_b ? 1 : 0);
    }

    static int highBit32(int v) {
        int n = 0;
        if ((v & 0xFFFF0000) != 0) {
            n += 16;
            v >>= 16;
        }
        if ((v & 0xFF00) != 0) {
            n += 8;
            v >>= 8;
        }
        if ((v & 0xF0) != 0) {
            n += 4;
            v >>= 4;
        }
        return n + c_high_bit4[v & 0xF];
    }

    static int highBit64(long v) {
        int n = 0;
        if ((v & 0xFFFFFFFF00000000L) != 0L) {
            n = 32;
            v >>>= 32;
        }
        return n + NumberUtils.highBit32((int)v);
    }
}

