/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.HadoopSDKPublic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@HadoopSDKExcluded
public final class NthElement {
    @HadoopSDKPublic
    public static <E> void execute(List<E> list, int first, int pos, int last, Comparator<E> comparator) {
        NthElement.select_(list, first, pos, last - 1, comparator);
    }

    @HadoopSDKPublic
    public static <E> int partitionApproximate(List<E> list, int first, int middle, int last, Comparator<E> comparator, int true_median_threshold_element_count) {
        E temp;
        int i;
        int sz = last - first;
        assert (sz >= 0);
        if (sz <= true_median_threshold_element_count) {
            NthElement.execute(list, first, middle, last, comparator);
            return middle;
        }
        int pivot = NthElement.chooseApproximatePivot_(list, first, last, comparator, true_median_threshold_element_count);
        E pivot_value = list.get(pivot);
        E temp2 = list.get(first);
        list.set(pivot, temp2);
        list.set(first, pivot_value);
        int store = first + 1;
        boolean swapped_any = false;
        for (i = first + 1; i != last; ++i) {
            if (comparator.compare(list.get(i), pivot_value) >= 0) continue;
            temp = list.get(i);
            list.set(i, list.get(store));
            list.set(store, temp);
            ++store;
            swapped_any = true;
        }
        if (!swapped_any) {
            for (i = first + 1; i != middle; ++i) {
                if (comparator.compare(list.get(i), pivot_value) > 0) continue;
                if (i != store) {
                    temp = list.get(i);
                    list.set(i, list.get(store));
                    list.set(store, temp);
                }
                ++store;
            }
        }
        E temp3 = list.get(first);
        list.set(first, list.get(--store));
        list.set(store, temp3);
        return store;
    }

    private static <E> int chooseApproximatePivot_(List<E> list, int from, int to, Comparator<E> comparator, int true_median_threshold_element_count) {
        int[] positions = new int[true_median_threshold_element_count];
        NthElement.fillPositions_(positions, to - from);
        ArrayList med_buffer = new ArrayList();
        int n = positions.length;
        for (int i = 0; i < n; ++i) {
            int k = positions[i];
            APair p = new APair();
            p.first = list.get(from + k);
            p.second = from + k;
            med_buffer.add(p);
        }
        int mid = positions.length / 2;
        NthElement.execute(med_buffer, 0, mid, med_buffer.size(), new APairComparator<E>(comparator));
        return ((APair)med_buffer.get((int)mid)).second;
    }

    private static void fillPositions_(int[] positions, int n) {
        int count = positions.length;
        assert (n > count);
        long k = n / 2;
        for (int i = 0; i < count; ++i) {
            positions[i] = (int)(k % (long)n);
            k = 6364136223846793005L * k + 1442695040888963407L & Long.MAX_VALUE;
        }
        Arrays.sort(positions);
    }

    private static <E> int select_(List<E> list, int left, int n, int right, Comparator<E> comparator) {
        assert (left <= n && n <= right);
        if (left == right) {
            return left;
        }
        int l = left;
        int r = right;
        int pivotIndex = -1;
        while (pivotIndex != n) {
            pivotIndex = NthElement.pivot_(list, l, r, comparator);
            if (n == (pivotIndex = NthElement.partition_(list, l, pivotIndex, r, comparator))) break;
            if (n < pivotIndex) {
                r = pivotIndex - 1;
                continue;
            }
            l = pivotIndex + 1;
        }
        return n;
    }

    private static <E> int partition_(List<E> list, int left, int pivotIndex, int right, Comparator<E> comparator) {
        if (comparator.compare(list.get(pivotIndex), list.get(right)) != 0) {
            Collections.swap(list, pivotIndex, right);
        }
        E pivotValue = list.get(right);
        int j = left;
        for (int i = left; i <= right - 1; ++i) {
            if (comparator.compare(list.get(i), pivotValue) >= 0) continue;
            Collections.swap(list, j, i);
            ++j;
        }
        if (comparator.compare(list.get(right), list.get(j)) != 0) {
            Collections.swap(list, right, j);
        }
        return j;
    }

    private static <E> int pivot_(List<E> list, int left, int right, Comparator<E> comparator) {
        int medianSub;
        int l = left;
        int r = left - 1;
        int i = left;
        for (int j = i + 4; j <= right; j += 4) {
            medianSub = NthElement.medianSub_(list, i, j, comparator);
            if (comparator.compare(list.get(medianSub), list.get(++r)) != 0) {
                Collections.swap(list, medianSub, r);
            }
            i = ++j;
        }
        if (i <= right && comparator.compare(list.get(medianSub = NthElement.medianSub_(list, i, right, comparator)), list.get(++r)) != 0) {
            Collections.swap(list, medianSub, r);
        }
        int m = l + r >> 1;
        return NthElement.select_(list, l, m, r, comparator);
    }

    private static <E> int medianSub_(List<E> list, int left, int right, Comparator<E> comparator) {
        int n = right - left;
        assert (n <= 4);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                int index1 = left + j;
                int index2 = left + j + 1;
                if (comparator.compare(list.get(index1), list.get(index2)) <= 0) continue;
                Collections.swap(list, index1, index2);
            }
        }
        int k = left + right >> 1;
        return k;
    }

    static class APairComparator<E>
    implements Comparator<APair<E>> {
        Comparator<E> comparator;

        public APairComparator(Comparator<E> c) {
            this.comparator = c;
        }

        @Override
        public int compare(APair<E> o1, APair<E> o2) {
            return this.comparator.compare(o1.first, o2.first);
        }
    }

    private static class APair<E> {
        E first;
        int second;

        private APair() {
        }
    }
}

