/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;

final class MultiPointImpl
extends MultiVertexGeometryImpl {
    public MultiPointImpl() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_pointCount = 0;
    }

    public MultiPointImpl(VertexDescription description) {
        if (description == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = description;
        this.m_pointCount = 0;
    }

    @Override
    public Geometry createInstance() {
        return new MultiPoint(this.m_description);
    }

    public void add(Point point) {
        if (point.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + 1);
        this.setPoint(this.m_pointCount - 1, point);
    }

    public void add(double x, double y) {
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + 1);
        this.setXY(this.m_pointCount - 1, x, y);
    }

    public void add(double x, double y, double z) {
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + 1);
        Point3D pt = new Point3D();
        pt.setCoords(x, y, z);
        this.setXYZ(this.m_pointCount - 1, pt);
    }

    public void add(Point3D pt) {
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + 1);
        this.setXYZ(this.m_pointCount - 1, pt);
    }

    public void add(MultiVertexGeometryImpl src, int beginIndex, int endIndex) {
        int endIndexC;
        int n = endIndexC = endIndex < 0 ? src.getPointCount() : endIndex;
        if (beginIndex < 0 || beginIndex > src.getPointCount() || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        if (beginIndex == endIndexC) {
            return;
        }
        this.mergeVertexDescription(src.getDescription());
        int count = endIndexC - beginIndex;
        int oldPointCount = this.m_pointCount;
        this.resizeNoInit(this.m_pointCount + count);
        int nattrib = this.m_description.getAttributeCount();
        for (int iattrib = 0; iattrib < nattrib; ++iattrib) {
            int semantics = this.m_description.getSemantics(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            AttributeStreamBase stream = this.getAttributeStreamRef(semantics);
            if (src.hasAttribute(semantics)) {
                AttributeStreamBase srcStream = src.getAttributeStreamRef(semantics);
                stream.insertRange(oldPointCount * ncomps, srcStream, beginIndex * ncomps, count * ncomps, true, 1, oldPointCount * ncomps);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            stream.insertRange(oldPointCount * ncomps, v, count * ncomps, oldPointCount * ncomps);
        }
    }

    public void addPoints(Point2D[] points, int beginIndex, int endIndex) {
        int endIndexC;
        int count = points.length;
        int n = endIndexC = endIndex < 0 ? count : endIndex;
        if (beginIndex < 0 || beginIndex > count || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        if (beginIndex == endIndexC) {
            return;
        }
        count = endIndexC - beginIndex;
        int oldPointCount = this.m_pointCount;
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + count);
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        xy.writeRange(oldPointCount * 2, count, points, beginIndex, true);
    }

    public void addPoints(double[] xy, int beginIndex, int endIndex) {
        int endIndexC;
        int count = xy.length;
        int n = endIndexC = endIndex < 0 ? count : endIndex;
        if (beginIndex < 0 || beginIndex > count || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        if (beginIndex == endIndexC) {
            return;
        }
        count = endIndexC - beginIndex;
        if ((count & 1) != 0) {
            throw new IllegalArgumentException();
        }
        int oldPointCount = this.m_pointCount;
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + count / 2);
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        position.writeRange(oldPointCount * 2, count, xy, beginIndex, true);
    }

    public void addPoints(Point3D[] points, int begin_index, int end_index) {
        int endIndexC;
        int count = points.length;
        int n = endIndexC = end_index < 0 ? count : end_index;
        if (count < 0 || begin_index < 0 || begin_index > count || endIndexC < begin_index) {
            throw new IllegalArgumentException();
        }
        this.addAttribute(1);
        if (begin_index == endIndexC) {
            return;
        }
        count = endIndexC - begin_index;
        int oldPointCount = this.m_pointCount;
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + count);
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        for (int i = 0; i < count; ++i) {
            double x = points[begin_index + i].x;
            double y = points[begin_index + i].y;
            stream.write(2 * (oldPointCount + i), x, y);
        }
        AttributeStreamOfDbl streamZ = (AttributeStreamOfDbl)this.getAttributeStreamRef(1);
        for (int i = 0; i < count; ++i) {
            streamZ.write(oldPointCount + i, points[begin_index + i].z);
        }
        this.notifyModified(2001);
    }

    public void insertPoint(int beforePointIndex, Point pt) {
        if (beforePointIndex > this.getPointCount()) {
            throw new GeometryException("index out of bounds");
        }
        if (beforePointIndex < 0) {
            beforePointIndex = this.getPointCount();
        }
        this.mergeVertexDescription(pt.getDescription());
        int oldPointCount = this.m_pointCount;
        this.resizeNoInit(this.m_pointCount + 1);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            if (pt.hasAttribute(semantics)) {
                this.m_vertexAttributes[iattr].insertAttributes(comp * beforePointIndex, pt, semantics, comp * oldPointCount);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * beforePointIndex, v, comp, comp * oldPointCount);
        }
        this.notifyModified(2001);
    }

    void insertPoints(int before_point_index, Point2D[] src_begin, int count) {
        InternalUtils.require(before_point_index <= this.getPointCount() && count >= 0);
        if (before_point_index < 0) {
            before_point_index = this.getPointCount();
        }
        if (count == 0) {
            return;
        }
        int oldPointCount = this.m_pointCount;
        this.resizeNoInit(this.m_pointCount + count);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            if (this.m_vertexAttributes[iattr] == null) continue;
            if (semantics == 0) {
                ((AttributeStreamOfDbl)this.m_vertexAttributes[iattr]).insertRange(comp * before_point_index, src_begin, 0, count, true, comp * oldPointCount);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * before_point_index, v, comp, comp * oldPointCount);
        }
        this.notifyModified(2001);
    }

    void insertPoints(int before_point_index, Point[] src_begin, int count) {
        InternalUtils.require(before_point_index <= this.getPointCount() && count >= 0);
        if (before_point_index < 0) {
            before_point_index = this.getPointCount();
        }
        if (count == 0) {
            return;
        }
        VertexDescription src_descr = src_begin[0].getDescription();
        this.mergeVertexDescription(src_descr);
        int oldPointCount = this.m_pointCount;
        this.resizeNoInit(this.m_pointCount + count);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            if (this.m_vertexAttributes[iattr] == null) continue;
            if (src_descr.hasAttribute(semantics)) {
                this.m_vertexAttributes[iattr].insertAttributes(before_point_index * comp, src_begin, count, semantics, oldPointCount * comp);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * before_point_index, v, comp * count, comp * oldPointCount);
        }
        this.notifyModified(2001);
    }

    void removePoint(int pointIndex) {
        if (pointIndex < 0 || pointIndex >= this.getPointCount()) {
            throw new GeometryException("index out of bounds");
        }
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].eraseRange(comp * pointIndex, comp, comp * this.m_pointCount);
        }
        --this.m_pointCount;
        if (this.m_reservedPointCount > 0) {
            --this.m_reservedPointCount;
        }
        this.notifyModified(2001);
    }

    void removePoints(int start_index, int count) {
        InternalUtils.require(start_index >= 0 && count >= 0 && start_index + count <= this.getPointCount());
        if (count == 0) {
            return;
        }
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].eraseRange(comp * start_index, comp * count, comp * this.m_pointCount);
        }
        this.m_pointCount -= count;
        if (this.m_reservedPointCount > 0) {
            this.m_reservedPointCount -= count;
        }
        this.notifyModified(2001);
    }

    void resizeNoInit(int point_count) {
        this._resizeImpl(point_count);
    }

    void resizeAndInitNonPositionAttributes(int point_count) {
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(point_count);
        if (this.m_pointCount > oldPointCount) {
            int nattr = this.m_description.getAttributeCount();
            for (int iattr = 1; iattr < nattr; ++iattr) {
                int semantics = this.m_description.getSemantics(iattr);
                double v = VertexDescription.getDefaultValue(semantics);
                int comp = VertexDescription.getComponentCount(semantics);
                this.m_vertexAttributes[iattr].insertRange(comp * oldPointCount, v, comp * (this.m_pointCount - oldPointCount), comp * oldPointCount);
            }
        }
    }

    @Override
    void _copyToImpl(MultiVertexGeometryImpl mvg) {
    }

    @Override
    public void setEmpty() {
        super._setEmptyImpl();
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        if (this.isEmpty()) {
            return;
        }
        if (transform.isIdentity()) {
            return;
        }
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        points.applyTransformation(transform, 0, this.m_pointCount);
        this.notifyModified(2001);
    }

    @Override
    public void applyTransformation(Transformation3D transform) {
        if (this.isEmpty()) {
            return;
        }
        this.addAttribute(1);
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        AttributeStreamOfDbl zs = (AttributeStreamOfDbl)this.m_vertexAttributes[1];
        Point3D pt3 = new Point3D();
        for (int ipoint = 0; ipoint < this.m_pointCount; ++ipoint) {
            pt3.x = points.read(ipoint * 2);
            pt3.y = points.read(ipoint * 2 + 1);
            pt3.z = zs.read(ipoint);
            Point3D res = transform.transform(pt3);
            points.write(ipoint * 2, res.x, res.y);
            zs.write(ipoint, res.z);
        }
        this.notifyModified(2001);
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.MultiPoint;
    }

    @Override
    public double calculateArea2D() {
        return 0.0;
    }

    @Override
    public double calculateLength2D() {
        return 0.0;
    }

    @Override
    public Object _getImpl() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiPointImpl)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public boolean equals(Geometry other, double tol) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiPointImpl)) {
            return false;
        }
        return super.equals(other, tol);
    }

    public void addPoints(Point[] points) {
        int count = points.length;
        this.resizeAndInitNonPositionAttributes(this.m_pointCount + count);
        for (int i = 0; i < count; ++i) {
            this.setPoint(i, points[i]);
        }
    }

    @Override
    public int queryCoordinates(Point2D[] dst, int dstSize, int beginIndex, int endIndex) {
        int endIndexC = endIndex < 0 ? this.m_pointCount : endIndex;
        endIndexC = Math.min(endIndexC, beginIndex + dstSize);
        if (beginIndex < 0 || beginIndex >= this.m_pointCount || endIndexC < beginIndex || dst.length != dstSize) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        int pointCountToRead = endIndexC - beginIndex;
        double[] dstArray = new double[pointCountToRead * 2];
        xy.readRange(2 * beginIndex, pointCountToRead * 2, dstArray, 0, true);
        for (int i = 0; i < pointCountToRead; ++i) {
            dst[i] = new Point2D(dstArray[i * 2], dstArray[i * 2 + 1]);
        }
        return endIndexC;
    }

    public int queryCoordinates(Point3D[] dst, int dstSize, int beginIndex, int endIndex) {
        int endIndexC = endIndex < 0 ? this.m_pointCount : endIndex;
        endIndexC = Math.min(endIndexC, beginIndex + dstSize);
        if (beginIndex < 0 || beginIndex >= this.m_pointCount || endIndexC < beginIndex || dst.length != dstSize) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        AttributeStreamOfDbl z = null;
        double v = VertexDescription.getDefaultValue(1);
        boolean hasZ = this.hasAttribute(1);
        if (hasZ) {
            z = (AttributeStreamOfDbl)this.getAttributeStreamRef(1);
        }
        int pointCountToRead = endIndexC - beginIndex;
        double[] dstArray = new double[pointCountToRead * 2];
        double[] zArray = new double[pointCountToRead];
        xy.readRange(2 * beginIndex, pointCountToRead * 2, dstArray, 0, true);
        z.readRange(beginIndex, pointCountToRead, zArray, 0, true);
        for (int i = 0; i < pointCountToRead; ++i) {
            dst[i] = new Point3D(dstArray[i * 2], dstArray[i * 2 + 1], hasZ ? zArray[i] : v);
        }
        return endIndexC;
    }

    @Override
    protected void _notifyModifiedAllImpl() {
    }

    @Override
    protected void _verifyStreamsAfterSizeChangeExtraImpl() {
    }

    @Override
    public boolean _buildRasterizedGeometryAccelerator(double toleranceXY, Geometry.GeometryAccelerationDegree accelDegree) {
        return false;
    }

    @Override
    public boolean _buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree accelDegree) {
        return false;
    }

    @Override
    public Geometry getBoundary() {
        return null;
    }

    void reserve(int capacity) {
        this.reserveImpl_(capacity);
    }
}

