/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

@AndroidSDKPublic
@HadoopSDKPublic
public class MultiPoint
extends MultiVertexGeometry
implements Serializable,
Iterable<Point> {
    private static final long serialVersionUID = 2L;
    private MultiPointImpl m_impl;

    @AndroidSDKPublic
    @HadoopSDKPublic
    public MultiPoint() {
        this.m_impl = new MultiPointImpl();
    }

    @HadoopSDKPublic
    public MultiPoint(VertexDescription description) {
        this.m_impl = new MultiPointImpl(description);
    }

    @HadoopSDKPublic
    public MultiPoint(Point point) {
        this.m_impl = new MultiPointImpl(point.getDescription());
        this.add(point);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getAttributeAsDbl(int semantics, int index, int ordinate) {
        return this.m_impl.getAttributeAsDbl(semantics, index, ordinate);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getAttributeAsInt(int semantics, int index, int ordinate) {
        return this.m_impl.getAttributeAsInt(semantics, index, ordinate);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point getPoint(int index) {
        return this.m_impl.getPoint(index);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getPointCount() {
        return this.m_impl.getPointCount();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point2D getXY(int index) {
        return this.m_impl.getXY(index);
    }

    @Override
    @HadoopSDKPublic
    public void getXY(int index, Point2D pt) {
        this.m_impl.getXY(index, pt);
    }

    @Override
    @HadoopSDKPublic
    public Point3D getXYZ(int index) {
        return this.m_impl.getXYZ(index);
    }

    @Override
    @HadoopSDKPublic
    public void queryCoordinates(Point2D[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    @Override
    @HadoopSDKPublic
    public void queryCoordinates(Point[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    @Override
    protected Object _getImpl() {
        return this.m_impl;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void add(Point point) {
        this.m_impl.add(point);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void add(double x, double y) {
        this.m_impl.add(x, y);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void add(Point2D pt) {
        this.m_impl.add(pt.x, pt.y);
    }

    public void add(double x, double y, double z) {
        this.m_impl.add(x, y, z);
    }

    public void add(Point3D pt) {
        this.m_impl.add(pt);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void add(MultiVertexGeometry src, int srcFrom, int srcTo) {
        this.m_impl.add((MultiVertexGeometryImpl)src._getImpl(), srcFrom, srcTo);
    }

    @HadoopSDKPublic
    public void addPoints(Point2D[] points, int beginIndex, int endIndex) {
        this.m_impl.addPoints(points, beginIndex, endIndex);
    }

    @HadoopSDKPublic
    public void addPoints(double[] xy, int beginIndex, int endIndex) {
        this.m_impl.addPoints(xy, beginIndex, endIndex);
    }

    @HadoopSDKPublic
    public void addPoints(Point3D[] points, int count, int beginIndex, int endIndex) {
        this.m_impl.addPoints(points, beginIndex, endIndex);
    }

    @HadoopSDKPublic
    public void addPoints(Point[] points) {
        this.m_impl.addPoints(points);
    }

    @HadoopSDKPublic
    public void insertPoints(int beforePointIndex, Point[] points, int count) {
        this.m_impl.insertPoints(beforePointIndex, points, count);
    }

    @HadoopSDKPublic
    public void insertPoints(int beforePointIndex, Point2D[] points, int count) {
        this.m_impl.insertPoints(beforePointIndex, points, count);
    }

    @HadoopSDKPublic
    public void removePoints(int startIndex, int count) {
        this.m_impl.removePoints(startIndex, count);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void insertPoint(int beforePointIndex, Point pt) {
        this.m_impl.insertPoint(beforePointIndex, pt);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void removePoint(int pointIndex) {
        this.m_impl.removePoint(pointIndex);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void resize(int pointCount) {
        this.m_impl.resizeAndInitNonPositionAttributes(pointCount);
    }

    @Override
    @HadoopSDKPublic
    public void queryCoordinates(Point3D[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setAttribute(int semantics, int index, int ordinate, double value) {
        this.m_impl.setAttribute(semantics, index, ordinate, value);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setAttribute(int semantics, int index, int ordinate, int value) {
        this.m_impl.setAttribute(semantics, index, ordinate, value);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setPoint(int index, Point pointSrc) {
        this.m_impl.setPoint(index, pointSrc);
    }

    @Override
    @HadoopSDKPublic
    public void setXY(int index, Point2D pt) {
        this.m_impl.setXY(index, pt);
    }

    @Override
    @HadoopSDKPublic
    public void setXYZ(int index, Point3D pt) {
        this.m_impl.setXYZ(index, pt);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void applyTransformation(Transformation2D transform) {
        this.m_impl.applyTransformation(transform);
    }

    @Override
    @HadoopSDKPublic
    public void applyTransformation(Transformation3D transform) {
        this.m_impl.applyTransformation(transform);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void copyTo(Geometry dst) {
        this.m_impl.copyTo((Geometry)dst._getImpl());
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry createInstance() {
        return new MultiPoint(this.getDescription());
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getDimension() {
        return 0;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry.Type getType() {
        return Geometry.Type.MultiPoint;
    }

    @Override
    @HadoopSDKPublic
    public VertexDescription getDescription() {
        return this.m_impl.getDescription();
    }

    @Override
    @HadoopSDKPublic
    public boolean hasAttribute(int semantics) {
        return this.m_impl.hasAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void addAttribute(int semantics) {
        this.m_impl.addAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void assignVertexDescription(VertexDescription src) {
        this.m_impl.assignVertexDescription(src);
    }

    @Override
    @HadoopSDKPublic
    public void dropAllAttributes() {
        this.m_impl.dropAllAttributes();
    }

    @Override
    @HadoopSDKPublic
    public void dropAttribute(int semantics) {
        this.m_impl.dropAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void mergeVertexDescription(VertexDescription src) {
        this.m_impl.mergeVertexDescription(src);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isEmpty() {
        return this.m_impl.isEmpty();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryEnvelope(Envelope env) {
        this.m_impl.queryEnvelope(env);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryEnvelope2D(Envelope2D env) {
        this.m_impl.queryEnvelope2D(env);
    }

    @Override
    @HadoopSDKPublic
    public void queryEnvelope3D(Envelope3D env) {
        this.m_impl.queryEnvelope3D(env);
    }

    @Override
    @HadoopSDKPublic
    public void queryInterval(int semantics, int ordinate, Envelope1D dst) {
        this.m_impl.queryInterval(semantics, ordinate, dst);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setEmpty() {
        this.m_impl.setEmpty();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.m_impl.equals(((MultiPoint)other)._getImpl());
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Geometry other, double tol) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.m_impl.equals((Geometry)other._getImpl(), tol);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int hashCode() {
        return this.m_impl.hashCode();
    }

    @HadoopSDKPublic
    public int queryCoordinates(Point2D[] dst, int dstSize, int beginIndex, int endIndex) {
        return this.m_impl.queryCoordinates(dst, dstSize, beginIndex, endIndex);
    }

    @HadoopSDKPublic
    public int queryCoordinates(Point3D[] dst, int dstSize, int beginIndex, int endIndex) {
        return this.m_impl.queryCoordinates(dst, dstSize, beginIndex, endIndex);
    }

    @Override
    @HadoopSDKPublic
    public void getPointByVal(int index, Point outPoint) {
        this.m_impl.getPointByVal(index, outPoint);
    }

    @Override
    @HadoopSDKPublic
    public void setPointByVal(int index, Point pointSrc) {
        this.m_impl.setPointByVal(index, pointSrc);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry getBoundary() {
        return this.m_impl.getBoundary();
    }

    @Override
    @HadoopSDKPublic
    public void replaceNaNs(int semantics, double value) {
        this.m_impl.replaceNaNs(semantics, value);
    }

    @Override
    @HadoopSDKPublic
    public void reserve(int capacity) {
        this.m_impl.reserve(capacity);
    }

    @Override
    public AttributeStreamBase getAttributeStreamRef(int semantics) {
        return this.m_impl.getAttributeStreamRef(semantics);
    }

    @Override
    public void notifyModified() {
        this.m_impl.notifyModified();
    }

    @Override
    @HadoopSDKPublic
    public Iterator<Point> iterator() {
        return new PointIterator();
    }

    private class PointIterator
    implements Iterator<Point> {
        private int m_index = 0;

        private PointIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_index < MultiPoint.this.getPointCount();
        }

        @Override
        public Point next() {
            if (this.m_index >= MultiPoint.this.getPointCount()) {
                throw new NoSuchElementException();
            }
            Point g = MultiPoint.this.getPoint(this.m_index);
            ++this.m_index;
            return g;
        }
    }
}

