/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Boundary;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.QuadTreeImpl;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;

final class MultiPathImpl
extends MultiVertexGeometryImpl {
    protected boolean m_bPolygon;
    protected double m_cachedLength2D;
    protected double m_cachedArea2D;
    protected AttributeStreamOfDbl m_cachedRingAreas2D;
    protected boolean m_bPathStarted;
    protected AttributeStreamOfInt32 m_paths;
    protected AttributeStreamOfInt8 m_pathFlags;
    protected AttributeStreamOfInt8 m_segmentFlags;
    protected AttributeStreamOfInt32 m_segmentParamIndex;
    protected AttributeStreamOfDbl m_segmentParams;
    protected int m_curveParamwritePoint;
    private int m_fill_rule = 0;
    private int m_currentPathIndex = 0;
    static int[] _segmentParamSizes = new int[]{0, 0, 6, 0, 8, 0};

    public boolean hasNonLinearSegments() {
        return this.m_curveParamwritePoint > 0;
    }

    public MultiPathImpl(boolean bPolygon) {
        this.m_bPolygon = bPolygon;
        this.m_bPathStarted = false;
        this.m_curveParamwritePoint = 0;
        this.m_cachedLength2D = 0.0;
        this.m_cachedArea2D = 0.0;
        this.m_pointCount = 0;
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_cachedRingAreas2D = null;
    }

    public MultiPathImpl(boolean bPolygon, VertexDescription description) {
        if (description == null) {
            throw new IllegalArgumentException();
        }
        this.m_bPolygon = bPolygon;
        this.m_bPathStarted = false;
        this.m_curveParamwritePoint = 0;
        this.m_cachedLength2D = 0.0;
        this.m_cachedArea2D = 0.0;
        this.m_pointCount = 0;
        this.m_description = description;
        this.m_cachedRingAreas2D = null;
    }

    public void startPath(double x, double y) {
        this.startPathImpl(x, y, 0.0);
    }

    public void startPath(Point2D point) {
        this.startPathImpl(point.x, point.y, 0.0);
    }

    public void startPath(Point3D point) {
        this.addAttribute(1);
        this.startPathImpl(point.x, point.y, point.z);
    }

    public void startPath(double x, double y, double z) {
        this.addAttribute(1);
        this.startPathImpl(x, y, z);
    }

    private void startPathImpl(double x, double y, double maybeZ) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            throw new IllegalArgumentException();
        }
        if (!this.m_bPathStarted) {
            this.insertPointWithDefaultsImpl_(-1, -1, x, y, maybeZ);
            this.m_bPathStarted = true;
        } else {
            this.setPointByValWithDefaults_(this.m_pointCount - 1, x, y, maybeZ);
        }
    }

    public void startPath(Point point) {
        if (point.isEmpty()) {
            throw new IllegalArgumentException();
        }
        VertexDescription vd_point = point.getDescription();
        if (this.m_description != vd_point) {
            this.mergeVertexDescription(vd_point);
        }
        if (!this.m_bPathStarted) {
            this.insertPointWithDefaultsImpl_(-1, -1, point);
            this.m_bPathStarted = true;
        } else {
            this.setPointByValWithDefaults_(this.m_pointCount - 1, point);
        }
    }

    protected void _beforeNewSegment(int resize_by) {
        if (this.m_pointCount == 0 && !this.m_bPathStarted) {
            assert (false);
            this.startPath(0.0, 0.0);
        }
        int oldcount = this.m_pointCount;
        int sz = this.m_paths.size() - 1;
        int newPointCount = oldcount + resize_by;
        this.m_paths.write(sz, newPointCount);
        this._resizeImpl(newPointCount);
        this.m_bPathStarted = false;
    }

    protected void _finishLineTo() {
    }

    public void lineTo(double x, double y) {
        this._beforeNewSegment(1);
        if (this.m_description.getAttributeCount() == 1) {
            this.setXY(this.m_pointCount - 1, x, y);
        } else {
            this.setPointByValWithDefaults_(this.m_pointCount - 1, x, y, 0.0);
        }
        this._finishLineTo();
    }

    public void lineTo(Point2D endPoint) {
        this.lineTo(endPoint.x, endPoint.y);
    }

    public void lineTo(Point3D endPoint) {
        this._beforeNewSegment(1);
        this.addAttribute(1);
        this.setPointByValWithDefaults_(this.m_pointCount - 1, endPoint.x, endPoint.y, endPoint.z);
        this._finishLineTo();
    }

    public void lineTo(double x, double y, double z) {
        this._beforeNewSegment(1);
        this.addAttribute(1);
        this.setPointByValWithDefaults_(this.m_pointCount - 1, x, y, z);
        this._finishLineTo();
    }

    public void lineTo(Point endPoint) {
        this._beforeNewSegment(1);
        VertexDescription inVd = endPoint.getDescription();
        if (this.m_description == inVd) {
            this.setPointByVal(this.m_pointCount - 1, endPoint);
        } else {
            this.mergeVertexDescription(inVd);
            this.setPointByValWithDefaults_(this.m_pointCount - 1, endPoint);
        }
        this._finishLineTo();
    }

    protected void _initSegmentData(int sz) {
        if (this.m_segmentParamIndex == null) {
            this.m_segmentFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(this.m_pointCount, (byte)1);
            this.m_segmentParamIndex = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(this.m_pointCount, -1);
        }
        int size = this.m_curveParamwritePoint + sz;
        if (this.m_segmentParams == null) {
            this.m_segmentParams = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithPersistence(1, size);
        } else {
            this.m_segmentParams.resize(size, 0.0);
        }
    }

    protected void _finishBezierTo() {
        this.m_segmentFlags.write(this.m_pointCount - 2, (byte)2);
    }

    public void bezierTo(Point2D controlPoint1, Point2D controlPoint2, Point2D endPoint) {
    }

    public void openPath(int pathIndex) {
        if (this.m_bPolygon) {
            throw GeometryException.GeometryInternalError();
        }
        if (pathIndex > this.getPathCount()) {
            throw new IllegalArgumentException();
        }
        if (this.m_pathFlags == null) {
            throw GeometryException.GeometryInternalError();
        }
        this.m_pathFlags.clearBits(pathIndex, (byte)1);
    }

    public void openPathAndDuplicateStartVertex(int pathIndex) {
        if (this.m_bPolygon) {
            throw GeometryException.GeometryInternalError();
        }
        int pathCount = this.getPathCount();
        if (pathIndex > pathCount) {
            throw GeometryException.GeometryInternalError();
        }
        if (!this.isClosedPath(pathIndex)) {
            return;
        }
        if (this.m_pathFlags == null) {
            throw GeometryException.GeometryInternalError();
        }
        int oldPointCount = this.m_pointCount;
        int pathIndexStart = this.getPathStart(pathIndex);
        int pathIndexEnd = this.getPathEnd(pathIndex);
        this._resizeImpl(this.m_pointCount + 1);
        this._verifyAllStreamsAfterSizeChange();
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * pathIndexEnd, this.m_vertexAttributes[iattr], comp * pathIndexStart, comp, true, 1, comp * oldPointCount);
        }
        for (int ipath = pathCount; ipath > pathIndex; --ipath) {
            int iend = this.m_paths.read(ipath);
            this.m_paths.write(ipath, iend + 1);
        }
        this.m_pathFlags.clearBits(pathIndex, (byte)1);
    }

    public void openAllPathsAndDuplicateStartVertex() {
        if (this.m_bPolygon) {
            throw GeometryException.GeometryInternalError();
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.m_pathFlags == null) {
            throw GeometryException.GeometryInternalError();
        }
        int closedPathCount = 0;
        int pathCount = this.getPathCount();
        for (int ipath = 0; ipath < pathCount; ++ipath) {
            if (!this.isClosedPath(ipath)) continue;
            if (this.getPathSize(ipath) > 0) {
                ++closedPathCount;
                continue;
            }
            this.m_pathFlags.clearBits(ipath, (byte)1);
        }
        if (closedPathCount == 0) {
            return;
        }
        int startOffset = 0;
        int npaths = this.getPathCount();
        int nattr = this.m_description.getAttributeCount();
        AttributeStreamBase[] newAttribs = new AttributeStreamBase[nattr];
        for (int ipath = 0; ipath < npaths; ++ipath) {
            int istart = this.getPathStart(ipath);
            int isize = this.getPathSize(ipath);
            boolean closed = this.isClosedPath(ipath);
            if (isize > 0) {
                int inew_start = istart + startOffset;
                for (int iattr = 0; iattr < nattr; ++iattr) {
                    if (this.m_vertexAttributes[iattr] == null) continue;
                    int semantics = this.m_description.getSemantics(iattr);
                    int comp = VertexDescription.getComponentCount(semantics);
                    if (newAttribs[iattr] == null) {
                        AttributeStreamBase copy_of_stream;
                        int new_size = comp * (this.m_pointCount + closedPathCount);
                        newAttribs[iattr] = copy_of_stream = AttributeStreamBase.createAttributeStreamWithSemantics(semantics, new_size);
                    }
                    newAttribs[iattr].writeRange(inew_start * comp, isize * comp, this.m_vertexAttributes[iattr], istart * comp, true, 1);
                    if (!closed) continue;
                    newAttribs[iattr].writeRange((inew_start + isize) * comp, comp, this.m_vertexAttributes[iattr], istart * comp, true, 1);
                }
            }
            this.m_paths.write(ipath, istart + startOffset);
            if (!closed) continue;
            this.m_pathFlags.clearBits(ipath, (byte)1);
            ++startOffset;
        }
        this.m_paths.write(npaths, this.m_pointCount + closedPathCount);
        this.m_pathFlags.clearBits(npaths, (byte)1);
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            this.m_vertexAttributes[iattr] = newAttribs[iattr];
        }
        this.m_pointCount += closedPathCount;
        if (this.m_reservedPointCount > 0) {
            this.m_reservedPointCount = this.m_pointCount;
        }
    }

    void closePathWithLine(int path_index) {
        this.throwIfEmpty();
        byte pf = this.m_pathFlags.read(path_index);
        this.m_pathFlags.write(path_index, (byte)(pf | 1));
        if (this.m_segmentFlags != null) {
            int vindex = this.getPathEnd(path_index) - 1;
            this.m_segmentFlags.write(vindex, (byte)1);
            this.m_segmentParamIndex.write(vindex, -1);
        }
    }

    void closePathWithLine() {
        this.throwIfEmpty();
        this.m_bPathStarted = false;
        this.closePathWithLine(this.getPathCount() - 1);
    }

    public void closeAllPaths() {
        if (this.m_bPolygon || this.isEmptyImpl()) {
            return;
        }
        this.m_bPathStarted = false;
        int npart = this.m_paths.size() - 1;
        for (int ipath = 0; ipath < npart; ++ipath) {
            if (this.isClosedPath(ipath)) continue;
            byte pf = this.m_pathFlags.read(ipath);
            this.m_pathFlags.write(ipath, (byte)(pf | 1));
        }
    }

    public static int getSegmentDataSize(byte flag) {
        return _segmentParamSizes[flag];
    }

    public void closePathWithBezier(Point2D controlPoint1, Point2D controlPoint2) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("Invalid call. This operation cannot be performed on an empty geometry.");
        }
        this.m_bPathStarted = false;
        int pathIndex = this.m_paths.size() - 2;
        byte pf = this.m_pathFlags.read(pathIndex);
        this.m_pathFlags.write(pathIndex, (byte)(pf | 1 | 2));
        this._initSegmentData(6);
        byte oldType = this.m_segmentFlags.read((byte)(this.m_pointCount - 1 & 7));
        this.m_segmentFlags.write(this.m_pointCount - 1, (byte)2);
        int curveIndex = this.m_curveParamwritePoint;
        if (MultiPathImpl.getSegmentDataSize(oldType) < MultiPathImpl.getSegmentDataSize((byte)2)) {
            this.m_segmentParamIndex.write(this.m_pointCount - 1, this.m_curveParamwritePoint);
            this.m_curveParamwritePoint += 6;
        } else {
            curveIndex = this.m_segmentParamIndex.read(this.m_pointCount - 1);
        }
        this.m_segmentParams.write(curveIndex, controlPoint1.x);
        this.m_segmentParams.write(curveIndex + 1, controlPoint1.y);
        double z = 0.0;
        this.m_segmentParams.write(curveIndex + 2, z);
        this.m_segmentParams.write(curveIndex + 3, controlPoint2.x);
        this.m_segmentParams.write(curveIndex + 4, controlPoint2.y);
        z = 0.0;
        this.m_segmentParams.write(curveIndex + 5, z);
    }

    public boolean isClosedPath(int ipath) {
        return (byte)(this.m_pathFlags.read(ipath) & 1) != 0;
    }

    public boolean isClosedPathInXYPlane(int path_index) {
        int iend;
        if (this.isClosedPath(path_index)) {
            return true;
        }
        int istart = this.getPathStart(path_index);
        if (istart > (iend = this.getPathEnd(path_index) - 1)) {
            return false;
        }
        Point2D ptS = this.getXY(istart);
        Point2D ptE = this.getXY(iend);
        return ptS.isEqual(ptE);
    }

    public boolean hasNonLinearSegments(int ipath) {
        return (this.m_pathFlags.read(ipath) & 2) != 0;
    }

    public void addSegment(Segment segment, boolean bStartNewPath) {
        Point point;
        this.mergeVertexDescription(segment.getDescription());
        if (segment.getType() == Geometry.Type.Line) {
            point = new Point();
            if (bStartNewPath || this.isEmpty()) {
                segment.queryStart(point);
                this.startPath(point);
            }
        } else {
            throw GeometryException.GeometryInternalError();
        }
        segment.queryEnd(point);
        this.lineTo(point);
    }

    void changeRingStartPoint(int newStartPointOfARing) {
        int ipath = this.getPathIndexFromPointIndex(newStartPointOfARing);
        int pathStart = this.getPathStart(ipath);
        if (pathStart == newStartPointOfARing) {
            return;
        }
        int pathEnd = this.getPathEnd(ipath);
        if (newStartPointOfARing >= pathEnd || newStartPointOfARing < pathStart) {
            throw new GeometryException("change_ring_start_point");
        }
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].rotate(pathStart * comp, newStartPointOfARing * comp, pathEnd * comp);
        }
    }

    public void addEnvelope(Envelope2D envSrc, boolean bReverse) {
        if (envSrc.isEmpty()) {
            return;
        }
        boolean bWasEmpty = this.m_pointCount == 0;
        this.startPath(envSrc.xmin, envSrc.ymin);
        if (bReverse) {
            this.lineTo(envSrc.xmax, envSrc.ymin);
            this.lineTo(envSrc.xmax, envSrc.ymax);
            this.lineTo(envSrc.xmin, envSrc.ymax);
        } else {
            this.lineTo(envSrc.xmin, envSrc.ymax);
            this.lineTo(envSrc.xmax, envSrc.ymax);
            this.lineTo(envSrc.xmax, envSrc.ymin);
        }
        this.closePathWithLine();
        this.m_bPathStarted = false;
        if (bWasEmpty && !bReverse) {
            this._clearDirtyFlag(256);
            if (this.m_bPolygon) {
                this.setIsSimple(3, 0.0, false);
            }
        }
    }

    public void addEnvelope(Envelope envSrc, boolean bReverse) {
        if (envSrc.isEmpty()) {
            return;
        }
        boolean bWasEmpty = this.m_pointCount == 0;
        Point pt = new Point(this.m_description);
        int n = 4;
        for (int i = 0; i < n; ++i) {
            int j = bReverse ? n - i - 1 : i;
            envSrc.queryCornerByVal(j, pt);
            if (i == 0) {
                this.startPath(pt);
                continue;
            }
            this.lineTo(pt);
        }
        this.closePathWithLine();
        this.m_bPathStarted = false;
        if (bWasEmpty && !bReverse) {
            this._clearDirtyFlag(256);
            if (this.m_bPolygon) {
                this.setIsSimple(3, 0.0, false);
            }
        }
    }

    public void add(MultiPathImpl src, boolean bReversePaths) {
        for (int i = 0; i < src.getPathCount(); ++i) {
            this.addPath(src, i, !bReversePaths);
        }
    }

    public void addPath(MultiPathImpl src, int srcPathIndex, boolean bForward) {
        this.insertPath(-1, src, srcPathIndex, bForward);
    }

    public void addPath(Point2D[] _points, int count, boolean bForward) {
        this.insertPath(-1, _points, 0, count, bForward);
    }

    public void addAndExplicitlyOpenAllPaths(MultiPathImpl src, boolean bReversePaths) {
        if (this == src) {
            throw new GeometryException("MultiPathImpl.add");
        }
        int currentPath = this.getPathCount();
        for (int i = 0; i < src.getPathCount(); ++i) {
            this.addPath(src, i, !bReversePaths);
            this.openPathAndDuplicateStartVertex(currentPath);
            ++currentPath;
        }
    }

    public void addSegmentsFromPath(MultiPathImpl src, int src_path_index, int src_segment_from, int src_segment_count, boolean b_start_new_path) {
        if (!b_start_new_path && this.getPathCount() == 0) {
            b_start_new_path = true;
        }
        if (src_path_index < 0) {
            src_path_index = src.getPathCount() - 1;
        }
        if (src_path_index >= src.getPathCount() || src_segment_from < 0 || src_segment_count < 0 || src_segment_from + src_segment_count > src.getSegmentCount(src_path_index)) {
            throw new GeometryException("index out of bounds");
        }
        if (src_segment_count == 0) {
            return;
        }
        int src_path_start = src.getPathStart(src_path_index);
        boolean bIncludesClosingSegment = src.isClosedPath(src_path_index) && src_segment_from + src_segment_count == src.getSegmentCount(src_path_index);
        this.m_bPathStarted = false;
        this.mergeVertexDescription(src.getDescription());
        int src_point_count = src_segment_count;
        int first_segment_start_point = src_path_start + src_segment_from;
        int srcFromPoint = first_segment_start_point + 1;
        if (b_start_new_path) {
            ++src_point_count;
            --srcFromPoint;
        }
        if (b_start_new_path || src.hasNonLinearSegments()) {
            // empty if block
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + src_point_count);
        this._verifyAllStreamsAfterSizeChange();
        if (b_start_new_path) {
            if (src_point_count == 0) {
                return;
            }
            this.m_paths.add(this.m_pointCount);
            byte flags = src.m_pathFlags.read(src_path_index);
            flags = (byte)(flags & 0xFFFFFFFB);
            if (this.m_bPolygon) {
                flags = (byte)(flags | 1);
            }
            this.m_pathFlags.write(this.m_pathFlags.size() - 1, flags);
            this.m_pathFlags.add((byte)0);
        } else {
            this.m_paths.write(this.m_pathFlags.size() - 1, this.m_pointCount);
        }
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            int src_points_to_add = bIncludesClosingSegment ? src_point_count - 1 : src_point_count;
            int isrcAttr = src.m_description.getAttributeIndex(semantics);
            if (isrcAttr < 0 || src.m_vertexAttributes[isrcAttr] == null) {
                double v = VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[iattr].insertRange(comp * oldPointCount, v, src_points_to_add * comp, comp * oldPointCount);
                if (!bIncludesClosingSegment) continue;
                this.m_vertexAttributes[iattr].insertRange(comp * oldPointCount + src_points_to_add * comp, v, comp, comp * oldPointCount);
                continue;
            }
            this.m_vertexAttributes[iattr].insertRange(comp * oldPointCount, src.m_vertexAttributes[isrcAttr], comp * srcFromPoint, src_points_to_add * comp, true, comp, comp * oldPointCount);
            if (!bIncludesClosingSegment) continue;
            this.m_vertexAttributes[iattr].insertRange(comp * (oldPointCount + src_points_to_add), src.m_vertexAttributes[isrcAttr], comp * src_path_start, comp, true, comp, comp * (oldPointCount + src_points_to_add));
        }
        if (this.hasNonLinearSegments()) {
            // empty if block
        }
        if (src.hasNonLinearSegments()) {
            // empty if block
        }
        if (bIncludesClosingSegment) {
            Point2D ptE;
            int path = this.getPathCount() - 1;
            int istart = this.getPathStart(path);
            int iend = this.getPathEnd(path) - 1;
            Point2D ptS = this.getXY(istart);
            if (ptS.isEqual(ptE = this.getXY(iend))) {
                --this.m_pointCount;
                this.m_paths.write(path + 1, this.m_pointCount);
            }
        }
        this.notifyModified(2001);
    }

    public void reverseAllPaths() {
        int n = this.getPathCount();
        for (int i = 0; i < n; ++i) {
            this.reversePath(i);
        }
    }

    public void reversePath(int pathIndex) {
        int pathCount = this.getPathCount();
        if (pathIndex >= pathCount) {
            throw new IllegalArgumentException();
        }
        int reversedPathStart = this.getPathStart(pathIndex);
        int reversedPathSize = this.getPathSize(pathIndex);
        if (this.hasNonLinearSegments()) {
            // empty if block
        }
        int offset = this.isClosedPath(pathIndex) ? 1 : 0;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].reverseRange(comp * (reversedPathStart + offset), comp * (reversedPathSize - offset), comp);
        }
        this.notifyModified(1233);
    }

    public void removePath(int pathIndex) {
        int i;
        int pathCount = this.getPathCount();
        if (pathIndex < 0) {
            pathIndex = pathCount - 1;
        }
        if (pathIndex >= pathCount) {
            throw new IllegalArgumentException();
        }
        int removedPathStart = this.getPathStart(pathIndex);
        int removedPathSize = this.getPathSize(pathIndex);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].eraseRange(comp * removedPathStart, comp * removedPathSize, comp * this.m_pointCount);
        }
        if (this.hasNonLinearSegments()) {
            // empty if block
        }
        for (i = pathIndex + 1; i <= pathCount; ++i) {
            int istart = this.m_paths.read(i);
            this.m_paths.write(i - 1, istart - removedPathSize);
        }
        if (this.m_pathFlags != null) {
            for (i = pathIndex + 1; i <= pathCount; ++i) {
                byte flags = this.m_pathFlags.read(i);
                this.m_pathFlags.write(i - 1, flags);
            }
        }
        this.m_paths.resize(pathCount);
        this.m_pathFlags.resize(pathCount);
        this.m_pointCount -= removedPathSize;
        this.m_reservedPointCount -= removedPathSize;
        this.notifyModified(2001);
        this.checkCompactSegmentParams_();
    }

    private boolean checkCompactSegmentParams_() {
        return false;
    }

    public void insertPath(int path_index, MultiPathImpl src, int src_path_index, boolean bForward) {
        byte flags;
        int ipath;
        int oldPathCount = this.getPathCount();
        InternalUtils.require(src != null && src != this && src_path_index < src.getPathCount() && path_index <= oldPathCount);
        if (path_index < 0) {
            path_index = oldPathCount;
        }
        if (src_path_index < 0) {
            src_path_index = src.getPathCount() - 1;
        }
        this.m_bPathStarted = false;
        this.mergeVertexDescription(src.m_description);
        int srcPathIndexStart = src.getPathStart(src_path_index);
        int srcPathSize = src.getPathSize(src_path_index);
        if (srcPathSize == 0) {
            this.insertPath(path_index, null, 0, 0, true);
            return;
        }
        int oldPointCount = this.m_pointCount;
        int offset = src.isClosedPath(src_path_index) && !bForward ? 1 : 0;
        this._resizeImpl(this.m_pointCount + srcPathSize);
        this._verifyAllStreamsAfterSizeChange();
        int pathIndexStart = path_index < oldPathCount ? this.getPathStart(path_index) : oldPointCount;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int isrcAttr = src.m_description.getAttributeIndex(semantics);
            int comp = VertexDescription.getComponentCount(semantics);
            if (isrcAttr >= 0 && src.m_vertexAttributes[isrcAttr] != null) {
                if (offset != 0) {
                    this.m_vertexAttributes[iattr].insertRange(pathIndexStart * comp, src.m_vertexAttributes[isrcAttr], comp * srcPathIndexStart, comp, true, comp, comp * oldPointCount);
                }
                this.m_vertexAttributes[iattr].insertRange((pathIndexStart + offset) * comp, src.m_vertexAttributes[isrcAttr], comp * (srcPathIndexStart + offset), comp * (srcPathSize - offset), bForward, comp, comp * (oldPointCount + offset));
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(pathIndexStart * comp, v, comp * srcPathSize, comp * oldPointCount);
        }
        int newPointCount = oldPointCount + srcPathSize;
        this.m_paths.add(newPointCount);
        for (ipath = oldPathCount; ipath >= path_index + 1; --ipath) {
            int iend = this.m_paths.read(ipath - 1);
            this.m_paths.write(ipath, iend + srcPathSize);
        }
        this.m_pathFlags.add((byte)0);
        for (ipath = oldPathCount - 1; ipath >= path_index + 1; --ipath) {
            flags = this.m_pathFlags.read(ipath);
            flags = (byte)(flags & 0xFFFFFFFB);
            this.m_pathFlags.write(ipath + 1, flags);
        }
        AttributeStreamOfInt8 srcPathFlags = src.getPathFlagsStreamRef();
        flags = srcPathFlags.read(src_path_index);
        flags = (byte)(flags & 0xFFFFFFFB);
        if (this.m_bPolygon) {
            flags = (byte)(flags | 1);
        }
        this.m_pathFlags.write(path_index, flags);
        if (src.hasNonLinearSegments()) {
            // empty if block
        }
        this.notifyModified(2001);
    }

    public void insertPathFromMultiPoint(int path_index_, MultiPoint pointSource, int points_offset, int count, boolean b_forward) {
        int ipath;
        int oldPathCount = this.getPathCount();
        int path_index = path_index_ < 0 ? oldPathCount : path_index_;
        InternalUtils.require(path_index <= oldPathCount && points_offset >= 0);
        int srcPointCount = pointSource != null ? pointSource.getPointCount() : 0;
        InternalUtils.require(points_offset < srcPointCount);
        MultiPointImpl src = pointSource != null ? (MultiPointImpl)pointSource._getImpl() : null;
        int srcPathSize = count < 0 ? srcPointCount - points_offset : count;
        InternalUtils.require(count < 0 || srcPathSize + points_offset <= srcPointCount);
        this.m_bPathStarted = false;
        this.mergeVertexDescription(src.getDescription());
        if (srcPathSize == 0) {
            this.insertPath(path_index, null, 0, 0, true);
            return;
        }
        int oldPointCount = this.m_pointCount;
        int srcPathIndexStart = points_offset;
        this._resizeImpl(this.m_pointCount + srcPathSize);
        this._verifyAllStreamsAfterSizeChange();
        int pathIndexStart = path_index < oldPathCount ? this.getPathStart(path_index) : oldPointCount;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int isrcAttr = src.getDescription().getAttributeIndex(semantics);
            int comp = VertexDescription.getComponentCount(semantics);
            if (isrcAttr >= 0) {
                AttributeStreamBase srcStream = src.getAttributeStreamRef(semantics);
                this.m_vertexAttributes[iattr].insertRange(pathIndexStart * comp, srcStream, comp * srcPathIndexStart, comp * srcPathSize, b_forward, comp, comp * oldPointCount);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(pathIndexStart * comp, v, comp * srcPathSize, comp * oldPointCount);
        }
        int newPointCount = oldPointCount + srcPathSize;
        this.m_paths.add(newPointCount);
        for (ipath = oldPathCount; ipath >= path_index + 1; --ipath) {
            int iend = this.m_paths.read(ipath - 1);
            this.m_paths.write(ipath, iend + srcPathSize);
        }
        this.m_pathFlags.add((byte)0);
        assert (this.m_pathFlags.size() == this.m_paths.size());
        for (ipath = oldPathCount - 1; ipath >= path_index + 1; --ipath) {
            byte flags = this.m_pathFlags.read(ipath);
            flags = (byte)(flags & 0xFFFFFFFB);
            this.m_pathFlags.write(ipath + 1, flags);
        }
        byte flags = 0;
        if (this.m_bPolygon) {
            flags = (byte)(flags | 1);
        }
        this.m_pathFlags.write(path_index, flags);
        this.notifyModified(2001);
    }

    public void insertPath(int path_index, Point2D[] points, int points_offset, int count, boolean bForward) {
        int ipath;
        int pathStart;
        int oldPathCount = this.getPathCount();
        if (path_index > oldPathCount || points_offset < 0) {
            throw new IllegalArgumentException();
        }
        if (path_index < 0) {
            path_index = oldPathCount;
        }
        this.m_bPathStarted = false;
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + count);
        if (count == 0) {
            this.notifyModified(32);
        }
        this._verifyAllStreamsAfterSizeChange();
        int n = pathStart = path_index < oldPathCount ? this.getPathStart(path_index) : oldPointCount;
        if (points != null) {
            ((AttributeStreamOfDbl)this.m_vertexAttributes[0]).insertRange(2 * pathStart, points, points_offset, count, bForward, 2 * oldPointCount);
        } else {
            double v = VertexDescription.getDefaultValue(0);
            ((AttributeStreamOfDbl)this.m_vertexAttributes[0]).insertRange(2 * pathStart, v, count * 2, 2 * oldPointCount);
        }
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(pathStart * comp, v, comp * count, comp * oldPointCount);
        }
        this.m_paths.add(this.m_pointCount);
        for (ipath = oldPathCount; ipath >= path_index + 1; --ipath) {
            int iend = this.m_paths.read(ipath - 1);
            this.m_paths.write(ipath, iend + count);
        }
        this.m_pathFlags.add((byte)0);
        assert (this.m_pathFlags.size() == this.m_paths.size());
        for (ipath = oldPathCount - 1; ipath >= path_index + 1; --ipath) {
            byte flags = this.m_pathFlags.read(ipath);
            flags = (byte)(flags & 0xFFFFFFFB);
            this.m_pathFlags.write(ipath + 1, flags);
        }
        if (this.m_bPolygon) {
            this.m_pathFlags.write(path_index, (byte)1);
        }
        if (this.hasNonLinearSegments()) {
            // empty if block
        }
        this.notifyModified(2001);
    }

    public void insertPoints(int path_index, int before_point_index, MultiPathImpl src, int src_path_index, int src_point_index_from, int src_point_count, boolean bForward) {
        if (path_index < 0) {
            path_index = this.getPathCount();
        }
        if (src_path_index < 0) {
            src_path_index = src.getPathCount() - 1;
        }
        if (path_index > this.getPathCount() || before_point_index >= 0 && before_point_index > this.getPathSize(path_index) || src_path_index >= src.getPathCount() || src_point_count > src.getPathSize(src_path_index)) {
            throw new IllegalArgumentException();
        }
        if (src_point_count == 0) {
            return;
        }
        this.mergeVertexDescription(src.m_description);
        if (path_index == this.getPathCount()) {
            this.m_paths.add(this.m_pointCount);
            byte flags = src.m_pathFlags.read(src_path_index);
            flags = (byte)(flags & 0xFFFFFFFB);
            if (!this.m_bPolygon) {
                this.m_pathFlags.add(flags);
            } else {
                this.m_pathFlags.add((byte)(flags | 1));
            }
        }
        if (before_point_index < 0) {
            before_point_index = this.getPathSize(path_index);
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + src_point_count);
        this._verifyAllStreamsAfterSizeChange();
        int pathStart = this.getPathStart(path_index);
        int absoluteIndex = pathStart + before_point_index;
        if (src_point_count < 0) {
            src_point_count = src.getPathSize(src_path_index);
        }
        int srcPathStart = src.getPathStart(src_path_index);
        int srcAbsoluteIndex = srcPathStart + src_point_count;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            int isrcAttr = src.m_description.getAttributeIndex(semantics);
            if (isrcAttr < 0 || src.m_vertexAttributes[isrcAttr] == null) {
                double v = VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[iattr].insertRange(comp * absoluteIndex, v, srcAbsoluteIndex * comp, comp * oldPointCount);
                continue;
            }
            this.m_vertexAttributes[iattr].insertRange(comp * (pathStart + before_point_index), src.m_vertexAttributes[isrcAttr], comp * (srcPathStart + src_point_index_from), src_point_count * comp, bForward, comp, comp * oldPointCount);
        }
        if (this.hasNonLinearSegments()) {
            // empty if block
        }
        int npaths = this.getPathCount();
        for (int ipath = path_index + 1; ipath <= npaths; ++ipath) {
            int num = this.m_paths.read(ipath);
            this.m_paths.write(ipath, num + src_point_count);
        }
        this.notifyModified(2001);
    }

    public void insertPoints(int path_index, int before_point_index, Point2D[] src, int src_point_index_from, int src_point_count, boolean bForward) {
        if (path_index < 0) {
            path_index = this.getPathCount();
        }
        if (path_index > this.getPathCount() || before_point_index > this.getPathSize(path_index) || src_point_index_from < 0) {
            throw new IllegalArgumentException();
        }
        if (src_point_count == 0) {
            return;
        }
        if (path_index == this.getPathCount()) {
            this.m_paths.add(this.m_pointCount);
            if (!this.m_bPolygon) {
                this.m_pathFlags.add((byte)0);
            } else {
                this.m_pathFlags.add((byte)1);
            }
        }
        if (before_point_index < 0) {
            before_point_index = this.getPathSize(path_index);
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + src_point_count);
        this._verifyAllStreamsAfterSizeChange();
        int pathStart = this.getPathStart(path_index);
        ((AttributeStreamOfDbl)this.m_vertexAttributes[0]).insertRange(2 * (pathStart + before_point_index), src, src_point_index_from, src_point_count, bForward, 2 * oldPointCount);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange((pathStart + before_point_index) * comp, v, comp * src_point_count, comp * oldPointCount);
        }
        if (this.hasNonLinearSegments()) {
            // empty if block
        }
        int npaths = this.getPathCount();
        for (int ipath = path_index + 1; ipath <= npaths; ++ipath) {
            this.m_paths.write(ipath, this.m_paths.read(ipath) + src_point_count);
        }
        this.notifyModified(2001);
    }

    public void insertPoint(int pathIndex, int beforePointIndex, Point2D pt) {
        if (Double.isNaN(pt.x) || Double.isNaN(pt.y)) {
            throw new IllegalArgumentException();
        }
        this.insertPointWithDefaultsImpl_(pathIndex, beforePointIndex, pt.x, pt.y, 0.0);
    }

    private void insertPointWithDefaultsImpl_(int path_index, int before_point_index, double x, double y, double z) {
        int path_count = this.getPathCount();
        if (path_index < 0) {
            path_index = path_count;
        }
        if (path_index > path_count || path_index < path_count && before_point_index > this.getPathSize(path_index)) {
            throw new IllegalArgumentException();
        }
        if (path_index == path_count) {
            this.addPath((Point2D[])null, 0, true);
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + 1);
        this._verifyAllStreamsAfterSizeChange();
        int pathStart = this.getPathStart(path_index);
        int insert_pos = before_point_index < 0 ? this.getPathSize(path_index) + pathStart : before_point_index + pathStart;
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        if (insert_pos == oldPointCount) {
            this.m_paths.write(path_index + 1, oldPointCount + 1);
            v.write(insert_pos * 2, x, y);
            if (this.m_description.hasAttribute(1)) {
                this.m_vertexAttributes[1].writeAsDbl(insert_pos, z);
            }
        } else {
            v.insert(2 * insert_pos, x, y, 2 * oldPointCount);
            int iattr = 1;
            if (this.m_description.hasAttribute(1)) {
                this.m_vertexAttributes[1].insertRange(insert_pos, z, 1, oldPointCount);
                iattr = 2;
            }
            int nattr = this.m_description.getAttributeCount();
            while (iattr < nattr) {
                int semantics = this.m_description.getSemantics(iattr);
                int comp = VertexDescription.getComponentCount(semantics);
                double val = VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[iattr].insertRange(comp * insert_pos, val, comp, comp * oldPointCount);
                ++iattr;
            }
            int npaths = path_count;
            for (int ipath = path_index + 1; ipath <= npaths; ++ipath) {
                this.m_paths.write(ipath, this.m_paths.read(ipath) + 1);
            }
        }
        this.notifyModified(2001);
    }

    public void insertPoint(int path_index, int before_point_index, Point pt) {
        if (pt.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.insertPointWithDefaultsImpl_(path_index, before_point_index, pt);
    }

    private void insertPointWithDefaultsImpl_(int path_index, int before_point_index, Point pt) {
        int insert_pos;
        int path_count = this.getPathCount();
        if (path_index < 0) {
            path_index = path_count;
        }
        if (path_index > path_count || path_index < path_count && before_point_index > this.getPathSize(path_index)) {
            throw new IllegalArgumentException();
        }
        if (path_index == path_count) {
            this.addPath((Point2D[])null, 0, true);
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + 1);
        this._verifyAllStreamsAfterSizeChange();
        int pathStart = this.getPathStart(path_index);
        int n = insert_pos = before_point_index < 0 ? this.getPathSize(path_index) + pathStart : before_point_index + pathStart;
        if (insert_pos == oldPointCount) {
            this.m_paths.write(path_index + 1, oldPointCount + 1);
            this.setPointByValWithDefaults_(insert_pos, pt);
        } else {
            VertexDescription srcDescr = pt.getDescription();
            if (this.m_description != srcDescr) {
                this.mergeVertexDescription(srcDescr);
            }
            int nattr = this.m_description.getAttributeCount();
            for (int iattr = 0; iattr < nattr; ++iattr) {
                int semantics = this.m_description.getSemantics(iattr);
                int comp = VertexDescription.getComponentCount(semantics);
                if (srcDescr.hasAttribute(semantics)) {
                    this.m_vertexAttributes[iattr].insertAttributes(comp * insert_pos, pt, semantics, comp * oldPointCount);
                    continue;
                }
                double v = VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[iattr].insertRange(comp * insert_pos, v, comp, comp * oldPointCount);
            }
            int npaths = path_count;
            for (int ipath = path_index + 1; ipath <= npaths; ++ipath) {
                this.m_paths.write(ipath, this.m_paths.read(ipath) + 1);
            }
        }
        this.notifyModified(2001);
    }

    public void removePoint(int path_index, int point_index) {
        int path_count = this.getPathCount();
        if (path_index < 0) {
            path_index = path_count - 1;
        }
        if (path_index >= path_count || point_index >= this.getPathSize(path_index)) {
            throw new IllegalArgumentException("Multi_path::remove_point");
        }
        int pathStart = this.getPathStart(path_index);
        if (point_index < 0) {
            point_index = this.getPathSize(path_index) - 1;
        }
        if (point_index < 0) {
            throw new IllegalArgumentException("Multi_path::remove_point");
        }
        int absoluteIndex = pathStart + point_index;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].eraseRange(comp * absoluteIndex, comp, comp * this.m_pointCount);
        }
        for (int ipath = path_count; ipath >= path_index + 1; --ipath) {
            int iend = this.m_paths.read(ipath);
            this.m_paths.write(ipath, iend - 1);
        }
        --this.m_pointCount;
        --this.m_reservedPointCount;
        this.notifyModified(2001);
    }

    public double calculatePathLength2D(int pathIndex) {
        SegmentIteratorImpl segIter = this.querySegmentIteratorAtVertex(this.getPathStart(pathIndex));
        MathUtils.KahanSummator len = new MathUtils.KahanSummator(0.0);
        while (segIter.hasNextSegment()) {
            len.add(segIter.nextSegment().calculateLength2D());
        }
        return len.getResult();
    }

    double calculateSubLength2D(int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        int absolute_from_index = this.getPathStart(from_path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(to_path_index) + to_point_index;
        if (absolute_to_index < absolute_from_index || absolute_from_index < 0 || absolute_to_index > this.getPointCount() - 1) {
            throw new IllegalArgumentException();
        }
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        double sub_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        while (true) {
            if (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                if (seg_iter.getStartPointIndex() != absolute_to_index) {
                    double segment_length = segment.calculateLength2D();
                    sub_length += segment_length;
                    continue;
                }
            }
            if (seg_iter.getStartPointIndex() == absolute_to_index || !seg_iter.nextPath()) break;
        }
        return sub_length;
    }

    double calculateSubLength2D(int path_index, int from_point_index, int to_point_index) {
        int absolute_from_index = this.getPathStart(path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(path_index) + to_point_index;
        if (absolute_from_index < 0 || absolute_to_index > this.getPointCount() - 1) {
            throw new IllegalArgumentException();
        }
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        if (absolute_from_index > absolute_to_index) {
            if (!this.isClosedPath(path_index)) {
                throw new IllegalArgumentException("cannot iterate across an open path");
            }
            seg_iter.setCirculator(true);
        }
        double prev_length = 0.0;
        double sub_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        do {
            assert (seg_iter.hasNextSegment());
            sub_length += prev_length;
            Segment segment = seg_iter.nextSegment();
            prev_length = segment.calculateLength2D();
        } while (seg_iter.getStartPointIndex() != absolute_to_index);
        return sub_length;
    }

    @Override
    public Geometry getBoundary() {
        return Boundary.calculate(this, null);
    }

    void interpolateAttributes(int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        for (int ipath = from_path_index; ipath < to_path_index - 1; ++ipath) {
            if (!this.isClosedPath(ipath)) continue;
            throw new IllegalArgumentException("cannot interpolate across closed paths");
        }
        int nattr = this.m_description.getAttributeCount();
        if (nattr == 1) {
            return;
        }
        double sub_length = this.calculateSubLength2D(from_path_index, from_point_index, to_path_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int interpolation = VertexDescription.getInterpolation(semantics);
            if (interpolation == 2) continue;
            int components = VertexDescription.getComponentCount(semantics);
            for (int ordinate = 0; ordinate < components; ++ordinate) {
                this.interpolateAttributes_(semantics, from_path_index, from_point_index, to_path_index, to_point_index, sub_length, ordinate);
            }
        }
    }

    void interpolateAttributesForSemantics(int semantics, int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        if (semantics == 0) {
            return;
        }
        if (!this.hasAttribute(semantics)) {
            throw new IllegalArgumentException("does not have the given attribute");
        }
        int interpolation = VertexDescription.getInterpolation(semantics);
        if (interpolation == 2) {
            throw new IllegalArgumentException("not implemented for the given semantics");
        }
        for (int ipath = from_path_index; ipath < to_path_index - 1; ++ipath) {
            if (!this.isClosedPath(ipath)) continue;
            throw new IllegalArgumentException("cannot interpolate across closed paths");
        }
        double sub_length = this.calculateSubLength2D(from_path_index, from_point_index, to_path_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        int components = VertexDescription.getComponentCount(semantics);
        for (int ordinate = 0; ordinate < components; ++ordinate) {
            this.interpolateAttributes_(semantics, from_path_index, from_point_index, to_path_index, to_point_index, sub_length, ordinate);
        }
    }

    void interpolateAttributes(int path_index, int from_point_index, int to_point_index) {
        int nattr = this.m_description.getAttributeCount();
        if (nattr == 1) {
            return;
        }
        double sub_length = this.calculateSubLength2D(path_index, from_point_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int interpolation = VertexDescription.getInterpolation(semantics);
            if (interpolation == 2) continue;
            int components = VertexDescription.getComponentCount(semantics);
            for (int ordinate = 0; ordinate < components; ++ordinate) {
                this.interpolateAttributes_(semantics, path_index, from_point_index, to_point_index, sub_length, ordinate);
            }
        }
    }

    void interpolateAttributesForSemantics(int semantics, int path_index, int from_point_index, int to_point_index) {
        if (semantics == 0) {
            return;
        }
        if (!this.hasAttribute(semantics)) {
            throw new IllegalArgumentException("does not have the given attribute");
        }
        int interpolation = VertexDescription.getInterpolation(semantics);
        if (interpolation == 2) {
            throw new IllegalArgumentException("not implemented for the given semantics");
        }
        double sub_length = this.calculateSubLength2D(path_index, from_point_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        int components = VertexDescription.getComponentCount(semantics);
        for (int ordinate = 0; ordinate < components; ++ordinate) {
            this.interpolateAttributes_(semantics, path_index, from_point_index, to_point_index, sub_length, ordinate);
        }
    }

    void interpolateAttributes_(int semantics, int from_path_index, int from_point_index, int to_path_index, int to_point_index, double sub_length, int ordinate) {
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        int absolute_from_index = this.getPathStart(from_path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(to_path_index) + to_point_index;
        double from_attribute = this.getAttributeAsDbl(semantics, absolute_from_index, ordinate);
        double to_attribute = this.getAttributeAsDbl(semantics, absolute_to_index, ordinate);
        double interpolated_attribute = from_attribute;
        double cumulative_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        do {
            if (!seg_iter.hasNextSegment()) continue;
            seg_iter.nextSegment();
            if (seg_iter.getStartPointIndex() == absolute_to_index) {
                return;
            }
            this.setAttribute(semantics, seg_iter.getStartPointIndex(), ordinate, interpolated_attribute);
            seg_iter.previousSegment();
            do {
                Segment segment = seg_iter.nextSegment();
                if (seg_iter.getEndPointIndex() == absolute_to_index) {
                    return;
                }
                double segment_length = segment.calculateLength2D();
                double t = (cumulative_length += segment_length) / sub_length;
                interpolated_attribute = MathUtils.lerp(from_attribute, to_attribute, t);
                if (seg_iter.isClosingSegment()) continue;
                this.setAttribute(semantics, seg_iter.getEndPointIndex(), ordinate, interpolated_attribute);
            } while (seg_iter.hasNextSegment());
        } while (seg_iter.nextPath());
    }

    void interpolateAttributes_(int semantics, int path_index, int from_point_index, int to_point_index, double sub_length, int ordinate) {
        assert (this.m_bPolygon);
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        int absolute_from_index = this.getPathStart(path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(path_index) + to_point_index;
        if (absolute_to_index == absolute_from_index) {
            return;
        }
        double from_attribute = this.getAttributeAsDbl(semantics, absolute_from_index, ordinate);
        double to_attribute = this.getAttributeAsDbl(semantics, absolute_to_index, ordinate);
        double cumulative_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        seg_iter.setCirculator(true);
        double prev_interpolated_attribute = from_attribute;
        do {
            Segment segment = seg_iter.nextSegment();
            this.setAttribute(semantics, seg_iter.getStartPointIndex(), ordinate, prev_interpolated_attribute);
            double segment_length = segment.calculateLength2D();
            double t = (cumulative_length += segment_length) / sub_length;
            prev_interpolated_attribute = MathUtils.lerp(from_attribute, to_attribute, t);
        } while (seg_iter.getEndPointIndex() != absolute_to_index);
    }

    @Override
    public void setEmpty() {
        this.m_curveParamwritePoint = 0;
        this.m_bPathStarted = false;
        this.m_paths = null;
        this.m_pathFlags = null;
        this.m_segmentParamIndex = null;
        this.m_segmentFlags = null;
        this.m_segmentParams = null;
        this._setEmptyImpl();
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        this.applyTransformation(transform, -1);
    }

    public void applyTransformation(Transformation2D transform, int pathIndex) {
        int lastIdx;
        int fistIdx;
        boolean bHasNonLinear;
        if (this.isEmpty()) {
            return;
        }
        if (transform.isIdentity()) {
            return;
        }
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        if (pathIndex < 0) {
            bHasNonLinear = this.hasNonLinearSegments();
            fistIdx = 0;
            lastIdx = this.m_pointCount;
        } else {
            bHasNonLinear = this.hasNonLinearSegments(pathIndex);
            fistIdx = this.getPathStart(pathIndex);
            lastIdx = this.getPathEnd(pathIndex);
        }
        if (!bHasNonLinear) {
            points.applyTransformation(transform, fistIdx * 2, lastIdx - fistIdx);
            this.notifyModified(2001);
            return;
        }
    }

    @Override
    public void applyTransformation(Transformation3D transform) {
        if (this.isEmpty()) {
            return;
        }
        this.addAttribute(1);
        this.replaceNaNs(1, 0.0);
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        AttributeStreamOfDbl zs = (AttributeStreamOfDbl)this.m_vertexAttributes[1];
        boolean bHasNonLinear = this.hasNonLinearSegments();
        if (bHasNonLinear) {
            throw new GeometryException("not implemented");
        }
        Point3D pt_start = new Point3D();
        int n = this.m_pointCount;
        for (int ipoint = 0; ipoint < n; ++ipoint) {
            pt_start.x = points.read(ipoint * 2);
            pt_start.y = points.read(ipoint * 2 + 1);
            pt_start.z = zs.read(ipoint);
            transform.transform(pt_start);
            points.write(ipoint * 2, pt_start.x, pt_start.y);
            zs.write(ipoint, pt_start.z);
        }
        this.notifyModified(2001);
    }

    @Override
    protected void _verifyStreamsAfterSizeChangeExtraImpl() {
        if (this.m_paths == null) {
            this.m_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(1, 0);
            this.m_pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(1, (byte)0);
        }
        if (this.m_segmentFlags != null) {
            this.m_segmentFlags.resize(this.m_reservedPointCount, 1.0);
            this.m_segmentParamIndex.resize(this.m_reservedPointCount, -1.0);
            this.checkCompactSegmentParams_();
        }
    }

    @Override
    void _copyToImpl(MultiVertexGeometryImpl dst) {
        MultiPathImpl dstPoly = (MultiPathImpl)dst;
        dstPoly.m_bPathStarted = false;
        dstPoly.m_curveParamwritePoint = this.m_curveParamwritePoint;
        dstPoly.m_fill_rule = this.m_fill_rule;
        dstPoly.m_paths = this.m_paths != null ? new AttributeStreamOfInt32(this.m_paths) : null;
        dstPoly.m_pathFlags = this.m_pathFlags != null ? new AttributeStreamOfInt8(this.m_pathFlags) : null;
        dstPoly.m_segmentParamIndex = this.m_segmentParamIndex != null ? new AttributeStreamOfInt32(this.m_segmentParamIndex) : null;
        dstPoly.m_segmentFlags = this.m_segmentFlags != null ? new AttributeStreamOfInt8(this.m_segmentFlags) : null;
        dstPoly.m_segmentParams = this.m_segmentParams != null ? new AttributeStreamOfDbl(this.m_segmentParams) : null;
        if (!this._hasDirtyFlag(512)) {
            dstPoly.m_cachedLength2D = this.m_cachedLength2D;
        }
        if (!this._hasDirtyFlag(1024)) {
            dstPoly.m_cachedRingAreas2D = this.m_cachedRingAreas2D;
            dstPoly.m_cachedArea2D = this.m_cachedArea2D;
        } else {
            dstPoly.m_cachedRingAreas2D = null;
        }
    }

    @Override
    public double calculateLength2D() {
        if (!this._hasDirtyFlag(512)) {
            return this.m_cachedLength2D;
        }
        SegmentIteratorImpl segIter = this.querySegmentIterator();
        segIter.stripAttributes();
        MathUtils.KahanSummator len = new MathUtils.KahanSummator(0.0);
        while (segIter.nextPath()) {
            while (segIter.hasNextSegment()) {
                len.add(segIter.nextSegment().calculateLength2D());
            }
        }
        this.st_lock.lock();
        if (this._hasDirtyFlag(512)) {
            this.m_cachedLength2D = len.getResult();
            this._clearDirtyFlag(512);
        }
        this.st_lock.unlock();
        return len.getResult();
    }

    @Override
    public boolean equals(Object other) {
        int pathCountOther;
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiPathImpl)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        MultiPathImpl otherMultiPath = (MultiPathImpl)other;
        int pathCount = this.getPathCount();
        if (pathCount != (pathCountOther = otherMultiPath.getPathCount())) {
            return false;
        }
        if (pathCount > 0 && this.m_paths != null && !this.m_paths.equals(otherMultiPath.m_paths, 0, pathCount + 1)) {
            return false;
        }
        if (this.m_fill_rule != otherMultiPath.m_fill_rule) {
            return false;
        }
        if (!this.m_bPolygon && this.m_pathFlags != null && !this.m_pathFlags.equals(otherMultiPath.m_pathFlags, 0, pathCount)) {
            return false;
        }
        return super.equals(other);
    }

    public SegmentIteratorImpl querySegmentIteratorAtVertex(int startVertexIndex) {
        if (startVertexIndex < 0 || startVertexIndex >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        SegmentIteratorImpl iter = new SegmentIteratorImpl(this, startVertexIndex);
        return iter;
    }

    public SegmentIteratorImpl querySegmentIterator() {
        return new SegmentIteratorImpl(this);
    }

    @Override
    public void _updateXYImpl(Envelope env, boolean bExact) {
        super._updateXYImpl(env, bExact);
        boolean bHasCurves = this.hasNonLinearSegments();
        if (bHasCurves) {
            SegmentIteratorImpl segIter = this.querySegmentIterator();
            while (segIter.nextPath()) {
                Segment curve;
                while (segIter.hasNextSegment() && (curve = segIter.nextCurve()) != null) {
                    Envelope2D env2D = new Envelope2D();
                    curve.queryEnvelope2D(env2D);
                    env.merge(env2D);
                }
            }
        }
    }

    @Override
    void calculateEnvelope2D(Envelope2D env, boolean bExact) {
        super.calculateEnvelope2D(env, bExact);
        boolean bHasCurves = this.hasNonLinearSegments();
        if (bHasCurves) {
            SegmentIteratorImpl segIter = this.querySegmentIterator();
            while (segIter.nextPath()) {
                Segment curve;
                while (segIter.hasNextSegment() && (curve = segIter.nextCurve()) != null) {
                    Envelope2D env2D = new Envelope2D();
                    curve.queryEnvelope2D(env2D);
                    env.merge(env2D);
                }
            }
        }
    }

    @Override
    public void _notifyModifiedAllImpl() {
        this.m_pointCount = this.m_paths == null || this.m_paths.size() == 0 ? 0 : this.m_paths.read(this.m_paths.size() - 1);
    }

    @Override
    public double calculateArea2D() {
        if (!this.m_bPolygon) {
            return 0.0;
        }
        this._updateRingAreas2D();
        return this.m_cachedArea2D;
    }

    public boolean isExteriorRing(int ringIndex) {
        if (!this.m_bPolygon) {
            return false;
        }
        this._updateOGCFlags();
        return (this.m_pathFlags.read(ringIndex) & 4) != 0;
    }

    public double calculateRingArea2D(int pathIndex) {
        if (!this.m_bPolygon) {
            return 0.0;
        }
        this._updateRingAreas2D();
        return this.m_cachedRingAreas2D.read(pathIndex);
    }

    private static void calcPathAreaLinearDoubled_(MultiPathImpl mp_impl, int path_index, AttributeStreamOfDbl xy_stream, MathUtils.KahanSummator path_area) {
        int path_start = mp_impl.getPathStart(path_index);
        int path_end = mp_impl.getPathEnd(path_index);
        if (path_end - path_start < 3) {
            return;
        }
        int ind = path_start * 2;
        Point2D p0 = new Point2D();
        xy_stream.read(ind, p0);
        double x0 = p0.x;
        double y0 = p0.y;
        Point2D p1 = new Point2D();
        xy_stream.read(ind + 2, p1);
        Point2D p2 = new Point2D();
        int n = path_end * 2;
        for (int i = ind + 4; i < n; i += 2) {
            xy_stream.read(i, p2);
            path_area.add((p2.x - p0.x) * (p1.y - y0));
            p0.setCoords(p1);
            p1.setCoords(p2);
        }
        path_area.add((x0 - p0.x) * (p1.y - y0));
    }

    public void _updateRingAreas2D() {
        if (!this._hasDirtyFlag(1024)) {
            return;
        }
        int pathCount = this.getPathCount();
        if (pathCount == 0) {
            this.st_lock.lock();
            if (this._hasDirtyFlag(1024)) {
                this.m_cachedArea2D = 0.0;
            }
            this._clearDirtyFlag(1024);
            this.st_lock.unlock();
            return;
        }
        AttributeStreamOfDbl cachedRingAreas2D = new AttributeStreamOfDbl(pathCount);
        MathUtils.KahanSummator totalArea = new MathUtils.KahanSummator(0.0);
        MathUtils.KahanSummator pathAreaDoubled = new MathUtils.KahanSummator(0.0);
        if (this.m_pointCount != 0) {
            AttributeStreamOfDbl position = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
            if (!this.hasNonLinearSegments()) {
                for (int ipath = 0; ipath < pathCount; ++ipath) {
                    pathAreaDoubled.reset();
                    MultiPathImpl.calcPathAreaLinearDoubled_(this, ipath, position, pathAreaDoubled);
                    double path_area = pathAreaDoubled.getResult() * 0.5;
                    totalArea.add(path_area);
                    cachedRingAreas2D.write(ipath, path_area);
                }
            }
        }
        this.st_lock.lock();
        if (this._hasDirtyFlag(1024)) {
            this.m_cachedArea2D = totalArea.getResult();
            this.m_cachedRingAreas2D = cachedRingAreas2D;
            this._clearDirtyFlag(1024);
        }
        this.st_lock.unlock();
    }

    int getOGCPolygonCount() {
        if (!this.m_bPolygon) {
            return 0;
        }
        this._updateOGCFlags();
        int polygonCount = 0;
        int partCount = this.getPathCount();
        for (int ipart = 0; ipart < partCount; ++ipart) {
            if ((this.m_pathFlags.read(ipart) & 4) == 0) continue;
            ++polygonCount;
        }
        return polygonCount;
    }

    protected void _updateOGCFlags() {
        assert (this.m_bPolygon);
        if (!this._hasDirtyFlag(16)) {
            return;
        }
        this._updateRingAreas2D();
        this._updateOGCFlagsHelper();
        this._clearDirtyFlag(16);
    }

    private void _updateOGCFlagsHelper() {
        int path_count = this.getPathCount();
        if (path_count == 0) {
            return;
        }
        assert (this.m_pathFlags != null && this.m_pathFlags.size() >= path_count);
        AttributeStreamOfInt8 path_flags = this.m_pathFlags;
        double firstSign = 1.0;
        for (int ipath = 0; ipath < path_count; ++ipath) {
            double area = this.m_cachedRingAreas2D.read(ipath);
            if (ipath == 0) {
                double d = firstSign = area > 0.0 ? 1.0 : -1.0;
            }
            if (area * firstSign > 0.0) {
                path_flags.setBits(ipath, (byte)4);
                continue;
            }
            path_flags.clearBits(ipath, (byte)4);
        }
    }

    public int getPathIndexFromPointIndex(int pointIndex) {
        return this.getPathIndexFromPointIndex(pointIndex, -1);
    }

    public int getPathIndexFromPointIndex(int pointIndex, int positionHint) {
        int ipath;
        if (positionHint == -1) {
            positionHint = this.m_currentPathIndex;
        }
        int path_count = this.getPathCount();
        this.m_currentPathIndex = ipath = MultiPathImpl.getPathIndexFromPointIndex(this.m_paths, path_count, pointIndex, positionHint);
        return ipath;
    }

    static int getPathIndexFromPointIndex(AttributeStreamOfInt32 parts, int path_count, int point_index, int positionHint) {
        if (positionHint >= 0 && positionHint < path_count) {
            if (point_index >= parts.read(positionHint)) {
                if (point_index < parts.read(positionHint + 1)) {
                    return positionHint;
                }
                ++positionHint;
            } else {
                --positionHint;
            }
            if (positionHint >= 0 && positionHint < path_count && point_index >= parts.read(positionHint) && point_index < parts.read(positionHint + 1)) {
                return positionHint;
            }
        }
        if (path_count < 5) {
            for (int i = 0; i < path_count; ++i) {
                if (point_index >= parts.read(i + 1)) continue;
                return i;
            }
            throw new IndexOutOfBoundsException();
        }
        if (point_index < 0 || point_index >= parts.read(path_count)) {
            throw new IndexOutOfBoundsException();
        }
        int minPathIndex = 0;
        int maxPathIndex = path_count - 1;
        while (maxPathIndex > minPathIndex) {
            int mid = minPathIndex + (maxPathIndex - minPathIndex >> 1);
            int pathStart = parts.read(mid);
            if (point_index < pathStart) {
                maxPathIndex = mid - 1;
                continue;
            }
            int pathEnd = parts.read(mid + 1);
            if (point_index >= pathEnd) {
                minPathIndex = mid + 1;
                continue;
            }
            return mid;
        }
        return minPathIndex;
    }

    int getHighestPointIndex(int path_index) {
        assert (path_index >= 0 && path_index < this.getPathCount());
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        int path_end = this.getPathEnd(path_index);
        int path_start = this.getPathStart(path_index);
        int max_index = -1;
        Point2D max_point = new Point2D();
        Point2D pt = new Point2D();
        max_point.y = NumberUtils.negativeInf();
        max_point.x = NumberUtils.negativeInf();
        for (int i = path_start + 0; i < path_end; ++i) {
            position.read(2 * i, pt);
            if (max_point.compare(pt) != -1) continue;
            max_index = i;
            max_point.setCoords(pt);
        }
        return max_index;
    }

    public int getSegmentCount() {
        int segCount = this.getPointCount();
        if (!this.m_bPolygon) {
            segCount -= this.getPathCount();
            int n = this.getPathCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isClosedPath(i)) continue;
                ++segCount;
            }
        }
        return segCount;
    }

    public int getSegmentCount(int path_index) {
        int segCount = this.getPathSize(path_index);
        if (!this.isClosedPath(path_index)) {
            --segCount;
        }
        return segCount;
    }

    @Override
    public Geometry createInstance() {
        return new MultiPathImpl(this.m_bPolygon, this.getDescription());
    }

    @Override
    public int getDimension() {
        return this.m_bPolygon ? 2 : 1;
    }

    @Override
    public Geometry.Type getType() {
        return this.m_bPolygon ? Geometry.Type.Polygon : Geometry.Type.Polyline;
    }

    public boolean isEnvelope() {
        return !this._hasDirtyFlag(256);
    }

    public AttributeStreamOfInt32 getPathStreamRef() {
        this.throwIfEmpty();
        return this.m_paths;
    }

    public void setPathStreamRef(AttributeStreamOfInt32 paths) {
        this.m_paths = paths;
        this.notifyModified(0xFFFFFF);
    }

    public AttributeStreamOfInt8 getSegmentFlagsStreamRef() {
        this.throwIfEmpty();
        return this.m_segmentFlags;
    }

    public AttributeStreamOfInt8 getPathFlagsStreamRef() {
        this.throwIfEmpty();
        return this.m_pathFlags;
    }

    public void setPathFlagsStreamRef(AttributeStreamOfInt8 pathFlags) {
        this.m_pathFlags = pathFlags;
        this.notifyModified(0xFFFFFF);
    }

    public AttributeStreamOfInt32 getSegmentIndexStreamRef() {
        this.throwIfEmpty();
        return this.m_segmentParamIndex;
    }

    public AttributeStreamOfDbl getSegmentDataStreamRef() {
        this.throwIfEmpty();
        return this.m_segmentParams;
    }

    public int getPathCount() {
        return this.m_paths != null ? this.m_paths.size() - 1 : 0;
    }

    public int getPathEnd(int partIndex) {
        return this.m_paths.read(partIndex + 1);
    }

    public int getPathSize(int partIndex) {
        return this.m_paths.read(partIndex + 1) - this.m_paths.read(partIndex);
    }

    public int getPathStart(int partIndex) {
        return this.m_paths.read(partIndex);
    }

    @Override
    public Object _getImpl() {
        return this;
    }

    void setDirtyOGCFlags() {
        this._setDirtyFlag(16);
    }

    void clearDirtyOGCFlags() {
        this._clearDirtyFlag(16);
    }

    @Override
    public boolean _buildRasterizedGeometryAccelerator(double toleranceXY, Geometry.GeometryAccelerationDegree accelDegree) {
        if (this.m_accelerators == null) {
            this.m_accelerators = new GeometryAccelerators();
        } else {
            this.ensureUniqueAccelerators_();
        }
        int rasterSize = RasterizedGeometry2D.rasterSizeFromAccelerationDegree(accelDegree);
        RasterizedGeometry2D rgeom = this.m_accelerators.getRasterizedGeometry();
        if (rgeom != null) {
            if (rgeom.getToleranceXY() < toleranceXY || rasterSize > rgeom.getRasterSize()) {
                this.m_accelerators._setRasterizedGeometry(null);
            } else {
                return true;
            }
        }
        rgeom = RasterizedGeometry2D.create(this, toleranceXY, rasterSize);
        this.m_accelerators._setRasterizedGeometry(rgeom);
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (!this.isEmptyImpl()) {
            int pathCount = this.getPathCount();
            if (this.m_paths != null) {
                this.m_paths.calculateHashImpl(hashCode, 0, pathCount + 1);
            }
            if (this.m_pathFlags != null) {
                this.m_pathFlags.calculateHashImpl(hashCode, 0, pathCount);
            }
        }
        return hashCode;
    }

    public byte getSegmentFlags(int ivertex) {
        if (this.m_segmentFlags != null) {
            return this.m_segmentFlags.read(ivertex);
        }
        return 1;
    }

    public void getSegment(int startVertexIndex, SegmentBuffer segBuffer, boolean bStripAttributes) {
        int ipath = this.getPathIndexFromPointIndex(startVertexIndex);
        int pathEnd = this.getPathEnd(ipath);
        if (startVertexIndex < 0 || startVertexIndex >= pathEnd || startVertexIndex == pathEnd - 1 && !this.isClosedPath(ipath)) {
            throw new GeometryException("index out of bounds");
        }
        AttributeStreamOfInt8 segFlagStream = this.getSegmentFlagsStreamRef();
        int segFlag = 1;
        if (segFlagStream != null) {
            segFlag = segFlagStream.read(startVertexIndex) & 7;
        }
        Line currentSegment = null;
        switch (segFlag) {
            case 1: {
                currentSegment = segBuffer.createLine();
                break;
            }
            case 2: {
                throw GeometryException.GeometryInternalError();
            }
            case 4: {
                throw GeometryException.GeometryInternalError();
            }
            default: {
                throw GeometryException.GeometryInternalError();
            }
        }
        if (!bStripAttributes) {
            currentSegment.assignVertexDescription(this.m_description);
        } else {
            currentSegment.assignVertexDescription(VertexDescriptionDesignerImpl.getDefaultDescriptor2D());
        }
        int endVertexIndex = startVertexIndex == this.getPathEnd(ipath) - 1 && this.isClosedPath(ipath) ? this.getPathStart(ipath) : startVertexIndex + 1;
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        double x1 = xy.read(2 * startVertexIndex);
        double y1 = xy.read(2 * startVertexIndex + 1);
        double x2 = xy.read(2 * endVertexIndex);
        double y2 = xy.read(2 * endVertexIndex + 1);
        currentSegment.setStartXY(x1, y1);
        currentSegment.setEndXY(x2, y2);
        if (!bStripAttributes) {
            int nattr = this.m_description.getAttributeCount();
            for (int i = 1; i < nattr; ++i) {
                int semantics = this.m_description.getSemantics(i);
                int ncomp = VertexDescription.getComponentCount(semantics);
                for (int ord = 0; ord < ncomp; ++ord) {
                    double vs = this.getAttributeAsDbl(semantics, startVertexIndex, ord);
                    currentSegment.setStartAttribute(semantics, ord, vs);
                    double ve = this.getAttributeAsDbl(semantics, endVertexIndex, ord);
                    currentSegment.setEndAttribute(semantics, ord, ve);
                }
            }
        }
    }

    void queryPathEnvelope2D(int path_index, Envelope2D envelope) {
        if (path_index >= this.getPathCount()) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            envelope.setEmpty();
            return;
        }
        if (this.hasNonLinearSegments(path_index)) {
            throw new GeometryException("not implemented");
        }
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        Point2D pt = new Point2D();
        Envelope2D env = new Envelope2D();
        env.setEmpty();
        int iend = this.getPathEnd(path_index);
        for (int i = this.getPathStart(path_index); i < iend; ++i) {
            stream.read(2 * i, pt);
            env.merge(pt);
        }
        envelope.setCoords(env);
    }

    public void queryLoosePathEnvelope2D(int path_index, Envelope2D envelope) {
        if (path_index >= this.getPathCount()) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            envelope.setEmpty();
            return;
        }
        if (this.hasNonLinearSegments(path_index)) {
            throw new GeometryException("not implemented");
        }
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        Point2D pt = new Point2D();
        Envelope2D env = new Envelope2D();
        env.setEmpty();
        int iend = this.getPathEnd(path_index);
        for (int i = this.getPathStart(path_index); i < iend; ++i) {
            stream.read(2 * i, pt);
            env.merge(pt);
        }
        envelope.setCoords(env);
    }

    @Override
    public boolean _buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree d) {
        if (this.m_accelerators == null) {
            this.m_accelerators = new GeometryAccelerators();
        } else {
            this.ensureUniqueAccelerators_();
        }
        this.m_accelerators._setQuadTree(null);
        QuadTreeImpl quad_tree_impl = InternalUtils.buildQuadTree(this);
        this.m_accelerators._setQuadTree(quad_tree_impl);
        return true;
    }

    boolean _buildQuadTreeForPathsAccelerator(Geometry.GeometryAccelerationDegree degree) {
        if (this.m_accelerators == null) {
            this.m_accelerators = new GeometryAccelerators();
        } else {
            this.ensureUniqueAccelerators_();
        }
        if (this.m_accelerators.getQuadTreeForPaths() != null) {
            return true;
        }
        this.ensureUniqueAccelerators_();
        this.m_accelerators._setQuadTreeForPaths(null);
        QuadTreeImpl quad_tree_impl = InternalUtils.buildQuadTreeForPaths(this);
        this.m_accelerators._setQuadTreeForPaths(quad_tree_impl);
        return true;
    }

    void reserve(int capacity) {
        this.reserveImpl_(capacity);
        if (capacity > 0 && this.m_paths == null) {
            this.m_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
            this.m_pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(0);
            this.m_paths.reserve(2);
            this.m_pathFlags.reserve(2);
            this.m_paths.resize(1, 0.0);
            this.m_pathFlags.resize(1, 0.0);
        }
    }

    void reserve(int vertices, int paths) {
        this.reserveImpl_(vertices);
        if (paths > 0) {
            if (this.m_paths == null) {
                this.m_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
                this.m_pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(0);
                this.m_paths.reserve(paths + 1);
                this.m_pathFlags.reserve(paths + 1);
                this.m_paths.resize(1, 0.0);
                this.m_pathFlags.resize(1, 0.0);
            } else {
                this.m_paths.reserve(paths + 1);
                this.m_pathFlags.reserve(paths + 1);
            }
        }
    }

    void setFillRule(int rule) {
        assert (this.m_bPolygon);
        this.m_fill_rule = rule;
    }

    int getFillRule() {
        return this.m_fill_rule;
    }

    int queryPointAlongPath(int ipath, double distance, Point ptOut) {
        InternalUtils.require(ptOut != null);
        ptOut.setEmpty();
        if (this.isEmpty()) {
            return -1;
        }
        InternalUtils.require(ipath >= 0 && ipath < this.getPathCount());
        int pathsize = this.getPathSize(ipath);
        if (pathsize == 0) {
            return -1;
        }
        if (pathsize == 1) {
            this.getPointByVal(this.getPathStart(ipath), ptOut);
            return this.getPathStart(ipath);
        }
        SegmentIteratorImpl iter = this.querySegmentIteratorAtVertex(this.getPathStart(ipath));
        if (distance < 0.0) {
            return -1;
        }
        MathUtils.KahanSummator d = new MathUtils.KahanSummator(0.0);
        while (iter.hasNextSegment()) {
            Segment seg = iter.nextSegment();
            double len = seg.calculateLength2D();
            double dprev = d.getResult();
            d.add(len);
            if (!(d.getResult() >= distance)) continue;
            double l = distance - dprev;
            if (l > len) {
                l = len;
            }
            double t = seg.lengthToT(l);
            seg.queryCoord(t, ptOut);
            return iter.getStartPointIndex();
        }
        if (this.isClosedPath(ipath)) {
            int index = this.getPathStart(ipath);
            this.getPointByVal(index, ptOut);
            return this.getPathEnd(ipath) - 1;
        }
        int index = this.getPathEnd(ipath) - 1;
        this.getPointByVal(index, ptOut);
        return this.getPathSize(ipath) > 1 ? this.getPathEnd(ipath) - 2 : this.getPathStart(ipath);
    }
}

