/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.OperatorExportToJson;
import com.esri.core.geometry.SpatialReference;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKPublic
public class MapGeometry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Geometry m_geometry = null;
    private SpatialReference sr = null;

    @AndroidSDKPublic
    @HadoopSDKPublic
    public MapGeometry(Geometry g, SpatialReference _sr) {
        this.m_geometry = g;
        this.sr = _sr;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry getGeometry() {
        return this.m_geometry;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setGeometry(Geometry geometry) {
        this.m_geometry = geometry;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setSpatialReference(SpatialReference sr) {
        this.sr = sr;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public SpatialReference getSpatialReference() {
        return this.sr;
    }

    @HadoopSDKPublic
    public String toString() {
        String snippet = OperatorExportToJson.local().execute(this.getSpatialReference(), this.getGeometry());
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        MapGeometry omg = (MapGeometry)other;
        SpatialReference sr = this.getSpatialReference();
        Geometry g = this.getGeometry();
        SpatialReference osr = omg.getSpatialReference();
        Geometry og = omg.getGeometry();
        if (!(sr == osr || sr != null && sr.equals(osr))) {
            return false;
        }
        return g == og || g != null && g.equals(og);
    }

    public boolean equals(MapGeometry other, double tol) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.sr != other.sr) {
            return false;
        }
        if (this.m_geometry != other.m_geometry) {
            return false;
        }
        if (!(this.sr == other.getSpatialReference() || this.sr != null && this.sr.equals(other.getSpatialReference()))) {
            return false;
        }
        return this.getGeometry() == other.getGeometry() || this.getGeometry() != null && this.getGeometry().equals(other.getGeometry(), tol);
    }

    @HadoopSDKPublic
    public int hashCode() {
        SpatialReference sr = this.getSpatialReference();
        Geometry g = this.getGeometry();
        int hc = 43219218;
        if (sr != null) {
            hc ^= sr.hashCode();
        }
        if (g != null) {
            hc ^= g.hashCode();
        }
        return hc;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static MapGeometry _clone(MapGeometry other) {
        Geometry geom = null;
        if (other.m_geometry != null) {
            geom = Geometry._clone(other.m_geometry);
        }
        return new MapGeometry(geom, other.sr);
    }
}

