/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope2DIntersectorImpl;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.QuadTree;
import com.esri.core.geometry.QuadTreeImpl;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;

final class InternalUtils {
    InternalUtils() {
    }

    static double adjust_tolerance_for_TE_clustering(double tol) {
        return 2.0 * Math.sqrt(2.0) * tol;
    }

    static double adjust_tolerance_for_TE_cracking(double tol) {
        return Math.sqrt(2.0) * tol;
    }

    private static double calculateToleranceInternal_(int semantics, SpatialReference sr, double gtolerance, boolean bConservative, boolean rel) {
        double stolerance = 0.0;
        if (sr != null) {
            stolerance = sr.getTolerance(semantics);
            if ((!rel || bConservative) && sr != null) {
                double grid_resolution = sr.getResolution(semantics);
                stolerance += grid_resolution * 1.01;
            }
        }
        if (bConservative) {
            gtolerance *= 4.0;
            stolerance *= 1.01;
        }
        return Math.max(stolerance, gtolerance);
    }

    static double calculateToleranceFromGeometryForOp(SpatialReference sr, Point pt1, Point pt2, boolean bConservative) {
        double gtolerance = Envelope2D._calculateToleranceFromFourValues(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
        return InternalUtils.calculateToleranceInternal_(0, sr, gtolerance, bConservative, false);
    }

    static double calculateToleranceFromGeometryForOp(SpatialReference sr, Envelope2D env2D, boolean bConservative) {
        double gtolerance = env2D._calculateToleranceFromEnvelope();
        return InternalUtils.calculateToleranceInternal_(0, sr, gtolerance, bConservative, false);
    }

    static double calculateZToleranceFromGeometryForOp(SpatialReference sr, Envelope1D env1D, boolean bConservative) {
        double gtolerance = env1D._calculateToleranceFromEnvelope();
        return InternalUtils.calculateToleranceInternal_(1, sr, gtolerance, bConservative, false);
    }

    static double calculateToleranceFromGeometryForOp(SpatialReference sr, Geometry geometry, boolean bConservative) {
        Envelope2D env2D = new Envelope2D();
        geometry.queryEnvelope2D(env2D);
        return InternalUtils.calculateToleranceFromGeometryForOp(sr, env2D, bConservative);
    }

    static double calculateZToleranceFromGeometryForOp(SpatialReference sr, Geometry geom, boolean bConservative) {
        Envelope1D env = geom.queryInterval(1, 0);
        return InternalUtils.calculateZToleranceFromGeometryForOp(sr, env, bConservative);
    }

    static double calculateToleranceFromGeometryForRel(SpatialReference sr, Envelope2D env2D, boolean bConservative) {
        double gtolerance = env2D._calculateToleranceFromEnvelope();
        return InternalUtils.calculateToleranceInternal_(0, sr, gtolerance, bConservative, true);
    }

    static double calculateZToleranceFromGeometryForRel(SpatialReference sr, Envelope1D env1D, boolean bConservative) {
        double gtolerance = env1D._calculateToleranceFromEnvelope();
        return InternalUtils.calculateToleranceInternal_(1, sr, gtolerance, bConservative, true);
    }

    static double calculateToleranceFromGeometryForRel(SpatialReference sr, Geometry geometry, boolean bConservative) {
        Envelope2D env2D = new Envelope2D();
        geometry.queryEnvelope2D(env2D);
        return InternalUtils.calculateToleranceFromGeometryForRel(sr, env2D, bConservative);
    }

    public static Envelope2D getMergedExtent(Geometry geom1, Envelope2D env2) {
        Envelope2D env1 = new Envelope2D();
        geom1.queryLooseEnvelope2D(env1);
        env1.merge(env2);
        return env1;
    }

    public static void getMergedExtent(Geometry geom1, Geometry geom2, Envelope2D env) {
        geom1.queryLooseEnvelope2D(env);
        boolean empty1 = env.isEmpty();
        double x1 = env.xmin;
        double y1 = env.ymin;
        double x2 = env.xmax;
        double y2 = env.ymax;
        geom2.queryLooseEnvelope2D(env);
        if (!empty1) {
            env.merge(x1, y1);
            env.mergeNE(x2, y2);
        }
    }

    public static Geometry createGeometry(int gt, VertexDescription vdIn) {
        VertexDescription vd = vdIn;
        if (vd == null) {
            vd = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        }
        switch (gt) {
            case 33: {
                return new Point(vd);
            }
            case 322: {
                return new Line(vd);
            }
            case 197: {
                return new Envelope(vd);
            }
            case 550: {
                return new MultiPoint(vd);
            }
            case 1607: {
                return new Polyline(vd);
            }
            case 1736: {
                return new Polygon(vd);
            }
        }
        throw new GeometryException("invalid argument.");
    }

    static boolean isClockwiseRing(MultiPathImpl polygon, int iring) {
        Point2D r;
        Point2D p;
        int high_point_index = polygon.getHighestPointIndex(iring);
        int path_start = polygon.getPathStart(iring);
        int path_end = polygon.getPathEnd(iring);
        Point2D q = polygon.getXY(high_point_index);
        if (high_point_index == path_start) {
            p = polygon.getXY(path_end - 1);
            r = polygon.getXY(path_start + 1);
        } else if (high_point_index == path_end - 1) {
            p = polygon.getXY(high_point_index - 1);
            r = polygon.getXY(path_start);
        } else {
            p = polygon.getXY(high_point_index - 1);
            r = polygon.getXY(high_point_index + 1);
        }
        int orientation = Point2D.orientationRobust(p, q, r);
        if (orientation == 0) {
            return polygon.calculateRingArea2D(iring) > 0.0;
        }
        return orientation == -1;
    }

    static QuadTreeImpl buildQuadTree(MultiPathImpl multipathImpl) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLooseEnvelope2D(extent);
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        int hint_index = -1;
        SegmentIteratorImpl seg_iter = multipathImpl.querySegmentIterator();
        Envelope2D boundingbox = new Envelope2D();
        boolean resized_extent = false;
        block0: while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                int index = seg_iter.getStartPointIndex();
                segment.queryEnvelope2D(boundingbox);
                if ((hint_index = quad_tree_impl.insert(index, boundingbox, hint_index)) != -1) continue;
                if (resized_extent) {
                    throw GeometryException.GeometryInternalError();
                }
                multipathImpl.calculateEnvelope2D(extent, false);
                resized_extent = true;
                quad_tree_impl.reset(extent, 8);
                seg_iter.resetToFirstPath();
                continue block0;
            }
        }
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTree(MultiPathImpl multipathImpl, Envelope2D extentOfInterest) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLooseEnvelope2D(extent);
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        int hint_index = -1;
        Envelope2D boundingbox = new Envelope2D();
        SegmentIteratorImpl seg_iter = multipathImpl.querySegmentIterator();
        boolean resized_extent = false;
        block0: while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                int index = seg_iter.getStartPointIndex();
                segment.queryEnvelope2D(boundingbox);
                if (!boundingbox.isIntersecting(extentOfInterest) || (hint_index = quad_tree_impl.insert(index, boundingbox, hint_index)) != -1) continue;
                if (resized_extent) {
                    throw GeometryException.GeometryInternalError();
                }
                multipathImpl.calculateEnvelope2D(extent, false);
                resized_extent = true;
                quad_tree_impl.reset(extent, 8);
                seg_iter.resetToFirstPath();
                continue block0;
            }
        }
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTreeForPaths(MultiPathImpl multipathImpl) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLooseEnvelope2D(extent);
        if (extent.isEmpty()) {
            return null;
        }
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        int hint_index = -1;
        Envelope2D boundingbox = new Envelope2D();
        boolean resized_extent = false;
        block0: do {
            int npaths = multipathImpl.getPathCount();
            for (int ipath = 0; ipath < npaths; ++ipath) {
                multipathImpl.queryPathEnvelope2D(ipath, boundingbox);
                hint_index = quad_tree_impl.insert(ipath, boundingbox, hint_index);
                if (hint_index == -1) {
                    if (resized_extent) {
                        throw GeometryException.GeometryInternalError();
                    }
                    multipathImpl.calculateEnvelope2D(extent, false);
                    resized_extent = true;
                    quad_tree_impl.reset(extent, 8);
                    continue block0;
                }
                resized_extent = false;
            }
        } while (resized_extent);
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTree(MultiPointImpl multipointImpl) {
        Envelope2D extent = new Envelope2D();
        multipointImpl.queryLooseEnvelope2D(extent);
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        Point2D pt = new Point2D();
        Envelope2D boundingbox = new Envelope2D();
        boolean resized_extent = false;
        for (int i = 0; i < multipointImpl.getPointCount(); ++i) {
            multipointImpl.getXY(i, pt);
            boundingbox.setCoords(pt);
            int element_handle = quad_tree_impl.insert(i, boundingbox);
            if (element_handle != -1) continue;
            if (resized_extent) {
                throw GeometryException.GeometryInternalError();
            }
            multipointImpl.calculateEnvelope2D(extent, false);
            resized_extent = true;
            quad_tree_impl.reset(extent, 8);
            i = -1;
        }
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTree(MultiPointImpl multipointImpl, Envelope2D extentOfInterest) {
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extentOfInterest, 8);
        Point2D pt = new Point2D();
        boolean resized_extent = false;
        Envelope2D boundingbox = new Envelope2D();
        for (int i = 0; i < multipointImpl.getPointCount(); ++i) {
            multipointImpl.getXY(i, pt);
            if (!extentOfInterest.contains(pt)) continue;
            boundingbox.setCoords(pt);
            int element_handle = quad_tree_impl.insert(i, boundingbox);
            if (element_handle != -1) continue;
            if (resized_extent) {
                throw GeometryException.GeometryInternalError();
            }
            resized_extent = true;
            Envelope2D extent = new Envelope2D();
            multipointImpl.calculateEnvelope2D(extent, false);
            quad_tree_impl.reset(extent, 8);
            i = -1;
        }
        return quad_tree_impl;
    }

    static Envelope2DIntersectorImpl getEnvelope2DIntersector(MultiPathImpl multipathImplA, MultiPathImpl multipathImplB, double tolerance) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipathImplA.queryLooseEnvelope2D(env_a);
        multipathImplB.queryLooseEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        Envelope2D envInter = new Envelope2D();
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        SegmentIteratorImpl segIterA = multipathImplA.querySegmentIterator();
        SegmentIteratorImpl segIterB = multipathImplB.querySegmentIterator();
        Envelope2DIntersectorImpl intersector = new Envelope2DIntersectorImpl();
        intersector.setTolerance(tolerance);
        boolean b_found_red = false;
        intersector.startRedConstruction();
        while (segIterA.nextPath()) {
            while (segIterA.hasNextSegment()) {
                Segment segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env_a);
                if (!env_a.isIntersecting(envInter)) continue;
                b_found_red = true;
                Envelope2D env = new Envelope2D();
                env.setCoords(env_a);
                intersector.addRedEnvelope(segIterA.getStartPointIndex(), env);
            }
        }
        intersector.endRedConstruction();
        if (!b_found_red) {
            return null;
        }
        boolean b_found_blue = false;
        intersector.startBlueConstruction();
        while (segIterB.nextPath()) {
            while (segIterB.hasNextSegment()) {
                Segment segmentB = segIterB.nextSegment();
                segmentB.queryEnvelope2D(env_b);
                if (!env_b.isIntersecting(envInter)) continue;
                b_found_blue = true;
                Envelope2D env = new Envelope2D();
                env.setCoords(env_b);
                intersector.addBlueEnvelope(segIterB.getStartPointIndex(), env);
            }
        }
        intersector.endBlueConstruction();
        if (!b_found_blue) {
            return null;
        }
        return intersector;
    }

    static Envelope2DIntersectorImpl getEnvelope2DIntersectorForParts(MultiPathImpl multipathImplA, MultiPathImpl multipathImplB, double tolerance, boolean bExteriorOnlyA, boolean bExteriorOnlyB) {
        int type_a = multipathImplA.getType().value();
        int type_b = multipathImplB.getType().value();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipathImplA.queryLooseEnvelope2D(env_a);
        multipathImplB.queryLooseEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        Envelope2D envInter = new Envelope2D();
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        Envelope2DIntersectorImpl intersector = new Envelope2DIntersectorImpl();
        intersector.setTolerance(tolerance);
        boolean b_found_red = false;
        intersector.startRedConstruction();
        int npaths = multipathImplA.getPathCount();
        for (int ipath_a = 0; ipath_a < npaths; ++ipath_a) {
            if (bExteriorOnlyA && type_a == 1736 && !multipathImplA.isExteriorRing(ipath_a)) continue;
            multipathImplA.queryPathEnvelope2D(ipath_a, env_a);
            if (!env_a.isIntersecting(envInter)) continue;
            b_found_red = true;
            intersector.addRedEnvelope(ipath_a, env_a);
        }
        intersector.endRedConstruction();
        if (!b_found_red) {
            return null;
        }
        boolean b_found_blue = false;
        intersector.startBlueConstruction();
        int npaths2 = multipathImplB.getPathCount();
        for (int ipath_b = 0; ipath_b < npaths2; ++ipath_b) {
            if (bExteriorOnlyB && type_b == 1736 && !multipathImplB.isExteriorRing(ipath_b)) continue;
            multipathImplB.queryPathEnvelope2D(ipath_b, env_b);
            if (!env_b.isIntersecting(envInter)) continue;
            b_found_blue = true;
            intersector.addBlueEnvelope(ipath_b, env_b);
        }
        intersector.endBlueConstruction();
        if (!b_found_blue) {
            return null;
        }
        return intersector;
    }

    static void setWeakSsimple(Polygon geom, double tol) {
        ((MultiVertexGeometryImpl)geom._getImpl()).setIsSimple(3, tol);
    }

    static boolean isAtLeastWeakSimple(MultiVertexGeometry geom, double tol) {
        return ((MultiVertexGeometryImpl)geom._getImpl()).getIsSimple(tol, null) >= 3;
    }

    static boolean isAtLeastWeakSimple(int simple_value) {
        return simple_value >= 3;
    }

    static boolean isAtLeastPlanarSimple(int simple_value) {
        return simple_value >= 4;
    }

    static boolean isAtLeastSimpleAsFeature(int gt, int simple_value) {
        assert (simple_value != 7);
        if (gt == 1736) {
            return InternalUtils.isAtLeastWeakSimple(simple_value);
        }
        return simple_value >= 1;
    }

    static QuadTree buildQuadTreeForOnePath(MultiPathImpl multipathImpl, int path) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLoosePathEnvelope2D(path, extent);
        QuadTree quad_tree = new QuadTree(extent, 8);
        int hint_index = -1;
        Envelope2D boundingbox = new Envelope2D();
        SegmentIteratorImpl seg_iter = multipathImpl.querySegmentIterator();
        seg_iter.resetToPath(path);
        if (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                int index = seg_iter.getStartPointIndex();
                segment.queryLooseEnvelope2D(boundingbox);
                if ((hint_index = quad_tree.insert(index, boundingbox, hint_index)) != -1) continue;
                throw new GeometryException("internal error");
            }
        }
        return quad_tree;
    }

    static boolean isAngleTooSharp(Point2D startPoint, Point2D midPoint, Point2D endPoint, double tolerance, boolean returnTrueForDegenerateSegments) {
        double sqrTol = tolerance * tolerance;
        Point2D p1 = new Point2D();
        p1.sub(startPoint, midPoint);
        Point2D p2 = new Point2D();
        p2.sub(endPoint, midPoint);
        double a2 = p1.sqrLength();
        double b2 = p2.sqrLength();
        if (returnTrueForDegenerateSegments && a2 <= sqrTol && b2 <= sqrTol) {
            return true;
        }
        double abSin2 = MathUtils.sqr(p1.crossProduct(p2));
        if (abSin2 <= sqrTol * a2 || abSin2 <= sqrTol * b2) {
            double abCos = p1.dotProduct(p2);
            return abCos >= 0.0;
        }
        return false;
    }

    static boolean snapStream(AttributeStreamOfDbl stream, int count, int ord, int stride, Envelope1D env) {
        boolean snapped = false;
        double vmin = env.vmin;
        double vmax = env.vmax;
        for (int i = ord; i < count; i += stride) {
            double v = stream.read(i);
            if (v < vmin) {
                snapped = true;
                stream.write(i, vmin);
                continue;
            }
            if (!(v > vmax)) continue;
            snapped = true;
            stream.write(i, vmax);
        }
        return snapped;
    }

    static boolean snapStream(AttributeStreamOfInt32 stream, int count, int ord, int stride, Envelope1D env) {
        boolean snapped = false;
        double vmin = env.vmin;
        double vmax = env.vmax;
        for (int i = ord; i < count; i += stride) {
            double v = stream.read(i);
            if (v < vmin) {
                snapped = true;
                stream.write(i, (int)vmin);
                continue;
            }
            if (!(v > vmax)) continue;
            snapped = true;
            stream.write(i, (int)vmax);
        }
        return snapped;
    }

    static boolean snapCoordinate(Geometry geom, Envelope1D env, int semantics, int ord) {
        if (!geom.hasAttribute(semantics)) {
            return false;
        }
        Geometry.Type gt = geom.getType();
        if (Geometry.isMultiVertex(gt.value())) {
            MultiVertexGeometry mvg = (MultiVertexGeometry)geom;
            int persistence = VertexDescription.getPersistence(semantics);
            int stride = VertexDescription.getComponentCount(semantics);
            int pc = mvg.getPointCount();
            if (persistence == 1) {
                AttributeStreamOfDbl attr = (AttributeStreamOfDbl)((MultiVertexGeometryImpl)mvg._getImpl()).getAttributeStreamRef(semantics);
                return InternalUtils.snapStream(attr, pc * stride, ord, stride, env);
            }
            if (persistence == 2) {
                AttributeStreamOfInt32 attr = (AttributeStreamOfInt32)((MultiVertexGeometryImpl)mvg._getImpl()).getAttributeStreamRef(semantics);
                return InternalUtils.snapStream(attr, pc * stride, ord, stride, env);
            }
            throw new GeometryException("snap_coordinate not implemented");
        }
        if (gt == Geometry.Type.Envelope) {
            Envelope envelope = (Envelope)geom;
            Envelope1D e = envelope.queryInterval(semantics, ord);
            boolean snapped = false;
            if (e.vmin < env.vmin) {
                snapped = true;
                e.vmin = env.vmin;
            }
            if (e.vmax > env.vmax) {
                snapped = true;
                e.vmax = env.vmax;
            }
            if (snapped) {
                envelope.setInterval(semantics, ord, e);
            }
            return snapped;
        }
        if (gt == Geometry.Type.Point) {
            Point point = (Point)geom;
            double v = point.getAttributeAsDbl(semantics, ord);
            boolean snapped = false;
            if (v < env.vmin) {
                snapped = true;
                v = env.vmin;
            }
            if (v > env.vmax) {
                snapped = true;
                v = env.vmax;
            }
            if (snapped) {
                point.setAttribute(semantics, ord, v);
            }
            return snapped;
        }
        if (Geometry.isSegment(gt.value())) {
            Segment seg = (Segment)geom;
            double v = seg.getStartAttributeAsDbl(semantics, ord);
            boolean snapped = false;
            if (v < env.vmin) {
                snapped = true;
                v = env.vmin;
            }
            if (v > env.vmax) {
                snapped = true;
                v = env.vmax;
            }
            if (snapped) {
                seg.setStartAttribute(semantics, ord, v);
            }
            if ((v = seg.getEndAttributeAsDbl(semantics, ord)) < env.vmin) {
                snapped = true;
                v = env.vmin;
            }
            if (v > env.vmax) {
                snapped = true;
                v = env.vmax;
            }
            if (snapped) {
                seg.setEndAttribute(semantics, ord, v);
            }
            return snapped;
        }
        throw new GeometryException("snap_coordinate not implemented");
    }

    static boolean snapY(Point2D[] pointsInOut, int count, double mi, double ma) {
        boolean modified = false;
        for (int i = 0; i < count; ++i) {
            double oy = pointsInOut[i].y;
            double y = NumberUtils.snap(oy, mi, ma);
            if (y == oy) continue;
            modified = true;
            pointsInOut[i].y = y;
        }
        return modified;
    }

    static void require(boolean condition) {
        if (!condition) {
            InternalUtils.throwIllegalArgumetException();
        }
    }

    static void require(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void throwIllegalArgumetException() {
        throw new IllegalArgumentException();
    }

    static void copyPoint2DArray(Point2D[] dst, Point2D[] src, int count) {
        if (dst == src) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            if (dst[i] == null) {
                dst[i] = new Point2D(src[i]);
                continue;
            }
            dst[i].setCoords(src[i]);
        }
    }

    static void copyPoint2DArray(double[][] dst, int dstStart, Point2D[] src, int src_start, int count) {
        int j = src_start;
        int n = count + dstStart;
        for (int k = dstStart; k < n; ++k) {
            if (dst[k] == null) {
                dst[k] = new double[2];
            }
            dst[k][0] = src[j].x;
            dst[k][1] = src[j].y;
            ++j;
        }
    }

    static void copyPoint2DArray(Point2D[] dst, int dstStart, double[][] src, int src_start, int count) {
        int j = src_start;
        int n = count + dstStart;
        for (int k = dstStart; k < n; ++k) {
            if (dst[k] == null) {
                dst[k] = new Point2D(src[j][0], src[j][1]);
            } else {
                dst[k].setCoords(src[j][0], src[j][1]);
            }
            ++j;
        }
    }

    static void copyPointArray(Point[] dst, Point[] src, int count) {
        if (dst == src) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            if (dst[i] == null) {
                dst[i] = new Point(src[i]);
                continue;
            }
            src[i].copyTo(dst[i]);
        }
    }
}

