/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Clipper;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.RoundEarthUtils;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.Transformation2D;
import com.esri.sde.sdk.pe.engine.PeDouble;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLineType;
import com.esri.sde.sdk.pe.engine.PeMacros;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import java.util.ArrayList;

@HadoopSDKExcluded
final class Gnomonic {
    private SpatialReference m_gcs;
    private double m_a;
    private double m_e2;
    private double m_rpu;
    private Point2D m_curv_center_rad;
    private Point3D m_cart_center_3D;
    Point3D m_basis_x;
    Point3D m_basis_y;
    Point3D m_normal;
    private double m_d;
    private Point2D m_north_pole_pcs;
    private Point2D m_south_pole_pcs;
    private Point2D m_dummy_pt2D_1 = new Point2D();
    private Point3D m_dummy_pt3D_1 = new Point3D();

    Gnomonic(SpatialReference gcs, Point2D curv_center_deg) {
        this.m_gcs = gcs;
        SpatialReferenceImpl gcs_impl = (SpatialReferenceImpl)gcs;
        PeGeogcs geog_cs = (PeGeogcs)gcs_impl.getPECoordSys();
        PeSpheroid spheroid = geog_cs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        this.m_a = spheroid.getAxis();
        this.m_e2 = flattening * (2.0 - flattening);
        this.m_rpu = gcs_impl.getUnit().getUnitToBaseFactor();
        this.m_curv_center_rad = new Point2D();
        this.m_curv_center_rad.scale(this.m_rpu, curv_center_deg);
        double lam = this.m_curv_center_rad.x;
        double phi = this.m_curv_center_rad.y;
        double cos_lam = Math.cos(lam);
        double sin_lam = Math.sin(lam);
        double cos_phi = Math.cos(phi);
        double sin_phi = Math.sin(phi);
        this.m_cart_center_3D = RoundEarthUtils.curv_to_cart(this.m_a, this.m_e2, cos_lam, sin_lam, cos_phi, sin_phi);
        this.m_normal = new Point3D(this.m_cart_center_3D);
        this.m_d = this.m_cart_center_3D.length();
        this.m_normal.div(this.m_d);
        this.m_basis_x = new Point3D();
        this.m_basis_x.setNaN();
        double len = 0.0;
        for (int i = 0; i < 3; ++i) {
            Point3D basis_vec = new Point3D(0.0, 0.0, 0.0);
            basis_vec.set(i, 1.0);
            Point3D v1 = new Point3D();
            v1.crossProductVector(this.m_cart_center_3D, basis_vec);
            double l1 = v1.sqrLength();
            if (!(l1 > len)) continue;
            this.m_basis_x.setCoords(v1);
            len = l1;
        }
        this.m_basis_x.normalize();
        this.m_basis_y = new Point3D();
        this.m_basis_y.crossProductVector(this.m_normal, this.m_basis_x);
        this.m_basis_y.normalize();
        this.m_north_pole_pcs = new Point2D();
        this.project(new Point2D(0.0, 1.5707963267948966 / this.m_rpu), this.m_north_pole_pcs);
        this.m_south_pole_pcs = new Point2D();
        this.project(new Point2D(0.0, -1.5707963267948966 / this.m_rpu), this.m_south_pole_pcs);
    }

    Point2D project(Point2D curv_pt_deg) {
        Point2D result = new Point2D();
        this.project(curv_pt_deg, result);
        return result;
    }

    void project(Point2D curv_pt_deg, Point2D result) {
        assert (this.m_dummy_pt2D_1 != curv_pt_deg);
        assert (this.m_dummy_pt2D_1 != result);
        Point2D curv_pt_rad = this.m_dummy_pt2D_1;
        curv_pt_rad.scale(this.m_rpu, curv_pt_deg);
        Point3D cart_pt = this.m_dummy_pt3D_1;
        RoundEarthUtils.curv_to_cart(this.m_a, this.m_e2, curv_pt_rad, cart_pt);
        double ax_by_cz = this.m_normal.dotProduct(cart_pt);
        if (ax_by_cz == 0.0) {
            result.setCoords(NumberUtils.NaN(), NumberUtils.NaN());
            return;
        }
        double k = this.m_d / ax_by_cz;
        if (k < 0.0) {
            result.setCoords(NumberUtils.NaN(), NumberUtils.NaN());
            return;
        }
        cart_pt.mul(k);
        cart_pt.sub(this.m_cart_center_3D);
        result.x = this.m_basis_x.dotProduct(cart_pt);
        result.y = this.m_basis_y.dotProduct(cart_pt);
    }

    Point2D unproject(Point2D proj_pt) {
        Point2D result = new Point2D();
        this.unproject(proj_pt, result);
        return result;
    }

    void unproject(Point2D proj_pt, Point2D result) {
        this.m_dummy_pt3D_1.scaleAdd(proj_pt.x, this.m_basis_x, proj_pt.y, this.m_basis_y);
        this.m_dummy_pt3D_1.add(this.m_cart_center_3D);
        RoundEarthUtils.cart_to_curv(this.m_a, this.m_e2, this.m_dummy_pt3D_1, result);
        result.div(this.m_rpu);
    }

    static double calculate_tight_radius_in_meters(double a, double e2, Point2D curv_center_rad) {
        double lam_a = curv_center_rad.x;
        double phi_a = curv_center_rad.y - 1.3089969389957472;
        double lam_b = curv_center_rad.x;
        double phi_b = curv_center_rad.y + 1.3089969389957472;
        double[] lam = new double[1];
        double[] phi = new double[1];
        lam[0] = lam_a;
        phi[0] = phi_a;
        RoundEarthUtils.lam_phi_reduction(lam, phi);
        lam_a = lam[0];
        phi_a = phi[0];
        lam[0] = lam_b;
        phi[0] = phi_b;
        RoundEarthUtils.lam_phi_reduction(lam, phi);
        lam_b = lam[0];
        phi_b = phi[0];
        PeDouble pe_distance_a = new PeDouble();
        PeDouble pe_distance_b = new PeDouble();
        PeLineType.great_elliptic_distance((double)a, (double)e2, (double)curv_center_rad.x, (double)curv_center_rad.y, (double)lam_a, (double)phi_a, (PeDouble)pe_distance_a, null, null);
        PeLineType.great_elliptic_distance((double)a, (double)e2, (double)curv_center_rad.x, (double)curv_center_rad.y, (double)lam_b, (double)phi_b, (PeDouble)pe_distance_b, null, null);
        double tight_radius = Math.min(pe_distance_a.val, pe_distance_b.val);
        return tight_radius;
    }

    void project(Geometry geometry) {
        Geometry.Type type = geometry.getType();
        if (Geometry.isMultiVertex(type.value())) {
            MultiVertexGeometry multi_vertex_geometry = (MultiVertexGeometry)geometry;
            this.project_multi_vertex_(multi_vertex_geometry);
            return;
        }
        throw new IllegalArgumentException("Gnomonic::project");
    }

    Geometry unproject(Geometry geometry, double pole_tolerance_meters, ProgressTracker progress_tracker) {
        Geometry.Type type = geometry.getType();
        if (Geometry.isMultiVertex(type.value())) {
            MultiVertexGeometry multi_vertex_geometry = (MultiVertexGeometry)geometry;
            AttributeStreamOfDbl path_areas = new AttributeStreamOfDbl(0);
            if (type == Geometry.Type.Polygon) {
                Polygon poly = (Polygon)geometry;
                int path_count = poly.getPathCount();
                path_areas.reserve(path_count);
                for (int i = 0; i < path_count; ++i) {
                    double area = poly.calculateRingArea2D(i);
                    path_areas.add(area);
                }
            }
            this.unproject_multi_vertex_(pole_tolerance_meters, multi_vertex_geometry);
            if (Geometry.isMultiPath(type.value())) {
                this.rectify_dateline_jumps_(this.m_gcs, 0.0, (MultiPath)multi_vertex_geometry);
                this.geo_normalize_(path_areas, this.m_gcs, 0.0, (MultiPath)multi_vertex_geometry, progress_tracker);
            } else {
                multi_vertex_geometry = (MultiVertexGeometry)ProjectionUtils.foldInto360DegreeRange(multi_vertex_geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, true, 0.0, progress_tracker);
            }
            return multi_vertex_geometry;
        }
        throw new IllegalArgumentException("Gnomonic::unproject");
    }

    private void project_multi_vertex_(MultiVertexGeometry multi_vertex_geometry) {
        MultiVertexGeometryImpl mvgimpl = (MultiVertexGeometryImpl)multi_vertex_geometry._getImpl();
        Point2D pt = new Point2D();
        int n = mvgimpl.getPointCount();
        for (int i = 0; i < n; ++i) {
            Point2D proj_pt;
            mvgimpl.getXY(i, pt);
            if (pt.y * this.m_rpu > 1.5707963267948966) {
                proj_pt = this.m_north_pole_pcs;
            } else if (pt.y * this.m_rpu < -1.5707963267948966) {
                proj_pt = this.m_south_pole_pcs;
            } else {
                this.project(pt, pt);
                proj_pt = pt;
            }
            mvgimpl.setXY(i, proj_pt);
        }
    }

    private void unproject_multi_vertex_(double tolerance, MultiVertexGeometry multi_vertex_geometry) {
        MultiVertexGeometryImpl mvgimpl = (MultiVertexGeometryImpl)multi_vertex_geometry._getImpl();
        double sqr_tolerance = tolerance * tolerance;
        Point2D proj_pt = new Point2D();
        Point2D curv_pt = new Point2D();
        int n = mvgimpl.getPointCount();
        for (int i = 0; i < n; ++i) {
            mvgimpl.getXY(i, proj_pt);
            if (!this.m_north_pole_pcs.isNaN() && Point2D.sqrDistance(proj_pt, this.m_north_pole_pcs) <= sqr_tolerance) {
                curv_pt.setCoords(this.m_curv_center_rad.x, 1.5707963267948966);
                curv_pt.scale(1.0 / this.m_rpu);
            } else if (!this.m_south_pole_pcs.isNaN() && Point2D.sqrDistance(proj_pt, this.m_south_pole_pcs) <= sqr_tolerance) {
                curv_pt.setCoords(this.m_curv_center_rad.x, -1.5707963267948966);
                curv_pt.scale(1.0 / this.m_rpu);
            } else {
                this.unproject(proj_pt, curv_pt);
            }
            mvgimpl.setXY(i, curv_pt);
        }
    }

    private void rectify_dateline_jumps_(SpatialReference gcs, double central_longitude_override, MultiPath multi_path) {
        Envelope2D pannable_extent = gcs.getPannableExtent();
        Point2D center_override = new Point2D(central_longitude_override, 0.0);
        pannable_extent.centerAt(center_override);
        double pannable_360 = pannable_extent.getWidth();
        double pannable_180 = 0.5 * pannable_360;
        Point2D last_projected_point = new Point2D();
        last_projected_point.setNaN();
        double[] current_projected_delta = new double[]{NumberUtils.NaN()};
        Point2D projected_point = new Point2D();
        Point2D projected_point_rectified = new Point2D();
        for (int ipath = 0; ipath < multi_path.getPathCount(); ++ipath) {
            for (int i = multi_path.getPathStart(ipath); i < multi_path.getPathEnd(ipath); ++i) {
                boolean b_is_pole;
                multi_path.getXY(i, projected_point);
                boolean bl = b_is_pole = PeMacros.PE_EQ((double)projected_point.y, (double)pannable_extent.ymax) || PeMacros.PE_EQ((double)pannable_extent.ymin, (double)projected_point.y);
                if (i == multi_path.getPathStart(ipath)) {
                    last_projected_point.setNaN();
                    current_projected_delta[0] = 0.0;
                } else if (!last_projected_point.isNaN() && !b_is_pole) {
                    this.rectify_projected_delta_(projected_point.x, last_projected_point.x, pannable_180, pannable_360, current_projected_delta);
                }
                projected_point_rectified.setCoords(projected_point);
                projected_point_rectified.x += current_projected_delta[0];
                multi_path.setXY(i, projected_point_rectified);
                if (b_is_pole) continue;
                last_projected_point.setCoords(projected_point_rectified);
            }
        }
        ((MultiVertexGeometryImpl)multi_path._getImpl()).notifyModified(2001);
    }

    private void rectify_projected_delta_(double raw_projected_point_x, double last_projected_point_x, double pannable_180, double pannable_360, double[] current_projected_delta) {
        if (current_projected_delta[0] + raw_projected_point_x - last_projected_point_x > pannable_180) {
            current_projected_delta[0] = current_projected_delta[0] - pannable_360;
        } else if (last_projected_point_x - (current_projected_delta[0] + raw_projected_point_x) > pannable_180) {
            current_projected_delta[0] = current_projected_delta[0] + pannable_360;
        }
    }

    private void geo_normalize_(AttributeStreamOfDbl path_areas, SpatialReference gcs, double central_longitude_override, MultiPath multi_path, ProgressTracker progress_tracker) {
        Geometry.Type type = multi_path.getType();
        Envelope2D pannable_extent = gcs.getPannableExtent();
        MultiPath normalized = multi_path;
        boolean b_wrapped_pole = false;
        boolean b_crossed_date_line = false;
        if (type == Geometry.Type.Polygon) {
            Envelope2D pannable_extent_center_override = new Envelope2D();
            Point2D center_override = new Point2D(central_longitude_override, 0.0);
            pannable_extent_center_override.setCoords(pannable_extent);
            pannable_extent_center_override.centerAt(center_override);
            b_wrapped_pole = this.check_and_prep_for_pole_(path_areas, gcs, pannable_extent_center_override, (Polygon)normalized, progress_tracker);
            MultiPath folded = this.fold_parts_into_360_(gcs, pannable_extent_center_override, normalized, progress_tracker);
            if (folded != normalized) {
                b_crossed_date_line = true;
            }
            normalized = folded;
        } else {
            normalized = (Polyline)OperatorProject.local().foldInto360RangeGeodetic(normalized, gcs, 2);
        }
        if (type == Geometry.Type.Polygon && (b_wrapped_pole || b_crossed_date_line)) {
            normalized = (MultiPath)OperatorSimplify.local().execute(normalized, gcs, false, progress_tracker);
        }
        if (normalized != multi_path) {
            multi_path.setEmpty();
            multi_path.add(normalized, false);
        }
    }

    private boolean check_and_prep_for_pole_(AttributeStreamOfDbl path_areas, SpatialReference gcs, Envelope2D pannable_extent, Polygon polygon, ProgressTracker progress_tracker) {
        boolean b_touched_pole = this.check_and_prep_for_pole_touch_(pannable_extent, polygon);
        boolean b_wrapped_pole = this.check_and_prep_for_pole_wrap_(path_areas, gcs, pannable_extent, polygon, progress_tracker);
        return b_touched_pole || b_wrapped_pole;
    }

    boolean check_and_prep_for_pole_touch_(Envelope2D pannable_extent, Polygon polygon) {
        boolean b_touches_pole;
        Envelope2D env = new Envelope2D();
        polygon.queryEnvelope2D(env);
        boolean b_touches_north = PeMacros.PE_EQ((double)pannable_extent.ymax, (double)env.ymax);
        boolean b_touches_south = PeMacros.PE_EQ((double)pannable_extent.ymin, (double)env.ymin);
        boolean bl = b_touches_pole = b_touches_north || b_touches_south;
        if (!b_touches_pole) {
            return false;
        }
        this.prep_pole_touch_(pannable_extent, polygon);
        return b_touches_pole;
    }

    private boolean check_and_prep_for_pole_wrap_(AttributeStreamOfDbl path_areas, SpatialReference gcs, Envelope2D pannable_extent, Polygon polygon, ProgressTracker progress_tracker) {
        ArrayList<Polygon> pole_wrappers = new ArrayList<Polygon>(0);
        AttributeStreamOfInt32 pole_wrapper_indices = new AttributeStreamOfInt32(0);
        double pannable_180 = 0.5 * pannable_extent.getWidth();
        Point2D start = new Point2D();
        Point2D end = new Point2D();
        for (int ipath = 0; ipath < polygon.getPathCount(); ++ipath) {
            double area;
            boolean b_hole;
            polygon.getXY(polygon.getPathStart(ipath), start);
            polygon.getXY(polygon.getPathEnd(ipath) - 1, end);
            boolean bl = b_hole = path_areas.get(ipath) < 0.0;
            if (Math.abs(start.x - end.x) > pannable_180) {
                Polygon pole_wrapper = this.prep_single_pole_wrap_(b_hole, gcs, pannable_extent, ipath, polygon, progress_tracker);
                pole_wrappers.add(pole_wrapper);
                pole_wrapper_indices.add(ipath);
                continue;
            }
            if (b_hole || !((area = polygon.calculateRingArea2D(ipath)) < 0.0)) continue;
            Polygon pole_wrapper = this.prep_double_pole_wrap_(gcs, pannable_extent, ipath, polygon, progress_tracker);
            pole_wrappers.add(pole_wrapper);
            pole_wrapper_indices.add(ipath);
        }
        if (pole_wrappers.size() == 0) {
            return false;
        }
        Polygon pole_wrapper = new Polygon(polygon.getDescription());
        int j = 0;
        int next_pole_wrap_index = pole_wrapper_indices.get(j);
        for (int i = 0; i < polygon.getPathCount(); ++i) {
            if (i == next_pole_wrap_index) {
                pole_wrapper.add((MultiPath)pole_wrappers.get(j), false);
                if (++j >= pole_wrapper_indices.size()) continue;
                next_pole_wrap_index = pole_wrapper_indices.get(j);
                continue;
            }
            pole_wrapper.addPath(polygon, i, true);
        }
        polygon.setEmpty();
        polygon.add(pole_wrapper, false);
        return true;
    }

    private void prep_pole_touch_(Envelope2D pannable_extent, Polygon polygon) {
        Polygon polygon_pole_touch = new Polygon();
        Point2D pt = new Point2D();
        Point2D pt_k = new Point2D();
        Point2D pole_pt = new Point2D();
        Point2D pt_k_next = new Point2D();
        Envelope2D path_env = new Envelope2D();
        for (int ipath = 0; ipath < polygon.getPathCount(); ++ipath) {
            int k_next;
            boolean b_touches_pole;
            polygon.queryPathEnvelope2D(ipath, path_env);
            boolean b_touches_north = PeMacros.PE_EQ((double)pannable_extent.ymax, (double)path_env.ymax);
            boolean b_touches_south = PeMacros.PE_EQ((double)pannable_extent.ymin, (double)path_env.ymin);
            boolean bl = b_touches_pole = b_touches_north || b_touches_south;
            if (!b_touches_pole) {
                polygon_pole_touch.addPath(polygon, ipath, true);
                continue;
            }
            polygon_pole_touch.insertPath(-1, null, 0, 0, true);
            int istart = polygon.getPathStart(ipath);
            int iend = polygon.getPathEnd(ipath);
            int n = iend - istart;
            int i = -1;
            for (i = istart; i < iend; ++i) {
                polygon.getXY(i, pt);
                b_touches_north = PeMacros.PE_EQ((double)pannable_extent.ymax, (double)pt.y);
                b_touches_south = PeMacros.PE_EQ((double)pannable_extent.ymin, (double)pt.y);
                if (!b_touches_north && !b_touches_south) break;
            }
            assert (i != iend);
            int k = i;
            boolean b_prev_touches_pole = false;
            double last_longitude = NumberUtils.NaN();
            do {
                polygon.getXY(k, pt_k);
                b_touches_north = PeMacros.PE_EQ((double)pannable_extent.ymax, (double)pt_k.y);
                b_touches_south = PeMacros.PE_EQ((double)pannable_extent.ymin, (double)pt_k.y);
                k_next = istart + (k + 1 - istart) % n;
                if (!b_touches_north && !b_touches_south) {
                    polygon_pole_touch.insertPoint(ipath, -1, pt_k);
                    last_longitude = pt_k.x;
                    b_prev_touches_pole = false;
                    continue;
                }
                pole_pt.setCoords(last_longitude, pt_k.y);
                polygon_pole_touch.insertPoint(ipath, -1, pole_pt);
                polygon.getXY(k_next, pt_k_next);
                boolean b_next_touches_north = PeMacros.PE_EQ((double)pannable_extent.ymax, (double)pt_k_next.y);
                boolean b_next_touches_south = PeMacros.PE_EQ((double)pannable_extent.ymin, (double)pt_k_next.y);
                if (!b_next_touches_north && !b_next_touches_south) {
                    pole_pt = new Point2D(pt_k_next.x, pt_k.y);
                    if (!b_prev_touches_pole) {
                        polygon_pole_touch.insertPoint(ipath, -1, pole_pt);
                    } else {
                        polygon_pole_touch.setXY(polygon_pole_touch.getPointCount() - 1, pole_pt);
                    }
                }
                b_prev_touches_pole = true;
            } while ((k = k_next) != i);
        }
        polygon.setEmpty();
        polygon.add(polygon_pole_touch, false);
    }

    private Polygon prep_single_pole_wrap_(boolean b_hole, SpatialReference gcs, Envelope2D pannable_extent, int ipath, Polygon polygon, ProgressTracker progress_tracker) {
        double pole;
        double repeat_shift;
        Polygon polygon_duplicated = new Polygon();
        Polygon polygon_shifted = new Polygon();
        Transformation2D transform = new Transformation2D();
        Point2D start = new Point2D();
        polygon.getXY(polygon.getPathStart(ipath), start);
        Point2D end = new Point2D();
        polygon.getXY(polygon.getPathEnd(ipath) - 1, end);
        double pannable_360 = pannable_extent.getWidth();
        double pannable_180 = 0.5 * pannable_360;
        Envelope2D polygon_env = new Envelope2D();
        polygon.queryEnvelope2D(polygon_env);
        int num_repeats = (int)Math.ceil(polygon_env.getWidth() / pannable_360) + 1;
        if (start.x > end.x) {
            repeat_shift = -pannable_360;
            pole = b_hole ? pannable_extent.ymin : pannable_extent.ymax;
        } else {
            repeat_shift = pannable_360;
            pole = b_hole ? pannable_extent.ymax : pannable_extent.ymin;
        }
        transform.setShift(repeat_shift, 0.0);
        polygon_duplicated.addPath(polygon, ipath, true);
        polygon_shifted.add(polygon_duplicated, false);
        Point connecting_point = new Point();
        for (int i = 0; i < num_repeats; ++i) {
            polygon_shifted.applyTransformation(transform);
            polygon_shifted.getPointByVal(0, connecting_point);
            polygon_duplicated.lineTo(connecting_point);
            polygon_duplicated.addSegmentsFromPath(polygon_shifted, 0, 0, polygon_shifted.getSegmentCount() - 1, false);
        }
        Point2D start_duplicated = new Point2D();
        Point2D end_duplicated = new Point2D();
        polygon_duplicated.getXY(0, start_duplicated);
        polygon_duplicated.getXY(polygon_duplicated.getPointCount() - 1, end_duplicated);
        start_duplicated.y = pole;
        end_duplicated.y = pole;
        polygon_duplicated.lineTo(end_duplicated);
        Point2D pt = new Point2D();
        pt.setCoords(end_duplicated);
        pt.x -= 0.5 * repeat_shift;
        while (Math.abs(pt.x - start_duplicated.x) > pannable_180) {
            polygon_duplicated.lineTo(pt);
            pt.x -= 0.5 * repeat_shift;
        }
        polygon_duplicated.lineTo(start_duplicated);
        double central_longitude = pannable_extent.getCenter().x;
        Envelope2D polygon_duplicated_env = new Envelope2D();
        polygon_duplicated.queryEnvelope2D(polygon_duplicated_env);
        double shift_factor = 0.0;
        double center = polygon_duplicated_env.getCenter().x;
        if (center - central_longitude > pannable_180) {
            shift_factor = -Math.ceil((center - central_longitude - pannable_180) / pannable_360);
        } else if (central_longitude - center > pannable_180) {
            shift_factor = Math.ceil((central_longitude - center - pannable_180) / pannable_360);
        }
        if (shift_factor != 0.0) {
            transform.setShift(shift_factor * pannable_360, 0.0);
            polygon_duplicated.applyTransformation(transform);
        }
        EditShape shape = new EditShape();
        int geometry = shape.addGeometry(polygon_duplicated);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)gcs, 0.0, 2, true, pannable_extent.xmin);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)gcs, 0.0, 2, true, pannable_extent.xmax);
        Polygon poly = (Polygon)shape.getGeometry(geometry);
        Envelope2D common_extent = InternalUtils.getMergedExtent(poly, pannable_extent);
        common_extent.inflate(0.0, 1.0);
        double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, common_extent, true);
        Polygon polygon_clipped = (Polygon)Clipper.clip(poly, pannable_extent, tolerance, NumberUtils.NaN(), progress_tracker);
        return polygon_clipped;
    }

    private Polygon prep_double_pole_wrap_(SpatialReference gcs, Envelope2D pannable_extent, int ipath, Polygon polygon, ProgressTracker progress_tracker) {
        boolean b_straddles_date_line;
        double pannable_360 = pannable_extent.getWidth();
        double pannable_180 = 0.5 * pannable_360;
        double central_longitude = pannable_extent.getCenter().x;
        Envelope2D path_envelope = new Envelope2D();
        polygon.queryPathEnvelope2D(ipath, path_envelope);
        double shift_factor = 0.0;
        double center = path_envelope.getCenter().x;
        if (center - central_longitude > pannable_180) {
            shift_factor = -Math.ceil((center - central_longitude - pannable_180) / pannable_360);
        } else if (central_longitude - center > pannable_180) {
            shift_factor = Math.ceil((central_longitude - center - pannable_180) / pannable_360);
        }
        if (shift_factor != 0.0) {
            Transformation2D transform = new Transformation2D();
            transform.setShift(shift_factor * pannable_360, 0.0);
            ((MultiPathImpl)polygon._getImpl()).applyTransformation(transform, ipath);
            polygon.queryPathEnvelope2D(ipath, path_envelope);
            center = path_envelope.getCenter().x;
        }
        Envelope2D full_world = new Envelope2D();
        if (pannable_extent.containsExclusive(path_envelope)) {
            b_straddles_date_line = false;
            full_world.setCoords(pannable_extent);
        } else {
            b_straddles_date_line = true;
            full_world.setCoords(pannable_extent);
            full_world.xmin -= pannable_360;
            full_world.xmax += pannable_360;
        }
        Polygon pole_wrapper = (Polygon)polygon.createInstance();
        pole_wrapper.addPath((Point2D[])null, 0, true);
        Point2D point = new Point2D();
        point.setCoords(full_world.xmin, full_world.ymin);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(full_world.xmin, full_world.ymax);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(0.5 * (full_world.xmin + full_world.xmax), full_world.ymax);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(full_world.xmax, full_world.ymax);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(full_world.xmax, full_world.ymin);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(0.5 * (full_world.xmin + full_world.xmax), full_world.ymin);
        pole_wrapper.insertPoint(0, -1, point);
        if (!b_straddles_date_line) {
            pole_wrapper.addPath(polygon, ipath, true);
        } else {
            pole_wrapper.addPath(polygon, ipath, true);
            Transformation2D transform = new Transformation2D();
            if (center < central_longitude) {
                transform.setShift(pannable_360, 0.0);
            } else {
                transform.setShift(-pannable_360, 0.0);
            }
            ((MultiPathImpl)polygon._getImpl()).applyTransformation(transform, ipath);
            pole_wrapper.addPath(polygon, ipath, true);
            EditShape shape = new EditShape();
            int geometry = shape.addGeometry(pole_wrapper);
            ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)gcs, 0.0, 2, true, pannable_extent.xmin);
            ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)gcs, 0.0, 2, true, pannable_extent.xmax);
            pole_wrapper = (Polygon)shape.getGeometry(geometry);
            Envelope2D common_extent = InternalUtils.getMergedExtent(pole_wrapper, pannable_extent);
            common_extent.inflate(0.0, 1.0);
            double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, common_extent, true);
            pole_wrapper = (Polygon)Clipper.clip(pole_wrapper, pannable_extent, tolerance, NumberUtils.NaN(), progress_tracker);
        }
        return pole_wrapper;
    }

    private MultiPath fold_parts_into_360_(SpatialReference gcs, Envelope2D pannable_extent, MultiPath multi_path, ProgressTracker progress_tracker) {
        Envelope2D env = new Envelope2D();
        multi_path.queryEnvelope2D(env);
        double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, multi_path, true);
        if (pannable_extent.xmin - env.xmin <= tolerance && env.xmax - pannable_extent.xmax <= tolerance) {
            return multi_path;
        }
        MultiPath centered_multi_path = (MultiPath)multi_path.createInstance();
        MultiPath path = (MultiPath)multi_path.createInstance();
        Envelope2D path_envelope = new Envelope2D();
        int path_count = multi_path.getPathCount();
        for (int i = 0; i < path_count; ++i) {
            multi_path.queryPathEnvelope2D(i, path_envelope);
            if (pannable_extent.xmin - path_envelope.xmin <= tolerance && path_envelope.xmax - pannable_extent.xmax <= tolerance) {
                centered_multi_path.addPath(multi_path, i, true);
                continue;
            }
            path.setEmpty();
            path.addPath(multi_path, i, true);
            path = Gnomonic.fold_into_360_no_union(gcs, pannable_extent, path, true, progress_tracker);
            centered_multi_path.add(path, true);
        }
        return centered_multi_path;
    }

    static MultiPath fold_into_360_no_union(SpatialReference gcs, Envelope2D pannable_extent, MultiPath multi_path, boolean b_can_modify_input, ProgressTracker progress_tracker) {
        MultiPath m;
        Envelope2D multi_path_env = new Envelope2D();
        multi_path.queryEnvelope2D(multi_path_env);
        double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, multi_path, true);
        if (pannable_extent.xmin - multi_path_env.xmin <= tolerance && multi_path_env.xmax - pannable_extent.xmax <= tolerance) {
            return multi_path;
        }
        double pannable_360 = pannable_extent.getWidth();
        int shift_factor = 0;
        while (pannable_extent.xmin + (double)shift_factor * pannable_360 < multi_path_env.xmin) {
            ++shift_factor;
        }
        while (pannable_extent.xmin + (double)shift_factor * pannable_360 > multi_path_env.xmin) {
            --shift_factor;
        }
        double shift = (double)shift_factor * pannable_360;
        Transformation2D transform = new Transformation2D();
        transform.setShift(-shift, 0.0);
        if (b_can_modify_input) {
            m = multi_path;
        } else {
            m = (MultiPath)multi_path.createInstance();
            multi_path.copyTo(m);
        }
        m.applyTransformation(transform);
        Envelope2D m_env = new Envelope2D();
        m.queryEnvelope2D(m_env);
        MultiPath poly = null;
        if (m_env.xmax > pannable_extent.xmax) {
            int s = 0;
            Envelope2D clipper = new Envelope2D();
            clipper.setCoords(pannable_extent);
            clipper.ymin -= 1.0;
            clipper.ymax += 1.0;
            MultiPath poly_inserted_180 = m;
            while (clipper.xmin < m_env.xmax) {
                if (m_env.xmax > clipper.xmax) {
                    poly_inserted_180 = ProjectionUtils.insertGeodeticPoints(poly_inserted_180, (SpatialReferenceImpl)gcs, 2, true, clipper.xmax);
                }
                Envelope2D common_extent = InternalUtils.getMergedExtent(poly_inserted_180, clipper);
                double clipping_tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, common_extent, true);
                MultiPath clipped = (MultiPath)Clipper.clip(poly_inserted_180, clipper, clipping_tolerance, NumberUtils.NaN(), progress_tracker);
                if (poly == null) {
                    if (clipped == poly_inserted_180) {
                        poly = (Polygon)clipped.createInstance();
                        clipped.copyTo(poly);
                    } else {
                        poly = clipped;
                    }
                } else {
                    transform.setShift((double)(-s) * pannable_360, 0.0);
                    clipped.applyTransformation(transform);
                    poly.add(clipped, false);
                }
                clipper.xmin = clipper.xmax;
                clipper.xmax = pannable_extent.xmax + (double)(++s) * pannable_360;
            }
        } else {
            poly = m;
        }
        return poly;
    }
}

