/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GeometryCollection
extends Geometry
implements Serializable,
Iterable<Geometry> {
    private static final long serialVersionUID = 1L;
    private VertexDescription m_description;
    private ArrayList<Geometry> m_geoms;
    private static final ArrayList<Geometry> EMPTY_LIST = new ArrayList();

    public GeometryCollection() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
    }

    public GeometryCollection(VertexDescription descr) {
        this.m_description = descr;
    }

    public GeometryCollection(Geometry other) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.addGeometry(other);
    }

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.GeometryCollection;
    }

    @Override
    public VertexDescription getDescription() {
        return this.m_description;
    }

    @Override
    public void assignVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        this._assignVertexDescriptionImpl(src);
    }

    private void _assignVertexDescriptionImpl(VertexDescription src) {
        for (Geometry g : GeometryCollection.safe(this.m_geoms)) {
            g.assignVertexDescription(src);
        }
        this.m_description = src;
    }

    @Override
    public void mergeVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        if (this.m_description.hasAttributesFrom(src)) {
            return;
        }
        this._mergeVertexDescriptionImpl(src);
    }

    @Override
    public boolean hasAttribute(int semantics) {
        return this.m_description.hasAttribute(semantics);
    }

    @Override
    public void addAttribute(int semantics) {
        if (this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.getMergedVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    public void dropAttribute(int semantics) {
        if (!this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.removeSemanticsFromVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    public void dropAllAttributes() {
        VertexDescription newvd = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        if (newvd == this.m_description) {
            return;
        }
        this.assignVertexDescription(newvd);
    }

    @Override
    public boolean isEmpty() {
        return this.m_geoms == null || this.m_geoms.size() == 0;
    }

    @Override
    public double calculateArea2D() {
        if (this.m_geoms == null) {
            return 0.0;
        }
        MathUtils.KahanSummator area = new MathUtils.KahanSummator(0.0);
        for (Geometry g : this.m_geoms) {
            area.add(g.calculateArea2D());
        }
        return area.getResult();
    }

    @Override
    public double calculateLength2D() {
        if (this.m_geoms == null) {
            return 0.0;
        }
        MathUtils.KahanSummator len = new MathUtils.KahanSummator(0.0);
        for (Geometry g : this.m_geoms) {
            len.add(g.calculateLength2D());
        }
        return len.getResult();
    }

    public int getGeometryCount() {
        if (this.m_geoms != null) {
            return this.m_geoms.size();
        }
        return 0;
    }

    public void addGeometry(Geometry geom) {
        if (geom.getGeometryType() == 3594) {
            GeometryCollection gc = (GeometryCollection)geom;
            int n = gc.getGeometryCount();
            for (int i = 0; i < n; ++i) {
                this.addGeometry(gc.getGeometry(i));
            }
        } else {
            this.ensureGeoms_();
            this.m_geoms.add(Geometry._clone(geom));
            this.mergeVertexDescription(geom.getDescription());
        }
    }

    public void addGeometryByRef(Geometry geom) {
        if (geom.getGeometryType() == 3594) {
            GeometryCollection gc = (GeometryCollection)geom;
            int n = gc.getGeometryCount();
            for (int i = 0; i < n; ++i) {
                this.addGeometryByRef(gc.getGeometry(i));
            }
        } else {
            this.ensureGeoms_();
            this.m_geoms.add(geom);
            this.mergeVertexDescription(geom.getDescription());
        }
    }

    public void addCursor(GeometryCursor gc) {
        Geometry g = gc.next();
        while (g != null) {
            this.addGeometry(g);
            g = gc.next();
        }
    }

    public void modifiedElement(int index) {
        this.mergeVertexDescription(this.getGeometry(index).getDescription());
    }

    public void modifiedElement(Geometry element) {
        this.mergeVertexDescription(element.getDescription());
    }

    public Geometry getGeometry(int index) {
        if (index < 0 || index >= GeometryCollection.safe(this.m_geoms).size()) {
            throw new IllegalArgumentException("get_geometry");
        }
        return this.m_geoms.get(index);
    }

    @Override
    public int getDimension() {
        int d = 0;
        for (Geometry g : GeometryCollection.safe(this.m_geoms)) {
            d = Math.max(d, g.getDimension());
        }
        return d;
    }

    public int hashCode() {
        int hash = 1231231212;
        for (Geometry g : GeometryCollection.safe(this.m_geoms)) {
            hash = NumberUtils.hashCombine(hash, g.hashCode());
        }
        return hash;
    }

    @Override
    public void queryEnvelope(Envelope env) {
        env.setEmpty();
        if (GeometryCollection.safe(this.m_geoms).size() == 0) {
            return;
        }
        Envelope e = new Envelope(this.m_description);
        for (Geometry g : this.m_geoms) {
            g.queryEnvelope(e);
            env.merge(e);
        }
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        env.setEmpty();
        if (GeometryCollection.safe(this.m_geoms).size() == 0) {
            return;
        }
        Envelope2D e = new Envelope2D();
        for (Geometry g : this.m_geoms) {
            g.queryEnvelope2D(e);
            env.merge(e);
        }
    }

    @Override
    public void queryEnvelope3D(Envelope3D env) {
        env.setEmpty();
        if (GeometryCollection.safe(this.m_geoms).size() == 0) {
            return;
        }
        Envelope3D e = new Envelope3D();
        for (Geometry g : this.m_geoms) {
            g.queryEnvelope3D(e);
            env.merge(e);
        }
    }

    @Override
    public void queryLooseEnvelope2D(Envelope2D env) {
        env.setEmpty();
        if (GeometryCollection.safe(this.m_geoms).size() == 0) {
            return;
        }
        Envelope2D e = new Envelope2D();
        for (Geometry g : this.m_geoms) {
            g.queryLooseEnvelope2D(e);
            env.merge(e);
        }
    }

    @Override
    public void queryLooseEnvelope3D(Envelope3D env) {
        env.setEmpty();
        if (GeometryCollection.safe(this.m_geoms).size() == 0) {
            return;
        }
        Envelope3D e = new Envelope3D();
        for (Geometry g : this.m_geoms) {
            g.queryLooseEnvelope3D(e);
            env.merge(e);
        }
    }

    @Override
    public void queryInterval(int semantics, int ordinate, Envelope1D env) {
        env.setEmpty();
        if (GeometryCollection.safe(this.m_geoms).size() == 0) {
            return;
        }
        Envelope1D e = new Envelope1D();
        for (Geometry g : this.m_geoms) {
            g.queryInterval(semantics, ordinate, e);
            env.merge(e);
        }
    }

    @Override
    public void copyTo(Geometry dst) {
        if (dst.getGeometryType() != 3594) {
            throw new IllegalArgumentException();
        }
        GeometryCollection dst_col = (GeometryCollection)dst;
        if (dst_col == this) {
            return;
        }
        if (this.m_geoms != null) {
            dst_col.ensureGeoms_();
            dst_col.m_geoms.clear();
            dst_col.assignVertexDescription(this.m_description);
            dst_col.m_geoms.ensureCapacity(this.m_geoms.size());
            for (Geometry g : this.m_geoms) {
                dst_col.m_geoms.add(Geometry._clone(g));
            }
        } else {
            dst_col.m_geoms = null;
            dst_col.assignVertexDescription(this.m_description);
        }
    }

    @Override
    public void setEmpty() {
        if (this.m_geoms != null) {
            this.m_geoms.clear();
        }
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        for (Geometry g : GeometryCollection.safe(this.m_geoms)) {
            g.applyTransformation(transform);
        }
    }

    @Override
    public void applyTransformation(Transformation3D transform) {
        this.addAttribute(1);
        for (Geometry g : GeometryCollection.safe(this.m_geoms)) {
            g.applyTransformation(transform);
        }
    }

    @Override
    public Geometry getBoundary() {
        GeometryCollection gc = (GeometryCollection)this.createInstance();
        if (GeometryCollection.safe(this.m_geoms).size() > 0) {
            gc.m_geoms.ensureCapacity(this.m_geoms.size());
            for (Geometry g : this.m_geoms) {
                Geometry b = g.getBoundary();
                if (b == null) continue;
                gc.m_geoms.add(b);
            }
        }
        return gc;
    }

    @Override
    public Geometry createInstance() {
        return new GeometryCollection(this.getDescription());
    }

    @Override
    public boolean equals(Geometry other, double tol) {
        if (other == this) {
            return true;
        }
        if (other.getGeometryType() != 3594) {
            return false;
        }
        GeometryCollection otherPt = (GeometryCollection)other;
        if (this.m_description != otherPt.m_description) {
            return false;
        }
        if (this.getGeometryCount() != otherPt.getGeometryCount()) {
            return false;
        }
        int i = 0;
        for (Geometry g : GeometryCollection.safe(this.m_geoms)) {
            if (g.equals(otherPt.getGeometry(i++), tol)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void replaceNaNs(int semantics, double value) {
        for (Geometry g : GeometryCollection.safe(this.m_geoms)) {
            g.replaceNaNs(semantics, value);
        }
    }

    @Override
    public Iterator<Geometry> iterator() {
        return new GCIterator();
    }

    public static GeometryCursor generateGeometryCursor(GeometryCollection gc, int dimensionMask) {
        return new GCGeometryCursor(gc, -1, dimensionMask);
    }

    @Override
    public String toString() {
        return OGCGeometry.createFromEsriGeometry(this, null).toString();
    }

    private static ArrayList<Geometry> safe(ArrayList<Geometry> geoms) {
        return geoms != null ? geoms : EMPTY_LIST;
    }

    private void ensureGeoms_() {
        if (this.m_geoms == null) {
            this.m_geoms = new ArrayList();
        }
    }

    private class GCIterator
    implements Iterator<Geometry> {
        int m_index = 0;

        private GCIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_index < GeometryCollection.this.getGeometryCount();
        }

        @Override
        public Geometry next() {
            if (this.m_index >= GeometryCollection.this.getGeometryCount()) {
                throw new NoSuchElementException();
            }
            Geometry g = GeometryCollection.this.getGeometry(this.m_index);
            ++this.m_index;
            return g;
        }
    }

    static class GCGeometryCursor
    extends GeometryCursor {
        private GeometryCollection m_gc;
        private int m_index;
        private int m_dim;

        GCGeometryCursor(GeometryCollection gc, int ind, int d) {
            this.m_gc = gc;
            this.m_index = ind;
            this.m_dim = d;
        }

        @Override
        public Geometry next() {
            Geometry g;
            do {
                if (this.m_index >= this.m_gc.getGeometryCount()) {
                    return null;
                }
                ++this.m_index;
                if (this.m_index == this.m_gc.getGeometryCount()) {
                    return null;
                }
                g = this.m_gc.getGeometry(this.m_index);
            } while (this.m_dim != -1 && (1 << g.getDimension() & this.m_dim) == 0);
            return g;
        }

        @Override
        public int getGeometryID() {
            return this.m_index;
        }
    }
}

