/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.EnvSrlzr;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.GenericGeometrySerializer;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.LnSrlzr;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.OperatorExportToJson;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.PtSrlzr;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.ObjectStreamException;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKPublic
public abstract class Geometry
implements Serializable {
    protected Geometry() {
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public abstract Type getType();

    @HadoopSDKPublic
    public final int getGeometryType() {
        return this.getType().value();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public abstract int getDimension();

    @HadoopSDKPublic
    public abstract VertexDescription getDescription();

    @HadoopSDKPublic
    public abstract void assignVertexDescription(VertexDescription var1);

    @HadoopSDKPublic
    public abstract void mergeVertexDescription(VertexDescription var1);

    @HadoopSDKPublic
    public abstract boolean hasAttribute(int var1);

    @HadoopSDKPublic
    public abstract void addAttribute(int var1);

    @HadoopSDKPublic
    public abstract void dropAttribute(int var1);

    @HadoopSDKPublic
    public abstract void dropAllAttributes();

    @HadoopSDKPublic
    public final Envelope1D queryInterval(int semantics, int ordinate) {
        Envelope1D env = new Envelope1D();
        this.queryInterval(semantics, ordinate, env);
        return env;
    }

    @HadoopSDKPublic
    public abstract void queryInterval(int var1, int var2, Envelope1D var3);

    @AndroidSDKPublic
    @HadoopSDKPublic
    public abstract void queryEnvelope(Envelope var1);

    @HadoopSDKPublic
    public abstract void queryEnvelope2D(Envelope2D var1);

    @HadoopSDKPublic
    public abstract void queryEnvelope3D(Envelope3D var1);

    @HadoopSDKPublic
    public void queryLooseEnvelope2D(Envelope2D env) {
        this.queryEnvelope2D(env);
    }

    @HadoopSDKPublic
    public void queryLooseEnvelope3D(Envelope3D env) {
        this.queryEnvelope3D(env);
    }

    @HadoopSDKPublic
    public abstract boolean isEmpty();

    @HadoopSDKPublic
    public abstract void setEmpty();

    @HadoopSDKPublic
    public abstract void applyTransformation(Transformation2D var1);

    @HadoopSDKPublic
    public abstract void applyTransformation(Transformation3D var1);

    @HadoopSDKPublic
    public abstract Geometry createInstance();

    @HadoopSDKPublic
    public abstract void copyTo(Geometry var1);

    @HadoopSDKPublic
    public double calculateArea2D() {
        return 0.0;
    }

    @HadoopSDKPublic
    public double calculateLength2D() {
        return 0.0;
    }

    @HadoopSDKPublic
    public void addZ() {
        this.addAttribute(1);
    }

    @HadoopSDKPublic
    public boolean hasZ() {
        return this.hasAttribute(1);
    }

    @HadoopSDKPublic
    public void addM() {
        this.addAttribute(2);
    }

    @HadoopSDKPublic
    public boolean hasM() {
        return this.hasAttribute(2);
    }

    @HadoopSDKPublic
    public void addID() {
        this.addAttribute(3);
    }

    @HadoopSDKPublic
    public boolean hasID() {
        return this.hasAttribute(3);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static int getDimensionFromType(int type) {
        return ((type & 0xC0) >> 6) + 1 >> 1;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean isPoint(int type) {
        return (type & 0x20) != 0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean isLinear(int type) {
        return (type & 0x40) != 0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean isArea(int type) {
        return (type & 0x80) != 0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean isSegment(int type) {
        return (type & 0x100) != 0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean isMultiVertex(int type) {
        return (type & 0x200) != 0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean isMultiPath(int type) {
        return (type & 0x400) != 0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry copy() {
        Geometry geom = this.createInstance();
        this.copyTo(geom);
        return geom;
    }

    @HadoopSDKPublic
    public abstract Geometry getBoundary();

    @HadoopSDKPublic
    public abstract void replaceNaNs(int var1, double var2);

    static Geometry _clone(Geometry src) {
        Geometry geom = src.createInstance();
        src.copyTo(geom);
        return geom;
    }

    Object writeReplace() throws ObjectStreamException {
        Type gt = this.getType();
        if (gt == Type.Point) {
            PtSrlzr pt = new PtSrlzr();
            pt.setGeometryByValue((Point)this);
            return pt;
        }
        if (gt == Type.Envelope) {
            EnvSrlzr e = new EnvSrlzr();
            e.setGeometryByValue((Envelope)this);
            return e;
        }
        if (gt == Type.Line) {
            LnSrlzr ln = new LnSrlzr();
            ln.setGeometryByValue((Line)this);
            return ln;
        }
        GenericGeometrySerializer geomSerializer = new GenericGeometrySerializer();
        geomSerializer.setGeometryByValue(this);
        return geomSerializer;
    }

    @HadoopSDKPublic
    public String toString() {
        String snippet = OperatorExportToJson.local().execute(null, this);
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }

    @HadoopSDKPublic
    public static int vertexCount(Geometry geom) {
        Type gt = geom.getType();
        if (Geometry.isMultiVertex(gt.value())) {
            return ((MultiVertexGeometry)geom).getPointCount();
        }
        if (geom.isEmpty()) {
            return 0;
        }
        if (gt == Type.Envelope) {
            return 4;
        }
        if (gt == Type.Point) {
            return 1;
        }
        if (Geometry.isSegment(gt.value())) {
            return 2;
        }
        throw new GeometryException("missing type");
    }

    public abstract boolean equals(Geometry var1, double var2);

    public final GeometryCursor asCursor() {
        return new SimpleGeometryCursor(this);
    }

    protected final void _mergeVertexDescriptionImpl(VertexDescription src) {
        VertexDescription olddescription = this.getDescription();
        assert (src != olddescription);
        VertexDescription description = VertexDescriptionDesignerImpl.getMergedVertexDescription(olddescription, src);
        this.assignVertexDescription(description);
    }

    protected Object _getImpl() {
        throw new RuntimeException("invalid call");
    }

    @HadoopSDKPublic
    public static enum GeometryAccelerationDegree {
        enumMild,
        enumMedium,
        enumHot;

    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static enum Type {
        Unknown(0),
        Point(33),
        Line(322),
        Envelope(197),
        MultiPoint(550),
        Polyline(1607),
        Polygon(1736),
        GeometryCollection(3594);

        private int enumValue;

        @AndroidSDKPublic
        @HadoopSDKPublic
        public int value() {
            return this.enumValue;
        }

        private Type(int val) {
            this.enumValue = val;
        }

        @HadoopSDKPublic
        public static Type intToType(int geometryType) {
            Type[] v = Type.values();
            for (int i = 0; i < v.length; ++i) {
                if (v[i].value() != geometryType) continue;
                return v[i];
            }
            throw new IllegalArgumentException();
        }
    }

    @HadoopSDKPublic
    public static interface GeometryType {
        @HadoopSDKPublic
        public static final int Unknown = 0;
        @HadoopSDKPublic
        public static final int Point = 33;
        @HadoopSDKPublic
        public static final int Line = 322;
        public static final int Bezier = 323;
        public static final int EllipticArc = 324;
        @HadoopSDKPublic
        public static final int Envelope = 197;
        @HadoopSDKPublic
        public static final int MultiPoint = 550;
        @HadoopSDKPublic
        public static final int Polyline = 1607;
        @HadoopSDKPublic
        public static final int Polygon = 1736;
        @HadoopSDKPublic
        public static final int GeometryCollection = 3594;
    }
}

