/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.SpatialReference;

@HadoopSDKExcluded
public final class Geohash {
    private static final char[] st_codes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static String toGeohash(SpatialReference sr, Point2D point_, int length) {
        if (length < 0) {
            length = 8;
        }
        Point2D point = new Point2D();
        point.setCoords(point_);
        point.scale(sr.getGCS().getUnit().getID() == 9102 ? 1.0 : sr.getGCS().getUnit().getUnitToBaseFactor() / Math.PI * 180.0);
        if (point.x < -180.0) {
            point.x = MathUtils.FMod(point.x, 360.0);
            if (point.x < -180.0) {
                point.x += 360.0;
            }
        } else if (point.x > 180.0) {
            point.x = MathUtils.FMod(point.x, 360.0);
            if (point.x > 180.0) {
                point.x -= 360.0;
            }
        }
        if (point.y > 90.0) {
            point.y = 90.0;
        }
        if (point.y < -90.0) {
            point.y = -90.0;
        }
        int[] bits32 = new int[4];
        int precision_bits = length * 5;
        Geohash.coordToBits(point.x, -180.0, 180.0, precision_bits - 1, bits32);
        Geohash.coordToBits(point.y, -90.0, 90.0, precision_bits - 2, bits32);
        StringBuilder hash = new StringBuilder();
        Geohash.encodeBase32_(bits32, length, length, hash);
        return hash.toString();
    }

    private static void coordToBits(double v, double minV_, double maxV_, int start_bit, int[] bits32InOut) {
        double minV = minV_;
        double maxV = maxV_;
        for (int ibit = start_bit; ibit >= 0; ibit -= 2) {
            int bit = ibit & 0x1F;
            int half = ibit >>> 5;
            double m = (maxV + minV) * 0.5;
            if (v >= m) {
                int n = half;
                bits32InOut[n] = bits32InOut[n] | 1 << bit;
                minV = m;
                continue;
            }
            maxV = m;
        }
    }

    private static void encodeBase32_(int[] bits, int originalLength, int newLength, StringBuilder hash) {
        int i;
        hash.setLength(0);
        hash.setLength(originalLength);
        int half = 0;
        int len = 0;
        for (i = 0; i < originalLength; ++i) {
            int v = bits[half] >>> len & 0x1F;
            if ((len += 5) > 31) {
                int extra_bits = 37 - len;
                v &= (1 << extra_bits) - 1;
                v |= (bits[++half] & (1 << (len -= 32)) - 1) << extra_bits;
            }
            assert (v >= 0 && v < 32);
            char ch = st_codes[v];
            hash.setCharAt(originalLength - 1 - i, ch);
        }
        if (newLength > originalLength) {
            int n = newLength - originalLength;
            for (i = 0; i < n; ++i) {
                hash.append('0');
            }
        } else if (newLength < originalLength) {
            hash.setLength(newLength);
        }
    }
}

