/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeographicTransformation;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.PeInitializer;
import com.esri.sde.sdk.pe.engine.PeGeogtran;
import com.esri.sde.sdk.pe.engine.PeParameter;
import com.esri.sde.sdk.pe.engine.PeProjectionException;
import com.esri.sde.sdk.pe.factory.PeFactory;

@HadoopSDKExcluded
final class GeographicTransformationImpl
extends GeographicTransformation {
    private static final long serialVersionUID = 1L;
    private GeogtranWrapper m_geogTranWrapper;
    private int m_hashCode;

    GeographicTransformationImpl() {
        this.m_bInverted = false;
        this.m_hashCode = 0;
    }

    GeographicTransformationImpl(PeGeogtran geogTran) {
        this.m_geogTranWrapper = new GeogtranWrapper(geogTran);
        this.m_bInverted = false;
        this.m_hashCode = this.getText().hashCode();
    }

    @Override
    public int getID() {
        return this.m_geogTranWrapper != null ? this.m_geogTranWrapper.m_wkid : 0;
    }

    @Override
    public GeographicTransformation copy() {
        GeographicTransformationImpl c = new GeographicTransformationImpl();
        this.copyTo(c);
        return c;
    }

    @Override
    public void copyTo(GeographicTransformation dst) {
        GeographicTransformationImpl p = (GeographicTransformationImpl)dst;
        p.m_geogTranWrapper = this.m_geogTranWrapper;
        p.m_bInverted = this.m_bInverted;
    }

    @Override
    public GeographicTransformation getInverse() {
        GeographicTransformationImpl c = (GeographicTransformationImpl)this.copy();
        c.invert();
        return c;
    }

    public void invert() {
        this.m_bInverted = !this.m_bInverted;
    }

    public PeGeogtran getPeGeogtran() {
        return this.m_geogTranWrapper != null ? this.m_geogTranWrapper.m_geogTran : null;
    }

    public void setID(int id) {
        if (id <= 0) {
            throw new IllegalArgumentException();
        }
        if (id == this.getID()) {
            return;
        }
        PeInitializer.touch();
        PeGeogtran geogTran = PeFactory.geogtran((int)id);
        if (geogTran == null) {
            throw new IllegalArgumentException();
        }
        this.m_geogTranWrapper = new GeogtranWrapper(geogTran);
        this.m_hashCode = this.getText().hashCode();
    }

    @Override
    public String getText() {
        if (this.m_geogTranWrapper == null) {
            return null;
        }
        return this.m_geogTranWrapper.m_geogTran.toString();
    }

    @Override
    public boolean referencesMissingData() {
        if (this.m_geogTranWrapper == null) {
            return false;
        }
        return !this.m_geogTranWrapper.isUsable();
    }

    @Override
    public String getGridName() {
        if (this.m_geogTranWrapper == null || this.m_geogTranWrapper.m_geogTran == null) {
            return "";
        }
        PeParameter[] params = this.m_geogTranWrapper.m_geogTran.getParameters();
        if (params[15] == null) {
            return "";
        }
        String buf = params[15].getName();
        if (buf.startsWith("Dataset_")) {
            return buf.substring(8);
        }
        return buf;
    }

    @Override
    public String getName() {
        if (this.m_geogTranWrapper == null || this.m_geogTranWrapper.m_geogTran == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (this.isInverted()) {
            result.append('~');
        }
        result.append(this.m_geogTranWrapper.m_geogTran.getName());
        return result.toString();
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        PeInitializer.touch();
        PeGeogtran geogTran = null;
        try {
            geogTran = PeGeogtran.fromString((String)text);
        }
        catch (PeProjectionException ex) {
            throw new IllegalArgumentException();
        }
        this.m_geogTranWrapper = new GeogtranWrapper(geogTran);
        this.m_hashCode = this.getText().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GeographicTransformationImpl o = (GeographicTransformationImpl)other;
        if (!(this.getID() > 0 && this.getID() == o.getID() || this.getPeGeogtran().isEqual(o.getPeGeogtran()))) {
            return false;
        }
        return this.m_bInverted == o.m_bInverted;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        String snippet = this.toString();
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }

    public static class GeogtranWrapper {
        public int m_wkid;
        PeGeogtran m_geogTran;
        volatile int usable;

        public GeogtranWrapper(PeGeogtran geogTran) {
            this.m_geogTran = geogTran;
            this.m_wkid = this.m_geogTran.getCode();
            if (this.m_wkid < 0) {
                this.m_wkid = 0;
            }
            this.usable = -1;
        }

        boolean isUsable() {
            int i = this.usable;
            if (i != -1) {
                return i != 0;
            }
            i = this.m_geogTran == null ? 1 : (this.m_geogTran.loadConstants() ? 1 : 0);
            this.usable = i;
            return i != 0;
        }
    }
}

