/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.CompositeGeographicTransformation;
import com.esri.core.geometry.GeogTranDefaults;
import com.esri.core.geometry.GeographicTransformation;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.ObjectCacheTable;
import java.util.concurrent.locks.ReentrantLock;

@HadoopSDKExcluded
class GeogTranQuickIDCache {
    private static final ReentrantLock m_lock = new ReentrantLock();
    private static final GeogTranQuickIDCache st_instance = new GeogTranQuickIDCache();
    private final ObjectCacheTable<GeogTransformKey, GeogTransformDescriptor> m_cache = new ObjectCacheTable(64);

    private static GeogTranQuickIDCache getInstance() {
        return st_instance;
    }

    private void add_(int GCS_1, int GCS_2, int geog_tran_ID_1, int b_inv_1_, int geog_tran_ID_2, int b_inv_2_) {
        boolean b_inv_2;
        boolean b_inv_1 = b_inv_1_ != 0;
        boolean bl = b_inv_2 = b_inv_2_ != 0;
        if (GCS_1 > GCS_2) {
            int temp;
            if (geog_tran_ID_2 != 0) {
                temp = geog_tran_ID_1;
                geog_tran_ID_1 = geog_tran_ID_2;
                geog_tran_ID_2 = temp;
                boolean b = b_inv_1;
                b_inv_1 = !b_inv_2;
                b_inv_2 = !b;
            } else {
                b_inv_1 = !b_inv_1;
            }
            temp = GCS_1;
            GCS_1 = GCS_2;
            GCS_2 = temp;
        }
        GeogTransformKey key = new GeogTransformKey(GCS_1, GCS_2);
        GeogTransformDescriptor descriptor = new GeogTransformDescriptor(geog_tran_ID_1, b_inv_1, geog_tran_ID_2, b_inv_2);
        this.m_cache.add(key, descriptor);
    }

    GeogTranQuickIDCache() {
        if (!GeogTranDefaults.hasGTDefaults()) {
            this.addSpecialGTsToCache_();
        }
    }

    private void addSpecialGTsToCache_() {
        this.add_(4326, 4269, 108190, 0, 0, 0);
        this.add_(4326, 4267, 1172, 1, 0, 0);
        this.add_(4326, 4230, 1133, 1, 0, 0);
        this.add_(4326, 4258, 1149, 1, 0, 0);
        this.add_(4326, 4284, 15865, 1, 0, 0);
        this.add_(4326, 4490, 0, 0, 0, 0);
        this.add_(4269, 4267, 1188, 0, 1172, 1);
        this.add_(4269, 4203, 0, 0, 0, 0);
        this.add_(4269, 4230, 0, 0, 0, 0);
        this.add_(4269, 4258, 0, 0, 0, 0);
        this.add_(4269, 4314, 0, 0, 0, 0);
        this.add_(4269, 4284, 108190, 1, 15865, 1);
        this.add_(4269, 4490, 0, 0, 0, 0);
        this.add_(4267, 4203, 0, 0, 0, 0);
        this.add_(4267, 4230, 0, 0, 0, 0);
        this.add_(4267, 4258, 0, 0, 0, 0);
        this.add_(4267, 4314, 0, 0, 0, 0);
        this.add_(4267, 4490, 0, 0, 0, 0);
        this.add_(4203, 4230, 0, 0, 0, 0);
        this.add_(4203, 4258, 0, 0, 0, 0);
        this.add_(4203, 4314, 0, 0, 0, 0);
        this.add_(4203, 4284, 0, 0, 0, 0);
        this.add_(4203, 4490, 0, 0, 0, 0);
        this.add_(4230, 4258, 1133, 0, 1149, 1);
        this.add_(4230, 4284, 1133, 0, 15865, 1);
        this.add_(4230, 4490, 0, 0, 0, 0);
        this.add_(4258, 4284, 1149, 0, 15865, 1);
        this.add_(4258, 4490, 0, 0, 0, 0);
        this.add_(4314, 4284, 1778, 0, 1310, 1);
        this.add_(4314, 4490, 0, 0, 0, 0);
        this.add_(4284, 4490, 0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompositeGeographicTransformation Lookup(int GCS_ID_1, int GCS_ID_2) {
        GeogTransformDescriptor descriptor;
        boolean b_inv = false;
        if (GCS_ID_1 > GCS_ID_2) {
            int temp = GCS_ID_1;
            GCS_ID_1 = GCS_ID_2;
            GCS_ID_2 = temp;
            b_inv = true;
        }
        GeogTransformKey key = new GeogTransformKey(GCS_ID_1, GCS_ID_2);
        try {
            m_lock.lock();
            descriptor = GeogTranQuickIDCache.getInstance().m_cache.get(key);
        }
        finally {
            m_lock.unlock();
        }
        if (descriptor == null) {
            return null;
        }
        return GeogTranDefaults.createCompositeGeoTransform(descriptor.m_geog_tran_ID_1, descriptor.m_inv_1, descriptor.m_geog_tran_ID_2, descriptor.m_inv_2, b_inv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void Register(int GCS_ID_1, int GCS_ID_2, CompositeGeographicTransformation cgt) {
        if (cgt != null && cgt.count() > 2) {
            return;
        }
        int geog_tran_ID_1 = 0;
        boolean b_inv_1 = false;
        int geog_tran_ID_2 = 0;
        boolean b_inv_2 = false;
        if (cgt.count() > 0) {
            GeographicTransformation GT_1 = cgt.getGeogTran(0);
            geog_tran_ID_1 = GT_1.getID();
            b_inv_1 = GT_1.isInverted();
            if (cgt.count() == 2) {
                GeographicTransformation GT_2 = cgt.getGeogTran(1);
                geog_tran_ID_2 = GT_2.getID();
                b_inv_2 = GT_2.isInverted();
            }
        }
        if (GCS_ID_1 > GCS_ID_2) {
            if (geog_tran_ID_2 != 0) {
                int temp = geog_tran_ID_1;
                geog_tran_ID_1 = geog_tran_ID_2;
                geog_tran_ID_2 = temp;
                boolean b = b_inv_1;
                b_inv_1 = !b_inv_2;
                b_inv_2 = !b;
            } else {
                b_inv_1 = !b_inv_1;
            }
            int temp = GCS_ID_1;
            GCS_ID_1 = GCS_ID_2;
            GCS_ID_2 = temp;
        }
        GeogTransformKey key = new GeogTransformKey(GCS_ID_1, GCS_ID_2);
        try {
            m_lock.lock();
            GeogTransformDescriptor descriptor = GeogTranQuickIDCache.st_instance.m_cache.get(key);
            if (descriptor == null) {
                descriptor = new GeogTransformDescriptor(geog_tran_ID_1, b_inv_1, geog_tran_ID_2, b_inv_2);
                GeogTranQuickIDCache.getInstance().m_cache.add(key, descriptor);
            }
        }
        finally {
            m_lock.unlock();
        }
    }

    private static final class GeogTransformDescriptor {
        int m_geog_tran_ID_1;
        int m_geog_tran_ID_2;
        boolean m_inv_1;
        boolean m_inv_2;

        GeogTransformDescriptor(int geog_tran_ID_1, boolean inv_1, int geog_tran_ID_2, boolean inv_2) {
            this.m_geog_tran_ID_1 = geog_tran_ID_1;
            this.m_inv_1 = inv_1;
            this.m_geog_tran_ID_2 = geog_tran_ID_2;
            this.m_inv_2 = inv_2;
        }
    }

    private static final class GeogTransformKey {
        private final int m_GCS_1;
        private final int m_GCS_2;
        private int m_hash_code;

        GeogTransformKey(int GCS_1, int GCS_2) {
            assert (GCS_1 < GCS_2);
            this.m_GCS_1 = GCS_1;
            this.m_GCS_2 = GCS_2;
            this.m_hash_code = NumberUtils.hash(GCS_1);
            this.m_hash_code = NumberUtils.hash(this.m_hash_code, GCS_2);
        }

        public int hashCode() {
            return this.m_hash_code;
        }

        public boolean equals(Object other) {
            return this.m_GCS_1 == ((GeogTransformKey)other).m_GCS_1 && this.m_GCS_2 == ((GeogTransformKey)other).m_GCS_2;
        }
    }
}

