/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.sde.sdk.pe.engine.PeCSTransformations;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeDouble;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLineType;
import com.esri.sde.sdk.pe.engine.PeMacros;
import com.esri.sde.sdk.pe.engine.PeMath;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import java.util.ArrayList;
import java.util.Collections;

@HadoopSDKExcluded
final class GeodeticDensify {
    private SpatialReference m_sr;
    private SpatialReference m_gcs;
    private ProjectionTransformation m_transform;
    private double m_a;
    private double m_e_squared;
    private double m_rpu;
    private double m_gcs_tolerance;
    private double m_rad_tolerance;
    private double m_max_length;
    private double m_max_deviation;
    private int m_curve_type;

    GeodeticDensify() {
    }

    static void addDensifiedPoint(ArrayList<Point2D> densified_points, Point2D pt) {
        Point2D pt_copy = new Point2D();
        pt_copy.setCoords(pt);
        densified_points.add(pt_copy);
    }

    static void addPointToStack(AttributeStreamOfDbl densified_stack, Point2D pt) {
        densified_stack.add(pt.x);
        densified_stack.add(pt.y);
    }

    static void popPointFromStack(AttributeStreamOfDbl densified_stack) {
        densified_stack.resizePreserveCapacity(densified_stack.size() - 2);
    }

    static void queryLastPointOnStack(AttributeStreamOfDbl densified_stack, Point2D last) {
        last.setCoords(densified_stack.get(densified_stack.size() - 2), densified_stack.get(densified_stack.size() - 1));
    }

    static Geometry densify(Geometry geometry, SpatialReference sr, int curve_type, double max_length, double max_deviation, ProgressTracker progress_tracker) {
        MultiPath densified;
        Geometry g;
        if (geometry == null) {
            throw new IllegalArgumentException("invalid argument");
        }
        Geometry.Type geometry_type = geometry.getType();
        if (geometry.isEmpty() || Geometry.isPoint(geometry_type.value())) {
            return geometry;
        }
        GeodeticDensify densifier = new GeodeticDensify();
        densifier.m_sr = sr;
        densifier.m_gcs = sr.getGCS();
        densifier.m_transform = ProjectionTransformation.createEx(sr, densifier.m_gcs, null);
        PeGeogcs PE_geogcs = (PeGeogcs)((SpatialReferenceImpl)densifier.m_gcs).getPECoordSys();
        PeSpheroid spheroid = PE_geogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        densifier.m_a = spheroid.getAxis();
        densifier.m_e_squared = flattening * (2.0 - flattening);
        densifier.m_rpu = densifier.m_gcs.getUnit().getUnitToBaseFactor();
        densifier.m_gcs_tolerance = densifier.m_gcs.getTolerance(0);
        densifier.m_rad_tolerance = densifier.m_gcs_tolerance * densifier.m_rpu;
        densifier.m_max_length = max_length;
        densifier.m_max_deviation = max_deviation;
        densifier.m_curve_type = curve_type;
        if (geometry_type == Geometry.Type.Envelope) {
            Polygon polygon = new Polygon(geometry.getDescription());
            polygon.addEnvelope((Envelope)geometry, false);
            g = polygon;
            geometry_type = Geometry.Type.Polygon;
        } else if (Geometry.isSegment(geometry_type.value())) {
            Polyline polyline = new Polyline(geometry.getDescription());
            polyline.addSegment((Segment)geometry, true);
            g = polyline;
            geometry_type = Geometry.Type.Polyline;
        } else {
            g = geometry;
        }
        if (densifier.m_curve_type != 4) {
            MultiPath multi_path = !densifier.m_transform.isIdentity() ? (MultiPath)OperatorProject.local().execute(g, densifier.m_transform, progress_tracker) : (MultiPath)ProjectionUtils.clipGeometryFromTopAndBottom(g, densifier.m_gcs);
            if (multi_path.isEmpty()) {
                return multi_path;
            }
            multi_path = GeodeticDensify.normalizeMultiPathGCS(densifier.m_rpu, multi_path);
            MultiPath gcs_densified = densifier.geodeticDensify_(multi_path);
            gcs_densified = (MultiPath)OperatorProject.local().foldInto360RangeGeodetic(gcs_densified, densifier.m_gcs, densifier.m_curve_type);
            densified = (MultiPath)OperatorProject.local().execute(gcs_densified, densifier.m_transform.getInverse(), progress_tracker);
        } else {
            MultiPath m;
            if (sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                Geometry pcs_horizon = ((SpatialReferenceImpl)sr).getPCSHorizon();
                m = (MultiPath)OperatorIntersection.local().execute(g, pcs_horizon, sr, progress_tracker);
                if (m == pcs_horizon) {
                    m = new Polygon();
                    pcs_horizon.copyTo(m);
                }
            } else {
                m = (MultiPath)ProjectionUtils.clipGeometryFromTopAndBottom(g, densifier.m_gcs);
            }
            MultiPath multi_path = m;
            if (multi_path.isEmpty()) {
                return multi_path;
            }
            densified = densifier.shapePreservingDensify_(multi_path);
        }
        return densified;
    }

    static MultiPath normalizeMultiPathGCS(double rpu, MultiPath multi_path) {
        Envelope2D env = new Envelope2D();
        multi_path.queryLooseEnvelope(env);
        if (env.getWidth() * rpu < Math.PI) {
            return multi_path;
        }
        boolean b_normalize = false;
        SegmentIterator seg_iter = multi_path.querySegmentIterator();
        Point2D pt_start = new Point2D();
        Point2D pt_end = new Point2D();
        block0: while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                segment.getStartXY(pt_start);
                segment.getEndXY(pt_end);
                pt_start.scale(rpu);
                pt_end.scale(rpu);
                if (!(Math.abs(pt_start.x - pt_end.x) > Math.PI)) continue;
                boolean b_within_pole = GeodeticDensify.checkForWithinPole(pt_start, pt_end);
                if (!b_within_pole) {
                    b_normalize = true;
                    continue block0;
                }
                if (!(Math.abs(pt_start.x - pt_end.x) > Math.PI * 2)) continue;
                b_normalize = true;
                continue block0;
            }
        }
        if (!b_normalize) {
            return multi_path;
        }
        MultiPath normalized = (MultiPath)multi_path.createInstance();
        normalized.reserve(multi_path.getPointCount());
        boolean b_has_attributes = multi_path.getDescription().getAttributeCount() > 1;
        Point2D geo_end = new Point2D();
        Point2D norm_start = new Point2D(0.0, 0.0);
        Point2D norm_end = new Point2D(0.0, 0.0);
        Point2D pt = new Point2D();
        Point point = new Point();
        seg_iter.resetToFirstPath();
        while (seg_iter.nextPath()) {
            double last_norm_x = NumberUtils.NaN();
            double[] current_normalized_delta = new double[]{0.0};
            while (seg_iter.hasNextSegment()) {
                boolean b_start_new_path;
                Segment segment = seg_iter.nextSegment();
                segment.getStartXY(pt_start);
                segment.getEndXY(pt_end);
                pt_start.scale(rpu);
                pt_end.scale(rpu);
                if (NumberUtils.isNaN(last_norm_x)) {
                    GeodeticDensify.rectifyDensifiedDelta_(pt_start.x, NumberUtils.NaN(), current_normalized_delta);
                    norm_start.setCoords(pt_start);
                } else {
                    norm_start.setCoords(norm_end);
                }
                last_norm_x = norm_start.x;
                boolean b_within_pole = GeodeticDensify.checkForWithinPole(pt_start, pt_end);
                if (!b_within_pole) {
                    geo_end.setCoords(pt_end);
                    GeodeticDensify.normalizePoint_(geo_end);
                    GeodeticDensify.rectifyDensifiedDelta_(geo_end.x, last_norm_x, current_normalized_delta);
                    norm_end.setCoords(current_normalized_delta[0] + geo_end.x, geo_end.y);
                } else {
                    if (pt_end.x - pt_start.x > Math.PI * 2) {
                        while (pt_end.x - pt_start.x > Math.PI * 2) {
                            pt_end.x -= Math.PI * 2;
                        }
                    } else if (pt_end.x - pt_start.x < Math.PI * -2) {
                        while (pt_end.x - pt_start.x < Math.PI * -2) {
                            pt_end.x += Math.PI * 2;
                        }
                    }
                    GeodeticDensify.rectifyDensifiedDelta_(pt_end.x, NumberUtils.NaN(), current_normalized_delta);
                    norm_end.setCoords(pt_end);
                }
                if (Math.abs(norm_end.x - pt_end.x) < 0.5) {
                    norm_end.setCoords(pt_end);
                }
                if (!b_has_attributes) {
                    b_start_new_path = seg_iter.isFirstSegmentInPath();
                    if (b_start_new_path) {
                        normalized.insertPath(-1, null, 0, 0, true);
                    }
                    int path_index = normalized.getPathCount() - 1;
                    pt.setCoords(norm_start);
                    pt.scale(1.0 / rpu);
                    normalized.insertPoint(path_index, -1, pt);
                    if (!seg_iter.isLastSegmentInPath() || multi_path.isClosedPath(seg_iter.getPathIndex())) continue;
                    pt.setCoords(norm_end);
                    pt.scale(1.0 / rpu);
                    normalized.insertPoint(path_index, -1, pt);
                    continue;
                }
                segment.queryCoord(0.0, point);
                pt.setCoords(norm_start);
                pt.scale(1.0 / rpu);
                point.setXY(pt);
                b_start_new_path = seg_iter.isFirstSegmentInPath();
                if (b_start_new_path) {
                    normalized.startPath(point);
                } else {
                    normalized.lineTo(point);
                }
                if (!seg_iter.isLastSegmentInPath() || multi_path.isClosedPath(seg_iter.getPathIndex())) continue;
                segment.queryCoord(1.0, point);
                pt.setCoords(norm_end);
                pt.scale(1.0 / rpu);
                point.setXY(pt);
                normalized.lineTo(point);
            }
        }
        return normalized;
    }

    static void geodeticDensifySegment(double a, double e_squared, int curve_type, Point2D pt_start_, Point2D pt_end_, double max_length, double max_deviation, double rad_tolerance, double[] p_geodetic_length, double[] p_start_azimuth, double[] p_end_azimuth, ArrayList<Point2D> densified_points, double[] current_densified_delta) {
        Point2D pt_start = new Point2D();
        Point2D pt_end = new Point2D();
        boolean b_swap = pt_start_.compare(pt_end_) > 0;
        GeodeticDensify.rectifyStartEnd_(b_swap, pt_start_, pt_end_, pt_start, pt_end);
        GeodeticDensify.geodeticDensifySegment_(a, e_squared, curve_type, pt_start, pt_end, max_length, max_deviation, rad_tolerance, p_geodetic_length, p_start_azimuth, p_end_azimuth, null, densified_points, current_densified_delta);
        if (b_swap) {
            GeodeticDensify.swapDensification_(p_start_azimuth, p_end_azimuth, null, densified_points);
        }
    }

    private MultiPath geodeticDensify_(MultiPath multi_path) {
        boolean b_has_attributes;
        assert (this.m_curve_type != 4);
        assert (this.m_max_length > 0.0 || this.m_max_deviation > 0.0);
        MultiPath gcs_densified = (MultiPath)multi_path.createInstance();
        SegmentIterator seg_iter = multi_path.querySegmentIterator();
        ArrayList<Point2D> densified_points = new ArrayList<Point2D>();
        AttributeStreamOfDbl densified_factors = null;
        SegmentBuffer segment_buffer = null;
        boolean bl = b_has_attributes = multi_path.getDescription().getAttributeCount() > 1;
        if (b_has_attributes) {
            densified_factors = new AttributeStreamOfDbl(0);
            segment_buffer = new SegmentBuffer();
        }
        double[] current_densified_delta = new double[1];
        Point2D pt_start_ = new Point2D();
        Point2D pt_end_ = new Point2D();
        Point2D pt_start = new Point2D();
        Point2D pt_end = new Point2D();
        while (seg_iter.nextPath()) {
            current_densified_delta[0] = 0.0;
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                pt_start_.setCoords(segment.getStartXY());
                pt_end_.setCoords(segment.getEndXY());
                pt_start_.scale(this.m_rpu);
                pt_end_.scale(this.m_rpu);
                boolean b_swap = pt_start_.compare(pt_end_) > 0;
                GeodeticDensify.rectifyStartEnd_(b_swap, pt_start_, pt_end_, pt_start, pt_end);
                densified_points.clear();
                if (densified_factors != null) {
                    densified_factors.resizePreserveCapacity(0);
                }
                if (this.m_max_length > 0.0) {
                    GeodeticDensify.geodeticDensifySegment_(this.m_a, this.m_e_squared, this.m_curve_type, pt_start, pt_end, this.m_max_length, this.m_max_deviation, this.m_rad_tolerance, null, null, null, b_has_attributes ? densified_factors : null, densified_points, current_densified_delta);
                } else {
                    GeodeticDensify.geodeticDensifySegmentByDeviation_(this.m_a, this.m_e_squared, this.m_curve_type, pt_start, pt_end, this.m_max_deviation, this.m_rad_tolerance, b_has_attributes ? densified_factors : null, densified_points, current_densified_delta);
                }
                if (b_swap) {
                    GeodeticDensify.swapDensification_(null, null, b_has_attributes ? densified_factors : null, densified_points);
                }
                assert (densified_points.size() >= 2);
                assert (!b_has_attributes || densified_factors.size() == densified_points.size());
                densified_points.get(0).setCoords(segment.getStartXY());
                densified_points.get(densified_points.size() - 1).setCoords(segment.getEndXY());
                for (int i = 1; i < densified_points.size() - 1; ++i) {
                    densified_points.get(i).scale(1.0 / this.m_rpu);
                }
                if (!b_has_attributes) {
                    GeodeticDensify.appendDensificationNoAttributes_(seg_iter.isFirstSegmentInPath(), seg_iter.isLastSegmentInPath() && !multi_path.isClosedPath(seg_iter.getPathIndex()), densified_points, gcs_densified);
                    continue;
                }
                Segment rectified_segment = GeodeticDensify.rectifySegment_(b_swap, segment, segment_buffer);
                GeodeticDensify.appendDensificationWithAttributes_(seg_iter.isFirstSegmentInPath(), seg_iter.isLastSegmentInPath() && !multi_path.isClosedPath(seg_iter.getPathIndex()), segment, rectified_segment, densified_factors, densified_points, gcs_densified);
            }
        }
        return gcs_densified;
    }

    private MultiPath shapePreservingDensify_(MultiPath multi_path) {
        boolean b_has_attributes;
        MultiPath densified = (MultiPath)multi_path.createInstance();
        SegmentIterator seg_iter = multi_path.querySegmentIterator();
        ArrayList<Point2D> densified_points = new ArrayList<Point2D>();
        AttributeStreamOfDbl densified_factors = null;
        SegmentBuffer segment_buffer = new SegmentBuffer();
        boolean bl = b_has_attributes = multi_path.getDescription().getAttributeCount() > 1;
        if (b_has_attributes) {
            densified_factors = new AttributeStreamOfDbl(0);
        }
        while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Point2D pt_end;
                Segment segment = seg_iter.nextSegment();
                Point2D pt_start = segment.getStartXY();
                boolean b_swap = pt_start.compare(pt_end = segment.getEndXY()) > 0;
                Segment rectified_segment = GeodeticDensify.rectifySegment_(b_swap, segment, segment_buffer);
                densified_points.clear();
                if (densified_factors != null) {
                    densified_factors.resizePreserveCapacity(0);
                }
                GeodeticDensify.shapePreservingDensifySegment_(this.m_a, this.m_e_squared, this.m_rpu, rectified_segment, this.m_sr, this.m_max_length, this.m_max_deviation, b_has_attributes ? densified_factors : null, densified_points);
                assert (densified_points.size() >= 2);
                assert (!b_has_attributes || densified_factors.size() == densified_points.size());
                if (b_swap) {
                    GeodeticDensify.swapDensification_(null, null, b_has_attributes ? densified_factors : null, densified_points);
                }
                if (!b_has_attributes) {
                    GeodeticDensify.appendDensificationNoAttributes_(seg_iter.isFirstSegmentInPath(), seg_iter.isLastSegmentInPath() && !multi_path.isClosedPath(seg_iter.getPathIndex()), densified_points, densified);
                    continue;
                }
                GeodeticDensify.appendDensificationWithAttributes_(seg_iter.isFirstSegmentInPath(), seg_iter.isLastSegmentInPath() && !multi_path.isClosedPath(seg_iter.getPathIndex()), segment, rectified_segment, densified_factors, densified_points, densified);
            }
        }
        return densified;
    }

    private static void appendDensificationNoAttributes_(boolean b_start_new_path, boolean b_add_end, ArrayList<Point2D> densified_points, MultiPath running_densified) {
        if (b_start_new_path) {
            running_densified.insertPath(-1, null, 0, 0, true);
        }
        int path_index = running_densified.getPathCount() - 1;
        Point2D[] points = densified_points.toArray(new Point2D[densified_points.size()]);
        running_densified.insertPoints(path_index, -1, points, 0, points.length - 1, true);
        if (b_add_end) {
            running_densified.insertPoint(path_index, -1, densified_points.get(densified_points.size() - 1));
        }
    }

    private static void appendDensificationWithAttributes_(boolean b_start_new_path, boolean b_add_end, Segment segment, Segment rectified_segment, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points, MultiPath running_densified) {
        Point point = new Point();
        segment.queryStart(point);
        if (b_start_new_path) {
            running_densified.startPath(point);
        } else {
            running_densified.lineTo(point);
        }
        if (densified_points.size() > 2) {
            double segment_length = rectified_segment.calculateLength2D();
            for (int i = 1; i < densified_points.size() - 1; ++i) {
                double t = rectified_segment.lengthToT(densified_factors.get(i) * segment_length);
                rectified_segment.queryCoord(t, point);
                point.setXY(densified_points.get(i));
                running_densified.lineTo(point);
            }
        }
        if (b_add_end) {
            segment.queryEnd(point);
            running_densified.lineTo(point);
        }
    }

    private static void geodeticDensifySegment_(double a, double e_squared, int curve_type, Point2D pt_start, Point2D pt_end, double max_length, double max_deviation, double rad_tolerance, double[] p_geodetic_length, double[] p_start_azimuth, double[] p_end_azimuth, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points, double[] current_densified_delta) {
        assert (pt_start.compare(pt_end) <= 0);
        PeDouble pe_az_s_e = new PeDouble();
        PeDouble pe_az_e_s = new PeDouble();
        PeDouble pe_geodetic_distance = new PeDouble();
        PeLineType.geodetic_distance((double)a, (double)e_squared, (double)pt_start.x, (double)pt_start.y, (double)pt_end.x, (double)pt_end.y, (PeDouble)pe_geodetic_distance, (PeDouble)pe_az_s_e, (PeDouble)pe_az_e_s, (int)curve_type);
        double geodetic_length = pe_geodetic_distance.val;
        double az_s_e = pe_az_s_e.val;
        double az_e_s = pe_az_e_s.val;
        double az_s_e_norm = az_s_e;
        double az_e_s_norm = az_e_s;
        if (az_s_e_norm < 0.0) {
            az_s_e_norm += Math.PI * 2;
        }
        if (az_e_s_norm < 0.0) {
            az_e_s_norm += Math.PI * 2;
        }
        if (p_geodetic_length != null) {
            p_geodetic_length[0] = geodetic_length;
        }
        if (p_start_azimuth != null) {
            p_start_azimuth[0] = az_s_e_norm;
        }
        if (p_end_azimuth != null) {
            p_end_azimuth[0] = az_e_s_norm;
        }
        double north_factor = NumberUtils.NaN();
        double south_factor = NumberUtils.NaN();
        if (densified_factors != null) {
            double q_90 = PeMath.q90((double)a, (double)e_squared);
            double q_start = PeMath.q((double)a, (double)e_squared, (double)pt_start.y);
            north_factor = (q_90 - q_start) / geodetic_length;
            south_factor = (q_90 + q_start) / geodetic_length;
        }
        boolean b_start_touches_pole = GeodeticDensify.checkStartForPoleTouch(pt_start, pt_end);
        boolean b_end_touches_pole = GeodeticDensify.checkEndForPoleTouch(pt_start, pt_end);
        boolean b_touches_pole = b_start_touches_pole || b_end_touches_pole;
        boolean b_crosses_pole = GeodeticDensify.checkForPoleCrossing_(pt_start, pt_end, rad_tolerance);
        PeDouble pe_geodetic_point_0 = new PeDouble();
        PeDouble pe_geodetic_point_1 = new PeDouble();
        Point2D geodetic_point = new Point2D();
        Point2D last_geodetic_point = new Point2D();
        Point2D point = new Point2D();
        GeodeticDensify.rectifyDensifiedDelta_(pt_start.x, NumberUtils.NaN(), current_densified_delta);
        double[] last_densified_delta = new double[]{current_densified_delta[0]};
        if (geodetic_length <= max_length) {
            GeodeticDensify.addDensifiedPoint(densified_points, pt_start);
            GeodeticDensify.rectifyDensifiedDelta_(pt_end.x, NumberUtils.NaN(), current_densified_delta);
            if (densified_factors != null) {
                densified_factors.add(0.0);
            }
            if (b_touches_pole) {
                if (b_start_touches_pole) {
                    GeodeticDensify.prepStartForPoleTouch_(pt_start, pt_end, densified_factors, densified_points);
                }
                if (b_end_touches_pole) {
                    GeodeticDensify.prepEndForPoleTouch_(pt_start, pt_end, densified_factors, densified_points);
                }
            } else if (b_crosses_pole) {
                GeodeticDensify.prepForLocalPoleCrossing_(pt_start, pt_end, az_s_e, north_factor, south_factor, densified_factors, densified_points);
            } else if (max_deviation > 0.0) {
                assert (false);
                last_geodetic_point.setCoords(pt_start.x - last_densified_delta[0], pt_start.y);
                geodetic_point.setCoords(pt_end.x - current_densified_delta[0], pt_end.y);
                GeodeticDensify.geodeticDensifySegmentByDeviationHelper_(a, e_squared, curve_type, pt_start, geodetic_length, az_s_e, last_geodetic_point, geodetic_point, 0.0, 1.0, max_deviation, rad_tolerance, densified_factors, densified_points, last_densified_delta);
            }
            GeodeticDensify.addDensifiedPoint(densified_points, pt_end);
            return;
        }
        int num_points = 1 + (int)Math.ceil(geodetic_length / max_length);
        assert (num_points > 1);
        double step = geodetic_length / (double)(num_points - 1);
        densified_points.ensureCapacity(densified_points.size() + num_points);
        Point2D last_densified_point = new Point2D();
        double last_factor = 0.0;
        GeodeticDensify.addDensifiedPoint(densified_points, pt_start);
        last_densified_point.setCoords(pt_start);
        last_geodetic_point.setCoords(pt_start.x - current_densified_delta[0], pt_start.y);
        if (densified_factors != null) {
            densified_factors.add(0.0);
        }
        for (int i = 1; i < num_points; ++i) {
            double factor;
            if (i < num_points - 1) {
                double distance = (double)i * step;
                PeLineType.geodetic_coordinate((double)a, (double)e_squared, (double)pt_start.x, (double)pt_start.y, (double)distance, (double)az_s_e, (PeDouble)pe_geodetic_point_0, (PeDouble)pe_geodetic_point_1, (int)curve_type);
                geodetic_point.setCoords(pe_geodetic_point_0.val, pe_geodetic_point_1.val);
                GeodeticDensify.rectifyDensifiedDelta_(geodetic_point.x, last_densified_point.x, current_densified_delta);
                point.setCoords(current_densified_delta[0] + geodetic_point.x, geodetic_point.y);
                factor = (double)i / ((double)num_points - 1.0);
            } else {
                GeodeticDensify.rectifyDensifiedDelta_(pt_end.x, NumberUtils.NaN(), current_densified_delta);
                geodetic_point.setCoords(pt_end.x - current_densified_delta[0], pt_end.y);
                point.setCoords(pt_end);
                factor = 1.0;
            }
            if (b_touches_pole) {
                if (i == 1 && b_start_touches_pole) {
                    GeodeticDensify.prepStartForPoleTouch_(pt_start, point, densified_factors, densified_points);
                }
                if (i == num_points - 1 && b_end_touches_pole) {
                    GeodeticDensify.prepEndForPoleTouch_(last_densified_point, pt_end, densified_factors, densified_points);
                }
            } else if (b_crosses_pole) {
                if (GeodeticDensify.checkForLocalPoleCrossing_(last_densified_point, point, rad_tolerance)) {
                    if (pt_start.x < pt_end.x) {
                        if (last_densified_point.x > point.x) {
                            current_densified_delta[0] = current_densified_delta[0] + Math.PI * 2;
                            point.setCoords(current_densified_delta[0] + geodetic_point.x, geodetic_point.y);
                        }
                    } else {
                        assert (pt_start.x > pt_end.x);
                        if (last_densified_point.x < point.x) {
                            current_densified_delta[0] = current_densified_delta[0] - Math.PI * 2;
                            point.setCoords(current_densified_delta[0] + geodetic_point.x, geodetic_point.y);
                        }
                    }
                    assert (Math.abs(point.x - pt_end.x) <= rad_tolerance);
                    GeodeticDensify.prepForLocalPoleCrossing_(last_densified_point, point, az_s_e, north_factor, south_factor, densified_factors, densified_points);
                }
            } else if (max_deviation > 0.0) {
                assert (false);
                GeodeticDensify.geodeticDensifySegmentByDeviationHelper_(a, e_squared, curve_type, pt_start, geodetic_length, az_s_e, last_geodetic_point, geodetic_point, last_factor, factor, max_deviation, rad_tolerance, densified_factors, densified_points, last_densified_delta);
            }
            GeodeticDensify.addDensifiedPoint(densified_points, point);
            if (densified_factors != null) {
                densified_factors.add(factor);
            }
            last_densified_point.setCoords(point);
            last_geodetic_point.setCoords(geodetic_point);
            last_densified_delta[0] = current_densified_delta[0];
            last_factor = factor;
        }
    }

    private static void geodeticDensifySegmentByDeviation_(double a, double e_squared, int curve_type, Point2D pt_start, Point2D pt_end, double max_deviation, double rad_tolerance, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points, double[] current_densified_delta) {
        assert (pt_start.compare(pt_end) <= 0);
        assert (max_deviation > 0.0);
        PeDouble pe_az_s_e = new PeDouble();
        PeDouble pe_az_e_s = new PeDouble();
        PeDouble pe_geodetic_distance = new PeDouble();
        PeLineType.geodetic_distance((double)a, (double)e_squared, (double)pt_start.x, (double)pt_start.y, (double)pt_end.x, (double)pt_end.y, (PeDouble)pe_geodetic_distance, (PeDouble)pe_az_s_e, (PeDouble)pe_az_e_s, (int)curve_type);
        double geodetic_length = pe_geodetic_distance.val;
        double az_s_e = pe_az_s_e.val;
        double north_factor = NumberUtils.NaN();
        double south_factor = NumberUtils.NaN();
        if (densified_factors != null) {
            double q_90 = PeMath.q90((double)a, (double)e_squared);
            double q_start = PeMath.q((double)a, (double)e_squared, (double)pt_start.y);
            north_factor = (q_90 - q_start) / geodetic_length;
            south_factor = (q_90 + q_start) / geodetic_length;
        }
        boolean b_start_touches_pole = GeodeticDensify.checkStartForPoleTouch(pt_start, pt_end);
        boolean b_end_touches_pole = GeodeticDensify.checkEndForPoleTouch(pt_start, pt_end);
        boolean b_touches_pole = b_start_touches_pole || b_end_touches_pole;
        boolean b_crosses_pole = GeodeticDensify.checkForPoleCrossing_(pt_start, pt_end, rad_tolerance);
        boolean b_within_pole = GeodeticDensify.checkForWithinPole(pt_start, pt_end);
        boolean b_intersects_pole = b_touches_pole || b_crosses_pole || b_within_pole;
        GeodeticDensify.rectifyDensifiedDelta_(pt_start.x, NumberUtils.NaN(), current_densified_delta);
        Point2D last_densified_point = new Point2D();
        GeodeticDensify.addDensifiedPoint(densified_points, pt_start);
        last_densified_point.setCoords(pt_start);
        if (densified_factors != null) {
            densified_factors.add(0.0);
        }
        if (b_intersects_pole) {
            if (b_touches_pole) {
                if (b_start_touches_pole) {
                    GeodeticDensify.prepStartForPoleTouch_(pt_start, pt_end, densified_factors, densified_points);
                }
                if (b_end_touches_pole) {
                    GeodeticDensify.prepEndForPoleTouch_(pt_start, pt_end, densified_factors, densified_points);
                }
            } else if (b_crosses_pole) {
                GeodeticDensify.prepForLocalPoleCrossing_(pt_start, pt_end, az_s_e, north_factor, south_factor, densified_factors, densified_points);
            }
            GeodeticDensify.rectifyDensifiedDelta_(pt_end.x, NumberUtils.NaN(), current_densified_delta);
            GeodeticDensify.addDensifiedPoint(densified_points, pt_end);
            if (densified_factors != null) {
                densified_factors.add(1.0);
            }
            return;
        }
        if (geodetic_length <= max_deviation) {
            GeodeticDensify.rectifyDensifiedDelta_(pt_end.x, NumberUtils.NaN(), current_densified_delta);
            GeodeticDensify.addDensifiedPoint(densified_points, pt_end);
            if (densified_factors != null) {
                densified_factors.add(1.0);
            }
            return;
        }
        Point2D start_geodetic_point = new Point2D();
        Point2D end_geodetic_point = new Point2D();
        start_geodetic_point.setCoords(pt_start);
        end_geodetic_point.setCoords(pt_end);
        start_geodetic_point.x -= current_densified_delta[0];
        assert (Math.abs(start_geodetic_point.x) <= Math.PI);
        end_geodetic_point.x -= current_densified_delta[0];
        if (end_geodetic_point.x < -Math.PI) {
            end_geodetic_point.x += Math.PI * 2;
        } else if (end_geodetic_point.x > Math.PI) {
            end_geodetic_point.x -= Math.PI * 2;
        }
        assert (Math.abs(end_geodetic_point.x) <= Math.PI);
        GeodeticDensify.geodeticDensifySegmentByDeviationHelper_(a, e_squared, curve_type, pt_start, geodetic_length, az_s_e, start_geodetic_point, end_geodetic_point, 0.0, 1.0, max_deviation, rad_tolerance, densified_factors, densified_points, current_densified_delta);
        GeodeticDensify.addDensifiedPoint(densified_points, pt_end);
        GeodeticDensify.rectifyDensifiedDelta_(pt_end.x, NumberUtils.NaN(), current_densified_delta);
        if (densified_factors != null) {
            densified_factors.add(1.0);
        }
    }

    private static void geodeticDensifySegmentByDeviationHelper_(double a, double e_squared, int curve_type, Point2D pt_start, double geodetic_length, double az_s_e, Point2D start_geodetic_point, Point2D end_geodetic_point, double start_factor, double end_factor, double max_deviation, double rad_tolerance, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points, double[] current_densified_delta) {
        assert (max_deviation > 0.0);
        Point2D last_densified_point = new Point2D();
        Point2D point = new Point2D();
        last_densified_point.setCoords(start_geodetic_point.x + current_densified_delta[0], start_geodetic_point.y);
        PeDouble pe_cut_densified_point_0 = new PeDouble();
        PeDouble pe_cut_densified_point_1 = new PeDouble();
        PeDouble pe_cut_closest_length = new PeDouble();
        Point2D left_densified_point = new Point2D();
        Point2D right_densified_point = new Point2D();
        Point2D cut_densified_point = new Point2D();
        Point2D mid_densified_point = new Point2D();
        double left_factor = start_factor;
        double right_factor = end_factor;
        left_densified_point.setCoords(start_geodetic_point);
        right_densified_point.setCoords(end_geodetic_point);
        assert (Math.abs(left_densified_point.x) <= Math.PI);
        assert (Math.abs(right_densified_point.x) <= Math.PI);
        AttributeStreamOfDbl right_densified_points_stack = new AttributeStreamOfDbl(0);
        AttributeStreamOfDbl right_factors_stack = new AttributeStreamOfDbl(0);
        GeodeticDensify.addPointToStack(right_densified_points_stack, right_densified_point);
        right_factors_stack.add(right_factor);
        Point2D closest_point = new Point2D();
        Line deviation_line = new Line();
        int c_divisions = 4;
        assert (c_divisions % 2 == 0);
        double[] scalars = new double[c_divisions - 1];
        GeodeticDensify.setScalarDivisions_(c_divisions, scalars);
        while (right_densified_points_stack.size() > 0) {
            boolean b_split = false;
            double cut_factor = NumberUtils.NaN();
            double mid_factor = NumberUtils.NaN();
            for (int i = 0; i < c_divisions - 1; ++i) {
                cut_factor = scalars[i] * right_factor + (1.0 - scalars[i]) * left_factor;
                PeLineType.geodetic_coordinate((double)a, (double)e_squared, (double)pt_start.x, (double)pt_start.y, (double)(cut_factor * geodetic_length), (double)az_s_e, (PeDouble)pe_cut_densified_point_0, (PeDouble)pe_cut_densified_point_1, (int)curve_type);
                cut_densified_point.setCoords(pe_cut_densified_point_0.val, pe_cut_densified_point_1.val);
                if (i == 0) {
                    mid_factor = cut_factor;
                    mid_densified_point.setCoords(cut_densified_point);
                }
                GeodeticDensify.setDeviationLine_(left_densified_point, cut_densified_point, right_densified_point, deviation_line);
                double t = deviation_line.getClosestCoordinate(cut_densified_point, true);
                assert (t >= 0.0 && t <= 1.0);
                deviation_line.getCoord2D(t, closest_point);
                PeLineType.geodetic_distance((double)a, (double)e_squared, (double)cut_densified_point.x, (double)cut_densified_point.y, (double)closest_point.x, (double)closest_point.y, (PeDouble)pe_cut_closest_length, null, null, (int)2);
                if (!(pe_cut_closest_length.val > max_deviation)) continue;
                b_split = true;
                break;
            }
            if (b_split) {
                right_densified_point.setCoords(mid_densified_point);
                right_factor = mid_factor;
                GeodeticDensify.addPointToStack(right_densified_points_stack, right_densified_point);
                right_factors_stack.add(right_factor);
                continue;
            }
            GeodeticDensify.popPointFromStack(right_densified_points_stack);
            right_factors_stack.eraseRange(right_factors_stack.size() - 1, 1, right_factors_stack.size() - 1);
            if (right_densified_points_stack.size() <= 0) continue;
            GeodeticDensify.rectifyDensifiedDelta_(right_densified_point.x, last_densified_point.x, current_densified_delta);
            point.setCoords(current_densified_delta[0] + right_densified_point.x, right_densified_point.y);
            GeodeticDensify.addDensifiedPoint(densified_points, point);
            last_densified_point.setCoords(point);
            if (densified_factors != null) {
                densified_factors.add(right_factor);
            }
            left_densified_point.setCoords(right_densified_point);
            left_factor = right_factor;
            GeodeticDensify.queryLastPointOnStack(right_densified_points_stack, right_densified_point);
            right_factor = right_factors_stack.get(right_factors_stack.size() - 1);
        }
    }

    private static void shapePreservingDensifySegment_(double a, double e_squared, double rpu, Segment rectified_segment, SpatialReference sr, double max_length, double max_deviation, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points) {
        assert (max_length > 0.0 || max_deviation > 0.0);
        Point2D left_nat_densified_point = new Point2D();
        Point2D right_nat_densified_point = new Point2D();
        Point2D cut_nat_densified_point = new Point2D();
        Point2D cut_nat_deviation_point = new Point2D();
        Point2D mid_nat_densified_point = new Point2D();
        Point2D left_gcs_densified_point = new Point2D();
        Point2D right_gcs_densified_point = new Point2D();
        Point2D cut_gcs_densified_point = new Point2D();
        Point2D cut_gcs_deviation_point = new Point2D();
        Point2D mid_gcs_densified_point = new Point2D();
        PeDouble pe_cut_interpolated_point_0 = new PeDouble();
        PeDouble pe_cut_interpolated_point_1 = new PeDouble();
        Point2D cut_interpolated_point = new Point2D();
        double[][] pe_points = new double[2][2];
        PeCoordsys pe_coord_sys = ((SpatialReferenceImpl)sr).getPECoordSys();
        boolean b_native_gcs = sr.getCoordinateSystemType() == SpatialReference.Type.Geographic;
        double nat_tolerance = sr.getTolerance(0);
        Point2D pt_start = rectified_segment.getStartXY();
        Point2D pt_end = rectified_segment.getEndXY();
        assert (pt_start.compare(pt_end) <= 0);
        if (!b_native_gcs) {
            pe_points[0][0] = pt_start.x;
            pe_points[0][1] = pt_start.y;
            pe_points[1][0] = pt_end.x;
            pe_points[1][1] = pt_end.y;
            int c_points_out = PeCSTransformations.projToGeog((PeProjcs)((PeProjcs)pe_coord_sys), (int)2, (double[][])pe_points);
            assert (c_points_out == 2);
            left_gcs_densified_point.x = pe_points[0][0] * rpu;
            left_gcs_densified_point.y = pe_points[0][1] * rpu;
            right_gcs_densified_point.x = pe_points[1][0] * rpu;
            right_gcs_densified_point.y = pe_points[1][1] * rpu;
        } else {
            left_gcs_densified_point.setCoords(pt_start.x * rpu, pt_start.y * rpu);
            right_gcs_densified_point.setCoords(pt_end.x * rpu, pt_end.y * rpu);
        }
        double total_length = 0.0;
        double left_factor = 0.0;
        double right_factor = 1.0;
        boolean b_is_curve = rectified_segment.isCurve();
        left_nat_densified_point.setCoords(pt_start);
        right_nat_densified_point.setCoords(pt_end);
        AttributeStreamOfDbl right_nat_densified_points_stack = new AttributeStreamOfDbl(0);
        AttributeStreamOfDbl right_gcs_densified_points_stack = new AttributeStreamOfDbl(0);
        AttributeStreamOfDbl right_factors_stack = new AttributeStreamOfDbl(0);
        GeodeticDensify.addPointToStack(right_nat_densified_points_stack, right_nat_densified_point);
        GeodeticDensify.addPointToStack(right_gcs_densified_points_stack, right_gcs_densified_point);
        right_factors_stack.add(right_factor);
        GeodeticDensify.addDensifiedPoint(densified_points, left_nat_densified_point);
        if (densified_factors != null) {
            densified_factors.add(left_factor);
        }
        int c_divisions = 6;
        double[] scalars = new double[c_divisions - 1];
        int n = max_deviation > 0.0 ? (b_is_curve ? c_divisions - 1 : 3) : (b_is_curve ? c_divisions - 1 : 1);
        assert (n <= c_divisions - 1);
        assert ((n + 1) % 2 == 0);
        GeodeticDensify.setScalarDivisions_(n, scalars);
        PeDouble pe_left_right_length = new PeDouble();
        PeDouble pe_left_right_azimuth = new PeDouble();
        PeDouble pe_left_cut_densified_length = new PeDouble();
        PeDouble pe_left_cut_deviation_length = new PeDouble();
        PeDouble pe_offset_inter_to_densified = new PeDouble();
        PeDouble pe_offset_inter_to_deviation = new PeDouble();
        PeDouble pe_offset_deviation_to_densified = new PeDouble();
        while (right_gcs_densified_points_stack.size() > 0) {
            boolean b_split = false;
            double cut_factor = NumberUtils.NaN();
            double mid_factor = NumberUtils.NaN();
            PeLineType.geodetic_distance((double)a, (double)e_squared, (double)left_gcs_densified_point.x, (double)left_gcs_densified_point.y, (double)right_gcs_densified_point.x, (double)right_gcs_densified_point.y, (PeDouble)pe_left_right_length, (PeDouble)pe_left_right_azimuth, null, (int)2);
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    if (!b_is_curve && !(max_deviation > 0.0)) {
                        assert (max_length > 0.0);
                        if (pe_left_right_length.val <= max_length && Math.abs(left_gcs_densified_point.x - right_gcs_densified_point.x) < Math.PI) break;
                    }
                    if (rectified_segment._calculateSubLength(left_factor, right_factor) <= nat_tolerance) {
                        assert (false);
                        break;
                    }
                }
                cut_factor = scalars[i] * right_factor + (1.0 - scalars[i]) * left_factor;
                rectified_segment.getCoord2D(cut_factor, cut_nat_densified_point);
                if (!b_native_gcs) {
                    pe_points[0][0] = cut_nat_densified_point.x;
                    pe_points[0][1] = cut_nat_densified_point.y;
                    PeCSTransformations.projToGeog((PeProjcs)((PeProjcs)pe_coord_sys), (int)1, (double[][])pe_points);
                    cut_gcs_densified_point.x = pe_points[0][0] * rpu;
                    cut_gcs_densified_point.y = pe_points[0][1] * rpu;
                } else {
                    cut_gcs_densified_point.setCoords(cut_nat_densified_point.x * rpu, cut_nat_densified_point.y * rpu);
                }
                if (i == 0) {
                    mid_factor = cut_factor;
                    mid_nat_densified_point.setCoords(cut_nat_densified_point);
                    mid_gcs_densified_point.setCoords(cut_gcs_densified_point);
                    if (max_length > 0.0 && (pe_left_right_length.val > max_length || Math.abs(left_gcs_densified_point.x - right_gcs_densified_point.x) >= Math.PI)) {
                        b_split = true;
                        break;
                    }
                }
                if (b_is_curve && max_length > 0.0) {
                    PeLineType.geodetic_distance((double)a, (double)e_squared, (double)left_gcs_densified_point.x, (double)left_gcs_densified_point.y, (double)cut_gcs_densified_point.x, (double)cut_gcs_densified_point.y, (PeDouble)pe_left_cut_densified_length, null, null, (int)2);
                    if (!(pe_left_cut_densified_length.val > max_length) && !(Math.abs(left_gcs_densified_point.x - cut_gcs_densified_point.x) >= Math.PI)) continue;
                    b_split = true;
                    break;
                }
                if (!(max_deviation > 0.0)) continue;
                if (b_is_curve) {
                    cut_nat_deviation_point.interpolate(left_nat_densified_point, right_nat_densified_point, scalars[i]);
                    if (!b_native_gcs) {
                        pe_points[0][0] = cut_nat_deviation_point.x;
                        pe_points[0][1] = cut_nat_deviation_point.y;
                        PeCSTransformations.projToGeog((PeProjcs)((PeProjcs)pe_coord_sys), (int)1, (double[][])pe_points);
                        cut_gcs_deviation_point.x = pe_points[0][0] * rpu;
                        cut_gcs_deviation_point.y = pe_points[0][1] * rpu;
                    } else {
                        cut_gcs_deviation_point.setCoords(cut_nat_deviation_point.x * rpu, cut_nat_deviation_point.y * rpu);
                    }
                } else {
                    cut_nat_deviation_point.setCoords(cut_nat_densified_point);
                    cut_gcs_deviation_point.setCoords(cut_gcs_densified_point);
                }
                PeLineType.geodetic_distance((double)a, (double)e_squared, (double)left_gcs_densified_point.x, (double)left_gcs_densified_point.y, (double)cut_gcs_deviation_point.x, (double)cut_gcs_deviation_point.y, (PeDouble)pe_left_cut_deviation_length, null, null, (int)2);
                if (pe_left_cut_deviation_length.val <= pe_left_right_length.val) {
                    PeLineType.geodetic_coordinate((double)a, (double)e_squared, (double)left_gcs_densified_point.x, (double)left_gcs_densified_point.y, (double)pe_left_cut_deviation_length.val, (double)pe_left_right_azimuth.val, (PeDouble)pe_cut_interpolated_point_0, (PeDouble)pe_cut_interpolated_point_1, (int)2);
                    cut_interpolated_point.setCoords(pe_cut_interpolated_point_0.val, pe_cut_interpolated_point_1.val);
                    PeLineType.geodetic_distance((double)a, (double)e_squared, (double)cut_interpolated_point.x, (double)cut_interpolated_point.y, (double)cut_gcs_densified_point.x, (double)cut_gcs_densified_point.y, (PeDouble)pe_offset_inter_to_densified, null, null, (int)2);
                    if (pe_offset_inter_to_densified.val > max_deviation) {
                        b_split = true;
                        break;
                    }
                    if (!b_is_curve) continue;
                    PeLineType.geodetic_distance((double)a, (double)e_squared, (double)cut_interpolated_point.x, (double)cut_interpolated_point.y, (double)cut_gcs_deviation_point.x, (double)cut_gcs_deviation_point.y, (PeDouble)pe_offset_inter_to_deviation, null, null, (int)2);
                    if (pe_offset_inter_to_deviation.val > max_deviation) {
                        b_split = true;
                        break;
                    }
                    PeLineType.geodetic_distance((double)a, (double)e_squared, (double)cut_gcs_deviation_point.x, (double)cut_gcs_deviation_point.y, (double)cut_gcs_densified_point.x, (double)cut_gcs_densified_point.y, (PeDouble)pe_offset_deviation_to_densified, null, null, (int)2);
                    if (!(pe_offset_deviation_to_densified.val > max_deviation)) continue;
                    b_split = true;
                    break;
                }
                b_split = true;
                break;
            }
            if (b_split) {
                right_nat_densified_point.setCoords(mid_nat_densified_point);
                right_gcs_densified_point.setCoords(mid_gcs_densified_point);
                right_factor = mid_factor;
                GeodeticDensify.addPointToStack(right_nat_densified_points_stack, right_nat_densified_point);
                GeodeticDensify.addPointToStack(right_gcs_densified_points_stack, right_gcs_densified_point);
                right_factors_stack.add(right_factor);
                continue;
            }
            GeodeticDensify.popPointFromStack(right_nat_densified_points_stack);
            GeodeticDensify.popPointFromStack(right_gcs_densified_points_stack);
            right_factors_stack.eraseRange(right_factors_stack.size() - 1, 1, right_factors_stack.size() - 1);
            GeodeticDensify.addDensifiedPoint(densified_points, right_nat_densified_point);
            total_length += pe_left_right_length.val;
            if (densified_factors != null) {
                densified_factors.add(total_length);
            }
            if (right_gcs_densified_points_stack.size() <= 0) continue;
            left_nat_densified_point.setCoords(right_nat_densified_point);
            left_gcs_densified_point.setCoords(right_gcs_densified_point);
            left_factor = right_factor;
            GeodeticDensify.queryLastPointOnStack(right_nat_densified_points_stack, right_nat_densified_point);
            GeodeticDensify.queryLastPointOnStack(right_gcs_densified_points_stack, right_gcs_densified_point);
            right_factor = right_factors_stack.get(right_factors_stack.size() - 1);
        }
        if (densified_factors != null) {
            double scale = 1.0 / total_length;
            for (int i = 0; i < densified_factors.size(); ++i) {
                densified_factors.write(i, densified_factors.read(i) * scale);
            }
        }
    }

    private static void swapDensification_(double[] start_azimuth, double[] end_azimuth, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points) {
        double e_a;
        Collections.reverse(densified_points);
        if (densified_factors != null) {
            densified_factors.reverseRange(0, densified_factors.size(), 1);
        }
        double s_a = start_azimuth != null ? start_azimuth[0] : NumberUtils.NaN();
        double d = e_a = end_azimuth != null ? end_azimuth[0] : NumberUtils.NaN();
        if (start_azimuth != null) {
            start_azimuth[0] = e_a;
        }
        if (end_azimuth != null) {
            end_azimuth[0] = s_a;
        }
    }

    private static void rectifyStartEnd_(boolean b_swap, Point2D pt_start_, Point2D pt_end_, Point2D pt_start, Point2D pt_end) {
        if (b_swap) {
            pt_start.setCoords(pt_end_);
            pt_end.setCoords(pt_start_);
        } else {
            pt_start.setCoords(pt_start_);
            pt_end.setCoords(pt_end_);
        }
    }

    private static Segment rectifySegment_(boolean b_swap, Segment segment, SegmentBuffer segment_buffer) {
        if (!b_swap) {
            return segment;
        }
        segment_buffer.create(segment.getType());
        segment.copyTo(segment_buffer.get());
        segment_buffer.get().reverse();
        return segment_buffer.get();
    }

    private static void rectifyDensifiedDelta_(double densified_point_x, double last_densified_point_x, double[] current_densified_delta) {
        if (NumberUtils.isNaN(last_densified_point_x)) {
            while (current_densified_delta[0] - densified_point_x > Math.PI) {
                current_densified_delta[0] = current_densified_delta[0] - Math.PI * 2;
            }
            while (densified_point_x - current_densified_delta[0] > Math.PI) {
                current_densified_delta[0] = current_densified_delta[0] + Math.PI * 2;
            }
            return;
        }
        if (current_densified_delta[0] + densified_point_x - last_densified_point_x > Math.PI) {
            current_densified_delta[0] = current_densified_delta[0] - Math.PI * 2;
        } else if (last_densified_point_x - (current_densified_delta[0] + densified_point_x) > Math.PI) {
            current_densified_delta[0] = current_densified_delta[0] + Math.PI * 2;
        }
    }

    private static void setDeviationLine_(Point2D left_densified_point, Point2D mid_densified_point, Point2D right_densified_point, Line deviation_line) {
        if (Math.abs(mid_densified_point.x - left_densified_point.x) < Math.PI) {
            deviation_line.setStartXY(left_densified_point);
            if (right_densified_point.x - left_densified_point.x >= Math.PI) {
                deviation_line.setEndXY(right_densified_point.x - Math.PI * 2, right_densified_point.y);
            } else if (left_densified_point.x - right_densified_point.x >= Math.PI) {
                deviation_line.setEndXY(right_densified_point.x + Math.PI * 2, right_densified_point.y);
            } else {
                deviation_line.setEndXY(right_densified_point.x, right_densified_point.y);
            }
        } else {
            deviation_line.setStartXY(right_densified_point);
            if (left_densified_point.x - right_densified_point.x >= Math.PI) {
                deviation_line.setEndXY(left_densified_point.x - Math.PI * 2, left_densified_point.y);
            } else if (right_densified_point.x - left_densified_point.x >= Math.PI) {
                deviation_line.setEndXY(left_densified_point.x + Math.PI * 2, left_densified_point.y);
            } else {
                deviation_line.setEndXY(left_densified_point.x, left_densified_point.y);
            }
        }
    }

    private static void setScalarDivisions_(int n, double[] scalars) {
        double t_center = 0.5;
        for (int i = 0; i < n; ++i) {
            double t;
            double t_deviation = Math.ceil((double)i / 2.0) / (double)(n + 1);
            if (i % 2 != 0) {
                t_deviation = -t_deviation;
            }
            scalars[i] = t = t_center + t_deviation;
        }
    }

    static boolean checkStartForPoleTouch(Point2D pt_start, Point2D pt_end) {
        if (PeMacros.PE_EQ((double)pt_start.y, (double)1.5707963267948966) && !PeMacros.PE_EQ((double)pt_end.y, (double)1.5707963267948966)) {
            return true;
        }
        return PeMacros.PE_EQ((double)pt_start.y, (double)-1.5707963267948966) && !PeMacros.PE_EQ((double)pt_end.y, (double)-1.5707963267948966);
    }

    static boolean checkEndForPoleTouch(Point2D pt_start, Point2D pt_end) {
        if (PeMacros.PE_EQ((double)pt_end.y, (double)1.5707963267948966) && !PeMacros.PE_EQ((double)pt_start.y, (double)1.5707963267948966)) {
            return true;
        }
        return PeMacros.PE_EQ((double)pt_end.y, (double)-1.5707963267948966) && !PeMacros.PE_EQ((double)pt_start.y, (double)-1.5707963267948966);
    }

    private static boolean checkForPoleCrossing_(Point2D pt_start, Point2D pt_end, double rad_tolerance) {
        return GeodeticDensify.checkForLocalPoleCrossing_(pt_start, pt_end, rad_tolerance) && !PeMacros.PE_EQ((double)pt_start.y, (double)1.5707963267948966) && !PeMacros.PE_EQ((double)pt_start.y, (double)-1.5707963267948966) && !PeMacros.PE_EQ((double)pt_end.y, (double)1.5707963267948966) && !PeMacros.PE_EQ((double)pt_end.y, (double)-1.5707963267948966);
    }

    private static boolean checkForLocalPoleCrossing_(Point2D prev_point, Point2D point, double rad_tolerance) {
        return Math.abs(Math.abs(prev_point.x - point.x) - Math.PI) <= rad_tolerance;
    }

    static boolean checkForWithinPole(Point2D pt_start, Point2D pt_end) {
        if (PeMacros.PE_EQ((double)pt_start.y, (double)1.5707963267948966) && PeMacros.PE_EQ((double)pt_end.y, (double)1.5707963267948966)) {
            return true;
        }
        return PeMacros.PE_EQ((double)pt_start.y, (double)-1.5707963267948966) && PeMacros.PE_EQ((double)pt_end.y, (double)-1.5707963267948966);
    }

    private static void prepStartForPoleTouch_(Point2D pt_start, Point2D point, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points) {
        if (pt_start.y > 0.0) {
            Point2D pole_point = new Point2D();
            pole_point.setCoords(point.x, 1.5707963267948966);
            if (!PeMacros.PE_EQ((double)pt_start.x, (double)pole_point.x) && !PeMacros.PE_EQ((double)point.y, (double)pole_point.y)) {
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(0.0);
                }
            }
        } else {
            Point2D pole_point = new Point2D();
            pole_point.setCoords(point.x, -1.5707963267948966);
            if (!PeMacros.PE_EQ((double)pt_start.x, (double)pole_point.x) && !PeMacros.PE_EQ((double)point.y, (double)pole_point.y)) {
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(0.0);
                }
            }
        }
    }

    private static void prepEndForPoleTouch_(Point2D point, Point2D pt_end, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points) {
        if (pt_end.y > 0.0) {
            Point2D pole_point = new Point2D();
            pole_point.setCoords(point.x, 1.5707963267948966);
            if (!PeMacros.PE_EQ((double)pt_end.x, (double)pole_point.x) && !PeMacros.PE_EQ((double)point.y, (double)pole_point.y)) {
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(1.0);
                }
            }
        } else {
            Point2D pole_point = new Point2D();
            pole_point.setCoords(point.x, -1.5707963267948966);
            if (!PeMacros.PE_EQ((double)pt_end.x, (double)pole_point.x) && !PeMacros.PE_EQ((double)point.y, (double)pole_point.y)) {
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(1.0);
                }
            }
        }
    }

    private static void prepForLocalPoleCrossing_(Point2D prev_point, Point2D point, double azimuth, double north_factor, double south_factor, AttributeStreamOfDbl densified_factors, ArrayList<Point2D> densified_points) {
        if (PeMacros.PE_ZERO((double)azimuth)) {
            Point2D pole_point;
            if (1.5707963267948966 - prev_point.y > 0.0) {
                pole_point = new Point2D();
                pole_point.setCoords(prev_point.x, 1.5707963267948966);
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(north_factor);
                }
            }
            if (1.5707963267948966 - point.y > 0.0) {
                pole_point = new Point2D();
                pole_point.setCoords(point.x, 1.5707963267948966);
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(north_factor);
                }
            }
        } else {
            Point2D pole_point;
            if (1.5707963267948966 + prev_point.y > 0.0) {
                pole_point = new Point2D();
                pole_point.setCoords(prev_point.x, -1.5707963267948966);
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(south_factor);
                }
            }
            if (1.5707963267948966 + point.y > 0.0) {
                pole_point = new Point2D();
                pole_point.setCoords(point.x, -1.5707963267948966);
                GeodeticDensify.addDensifiedPoint(densified_points, pole_point);
                if (densified_factors != null) {
                    densified_factors.add(south_factor);
                }
            }
        }
    }

    private static void normalizePoint_(Point2D point) {
        block3: {
            block2: {
                if (!(point.x < -Math.PI)) break block2;
                while (point.x < -Math.PI) {
                    point.x += Math.PI * 2;
                }
                break block3;
            }
            if (!(point.x > Math.PI)) break block3;
            while (point.x > Math.PI) {
                point.x -= Math.PI * 2;
            }
        }
    }
}

