/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.Boundary;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKPublic
public class Envelope
extends Geometry
implements Serializable {
    VertexDescription m_description;
    private final Envelope2D m_envelope = new Envelope2D();
    private double[] m_attributes = null;

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Envelope(Point center, double width, double height) {
        this.m_description = center.getDescription();
        this.m_envelope.setEmpty();
        this._ensureAttributes();
        if (center.isEmpty()) {
            return;
        }
        this._setFromPoint(center, width, height);
    }

    @HadoopSDKPublic
    public Envelope(Envelope2D env2D) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_envelope.setCoords(env2D);
        this.m_envelope.normalize();
    }

    @HadoopSDKPublic
    public Envelope(VertexDescription vd) {
        if (vd == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = vd;
        this.m_envelope.setEmpty();
        this._ensureAttributes();
    }

    @HadoopSDKPublic
    public Envelope(VertexDescription vd, Envelope2D env2D) {
        if (vd == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = vd;
        this.m_envelope.setCoords(env2D);
        this.m_envelope.normalize();
        this._ensureAttributes();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Envelope() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_envelope.setEmpty();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Envelope(Point point) {
        this.m_description = point.m_description;
        this.m_envelope.setEmpty();
        this._ensureAttributes();
        if (point.isEmpty()) {
            return;
        }
        this._setFromPoint(point);
    }

    @HadoopSDKPublic
    public Envelope(Envelope other) {
        this.m_description = other.m_description;
        this._ensureAttributes(true);
        other.copyTo(this);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Envelope(double xmin, double ymin, double xmax, double ymax) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setCoords(xmin, ymin, xmax, ymax);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setCoords(double xmin, double ymin, double xmax, double ymax) {
        this.m_envelope.setCoords(xmin, ymin, xmax, ymax);
    }

    public void setCoords(Point[] points) {
        this.setEmpty();
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            this.merge(points[i]);
        }
    }

    void setEnvelope2D(Envelope2D e2d) {
        if (!e2d.isValid()) {
            throw new IllegalArgumentException();
        }
        this.m_envelope.setCoords(e2d);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setEmpty() {
        this.m_envelope.setEmpty();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isEmpty() {
        return this.m_envelope.isEmpty();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getWidth() {
        return this.m_envelope.getWidth();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getHeight() {
        return this.m_envelope.getHeight();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getCenterX() {
        return this.m_envelope.getCenterX();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getCenterY() {
        return this.m_envelope.getCenterY();
    }

    @HadoopSDKPublic
    public Point2D getCenterXY() {
        return this.m_envelope.getCenter();
    }

    @HadoopSDKPublic
    public void getCenter(Point point_out) {
        point_out.assignVertexDescription(this.m_description);
        if (this.isEmpty()) {
            point_out.setEmpty();
            return;
        }
        int nattrib = this.m_description.getAttributeCount();
        for (int i = 1; i < nattrib; ++i) {
            int semantics = this.m_description.getSemantics(i);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomp; ++iord) {
                double v = 0.5 * (this.getAttributeAsDblImpl_(0, semantics, iord) + this.getAttributeAsDblImpl_(1, semantics, iord));
                point_out.setAttribute(semantics, iord, v);
            }
        }
        point_out.setXY(this.m_envelope.getCenter());
    }

    @HadoopSDKPublic
    public void merge(Point2D pt) {
        this.m_envelope.merge(pt);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void merge(Envelope other) {
        if (other.isEmpty()) {
            return;
        }
        VertexDescription otherVD = other.m_description;
        if (otherVD != this.m_description) {
            this.mergeVertexDescription(otherVD);
        }
        this.m_envelope.merge(other.m_envelope);
        int nattrib = otherVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = otherVD.getSemantics(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                Envelope1D intervalOther = other.queryInterval(semantics, iord);
                Envelope1D interval = this.queryInterval(semantics, iord);
                interval.merge(intervalOther);
                this.setInterval(semantics, iord, interval);
            }
        }
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void merge(Point point) {
        if (point.isEmptyImpl()) {
            return;
        }
        VertexDescription pointVD = point.m_description;
        if (this.m_description != pointVD) {
            this.mergeVertexDescription(pointVD);
        }
        if (this.isEmpty()) {
            this._setFromPoint(point);
            return;
        }
        this.m_envelope.merge(point.getX(), point.getY());
        int nattrib = pointVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = pointVD.getSemantics(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                double v = point.getAttributeAsDbl(semantics, iord);
                Envelope1D interval = this.queryInterval(semantics, iord);
                interval.merge(v);
                this.setInterval(semantics, iord, interval);
            }
        }
    }

    void _setFromPoint(Point centerPoint, double width, double height) {
        this.m_envelope.setCoords(centerPoint.getXY(), width, height);
        VertexDescription pointVD = centerPoint.m_description;
        int nattrib = pointVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = pointVD.getSemantics(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                double v = centerPoint.getAttributeAsDbl(semantics, iord);
                this.setInterval(semantics, iord, v, v);
            }
        }
    }

    void _setFromPoint(Point centerPoint) {
        this.m_envelope.setCoords(centerPoint.getX(), centerPoint.getY());
        VertexDescription pointVD = centerPoint.m_description;
        int nattrib = pointVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = pointVD.getSemantics(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                double v = centerPoint.getAttributeAsDbl(semantics, iord);
                this.setInterval(semantics, iord, v, v);
            }
        }
    }

    @HadoopSDKPublic
    public void merge(Envelope2D other) {
        this.m_envelope.merge(other);
    }

    @HadoopSDKPublic
    public void setInterval(int semantics, int ordinate, double vmin, double vmax) {
        this.setInterval(semantics, ordinate, new Envelope1D(vmin, vmax));
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void reaspect(double arWidth, double arHeight) {
        this.m_envelope.reaspect(arWidth, arHeight);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void inflate(double dx, double dy) {
        this.m_envelope.inflate(dx, dy);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void applyTransformation(Transformation2D transform) {
        transform.transform(this.m_envelope);
    }

    @Override
    @HadoopSDKPublic
    public void applyTransformation(Transformation3D transform) {
        if (!this.m_envelope.isEmpty()) {
            Envelope3D env = new Envelope3D();
            this.queryEnvelope3D(env);
            if (env.isEmptyZ()) {
                env.setEmpty();
            } else {
                transform.transform(env);
            }
        }
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void copyTo(Geometry dst) {
        if (dst.getType() != this.getType()) {
            throw new IllegalArgumentException();
        }
        Envelope envDst = (Envelope)dst;
        envDst.m_envelope.setCoords(this.m_envelope);
        if (envDst.m_description == this.m_description) {
            if (this.m_attributes != null) {
                System.arraycopy(this.m_attributes, 0, envDst.m_attributes, 0, (this.m_description.getTotalComponentCount() - 2) * 2);
            }
        } else {
            envDst.m_description = this.m_description;
            envDst.m_attributes = null;
            if (this.m_attributes != null) {
                envDst._ensureAttributes(true);
                System.arraycopy(this.m_attributes, 0, envDst.m_attributes, 0, (this.m_description.getTotalComponentCount() - 2) * 2);
            }
        }
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry createInstance() {
        return new Envelope(this.m_description);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double calculateArea2D() {
        return this.m_envelope.getArea();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double calculateLength2D() {
        return this.m_envelope.getLength();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry.Type getType() {
        return Geometry.Type.Envelope;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getDimension() {
        return 2;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryEnvelope(Envelope env) {
        this.copyTo(env);
    }

    @Override
    @HadoopSDKPublic
    public void queryEnvelope2D(Envelope2D env) {
        env.xmin = this.m_envelope.xmin;
        env.ymin = this.m_envelope.ymin;
        env.xmax = this.m_envelope.xmax;
        env.ymax = this.m_envelope.ymax;
    }

    @Override
    @HadoopSDKPublic
    public void queryEnvelope3D(Envelope3D env) {
        env.xmin = this.m_envelope.xmin;
        env.ymin = this.m_envelope.ymin;
        env.xmax = this.m_envelope.xmax;
        env.ymax = this.m_envelope.ymax;
        env.setCoords(this.m_envelope.xmin, this.m_envelope.ymin, this._getAttributeAsDbl(0, 1, 0), this.m_envelope.xmax, this.m_envelope.ymax, this._getAttributeAsDbl(1, 1, 0));
    }

    @Override
    @HadoopSDKPublic
    public void queryInterval(int semantics, int ordinate, Envelope1D interval) {
        if (this.isEmpty()) {
            interval.setEmpty();
            return;
        }
        if (semantics == 0) {
            if (ordinate == 0) {
                this.m_envelope.queryIntervalX(interval);
            } else if (ordinate == 1) {
                this.m_envelope.queryIntervalY(interval);
            } else {
                throw new IllegalArgumentException();
            }
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IllegalArgumentException();
        }
        int attribute_index = this.m_description.getAttributeIndex(semantics);
        if (attribute_index >= 0) {
            interval.vmin = this.m_attributes[Envelope._getEndPointOffset(this.m_description, 0) + this.m_description._getPointAttributeOffset(attribute_index) - 2 + ordinate];
            interval.vmax = this.m_attributes[Envelope._getEndPointOffset(this.m_description, 1) + this.m_description._getPointAttributeOffset(attribute_index) - 2 + ordinate];
        } else {
            double v = VertexDescription.getDefaultValue(semantics);
            interval.setCoords(v, v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @HadoopSDKPublic
    public void setInterval(int semantics, int ordinate, Envelope1D env) {
        if (semantics == 0) {
            if (ordinate == 0) {
                this.m_envelope.xmin = env.vmin;
                this.m_envelope.xmax = env.vmax;
                return;
            } else {
                if (ordinate != 1) throw new IndexOutOfBoundsException();
                this.m_envelope.ymin = env.vmin;
                this.m_envelope.ymax = env.vmax;
            }
            return;
        } else {
            this._setAttributeAsDbl(0, semantics, ordinate, env.vmin);
            this._setAttributeAsDbl(1, semantics, ordinate, env.vmax);
        }
    }

    @HadoopSDKPublic
    public void queryCoordinates(Point2D[] dst) {
        if (dst == null || dst.length < 4 || this.m_envelope.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.m_envelope.queryCorners(dst);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryCornerByVal(int index, Point ptDst) {
        if (index < 0 || index > 3) {
            throw new IndexOutOfBoundsException("");
        }
        ptDst.assignVertexDescription(this.m_description);
        int nattrib = this.getDescription().getAttributeCount();
        for (int i = 1; i < nattrib; ++i) {
            int semantics = this.m_description.getSemantics(i);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomp; ++iord) {
                ptDst.setAttribute(semantics, iord, this.getAttributeAsDblImpl_(index % 2, semantics, iord));
            }
        }
        this.m_envelope.queryCorner(index, ptDst);
    }

    @HadoopSDKPublic
    public void queryCorner(int index, Point2D ptDst) {
        Point2D p = this.m_envelope.queryCorner(index);
        ptDst.setCoords(p.x, p.y);
    }

    int getEndPointOffset(VertexDescription descr, int end_point) {
        return end_point * (descr.getTotalComponentCount() - 2);
    }

    double getAttributeAsDblImpl_(int end_point, int semantics, int ordinate) {
        if (this.m_envelope.isEmpty()) {
            throw new GeometryException("empty geometry");
        }
        assert (end_point == 0 || end_point == 1);
        if (semantics == 0) {
            if (end_point != 0) {
                return ordinate != 0 ? this.m_envelope.ymax : this.m_envelope.xmax;
            }
            return ordinate != 0 ? this.m_envelope.ymin : this.m_envelope.xmin;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IllegalArgumentException();
        }
        int attribute_index = this.m_description.getAttributeIndex(semantics);
        if (attribute_index >= 0) {
            return this.m_attributes[this.getEndPointOffset(this.m_description, end_point) + this.m_description.getPointAttributeOffset_(attribute_index) - 2 + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    void setAttributeAsDblImpl_(int end_point, int semantics, int ordinate, double value) {
        assert (end_point == 0 || end_point == 1);
        if (semantics == 0) {
            if (end_point != 0) {
                if (ordinate != 0) {
                    this.m_envelope.ymax = value;
                } else {
                    this.m_envelope.xmax = value;
                }
            } else if (ordinate != 0) {
                this.m_envelope.ymin = value;
            } else {
                this.m_envelope.xmin = value;
            }
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IllegalArgumentException();
        }
        this.addAttribute(semantics);
        int attribute_index = this.m_description.getAttributeIndex(semantics);
        this.m_attributes[this.getEndPointOffset((VertexDescription)this.m_description, (int)end_point) + this.m_description.getPointAttributeOffset_((int)attribute_index) - 2 + ordinate] = value;
    }

    private final void _ensureAttributes() {
        this._ensureAttributes(false);
    }

    private final void _ensureAttributes(boolean dont_init) {
        int sz = this.m_description.getTotalComponentCount() - 2;
        if (this.m_attributes == null && sz > 0) {
            this.m_attributes = new double[sz * 2];
            if (!dont_init) {
                System.arraycopy(this.m_description._getDefaultPointAttributes(), 2, this.m_attributes, 0, sz);
                System.arraycopy(this.m_description._getDefaultPointAttributes(), 2, this.m_attributes, sz, sz);
            }
        }
    }

    private final void _assignVertexDescriptionImpl(VertexDescription new_descr) {
        int[] new_to_old = VertexDescriptionDesignerImpl.mapAttributes(new_descr, this.m_description);
        double[] attr = null;
        int new_total = new_descr.getTotalComponentCount() - 2;
        int old_total = this.m_description.getTotalComponentCount() - 2;
        if (new_total > 0) {
            attr = new double[2 * new_total];
            System.arraycopy(new_descr._getDefaultPointAttributes(), 2, attr, 0, new_total);
            System.arraycopy(new_descr._getDefaultPointAttributes(), 2, attr, new_total, new_total);
        }
        int n = new_descr.getAttributeCount();
        for (int i = 1; i < n; ++i) {
            int oldIndex = new_to_old[i];
            if (oldIndex == -1) continue;
            int oldind = this.m_description.getPointAttributeOffset_(oldIndex) - 2;
            int newind = new_descr.getPointAttributeOffset_(i) - 2;
            int ncomp = VertexDescription.getComponentCount(new_descr.getSemantics(i));
            for (int c = 0; c < ncomp; ++c) {
                attr[newind + c] = this.m_attributes[oldind + c];
                attr[new_total + newind + c] = this.m_attributes[old_total + oldind + c];
            }
        }
        this.m_description = new_descr;
        this.m_attributes = attr;
    }

    double _getAttributeAsDbl(int endPoint, int semantics, int ordinate) {
        if (this.m_envelope.isEmpty()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
        if (semantics == 0) {
            if (endPoint != 0) {
                return ordinate != 0 ? this.m_envelope.ymax : this.m_envelope.xmax;
            }
            return ordinate != 0 ? this.m_envelope.ymin : this.m_envelope.xmin;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return this.m_attributes[Envelope._getEndPointOffset(this.m_description, endPoint) + this.m_description._getPointAttributeOffset(attributeIndex) - 2 + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    void _setAttributeAsDbl(int endPoint, int semantics, int ordinate, double value) {
        if (semantics == 0) {
            if (endPoint != 0) {
                if (ordinate != 0) {
                    this.m_envelope.ymax = value;
                } else {
                    this.m_envelope.xmax = value;
                }
            } else if (ordinate != 0) {
                this.m_envelope.ymin = value;
            } else {
                this.m_envelope.xmin = value;
            }
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        this.addAttribute(semantics);
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        this.m_attributes[Envelope._getEndPointOffset((VertexDescription)this.m_description, (int)endPoint) + this.m_description._getPointAttributeOffset((int)attributeIndex) - 2 + ordinate] = value;
    }

    int _getAttributeAsInt(int endPoint, int semantics, int ordinate) {
        return (int)this._getAttributeAsDbl(endPoint, semantics, ordinate);
    }

    static int _getEndPointOffset(VertexDescription vd, int endPoint) {
        return endPoint * (vd.getTotalComponentCount() - 2);
    }

    @HadoopSDKPublic
    public boolean isIntersecting(Envelope2D other) {
        return this.m_envelope.isIntersecting(other);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean intersect(Envelope other) {
        if (!this.m_envelope.intersect(other.m_envelope)) {
            this.setEmpty();
            return false;
        }
        VertexDescription otherVD = other.getDescription();
        this.mergeVertexDescription(otherVD);
        int nattrib = this.m_description.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = this.m_description.getSemantics(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                Envelope1D interval_other = other.queryInterval(semantics, iord);
                Envelope1D interval = this.queryInterval(semantics, iord);
                interval.intersect(interval_other);
                this.setInterval(semantics, iord, interval);
            }
        }
        return true;
    }

    boolean intersectCommonAttributes(Envelope other) {
        if (!this.m_envelope.intersect(other.m_envelope)) {
            this.setEmpty();
            return false;
        }
        VertexDescription otherVD = other.getDescription();
        int nattrib = this.m_description.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = this.m_description.getSemantics(iattrib);
            if (!otherVD.hasAttribute(semantics)) continue;
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                Envelope1D interval_other = other.queryInterval(semantics, iord);
                Envelope1D interval = this.queryInterval(semantics, iord);
                interval.intersect(interval_other);
                this.setInterval(semantics, iord, interval);
            }
        }
        return true;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isIntersecting(Envelope other) {
        return this.m_envelope.isIntersecting(other.m_envelope);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void centerAt(Point c, double w, double h) {
        if (c.isEmpty()) {
            this.setEmpty();
            return;
        }
        this._setFromPoint(c, w, h);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void offset(double dx, double dy) {
        this.m_envelope.offset(dx, dy);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void normalize() {
        this.m_envelope.normalize();
    }

    @HadoopSDKPublic
    public Point2D getCenter2D() {
        return this.m_envelope.getCenter();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point getCenter() {
        Point pointOut = new Point(this.m_description);
        if (this.isEmpty()) {
            return pointOut;
        }
        int nattrib = this.m_description.getAttributeCount();
        for (int i = 1; i < nattrib; ++i) {
            int semantics = this.m_description.getSemantics(i);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomp; ++iord) {
                double v = 0.5 * (this._getAttributeAsDbl(0, semantics, iord) + this._getAttributeAsDbl(1, semantics, iord));
                pointOut.setAttribute(semantics, iord, v);
            }
        }
        pointOut.setXY(this.m_envelope.getCenterX(), this.m_envelope.getCenterY());
        return pointOut;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void centerAt(Point c) {
        if (c.isEmpty()) {
            this.setEmpty();
            return;
        }
        this.m_envelope.centerAt(c.getX(), c.getY());
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point getLowerLeft() {
        return new Point(this.m_envelope.getLowerLeft());
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point getUpperRight() {
        return new Point(this.m_envelope.getUpperRight());
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point getLowerRight() {
        return new Point(this.m_envelope.getLowerRight());
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point getUpperLeft() {
        return new Point(this.m_envelope.getUpperLeft());
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean contains(Point p) {
        if (p.isEmpty()) {
            return false;
        }
        return this.m_envelope.contains(p.getX(), p.getY());
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean contains(Point2D p) {
        return this.m_envelope.contains(p);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean contains(Envelope env) {
        return this.m_envelope.contains(env.m_envelope);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)_other;
        if (this.m_description != other.m_description) {
            return false;
        }
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        if (!this.m_envelope.equals(other.m_envelope)) {
            return false;
        }
        int n = (this.m_description.getTotalComponentCount() - 2) * 2;
        for (int i = 0; i < n; ++i) {
            if (NumberUtils.isEqualNonIEEE(this.m_attributes[i], other.m_attributes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Geometry _other, double tol) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)_other;
        if (this.m_description != other.m_description) {
            return false;
        }
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        if (Math.abs(this.m_envelope.xmin - other.m_envelope.xmin) > tol || Math.abs(this.m_envelope.xmax - other.m_envelope.xmax) > tol || Math.abs(this.m_envelope.ymin - other.m_envelope.ymin) > tol || Math.abs(this.m_envelope.ymax - other.m_envelope.ymax) > tol) {
            return false;
        }
        int n = (this.m_description.getTotalComponentCount() - 2) * 2;
        for (int i = 0; i < n; ++i) {
            if (NumberUtils.isEqualNonIEEE(this.m_attributes[i], other.m_attributes[i], tol)) continue;
            return false;
        }
        return true;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int hashCode() {
        int hashCode = this.m_description.hashCode();
        hashCode = NumberUtils.hash(hashCode, this.m_envelope.hashCode());
        if (!this.isEmpty() && this.m_attributes != null) {
            int n = (this.m_description.getTotalComponentCount() - 2) * 2;
            for (int i = 0; i < n; ++i) {
                hashCode = NumberUtils.hash(hashCode, this.m_attributes[i]);
            }
        }
        return hashCode;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public final double getXMin() {
        return this.m_envelope.xmin;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public final double getYMin() {
        return this.m_envelope.ymin;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public final double getXMax() {
        return this.m_envelope.xmax;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public final double getYMax() {
        return this.m_envelope.ymax;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setXMin(double x) {
        this.m_envelope.xmin = x;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setXMax(double x) {
        this.m_envelope.xmax = x;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setYMin(double y) {
        this.m_envelope.ymin = y;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setYMax(double y) {
        this.m_envelope.ymax = y;
    }

    void setFromData_(VertexDescription descr, double[] data) {
        this.assignVertexDescription(descr);
        this.m_envelope.setCoords(data[0], data[1], data[2], data[3]);
        if (this.m_attributes != null) {
            System.arraycopy(data, 4, this.m_attributes, 0, (this.m_description.getTotalComponentCount() - 2) * 2);
        }
    }

    double[] copyToData_() {
        double[] dst = new double[this.m_description.getTotalComponentCount() * 2];
        this.copyToData_(dst);
        return dst;
    }

    void copyToData_(double[] data) {
        data[0] = this.m_envelope.xmin;
        data[1] = this.m_envelope.ymin;
        data[2] = this.m_envelope.xmax;
        data[3] = this.m_envelope.ymax;
        if (this.m_attributes != null) {
            System.arraycopy(this.m_attributes, 0, data, 4, (this.m_description.getTotalComponentCount() - 2) * 2);
        }
    }

    static void queryIntervalFromData_(VertexDescription descr, double[] data, int semantics, int ordinate, Envelope1D dst) {
        if (semantics != 0) {
            int n = descr.getTotalComponentCount() - 2;
            int offset = descr._getPointAttributeOffsetFromSemantics(semantics) - 2;
            dst.setCoords(data[4 + offset + ordinate], data[4 + n + offset + ordinate]);
        } else if (ordinate == 0) {
            dst.setCoords(data[0], data[2]);
        } else {
            dst.setCoords(data[1], data[3]);
        }
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry getBoundary() {
        return Boundary.calculate(this, null);
    }

    @Override
    @HadoopSDKPublic
    public void replaceNaNs(int semantics, double value) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        for (int i = 0; i < ncomps; ++i) {
            Envelope1D interval = this.queryInterval(semantics, i);
            if (!interval.isEmpty()) continue;
            interval.vmin = value;
            interval.vmax = value;
            this.setInterval(semantics, i, interval);
        }
    }

    @Override
    @HadoopSDKPublic
    public VertexDescription getDescription() {
        return this.m_description;
    }

    @Override
    @HadoopSDKPublic
    public void assignVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        this._assignVertexDescriptionImpl(src);
    }

    @Override
    @HadoopSDKPublic
    public void mergeVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        if (this.m_description.hasAttributesFrom(src)) {
            return;
        }
        this._mergeVertexDescriptionImpl(src);
    }

    @Override
    @HadoopSDKPublic
    public boolean hasAttribute(int semantics) {
        return this.m_description.hasAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void addAttribute(int semantics) {
        if (this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.getMergedVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    @HadoopSDKPublic
    public void dropAttribute(int semantics) {
        if (!this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.removeSemanticsFromVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    @HadoopSDKPublic
    public void dropAllAttributes() {
        VertexDescription newvd = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        if (newvd == this.m_description) {
            return;
        }
        this.assignVertexDescription(newvd);
    }
}

