/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.BucketSort;
import com.esri.core.geometry.ClassicSort;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HitMap2D;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIntersector;
import com.esri.core.geometry.StridedIndexTypeCollection;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.util.ArrayList;

final class EditShape {
    private int m_path_count = 0;
    private int m_geometryCount = 0;
    private int m_point_count = 0;
    private int m_first_geometry = -1;
    private int m_last_geometry = -1;
    private StridedIndexTypeCollection m_vertex_index_list;
    private MultiPoint m_vertices_mp;
    private MultiPointImpl m_vertices = null;
    private AttributeStreamOfDbl m_xy_stream = null;
    private VertexDescription m_vertex_description = null;
    private boolean m_b_has_attributes = false;
    private ArrayList<Segment> m_segments;
    private AttributeStreamOfDbl m_weights;
    private ArrayList<AttributeStreamOfInt32> m_indices;
    private StridedIndexTypeCollection m_path_index_list;
    private AttributeStreamOfDbl m_path_areas;
    private AttributeStreamOfDbl m_path_lengths;
    private ArrayList<AttributeStreamOfInt32> m_pathindices;
    private StridedIndexTypeCollection m_geometry_index_list;
    private ArrayList<AttributeStreamOfInt32> m_geometry_indices;
    private AttributeStreamOfInt32 m_selected_vertices;
    private int m_selected_count;
    private int m_selection_index;
    private boolean m_selection;
    private BucketSort m_bucket_sort;
    private Point m_helper_point;

    Segment getSegmentFromIndex_(int vindex) {
        return this.m_segments != null ? this.m_segments.get(vindex) : null;
    }

    void setSegmentToIndex_(int vindex, Segment seg) {
        if (this.m_segments == null) {
            if (seg == null) {
                return;
            }
            this.m_segments = new ArrayList();
            int n = this.m_vertices.getPointCount();
            for (int i = 0; i < n; ++i) {
                this.m_segments.add(null);
            }
        }
        this.m_segments.set(vindex, seg);
    }

    void setPrevPath_(int path, int prev) {
        this.m_path_index_list.setField(path, 1, prev);
    }

    void setNextPath_(int path, int next) {
        this.m_path_index_list.setField(path, 2, next);
    }

    void setPathFlags_(int path, int flags) {
        this.m_path_index_list.setField(path, 6, flags);
    }

    int getPathFlags_(int path) {
        return this.m_path_index_list.getField(path, 6);
    }

    void setPathGeometry_(int path, int geom) {
        this.m_path_index_list.setField(path, 7, geom);
    }

    int getPathIndex_(int path) {
        return this.m_path_index_list.getField(path, 0);
    }

    void setNextGeometry_(int geom, int next) {
        this.m_geometry_index_list.setField(geom, 1, next);
    }

    void setPrevGeometry_(int geom, int prev) {
        this.m_geometry_index_list.setField(geom, 0, prev);
    }

    int getGeometryIndex_(int geom) {
        return this.m_geometry_index_list.getField(geom, 7);
    }

    int getFirstPath_(int geom) {
        return this.m_geometry_index_list.getField(geom, 3);
    }

    void setFirstPath_(int geom, int firstPath) {
        this.m_geometry_index_list.setField(geom, 3, firstPath);
    }

    void setLastPath_(int geom, int path) {
        this.m_geometry_index_list.setField(geom, 4, path);
    }

    int newGeometry_(int gt) {
        if (this.m_geometry_index_list == null) {
            this.m_geometry_index_list = new StridedIndexTypeCollection(8);
        }
        int index = this.m_geometry_index_list.newElement();
        this.m_geometry_index_list.setField(index, 2, gt);
        this.m_geometry_index_list.setField(index, 5, 0);
        this.m_geometry_index_list.setField(index, 6, 0);
        this.m_geometry_index_list.setField(index, 7, this.m_geometry_index_list.elementToIndex(index));
        return index;
    }

    void freeGeometry_(int geom) {
        this.m_geometry_index_list.deleteElement(geom);
    }

    int newPath_(int geom) {
        if (this.m_path_index_list == null) {
            this.m_path_index_list = new StridedIndexTypeCollection(8);
            this.m_vertex_index_list = new StridedIndexTypeCollection(5);
            this.m_path_areas = new AttributeStreamOfDbl(0);
            this.m_path_lengths = new AttributeStreamOfDbl(0);
        }
        int index = this.m_path_index_list.newElement();
        int pindex = this.m_path_index_list.elementToIndex(index);
        this.m_path_index_list.setField(index, 0, pindex);
        this.m_path_index_list.setField(index, 3, 0);
        this.m_path_index_list.setField(index, 6, 0);
        this.setPathGeometry_(index, geom);
        if (pindex >= this.m_path_areas.size()) {
            int sz = pindex < 16 ? 16 : pindex * 3 / 2;
            this.m_path_areas.resize(sz);
            this.m_path_lengths.resize(sz);
        }
        this.m_path_areas.set(pindex, 0.0);
        this.m_path_lengths.set(pindex, 0.0);
        ++this.m_path_count;
        return index;
    }

    void freePath_(int path) {
        this.m_path_index_list.deleteElement(path);
        --this.m_path_count;
    }

    void freeVertex_(int vertex) {
        this.m_vertex_index_list.deleteElement(vertex);
        --this.m_point_count;
    }

    int newVertex_(int vindex) {
        assert (vindex >= 0 || vindex == -1);
        if (this.m_path_index_list == null) {
            this.m_path_index_list = new StridedIndexTypeCollection(8);
            this.m_vertex_index_list = new StridedIndexTypeCollection(5);
            this.m_path_areas = new AttributeStreamOfDbl(0);
            this.m_path_lengths = new AttributeStreamOfDbl(0);
        }
        int index = this.m_vertex_index_list.newElement();
        int vi = vindex >= 0 ? vindex : this.m_vertex_index_list.elementToIndex(index);
        this.m_vertex_index_list.setField(index, 0, vi);
        if (vindex < 0) {
            if (vi >= this.m_vertices.getPointCount()) {
                int sz = vi < 16 ? 16 : vi * 3 / 2;
                this.m_vertices.resizeNoInit(sz);
                if (this.m_segments != null) {
                    for (int i = 0; i < sz; ++i) {
                        this.m_segments.add(null);
                    }
                }
                if (this.m_weights != null) {
                    this.m_weights.resize(sz);
                }
                this.m_xy_stream = (AttributeStreamOfDbl)this.m_vertices.getAttributeStreamRef(0);
            }
            this.m_vertices.setXY(vi, -1.0E38, -1.0E38);
            if (this.m_segments != null) {
                this.m_segments.set(vi, null);
            }
            if (this.m_weights != null) {
                this.m_weights.write(vi, 1.0);
            }
        }
        this.m_vertex_index_list.setField(index, 4, vi * 2);
        ++this.m_point_count;
        return index;
    }

    void free_vertex_(int vertex) {
        this.m_vertex_index_list.deleteElement(vertex);
        --this.m_point_count;
    }

    int insertVertex_(int path, int before, Point point) {
        return this.insertVertex_(path, before, point, false);
    }

    int insertVertex_(int path, int before, Point point, boolean preserveFirst) {
        int prev = before != -1 ? this.getPrevVertex(before) : this.getLastVertex(path);
        int next = prev != -1 ? this.getNextVertex(prev) : -1;
        int vertex = this.newVertex_(point == null ? this.m_point_count : -1);
        int vindex = this.getVertexIndex(vertex);
        if (point != null) {
            this.m_vertices.setPointByVal(vindex, point);
        }
        this.setPathToVertex_(vertex, path);
        this.setNextVertex_(vertex, next);
        this.setPrevVertex_(vertex, prev);
        if (next != -1) {
            this.setPrevVertex_(next, vertex);
        }
        if (prev != -1) {
            this.setNextVertex_(prev, vertex);
        }
        boolean b_closed = this.isClosedPath(path);
        int first = this.getFirstVertex(path);
        if (before == -1) {
            this.setLastVertex_(path, vertex);
        }
        if (!(before != first || b_closed && preserveFirst && first != -1)) {
            this.setFirstVertex_(path, vertex);
        }
        if (b_closed && next == -1) {
            this.setNextVertex_(vertex, vertex);
            this.setPrevVertex_(vertex, vertex);
        }
        this.setPathSize_(path, this.getPathSize(path) + 1);
        int geometry = this.getGeometryFromPath(path);
        this.setGeometryVertexCount_(geometry, this.getPointCount(geometry) + 1);
        return vertex;
    }

    Point getHelperPoint_() {
        if (this.m_helper_point == null) {
            this.m_helper_point = new Point(this.m_vertices.getDescription());
        }
        return this.m_helper_point;
    }

    void setFillRule(int geom, int rule) {
        int t = this.m_geometry_index_list.getField(geom, 2);
        t &= 0xF7FFFFFF;
        this.m_geometry_index_list.setField(geom, 2, t |= rule == 1 ? 0x8000000 : 0);
    }

    int getFillRule(int geom) {
        int t = this.m_geometry_index_list.getField(geom, 2);
        return (t & 0x8000000) != 0 ? 1 : 0;
    }

    int addMultiPath_(MultiPath multi_path) {
        int newgeom = this.createGeometry(multi_path.getType(), multi_path.getDescription());
        if (multi_path.getType() == Geometry.Type.Polygon) {
            this.setFillRule(newgeom, ((Polygon)multi_path).getFillRule());
        }
        this.appendMultiPath_(newgeom, multi_path);
        return newgeom;
    }

    int addMultiPoint_(MultiPoint multi_point) {
        int newgeometry = this.createGeometry(multi_point.getType(), multi_point.getDescription());
        this.appendMultiPoint_(newgeometry, multi_point);
        return newgeometry;
    }

    int addPoint_(Point point) {
        int newgeometry = this.createGeometry(Geometry.Type.MultiPoint, point.getDescription());
        this.appendPoint_(newgeometry, point, null);
        return newgeometry;
    }

    int addPoint_(Point point, Envelope2D extentOfInterest) {
        int newgeometry = this.createGeometry(Geometry.Type.MultiPoint, point.getDescription());
        this.appendPoint_(newgeometry, point, extentOfInterest);
        return newgeometry;
    }

    void appendMultiPath_(int dstGeom, MultiPath multi_path) {
        MultiPathImpl mp_impl = (MultiPathImpl)multi_path._getImpl();
        this.m_vertices_mp.add(multi_path, 0, mp_impl.getPointCount());
        this.m_xy_stream = (AttributeStreamOfDbl)this.m_vertices.getAttributeStreamRef(0);
        boolean b_some_segments = this.m_segments != null && mp_impl.getSegmentFlagsStreamRef() != null;
        int npath = mp_impl.getPathCount();
        for (int ipath = 0; ipath < npath; ++ipath) {
            if (mp_impl.getPathSize(ipath) == 0) continue;
            int path = this.insertPath(dstGeom, -1);
            this.setClosedPath(path, mp_impl.isClosedPath(ipath));
            int iend = mp_impl.getPathEnd(ipath);
            for (int ivertex = mp_impl.getPathStart(ipath); ivertex < iend; ++ivertex) {
                int vertex = this.insertVertex_(path, -1, null);
                if (!b_some_segments) continue;
                int vindex = this.getVertexIndex(vertex);
                if ((mp_impl.getSegmentFlags(ivertex) & 1) != 0) {
                    this.setSegmentToIndex_(vindex, null);
                    continue;
                }
                SegmentBuffer seg_buffer = new SegmentBuffer();
                mp_impl.getSegment(ivertex, seg_buffer, true);
                this.setSegmentToIndex_(vindex, seg_buffer.get());
            }
        }
    }

    void appendPoint_(int dstGeom, Point src_point, Envelope2D extentOfInterest) {
        if (src_point.isEmpty()) {
            return;
        }
        if (extentOfInterest != null && extentOfInterest.contains(src_point.getX(), src_point.getY())) {
            return;
        }
        this.m_vertices.reserve(this.m_vertices.getPointCount() + 1);
        this.m_vertices_mp.add(src_point);
        this.m_xy_stream = (AttributeStreamOfDbl)this.m_vertices.getAttributeStreamRef(0);
        this.m_vertex_index_list.setCapacity(this.m_vertex_index_list.size() + 1);
        int path = this.insertPath(dstGeom, -1);
        this.insertVertex_(path, -1, null, false);
    }

    void appendMultiPoint_(int dstGeom, MultiPoint multi_point) {
        this.m_vertices_mp.add(multi_point, 0, multi_point.getPointCount());
        this.m_xy_stream = (AttributeStreamOfDbl)this.m_vertices.getAttributeStreamRef(0);
        int path = this.insertPath(dstGeom, -1);
        int iend = multi_point.getPointCount();
        for (int ivertex = 0; ivertex < iend; ++ivertex) {
            this.insertVertex_(path, -1, null);
        }
    }

    void splitSegmentForward_(int origin_vertex, SegmentIntersector intersector, int intersector_index) {
        int last_vertex = this.getNextVertex(origin_vertex);
        if (last_vertex == -1) {
            throw GeometryException.GeometryInternalError();
        }
        Point point = this.getHelperPoint_();
        int path = this.getPathFromVertex(origin_vertex);
        int vertex = origin_vertex;
        int n = intersector.getResultSegmentCount(intersector_index);
        for (int i = 0; i < n; ++i) {
            int vindex = this.getVertexIndex(vertex);
            int next_vertex = this.getNextVertex(vertex);
            Segment seg = intersector.getResultSegment(intersector_index, i);
            if (i == 0) {
                seg.queryStart(point);
                this.setPoint(vertex, point);
            }
            if (seg.getType().value() == 322) {
                this.setSegmentToIndex_(vindex, null);
            } else {
                this.setSegmentToIndex_(vindex, (Segment)Geometry._clone(seg));
            }
            seg.queryEnd(point);
            if (i < n - 1) {
                int inserted_vertex;
                vertex = inserted_vertex = this.insertVertex_(path, next_vertex, point, true);
                continue;
            }
            this.setPoint(last_vertex, point);
            assert (last_vertex == next_vertex);
        }
    }

    void splitSegmentBackward_(int origin_vertex, SegmentIntersector intersector, int intersector_index) {
        int last_vertex = this.getNextVertex(origin_vertex);
        if (last_vertex == -1) {
            throw GeometryException.GeometryInternalError();
        }
        Point point = this.getHelperPoint_();
        int path = this.getPathFromVertex(origin_vertex);
        int vertex = origin_vertex;
        int n = intersector.getResultSegmentCount(intersector_index);
        for (int i = 0; i < n; ++i) {
            int vindex = this.getVertexIndex(vertex);
            int next_vertex = this.getNextVertex(vertex);
            Segment seg = intersector.getResultSegment(intersector_index, n - i - 1);
            if (i == 0) {
                seg.queryEnd(point);
                this.setPoint(vertex, point);
            }
            if (seg.getType().value() == 322) {
                this.setSegmentToIndex_(vindex, null);
            } else {
                this.setSegmentToIndex_(vindex, (Segment)Geometry._clone(seg));
            }
            seg.queryStart(point);
            if (i < n - 1) {
                int inserted_vertex;
                vertex = inserted_vertex = this.insertVertex_(path, next_vertex, point, true);
                continue;
            }
            this.setPoint(last_vertex, point);
            assert (last_vertex == next_vertex);
        }
    }

    EditShape() {
    }

    int getTotalPointCount() {
        return this.m_point_count;
    }

    int getPathCount() {
        return this.m_path_count;
    }

    Envelope2D getEnvelope2D() {
        Envelope2D env = new Envelope2D();
        env.setEmpty();
        VertexIterator vert_iter = this.queryVertexIterator();
        Point2D pt = new Point2D();
        boolean b_first = true;
        int ivertex = vert_iter.next();
        while (ivertex != -1) {
            this.getXY(ivertex, pt);
            if (b_first) {
                env.merge(pt.x, pt.y);
            } else {
                env.mergeNE(pt.x, pt.y);
            }
            b_first = false;
            ivertex = vert_iter.next();
        }
        return env;
    }

    int getGeometryCount() {
        return this.m_geometryCount;
    }

    int addGeometry(Geometry geometry) {
        Geometry.Type gt = geometry.getType();
        if (Geometry.isMultiPath(gt.value())) {
            return this.addMultiPath_((MultiPath)geometry);
        }
        if (gt == Geometry.Type.MultiPoint) {
            return this.addMultiPoint_((MultiPoint)geometry);
        }
        if (gt == Geometry.Type.Point) {
            return this.addPoint_((Point)geometry);
        }
        if (gt == Geometry.Type.Envelope) {
            Polygon poly = new Polygon();
            poly.addEnvelope((Envelope)geometry, false);
            return this.addMultiPath_(poly);
        }
        throw GeometryException.GeometryInternalError();
    }

    void appendGeometry(int dstGeometry, Geometry srcGeometry) {
        Geometry.Type gt = srcGeometry.getType();
        if (Geometry.isMultiPath(gt.value())) {
            this.appendMultiPath_(dstGeometry, (MultiPath)srcGeometry);
            return;
        }
        if (gt.value() == 550) {
            this.appendMultiPoint_(dstGeometry, (MultiPoint)srcGeometry);
            return;
        }
        throw GeometryException.GeometryInternalError();
    }

    int addPathFromMultiPath(MultiPath multi_path, int ipath, boolean as_polygon) {
        int newgeom = this.createGeometry(as_polygon ? Geometry.Type.Polygon : Geometry.Type.Polyline, multi_path.getDescription());
        MultiPathImpl mp_impl = (MultiPathImpl)multi_path._getImpl();
        if (multi_path.getPathSize(ipath) < 2) {
            return newgeom;
        }
        this.m_vertices_mp.add(multi_path, multi_path.getPathStart(ipath), mp_impl.getPathEnd(ipath));
        this.m_xy_stream = (AttributeStreamOfDbl)this.m_vertices.getAttributeStreamRef(0);
        int path = this.insertPath(newgeom, -1);
        this.setClosedPath(path, mp_impl.isClosedPath(ipath) || as_polygon);
        boolean b_some_segments = this.m_segments != null && mp_impl.getSegmentFlagsStreamRef() != null;
        int iend = mp_impl.getPathEnd(ipath);
        for (int ivertex = mp_impl.getPathStart(ipath); ivertex < iend; ++ivertex) {
            int vertex = this.insertVertex_(path, -1, null);
            if (!b_some_segments) continue;
            int vindex = this.getVertexIndex(vertex);
            if ((mp_impl.getSegmentFlags(ivertex) & 1) != 0) {
                this.setSegmentToIndex_(vindex, null);
                continue;
            }
            SegmentBuffer seg_buffer = new SegmentBuffer();
            mp_impl.getSegment(ivertex, seg_buffer, true);
            this.setSegmentToIndex_(vindex, seg_buffer.get());
        }
        return newgeom;
    }

    Geometry getGeometry(int geometry) {
        int gt = this.getGeometryType(geometry);
        Geometry geom = InternalUtils.createGeometry(gt, this.m_vertices_mp.getDescription());
        int point_count = this.getPointCount(geometry);
        if (point_count == 0) {
            return geom;
        }
        if (Geometry.isMultiPath(gt)) {
            MultiPathImpl mp_impl = (MultiPathImpl)geom._getImpl();
            int path_count = this.getPathCount(geometry);
            AttributeStreamOfInt32 parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(path_count + 1);
            AttributeStreamOfInt8 pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(path_count + 1, (byte)0);
            VertexDescription description = geom.getDescription();
            Point2D pt = new Point2D();
            int nattrib = description.getAttributeCount();
            for (int iattrib = 0; iattrib < nattrib; ++iattrib) {
                int semantics = description.getSemantics(iattrib);
                int ncomps = VertexDescription.getComponentCount(semantics);
                AttributeStreamBase dst_stream = AttributeStreamBase.createAttributeStreamWithSemantics(semantics, point_count);
                AttributeStreamBase src_stream = this.m_vertices.getAttributeStreamRef(semantics);
                int dst_index = 0;
                int ipath = 0;
                int nvert = 0;
                int path = this.getFirstPath(geometry);
                while (path != -1) {
                    byte flag_mask = 0;
                    if (this.isClosedPath(path)) {
                        flag_mask = (byte)(flag_mask | 1);
                    } else assert (gt != 1736);
                    if (this.isExterior(path)) {
                        flag_mask = (byte)(flag_mask | 4);
                    }
                    if (flag_mask != 0) {
                        pathFlags.setBits(ipath, flag_mask);
                    }
                    int path_size = this.getPathSize(path);
                    parts.write(ipath++, nvert);
                    nvert += path_size;
                    if (semantics == 0) {
                        AttributeStreamOfDbl src_stream_dbl = (AttributeStreamOfDbl)src_stream;
                        AttributeStreamOfDbl dst_stream_dbl = (AttributeStreamOfDbl)dst_stream;
                        int vertex = this.getFirstVertex(path);
                        while (dst_index < nvert) {
                            int src_index = this.getVertexIndex(vertex);
                            src_stream_dbl.read(src_index * 2, pt);
                            dst_stream_dbl.write(dst_index * 2, pt);
                            vertex = this.getNextVertex(vertex);
                            ++dst_index;
                        }
                    } else {
                        int vertex = this.getFirstVertex(path);
                        while (dst_index < nvert) {
                            int src_index = this.getVertexIndex(vertex);
                            for (int icomp = 0; icomp < ncomps; ++icomp) {
                                double d = src_stream.readAsDbl(src_index * ncomps + icomp);
                                dst_stream.writeAsDbl(dst_index * ncomps + icomp, d);
                            }
                            vertex = this.getNextVertex(vertex);
                            ++dst_index;
                        }
                    }
                    path = this.getNextPath(path);
                }
                assert (nvert == point_count);
                assert (ipath == path_count);
                mp_impl.setAttributeStreamRef(semantics, dst_stream);
                parts.write(path_count, point_count);
            }
            mp_impl.setPathFlagsStreamRef(pathFlags);
            mp_impl.setPathStreamRef(parts);
            mp_impl.notifyModified(0xFFFFFF);
        } else if (gt == 550) {
            MultiPointImpl mp_impl = (MultiPointImpl)geom._getImpl();
            VertexDescription description = geom.getDescription();
            mp_impl.reserveImpl_(point_count);
            mp_impl.resizeNoInit(point_count);
            int nattrib = description.getAttributeCount();
            for (int iattrib = 0; iattrib < nattrib; ++iattrib) {
                int semantics = description.getSemantics(iattrib);
                int ncomps = VertexDescription.getComponentCount(semantics);
                AttributeStreamBase dst_stream = mp_impl.getAttributeStreamRef(semantics);
                AttributeStreamBase src_stream = this.m_vertices.getAttributeStreamRef(semantics);
                assert (this.getPathCount(geometry) == 1);
                int path = this.getFirstPath(geometry);
                int path_size = this.getPathSize(path);
                int vertex = this.getFirstVertex(path);
                for (int dst_index = 0; dst_index < path_size; ++dst_index) {
                    int src_index = this.getVertexIndex(vertex);
                    for (int icomp = 0; icomp < ncomps; ++icomp) {
                        double d = src_stream.readAsDbl(src_index * ncomps + icomp);
                        dst_stream.writeAsDbl(dst_index * ncomps + icomp, d);
                    }
                    vertex = this.getNextVertex(vertex);
                }
                mp_impl.setAttributeStreamRef(semantics, dst_stream);
            }
            mp_impl.notifyModified(0xFFFFFF);
        } else assert (false);
        return geom;
    }

    int createGeometry(Geometry.Type geometry_type) {
        return this.createGeometry(geometry_type, VertexDescriptionDesignerImpl.getDefaultDescriptor2D());
    }

    int removeGeometry(int geometry) {
        int path = this.getFirstPath(geometry);
        while (path != -1) {
            path = this.removePath(path);
        }
        int prev = this.getPrevGeometry(geometry);
        int next = this.getNextGeometry(geometry);
        if (prev != -1) {
            this.setNextGeometry_(prev, next);
        } else {
            this.m_first_geometry = next;
        }
        if (next != -1) {
            this.setPrevGeometry_(next, prev);
        } else {
            this.m_last_geometry = prev;
        }
        this.freeGeometry_(geometry);
        return next;
    }

    int createGeometry(Geometry.Type geometry_type, VertexDescription description) {
        int newgeom = this.newGeometry_(geometry_type.value());
        if (this.m_vertices == null) {
            this.m_vertices_mp = new MultiPoint(description);
            this.m_vertices = (MultiPointImpl)this.m_vertices_mp._getImpl();
        } else {
            this.m_vertices_mp.mergeVertexDescription(description);
        }
        this.m_vertex_description = this.m_vertices_mp.getDescription();
        boolean bl = this.m_b_has_attributes = this.m_vertex_description.getAttributeCount() > 1;
        if (this.m_first_geometry == -1) {
            this.m_first_geometry = newgeom;
            this.m_last_geometry = newgeom;
        } else {
            this.setPrevGeometry_(newgeom, this.m_last_geometry);
            this.setNextGeometry_(this.m_last_geometry, newgeom);
            this.m_last_geometry = newgeom;
        }
        return newgeom;
    }

    int getFirstGeometry() {
        return this.m_first_geometry;
    }

    int getNextGeometry(int geom) {
        return this.m_geometry_index_list.getField(geom, 1);
    }

    int getPrevGeometry(int geom) {
        return this.m_geometry_index_list.getField(geom, 0);
    }

    int getGeometryType(int geom) {
        return this.m_geometry_index_list.getField(geom, 2) & Integer.MAX_VALUE;
    }

    void setGeometryUserIndex(int geom, int index, int value) {
        AttributeStreamOfInt32 stream = this.m_geometry_indices.get(index);
        int pindex = this.getGeometryIndex_(geom);
        if (pindex >= stream.size()) {
            stream.resize(Math.max((int)((double)pindex * 1.25), 16), -1.0);
        }
        stream.write(pindex, value);
    }

    int getGeometryUserIndex(int geom, int index) {
        AttributeStreamOfInt32 stream;
        int pindex = this.getGeometryIndex_(geom);
        if (pindex < (stream = this.m_geometry_indices.get(index)).size()) {
            return stream.read(pindex);
        }
        return -1;
    }

    int createGeometryUserIndex() {
        if (this.m_geometry_indices == null) {
            this.m_geometry_indices = new ArrayList(4);
        }
        for (int i = 0; i < this.m_geometry_indices.size(); ++i) {
            if (this.m_geometry_indices.get(i) != null) continue;
            this.m_geometry_indices.set(i, (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0));
            return i;
        }
        this.m_geometry_indices.add((AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0));
        return this.m_geometry_indices.size() - 1;
    }

    void removeGeometryUserIndex(int index) {
        this.m_geometry_indices.set(index, null);
    }

    int getFirstPath(int geometry) {
        return this.m_geometry_index_list.getField(geometry, 3);
    }

    int getLastPath(int geometry) {
        return this.m_geometry_index_list.getField(geometry, 4);
    }

    int getPointCount(int geom) {
        return this.m_geometry_index_list.getField(geom, 5);
    }

    int getPathCount(int geom) {
        return this.m_geometry_index_list.getField(geom, 6);
    }

    int filterClosePoints(double tolerance, boolean b_remove_last_vertices, boolean only_polygons) {
        return this.filterClosePoints(tolerance, b_remove_last_vertices, only_polygons, -1);
    }

    int filterClosePoints(double tolerance, boolean b_remove_last_vertices, boolean only_polygons, int geometry_) {
        int geometry;
        int res = 0;
        int n = geometry = geometry_ == -1 ? this.getFirstGeometry() : geometry_;
        while (geometry != -1) {
            int gt = this.getGeometryType(geometry);
            if (Geometry.isMultiPath(gt) && (!only_polygons || gt == 1736)) {
                boolean b_polygon = this.getGeometryType(geometry) == 1736;
                int path = this.getFirstPath(geometry);
                while (path != -1) {
                    int vertex;
                    int next;
                    int vertex2 = this.getFirstVertex(path);
                    for (int vertex_counter = 0; vertex_counter < this.getPathSize(path) / 2 && (next = this.getNextVertex(vertex2)) != -1; ++vertex_counter) {
                        int vindex = this.getVertexIndex(vertex2);
                        Segment seg = this.getSegmentFromIndex_(vindex);
                        double length = 0.0;
                        if (seg != null) {
                            length = seg.calculateLength2D();
                        } else {
                            int vindex_next = this.getVertexIndex(next);
                            length = this.m_vertices._getShortestDistance(vindex, vindex_next);
                        }
                        if (length <= tolerance) {
                            if (length == 0.0) {
                                if (res == 0) {
                                    res = -1;
                                }
                            } else {
                                res = 1;
                            }
                            if (next == this.getLastVertex(path)) continue;
                            this.transferAllDataToTheVertex(next, vertex2);
                            this.removeVertex(next, true);
                            continue;
                        }
                        vertex2 = this.getNextVertex(vertex2);
                    }
                    int first_vertex = this.getFirstVertex(path);
                    int n2 = vertex = this.isClosedPath(path) ? first_vertex : this.getLastVertex(path);
                    while (this.getPathSize(path) > 0) {
                        int prev = this.getPrevVertex(vertex);
                        if (prev != -1) {
                            int vindex_prev = this.getVertexIndex(prev);
                            Segment seg = this.getSegmentFromIndex_(vindex_prev);
                            double length = 0.0;
                            if (seg != null) {
                                length = seg.calculateLength2D();
                            } else {
                                int vindex = this.getVertexIndex(vertex);
                                length = this.m_vertices._getShortestDistance(vindex, vindex_prev);
                            }
                            if (length <= tolerance) {
                                if (length == 0.0) {
                                    if (res == 0) {
                                        res = -1;
                                    }
                                } else {
                                    res = 1;
                                }
                                this.transferAllDataToTheVertex(prev, vertex);
                                this.removeVertex(prev, false);
                                if (first_vertex != prev) continue;
                                first_vertex = this.getFirstVertex(path);
                                continue;
                            }
                            if ((vertex = this.getPrevVertex(vertex)) != first_vertex) continue;
                            break;
                        }
                        this.removeVertex(vertex, true);
                        if (res != 0) break;
                        res = -1;
                        break;
                    }
                    int path_size = this.getPathSize(path);
                    if (b_remove_last_vertices && (b_polygon ? path_size < 3 : path_size < 2)) {
                        path = this.removePath(path);
                        res = path_size > 0 ? 1 : (res == 0 ? -1 : res);
                        continue;
                    }
                    path = this.getNextPath(path);
                }
            }
            geometry = geometry_ == -1 ? this.getNextGeometry(geometry) : -1;
        }
        return res;
    }

    boolean hasDegenerateSegments(double tolerance) {
        int geometry = this.getFirstGeometry();
        while (geometry != -1) {
            if (Geometry.isMultiPath(this.getGeometryType(geometry))) {
                boolean b_polygon = this.getGeometryType(geometry) == 1736;
                int path = this.getFirstPath(geometry);
                while (path != -1) {
                    int next;
                    int path_size = this.getPathSize(path);
                    if (b_polygon ? path_size < 3 : path_size < 2) {
                        return true;
                    }
                    int vertex = this.getFirstVertex(path);
                    for (int index = 0; index < path_size && (next = this.getNextVertex(vertex)) != -1; ++index) {
                        int vindex = this.getVertexIndex(vertex);
                        Segment seg = this.getSegmentFromIndex_(vindex);
                        double length = 0.0;
                        if (seg != null) {
                            length = seg.calculateLength2D();
                        } else {
                            int vindex_next = this.getVertexIndex(next);
                            length = this.m_vertices._getShortestDistance(vindex, vindex_next);
                        }
                        if (length <= tolerance) {
                            return true;
                        }
                        vertex = next;
                    }
                    path = this.getNextPath(path);
                }
            }
            geometry = this.getNextGeometry(geometry);
        }
        return false;
    }

    void transferAllDataToTheVertex(int from_vertex, int to_vertex) {
        int vindexFrom = this.getVertexIndex(from_vertex);
        int vindexTo = this.getVertexIndex(to_vertex);
        if (this.m_weights != null) {
            double weight = this.m_weights.read(vindexFrom);
            this.m_weights.write(vindexTo, weight);
        }
        if (this.m_b_has_attributes) {
            // empty if block
        }
        if (this.m_indices != null) {
            int n = this.m_indices.size();
            for (int i = 0; i < n; ++i) {
                int value;
                if (i == this.m_selection_index || this.m_indices.get(i) == null || (value = this.getUserIndex(from_vertex, i)) == -1) continue;
                this.setUserIndex(to_vertex, i, value);
            }
        }
        if (this.selected(from_vertex)) {
            this.select(to_vertex);
        }
    }

    int splitSegment(int origin_vertex, double[] split_scalars, int split_count) {
        return this.splitSegmentAxisAware(origin_vertex, split_scalars, split_count, null, -1);
    }

    int splitSegment(int origin_vertex, double[] split_scalars, int split_count, Point2D[] split_vertices) {
        return this.splitSegmentAxisAware(origin_vertex, split_scalars, split_count, split_vertices, -1);
    }

    int splitSegmentAxisAware(int origin_vertex, double[] split_scalars, int split_count, Point2D[] split_vertices, int axis) {
        int actual_splits = 0;
        int next_vertex = this.getNextVertex(origin_vertex);
        if (next_vertex == -1) {
            throw GeometryException.GeometryInternalError();
        }
        assert (axis == -1 || split_vertices != null);
        int vindex = this.getVertexIndex(origin_vertex);
        int vindex_next = this.getVertexIndex(next_vertex);
        Segment seg = this.getSegmentFromIndex_(vindex);
        double seg_length = seg == null ? this.m_vertices._getShortestDistance(vindex, vindex_next) : seg.calculateLength2D();
        double told = 0.0;
        int path = this.getPathFromVertex(origin_vertex);
        for (int i = 0; i < split_count; ++i) {
            double t = split_scalars[i];
            if (told < t && t < 1.0) {
                double f = t;
                if (seg != null) {
                    f = seg_length > 0.0 ? seg._calculateSubLength(t) / seg_length : 0.0;
                }
                this.m_vertices._interpolateTwoVertices(vindex, vindex_next, f, this.getHelperPoint_());
                int inserted_vertex = this.insertVertex_(path, next_vertex, this.getHelperPoint_(), true);
                ++actual_splits;
                if (seg != null) {
                    Segment subseg = seg.cut(told, t);
                    if (split_vertices != null) {
                        if (i > 0) {
                            subseg.setStartXY(split_vertices[i - 1]);
                        }
                        subseg.setEndXY(split_vertices[i]);
                    }
                    int prev_vertex = this.getPrevVertex(inserted_vertex);
                    int vindex_prev = this.getVertexIndex(prev_vertex);
                    this.setSegmentToIndex_(vindex_prev, subseg);
                    this.setXY(inserted_vertex, subseg.getEndX(), subseg.getEndY());
                    if (i == split_count - 1 || split_scalars[i + 1] == 1.0) {
                        Segment subseg_end = seg.cut(t, 1.0);
                        if (split_vertices != null) {
                            subseg_end.setStartXY(split_vertices[i]);
                        }
                        int vindex_inserted = this.getVertexIndex(inserted_vertex);
                        this.setSegmentToIndex_(vindex_inserted, subseg_end);
                    }
                }
            }
            told = t;
        }
        return actual_splits;
    }

    void interpolateAttributesForClosedPath(int path, int from_vertex, int to_vertex) {
        assert (this.isClosedPath(path));
        if (!this.m_b_has_attributes) {
            return;
        }
        double sub_length = this.calculateSubLength2D(path, from_vertex, to_vertex);
        if (sub_length == 0.0) {
            return;
        }
        int nattr = this.m_vertex_description.getAttributeCount();
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_vertex_description.getSemantics(iattr);
            int interpolation = VertexDescription.getInterpolation(semantics);
            if (interpolation == 2) continue;
            int components = VertexDescription.getComponentCount(semantics);
            for (int ordinate = 0; ordinate < components; ++ordinate) {
                this.interpolateAttributesForClosedPath_(semantics, path, from_vertex, to_vertex, sub_length, ordinate);
            }
        }
    }

    double calculateSubLength2D(int path, int from_vertex, int to_vertex) {
        int shape_from_index = this.getVertexIndex(from_vertex);
        int shape_to_index = this.getVertexIndex(to_vertex);
        if (shape_from_index < 0 || shape_to_index > this.getTotalPointCount() - 1) {
            throw new IllegalArgumentException("invalid call");
        }
        if (shape_from_index > shape_to_index && !this.isClosedPath(path)) {
            throw new IllegalArgumentException("cannot iterate across an open path");
        }
        double sub_length = 0.0;
        int vertex = from_vertex;
        while (vertex != to_vertex) {
            int vertex_index = this.getVertexIndex(vertex);
            Segment segment = this.getSegmentFromIndex_(vertex_index);
            if (segment != null) {
                sub_length += segment.calculateLength2D();
            } else {
                int next_vertex_index = this.getVertexIndex(this.getNextVertex(vertex));
                sub_length += this.m_vertices._getShortestDistance(vertex_index, next_vertex_index);
            }
            vertex = this.getNextVertex(vertex);
        }
        return sub_length;
    }

    void setPoint(int vertex, Point new_coord) {
        int vindex_p;
        Segment seg_p;
        int prev;
        int vindex = this.getVertexIndex(vertex);
        this.m_vertices.setPointByVal(vindex, new_coord);
        Segment seg = this.getSegmentFromIndex_(vindex);
        if (seg != null) {
            seg.setStart(new_coord);
        }
        if ((prev = this.getPrevVertex(vertex)) != -1 && (seg_p = this.getSegmentFromIndex_(vindex_p = this.getVertexIndex(prev))) != null) {
            seg.setEnd(new_coord);
        }
    }

    void queryPoint(int vertex, Point point) {
        int vindex = this.getVertexIndex(vertex);
        this.m_vertices.getPointByVal(vindex, point);
    }

    void setXY(int vertex, Point2D new_coord) {
        this.setXY(vertex, new_coord.x, new_coord.y);
    }

    void setXY(int vertex, double new_x, double new_y) {
        int vindex_p;
        Segment seg_p;
        int prev;
        int vindex = this.getVertexIndex(vertex);
        this.m_vertices.setXY(vindex, new_x, new_y);
        Segment seg = this.getSegmentFromIndex_(vindex);
        if (seg != null) {
            seg.setStartXY(new_x, new_y);
        }
        if ((prev = this.getPrevVertex(vertex)) != -1 && (seg_p = this.getSegmentFromIndex_(vindex_p = this.getVertexIndex(prev))) != null) {
            seg.setEndXY(new_x, new_y);
        }
    }

    Point2D getXY(int vertex) {
        Point2D pt = new Point2D();
        this.getXY(vertex, pt);
        return pt;
    }

    void getXY(int vertex, Point2D ptOut) {
        int vindex = this.getVertexIndex(vertex);
        this.m_xy_stream.read(vindex * 2, ptOut);
    }

    void getXYWithIndex(int index, Point2D ptOut) {
        this.m_xy_stream.read(2 * index, ptOut);
    }

    double getAttributeAsDbl(int semantics, int vertex, int ordinate) {
        return this.m_vertices.getAttributeAsDbl(semantics, this.getVertexIndex(vertex), ordinate);
    }

    void setAttribute(int semantics, int vertex, int ordinate, double value) {
        this.m_vertices.setAttribute(semantics, this.getVertexIndex(vertex), ordinate, value);
    }

    void setAttribute(int semantics, int vertex, int ordinate, int value) {
        this.m_vertices.setAttribute(semantics, this.getVertexIndex(vertex), ordinate, value);
    }

    VertexDescription getVertexDescription() {
        return this.m_vertex_description;
    }

    int getMinPathVertexY(int path) {
        int first_vert;
        int minv = first_vert = this.getFirstVertex(path);
        int vert = this.getNextVertex(first_vert);
        while (vert != -1 && vert != first_vert) {
            if (this.compareVerticesSimpleY_(vert, minv) < 0) {
                minv = vert;
            }
            vert = this.getNextVertex(vert);
        }
        return minv;
    }

    int getVertexIndex(int vertex) {
        return this.m_vertex_index_list.getField(vertex, 0);
    }

    double getY(int vertex) {
        int vindex = this.getVertexIndex(vertex);
        return this.m_xy_stream.read(2 * vindex + 1);
    }

    boolean isEqualXY(int vertex_1, int vertex_2) {
        int vindex1 = this.getVertexIndex(vertex_1);
        int vindex2 = this.getVertexIndex(vertex_2);
        return this.m_xy_stream.isEqualPoints(vindex1 * 2, vindex2 * 2);
    }

    boolean isEqualXY(int vertex, Point2D pt) {
        int vindex = this.getVertexIndex(vertex);
        return this.m_xy_stream.isEqualPoints(2 * vindex, pt);
    }

    void setWeight(int vertex, double weight) {
        int vindex;
        if (weight < 1.0) {
            weight = 1.0;
        }
        if (this.m_weights == null) {
            if (weight == 1.0) {
                return;
            }
            this.m_weights = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(this.m_vertices.getPointCount(), 1.0);
        }
        if ((vindex = this.getVertexIndex(vertex)) >= this.m_weights.size()) {
            this.m_weights.resize(vindex + 1, 1.0);
        }
        this.m_weights.write(vindex, weight);
    }

    double getWeight(int vertex) {
        int vindex = this.getVertexIndex(vertex);
        if (this.m_weights == null || vindex >= this.m_weights.size()) {
            return 1.0;
        }
        return this.m_weights.read(vindex);
    }

    void removeWeights() {
        this.m_weights = null;
    }

    void setUserIndex(int vertex, int index, int value) {
        AttributeStreamOfInt32 stream = this.m_indices.get(index);
        assert (this.getPrevVertex(vertex) != -2125315821);
        int vindex = this.getVertexIndex(vertex);
        if (stream.size() < this.m_vertices.getPointCount()) {
            stream.resize(this.m_vertices.getPointCount(), -1.0);
        }
        stream.write(vindex, value);
    }

    int getUserIndex(int vertex, int index) {
        AttributeStreamOfInt32 stream;
        int vindex = this.getVertexIndex(vertex);
        if (vindex < (stream = this.m_indices.get(index)).size()) {
            int val = stream.read(vindex);
            return val;
        }
        return -1;
    }

    int createUserIndex() {
        if (this.m_indices == null) {
            this.m_indices = new ArrayList(0);
        }
        for (int i = 0; i < this.m_indices.size(); ++i) {
            if (this.m_indices.get(i) != null) continue;
            this.m_indices.set(i, (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0, -1));
            return i;
        }
        this.m_indices.add((AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0, -1));
        return this.m_indices.size() - 1;
    }

    void removeUserIndex(int index) {
        this.m_indices.set(index, null);
    }

    Segment getSegment(int vertex) {
        if (this.m_segments != null) {
            int vindex = this.getVertexIndex(vertex);
            return this.m_segments.get(vindex);
        }
        return null;
    }

    boolean queryLineConnector(int vertex, Line line) {
        return this.queryLineConnector(vertex, line, false);
    }

    boolean queryLineConnector(int vertex, Line line, boolean ignoreAttributes) {
        int next = this.getNextVertex(vertex);
        if (next == -1) {
            return false;
        }
        if (ignoreAttributes || !this.m_b_has_attributes) {
            Point2D pt = new Point2D();
            this.getXY(vertex, pt);
            line.setStartXY(pt);
            this.getXY(next, pt);
            line.setEndXY(pt);
        } else {
            Point pt = new Point();
            this.queryPoint(vertex, pt);
            line.setStart(pt);
            this.queryPoint(next, pt);
            line.setEnd(pt);
        }
        return true;
    }

    int insertPath(int geometry, int before_path) {
        int prev = -1;
        if (before_path != -1) {
            if (geometry != this.getGeometryFromPath(before_path)) {
                throw GeometryException.GeometryInternalError();
            }
            prev = this.getPrevPath(before_path);
        } else {
            prev = this.getLastPath(geometry);
        }
        int newpath = this.newPath_(geometry);
        if (before_path != -1) {
            this.setPrevPath_(before_path, newpath);
        }
        this.setNextPath_(newpath, before_path);
        this.setPrevPath_(newpath, prev);
        if (prev != -1) {
            this.setNextPath_(prev, newpath);
        } else {
            this.setFirstPath_(geometry, newpath);
        }
        if (before_path == -1) {
            this.setLastPath_(geometry, newpath);
        }
        this.setGeometryPathCount_(geometry, this.getPathCount(geometry) + 1);
        return newpath;
    }

    int insertClosedPath_(int geometry, int before_path, int first_vertex, int checked_vertex, boolean[] contains_checked_vertex) {
        int path = this.insertPath(geometry, -1);
        int path_size = 0;
        int vertex = first_vertex;
        boolean contains = false;
        while (true) {
            if (vertex == checked_vertex) {
                contains = true;
            }
            this.setPathToVertex_(vertex, path);
            ++path_size;
            int next = this.getNextVertex(vertex);
            assert (this.getNextVertex(this.getPrevVertex(vertex)) == vertex);
            if (next == first_vertex) break;
            vertex = next;
        }
        this.setClosedPath(path, true);
        this.setPathSize_(path, path_size);
        if (contains) {
            first_vertex = checked_vertex;
        }
        this.setFirstVertex_(path, first_vertex);
        this.setLastVertex_(path, this.getPrevVertex(first_vertex));
        this.setRingAreaValid_(path, false);
        if (contains_checked_vertex != null) {
            contains_checked_vertex[0] = contains;
        }
        return path;
    }

    int removePath(int path) {
        int prev = this.getPrevPath(path);
        int next = this.getNextPath(path);
        int geometry = this.getGeometryFromPath(path);
        if (prev != -1) {
            this.setNextPath_(prev, next);
        } else {
            this.setFirstPath_(geometry, next);
        }
        if (next != -1) {
            this.setPrevPath_(next, prev);
        } else {
            this.setLastPath_(geometry, prev);
        }
        this.clearPath(path);
        this.setGeometryPathCount_(geometry, this.getPathCount(geometry) - 1);
        this.freePath_(path);
        return next;
    }

    void clearPath(int path) {
        int first_vertex = this.getFirstVertex(path);
        if (first_vertex != -1) {
            int vertex = first_vertex;
            int n = this.getPathSize(path);
            for (int i = 0; i < n; ++i) {
                int v = vertex;
                vertex = this.getNextVertex(vertex);
                this.freeVertex_(v);
            }
            int geometry = this.getGeometryFromPath(path);
            this.setGeometryVertexCount_(geometry, this.getPointCount(geometry) - this.getPathSize(path));
        }
        this.setPathSize_(path, 0);
    }

    int getNextPath(int currentPath) {
        return this.m_path_index_list.getField(currentPath, 2);
    }

    int getPrevPath(int currentPath) {
        return this.m_path_index_list.getField(currentPath, 1);
    }

    int getPathSize(int path) {
        return this.m_path_index_list.getField(path, 3);
    }

    boolean isClosedPath(int path) {
        return (this.getPathFlags_(path) & 1) != 0;
    }

    void setClosedPath(int path, boolean b_yes_no) {
        if (this.isClosedPath(path) == b_yes_no) {
            return;
        }
        if (this.getPathSize(path) > 0) {
            int first = this.getFirstVertex(path);
            int last = this.getLastVertex(path);
            if (b_yes_no) {
                this.setNextVertex_(last, first);
                this.setPrevVertex_(first, last);
                int vindex = this.getVertexIndex(last);
                this.setSegmentToIndex_(vindex, null);
            } else {
                this.setNextVertex_(last, -1);
                this.setPrevVertex_(first, -1);
                int vindex = this.getVertexIndex(last);
                this.setSegmentToIndex_(vindex, null);
            }
        }
        int oldflags = this.getPathFlags_(path);
        int flags = (oldflags | 1) - 1;
        this.setPathFlags_(path, flags | (b_yes_no ? 1 : 0));
    }

    void closeAllPaths(int geometry) {
        if (this.getGeometryType(geometry) == 1736) {
            return;
        }
        if (!Geometry.isLinear(this.getGeometryType(geometry))) {
            throw GeometryException.GeometryInternalError();
        }
        int path = this.getFirstPath(geometry);
        while (path != -1) {
            this.setClosedPath(path, true);
            path = this.getNextPath(path);
        }
    }

    int getGeometryFromPath(int path) {
        return this.m_path_index_list.getField(path, 7);
    }

    boolean isExterior(int path) {
        return (this.getPathFlags_(path) & 2) != 0;
    }

    void setExterior(int path, boolean b_yes_no) {
        int oldflags = this.getPathFlags_(path);
        int flags = (oldflags | 2) - 2;
        this.setPathFlags_(path, flags | (b_yes_no ? 2 : 0));
    }

    double getRingArea(int path) {
        if (this.isRingAreaValid_(path)) {
            return this.m_path_areas.get(this.getPathIndex_(path));
        }
        Line line = new Line();
        int vertex = this.getFirstVertex(path);
        if (vertex == -1) {
            return 0.0;
        }
        Point2D pt0 = new Point2D();
        this.getXY(vertex, pt0);
        double area = 0.0;
        int n = this.getPathSize(path);
        for (int i = 0; i < n; ++i) {
            block7: {
                Segment seg;
                block6: {
                    seg = this.getSegment(vertex);
                    if (seg != null) break block6;
                    if (!this.queryLineConnector(vertex, line)) break block7;
                    seg = line;
                }
                double a = seg._calculateArea2DHelper(pt0.x, pt0.y);
                area += a;
            }
            vertex = this.getNextVertex(vertex);
        }
        this.setRingAreaValid_(path, true);
        this.m_path_areas.set(this.getPathIndex_(path), area);
        return area;
    }

    void setPathUserIndex(int path, int index, int value) {
        AttributeStreamOfInt32 stream = this.m_pathindices.get(index);
        int pindex = this.getPathIndex_(path);
        if (stream.size() < this.m_path_areas.size()) {
            stream.resize(this.m_path_areas.size(), -1.0);
        }
        stream.write(pindex, value);
    }

    int getPathUserIndex(int path, int index) {
        AttributeStreamOfInt32 stream;
        int pindex = this.getPathIndex_(path);
        if (pindex < (stream = this.m_pathindices.get(index)).size()) {
            return stream.read(pindex);
        }
        return -1;
    }

    int createPathUserIndex() {
        if (this.m_pathindices == null) {
            this.m_pathindices = new ArrayList(0);
        }
        for (int i = 0; i < this.m_pathindices.size(); ++i) {
            if (this.m_pathindices.get(i) != null) continue;
            this.m_pathindices.set(i, (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0));
            return i;
        }
        this.m_pathindices.add((AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0));
        return this.m_pathindices.size() - 1;
    }

    void removePathUserIndex(int index) {
        this.m_pathindices.set(index, null);
    }

    void movePath(int geom, int before_path, int path_to_move) {
        if (path_to_move == -1) {
            throw new IllegalArgumentException();
        }
        if (before_path == path_to_move) {
            return;
        }
        int next = this.getNextPath(path_to_move);
        int prev = this.getPrevPath(path_to_move);
        int geom_src = this.getGeometryFromPath(path_to_move);
        if (prev == -1) {
            this.setFirstPath_(geom_src, next);
        } else {
            this.setNextPath_(prev, next);
        }
        if (next == -1) {
            this.setLastPath_(geom_src, prev);
        } else {
            this.setPrevPath_(next, prev);
        }
        this.setGeometryVertexCount_(geom_src, this.getPointCount(geom_src) - this.getPathSize(path_to_move));
        this.setGeometryPathCount_(geom_src, this.getPathCount(geom_src) - 1);
        prev = before_path == -1 ? this.getLastPath(geom) : this.getPrevPath(before_path);
        this.setPrevPath_(path_to_move, prev);
        this.setNextPath_(path_to_move, before_path);
        if (before_path == -1) {
            this.setLastPath_(geom, path_to_move);
        } else {
            this.setPrevPath_(before_path, path_to_move);
        }
        if (prev == -1) {
            this.setFirstPath_(geom, path_to_move);
        } else {
            this.setNextPath_(prev, path_to_move);
        }
        this.setGeometryVertexCount_(geom, this.getPointCount(geom) + this.getPathSize(path_to_move));
        this.setGeometryPathCount_(geom, this.getPathCount(geom) + 1);
        this.setPathGeometry_(path_to_move, geom);
    }

    int addVertex(int path, int vertex) {
        this.m_vertices.getPointByVal(this.getVertexIndex(vertex), this.getHelperPoint_());
        return this.insertVertex_(path, -1, this.getHelperPoint_());
    }

    int removeVertex(int vertex, boolean b_left_segment) {
        int path = this.getPathFromVertex(vertex);
        int prev = this.getPrevVertex(vertex);
        int next = this.getNextVertex(vertex);
        if (prev != -1) {
            this.setNextVertex_(prev, next);
        }
        int path_size = this.getPathSize(path);
        if (vertex == this.getFirstVertex(path)) {
            this.setFirstVertex_(path, path_size > 1 ? next : -1);
        }
        if (next != -1) {
            this.setPrevVertex_(next, prev);
        }
        if (vertex == this.getLastVertex(path)) {
            this.setLastVertex_(path, path_size > 1 ? prev : -1);
        }
        if (prev != -1 && next != -1) {
            int vindex_prev = this.getVertexIndex(prev);
            int vindex_next = this.getVertexIndex(next);
            if (b_left_segment) {
                Segment seg = this.getSegmentFromIndex_(vindex_prev);
                if (seg != null) {
                    Point2D pt = new Point2D();
                    this.m_vertices.getXY(vindex_next, pt);
                    seg.setEndXY(pt);
                }
            } else {
                int vindex_erased = this.getVertexIndex(vertex);
                Segment seg = this.getSegmentFromIndex_(vindex_erased);
                this.setSegmentToIndex_(vindex_prev, seg);
                if (seg != null) {
                    Point2D pt = this.m_vertices.getXY(vindex_prev);
                    seg.setStartXY(pt);
                }
            }
        }
        this.setPathSize_(path, path_size - 1);
        int geometry = this.getGeometryFromPath(path);
        this.setGeometryVertexCount_(geometry, this.getPointCount(geometry) - 1);
        this.freeVertex_(vertex);
        return next;
    }

    int getFirstVertex(int path) {
        return this.m_path_index_list.getField(path, 4);
    }

    int getLastVertex(int path) {
        return this.m_path_index_list.getField(path, 5);
    }

    int getNextVertex(int currentVertex) {
        return this.m_vertex_index_list.getField(currentVertex, 2);
    }

    int getPrevVertex(int currentVertex) {
        return this.m_vertex_index_list.getField(currentVertex, 1);
    }

    int getPrevVertex(int currentVertex, int dir) {
        return dir > 0 ? this.m_vertex_index_list.getField(currentVertex, 1) : this.m_vertex_index_list.getField(currentVertex, 2);
    }

    int getNextVertex(int currentVertex, int dir) {
        return dir > 0 ? this.m_vertex_index_list.getField(currentVertex, 2) : this.m_vertex_index_list.getField(currentVertex, 1);
    }

    int getPathFromVertex(int vertex) {
        return this.m_vertex_index_list.getField(vertex, 3);
    }

    int addPoint(int path, Point point) {
        return this.insertVertex_(path, -1, point);
    }

    private static VertexIterator create_vi_(EditShape parent, int geometry, int path, int vertex, int first_vertex, int index, boolean b_skip_mulit_points, boolean selection, boolean one_geom) {
        return new VertexIterator(parent, geometry, path, vertex, first_vertex, index, b_skip_mulit_points, selection, one_geom);
    }

    VertexIterator queryVertexIterator() {
        return this.queryVertexIterator(false);
    }

    VertexIterator queryVertexIterator(VertexIterator source) {
        return new VertexIterator(source);
    }

    VertexIterator queryVertexIterator(boolean b_skip_multi_points) {
        return this.queryVertexIterator(b_skip_multi_points, -1);
    }

    VertexIterator queryVertexIterator(boolean b_skip_multi_points, int geometry_) {
        int geometry = -1;
        int path = -1;
        int vertex = -1;
        int first_vertex = -1;
        int index = 0;
        boolean bFound = false;
        int n = geometry = geometry_ != -1 ? geometry_ : this.getFirstGeometry();
        while (geometry != -1) {
            if (!b_skip_multi_points || Geometry.isMultiPath(this.getGeometryType(geometry))) {
                path = this.getFirstPath(geometry);
                while (path != -1) {
                    first_vertex = vertex = this.getFirstVertex(path);
                    index = 0;
                    if (vertex != -1) {
                        bFound = true;
                        break;
                    }
                    path = this.getNextPath(path);
                }
                if (bFound || geometry_ != -1) break;
            }
            geometry = this.getNextGeometry(geometry);
        }
        return EditShape.create_vi_(this, geometry, path, vertex, first_vertex, index, b_skip_multi_points, false, geometry_ != -1);
    }

    VertexIterator queryVertexIteratorOnSelection() {
        return this.queryVertexIteratorOnSelection(-1);
    }

    VertexIterator queryVertexIteratorOnSelection(int geometry) {
        if (this.m_selection) {
            return EditShape.create_vi_(this, geometry, -1, 0, -1, -1, false, true, geometry != -1);
        }
        return this.queryVertexIterator(false, geometry);
    }

    boolean hasSelection() {
        return this.m_selection;
    }

    boolean selected(int vertex) {
        return !this.m_selection || this.selected_(vertex);
    }

    private boolean selected_(int vertex) {
        assert (this.m_selection);
        assert (this.getUserIndex(vertex, this.m_selection_index) == -1 || this.m_selected_vertices.get(this.getUserIndex(vertex, this.m_selection_index)) == vertex);
        return this.getUserIndex(vertex, this.m_selection_index) >= 0;
    }

    void createEmptySelection() {
        if (this.m_selection) {
            this.removeSelection();
            this.createEmptySelection();
            return;
        }
        this.m_selection_index = this.createUserIndex();
        this.m_selection = true;
        this.m_selected_count = 0;
    }

    void removeSelection() {
        if (this.m_selection) {
            this.m_selected_vertices.clear(true);
            this.removeUserIndex(this.m_selection_index);
            this.m_selection_index = -1;
            this.m_selection = false;
            this.m_selected_count = 0;
        }
    }

    boolean select(int vertex) {
        if (this.selected(vertex)) {
            return true;
        }
        this.setUserIndex(vertex, this.m_selection_index, this.m_selected_vertices.size());
        this.m_selected_vertices.add(vertex);
        ++this.m_selected_count;
        return false;
    }

    void unselect(int vertex) {
        if (!this.m_selection) {
            return;
        }
        int index = this.getUserIndex(vertex, this.m_selection_index);
        if (index >= 0) {
            assert (this.m_selected_vertices.get(index) == vertex);
            this.m_selected_vertices.set(index, -1);
            this.setUserIndex(vertex, this.m_selection_index, -1);
            --this.m_selected_count;
        }
    }

    int getSelectedCount() {
        if (!this.m_selection) {
            return this.getTotalPointCount();
        }
        return this.m_selected_count;
    }

    void dbg_check_selection() {
        if (!this.m_selection) {
            GeometryException.releaseAssert(this.m_selection_index == -1);
            GeometryException.releaseAssert(this.m_selected_count == 0);
            return;
        }
        VertexIterator vi = this.queryVertexIterator();
        int i = 0;
        int v = vi.next();
        while (v != -1) {
            if (this.getUserIndex(v, this.m_selection_index) != -1) {
                GeometryException.releaseAssert(v == this.m_selected_vertices.get(this.getUserIndex(v, this.m_selection_index)));
                ++i;
            }
            v = vi.next();
        }
        GeometryException.releaseAssert(i == this.m_selected_count);
    }

    boolean createSelectionForCrackingAndClustering(Envelope2D extent, double tolerance) {
        this.removeSelection();
        if (this.getGeometryCount() > 64 || this.getTotalPointCount() < 100) {
            return false;
        }
        HitMap2D hit_map = new HitMap2D(extent, tolerance, 16384, this.getGeometryCount());
        int geom = this.getFirstGeometry();
        while (geom != -1) {
            hit_map.addGeometry(this, geom, true);
            geom = this.getNextGeometry(geom);
        }
        this.createEmptySelection();
        Line line = new Line();
        Point2D pt1 = new Point2D();
        Point2D pt2 = new Point2D();
        int geom2 = this.getFirstGeometry();
        while (geom2 != -1) {
            int path = this.getFirstPath(geom2);
            while (path != -1) {
                int vertex = this.getFirstVertex(path);
                if (vertex != -1) {
                    this.getXY(vertex, pt1);
                    boolean prev_selected = false;
                    int n = this.getPathSize(path);
                    for (int i = 0; i < n; ++i) {
                        int next = this.getNextVertex(vertex);
                        if (next != -1) {
                            this.getXY(next, pt2);
                            line.setStartXY(pt1);
                            line.setEndXY(pt2);
                            if (hit_map.hitTest(line, geom2, true)) {
                                if (!prev_selected) {
                                    this.select(vertex);
                                }
                                this.select(next);
                                prev_selected = true;
                            } else {
                                prev_selected = false;
                            }
                            pt1 = pt2;
                        } else assert (i == n - 1);
                        vertex = next;
                    }
                }
                path = this.getNextPath(path);
            }
            geom2 = this.getNextGeometry(geom2);
        }
        hit_map.reset(extent);
        VertexIterator vi = this.queryVertexIteratorOnSelection();
        int vertex = vi.next();
        while (vertex != -1) {
            int next = this.getNextVertex(vertex);
            if (next != -1 && !this.selected(next)) {
                this.getXY(vertex, pt1);
                this.getXY(next, pt2);
                int geom3 = this.getGeometryFromPath(this.getPathFromVertex(vertex));
                line.setStartXY(pt1);
                line.setEndXY(pt2);
                hit_map.addGeometry(line, (long)geom3, true);
            }
            vertex = next;
        }
        AttributeStreamOfInt32 additional_selections = new AttributeStreamOfInt32(0);
        additional_selections.reserve(256);
        int geom4 = this.getFirstGeometry();
        while (geom4 != -1) {
            int path = this.getFirstPath(geom4);
            while (path != -1) {
                int vertex2 = this.getFirstVertex(path);
                if (vertex2 != -1) {
                    int n = this.getPathSize(path);
                    for (int i = 0; i < n; ++i) {
                        int next = this.getNextVertex(vertex2);
                        if (next != -1) {
                            if (this.selected(vertex2)) {
                                if (!this.selected(next)) {
                                    additional_selections.add(next);
                                }
                            } else if (this.selected(next)) {
                                additional_selections.add(vertex2);
                            } else {
                                this.getXY(vertex2, pt1);
                                this.getXY(next, pt2);
                                line.setStartXY(pt1);
                                line.setEndXY(pt2);
                                if (hit_map.hitTest(line, geom4, true)) {
                                    if (additional_selections.size() == 0 || vertex2 != additional_selections.getLast()) {
                                        additional_selections.add(vertex2);
                                    }
                                    additional_selections.add(next);
                                }
                            }
                        } else assert (i == n - 1);
                        vertex2 = next;
                    }
                }
                path = this.getNextPath(path);
            }
            geom4 = this.getNextGeometry(geom4);
        }
        int n = additional_selections.size();
        for (int i = 0; i < n; ++i) {
            this.select(additional_selections.get(i));
        }
        return true;
    }

    void applyTransformation(Transformation2D transform) {
        this.m_vertices_mp.applyTransformation(transform);
        if (this.m_segments != null) {
            int n = this.m_segments.size();
            for (int i = 0; i < n; ++i) {
                if (this.m_segments.get(i) == null) continue;
                this.m_segments.get(i).applyTransformation(transform);
            }
        }
    }

    void interpolateAttributesForClosedPath_(int semantics, int path, int from_vertex, int to_vertex, double sub_length, int ordinate) {
        if (from_vertex == to_vertex) {
            return;
        }
        double from_attribute = this.getAttributeAsDbl(semantics, from_vertex, ordinate);
        double to_attribute = this.getAttributeAsDbl(semantics, to_vertex, ordinate);
        double cumulative_length = 0.0;
        double prev_interpolated_attribute = from_attribute;
        int vertex = from_vertex;
        while (vertex != to_vertex) {
            double segment_length;
            this.setAttribute(semantics, vertex, ordinate, prev_interpolated_attribute);
            int vertex_index = this.getVertexIndex(vertex);
            Segment segment = this.getSegmentFromIndex_(vertex_index);
            if (segment != null) {
                segment_length = segment.calculateLength2D();
            } else {
                int next_vertex_index = this.getVertexIndex(this.getNextVertex(vertex));
                segment_length = this.m_vertices._getShortestDistance(vertex_index, next_vertex_index);
            }
            double t = (cumulative_length += segment_length) / sub_length;
            prev_interpolated_attribute = MathUtils.lerp(from_attribute, to_attribute, t);
            vertex = this.getNextVertex(vertex);
        }
    }

    void SetGeometryType_(int geom, int gt) {
        this.m_geometry_index_list.setField(geom, 2, gt);
    }

    void splitSegmentWithIntersector(int origin_vertex, SegmentIntersector intersector, int intersector_index, boolean b_forward) {
        if (b_forward) {
            this.splitSegmentForward_(origin_vertex, intersector, intersector_index);
        } else {
            this.splitSegmentBackward_(origin_vertex, intersector, intersector_index);
        }
    }

    void setPrevVertex_(int vertex, int prev) {
        this.m_vertex_index_list.setField(vertex, 1, prev);
    }

    void setNextVertex_(int vertex, int next) {
        this.m_vertex_index_list.setField(vertex, 2, next);
    }

    void setPathToVertex_(int vertex, int path) {
        this.m_vertex_index_list.setField(vertex, 3, path);
    }

    void setPathSize_(int path, int size) {
        this.m_path_index_list.setField(path, 3, size);
    }

    void setFirstVertex_(int path, int first_vertex) {
        this.m_path_index_list.setField(path, 4, first_vertex);
    }

    void setLastVertex_(int path, int last_vertex) {
        this.m_path_index_list.setField(path, 5, last_vertex);
    }

    void setGeometryPathCount_(int geom, int path_count) {
        this.m_geometry_index_list.setField(geom, 6, path_count);
    }

    void setGeometryVertexCount_(int geom, int vertex_count) {
        this.m_geometry_index_list.setField(geom, 5, vertex_count);
    }

    boolean ringParentageCheckInternal_(int vertex_1, int vertex_2) {
        if (vertex_1 == vertex_2) {
            return true;
        }
        int vprev_1 = vertex_1;
        int vprev_2 = vertex_2;
        int v_1 = this.getNextVertex(vertex_1);
        int v_2 = this.getNextVertex(vertex_2);
        while (v_1 != vertex_1 && v_2 != vertex_2) {
            if (v_1 == vertex_2) {
                return true;
            }
            if (v_2 == vertex_1) {
                return true;
            }
            assert (this.getPrevVertex(v_1) == vprev_1);
            assert (this.getPrevVertex(v_2) == vprev_2);
            vprev_1 = v_1;
            vprev_2 = v_2;
            v_1 = this.getNextVertex(v_1);
            v_2 = this.getNextVertex(v_2);
        }
        return false;
    }

    void reverseRingInternal_(int vertex) {
        int next;
        int v = vertex;
        do {
            int prev = this.getPrevVertex(v);
            next = this.getNextVertex(v);
            this.setNextVertex_(v, prev);
            this.setPrevVertex_(v, next);
        } while ((v = next) != vertex);
    }

    void setTotalPointCount_(int count) {
        this.m_point_count = count;
    }

    void removePathOnly_(int path) {
        int prev = this.getPrevPath(path);
        int next = this.getNextPath(path);
        int geometry = this.getGeometryFromPath(path);
        if (prev != -1) {
            this.setNextPath_(prev, next);
        } else {
            this.setFirstPath_(geometry, next);
        }
        if (next != -1) {
            this.setPrevPath_(next, prev);
        } else {
            this.setLastPath_(geometry, prev);
        }
        this.setFirstVertex_(path, -1);
        this.setLastVertex_(path, -1);
        this.freePath_(path);
    }

    int removeVertexInternal_(int vertex, boolean b_left_segment) {
        int prev = this.getPrevVertex(vertex);
        int next = this.getNextVertex(vertex);
        if (prev != -1) {
            this.setNextVertex_(prev, next);
        }
        if (next != -1) {
            this.setPrevVertex_(next, prev);
        }
        if (prev != -1 && next != -1) {
            int vindex_prev = this.getVertexIndex(prev);
            int vindex_next = this.getVertexIndex(next);
            if (b_left_segment) {
                Segment seg = this.getSegmentFromIndex_(vindex_prev);
                if (seg != null) {
                    Point2D pt = new Point2D();
                    this.m_vertices.getXY(vindex_next, pt);
                    seg.setEndXY(pt);
                }
            } else {
                int vindex_erased = this.getVertexIndex(vertex);
                Segment seg = this.getSegmentFromIndex_(vindex_erased);
                this.setSegmentToIndex_(vindex_prev, seg);
                if (seg != null) {
                    Point2D pt = new Point2D();
                    this.m_vertices.getXY(vindex_prev, pt);
                    seg.setStartXY(pt);
                }
            }
        }
        this.freeVertex_(vertex);
        return next;
    }

    boolean isRingAreaValid_(int path) {
        return (this.getPathFlags_(path) & 4) != 0;
    }

    void setRingAreaValid_(int path, boolean b_yes_no) {
        int oldflags = this.getPathFlags_(path);
        int flags = (oldflags | 4) - 4;
        this.setPathFlags_(path, flags | (b_yes_no ? 4 : 0));
    }

    int compareVerticesSimpleY_(int v_1, int v_2) {
        Point2D pt_1 = new Point2D();
        this.getXY(v_1, pt_1);
        Point2D pt_2 = new Point2D();
        this.getXY(v_2, pt_2);
        int res = pt_1.compare(pt_2);
        return res;
    }

    int compareVerticesSimpleX_(int v_1, int v_2) {
        Point2D pt_1 = new Point2D();
        this.getXY(v_1, pt_1);
        Point2D pt_2 = new Point2D();
        this.getXY(v_2, pt_2);
        int res = pt_1.compare(pt_2);
        return res;
    }

    void sortVerticesSimpleByY_(AttributeStreamOfInt32 points, int begin_, int end_) {
        if (this.m_bucket_sort == null) {
            this.m_bucket_sort = new BucketSort();
        }
        this.m_bucket_sort.sort(points, begin_, end_, new EditShapeBucketSortHelper(this));
    }

    void sortVerticesSimpleByYHelper_(AttributeStreamOfInt32 points, int begin_, int end_) {
        points.Sort(begin_, end_, new SimplificatorVertexComparerY(this));
    }

    void sortVerticesSimpleByX_(AttributeStreamOfInt32 points, int begin_, int end_) {
        points.Sort(begin_, end_, new SimplificatorVertexComparerX(this));
    }

    boolean hasPointFeatures() {
        int geometry = this.getFirstGeometry();
        while (geometry != -1) {
            if (!Geometry.isMultiPath(this.getGeometryType(geometry))) {
                return true;
            }
            geometry = this.getNextGeometry(geometry);
        }
        return false;
    }

    void swapGeometry(int geom1, int geom2) {
        int first_path1 = this.getFirstPath(geom1);
        int first_path2 = this.getFirstPath(geom2);
        int last_path1 = this.getLastPath(geom1);
        int last_path2 = this.getLastPath(geom2);
        int path = this.getFirstPath(geom1);
        while (path != -1) {
            this.setPathGeometry_(path, geom2);
            path = this.getNextPath(path);
        }
        path = this.getFirstPath(geom2);
        while (path != -1) {
            this.setPathGeometry_(path, geom1);
            path = this.getNextPath(path);
        }
        this.setFirstPath_(geom1, first_path2);
        this.setFirstPath_(geom2, first_path1);
        this.setLastPath_(geom1, last_path2);
        this.setLastPath_(geom2, last_path1);
        int vc1 = this.getPointCount(geom1);
        int pc1 = this.getPathCount(geom1);
        int vc2 = this.getPointCount(geom2);
        int pc2 = this.getPathCount(geom2);
        this.setGeometryVertexCount_(geom1, vc2);
        this.setGeometryVertexCount_(geom2, vc1);
        this.setGeometryPathCount_(geom1, pc2);
        this.setGeometryPathCount_(geom2, pc1);
        int gt1 = this.m_geometry_index_list.getField(geom1, 2);
        int gt2 = this.m_geometry_index_list.getField(geom2, 2);
        this.m_geometry_index_list.setField(geom1, 2, gt2);
        this.m_geometry_index_list.setField(geom2, 2, gt1);
    }

    void removeNaNVertices() {
        Point2D tmp = new Point2D();
        int geom = this.getFirstGeometry();
        while (geom != -1) {
            int path = this.getFirstPath(geom);
            while (path != -1) {
                int vertex = this.getFirstVertex(path);
                int n = this.getPathSize(path);
                for (int i = 0; i < n; ++i) {
                    this.getXY(vertex, tmp);
                    vertex = !tmp.isFinite() ? this.removeVertex(vertex, true) : this.getNextVertex(vertex);
                }
                path = this.getNextPath(path);
            }
            geom = this.getNextGeometry(geom);
        }
    }

    void replaceNaNs(int semantics, double value) {
        if (!this.m_vertex_description.hasAttribute(semantics)) {
            throw new GeometryException("internal error");
        }
        this.m_vertices.replaceNaNs(semantics, value);
    }

    public void collapseAllGeometriesToFirst() {
        int first_geom = this.getFirstGeometry();
        int first_path_count = this.getPathCount(first_geom);
        int first_vertex_count = this.getPointCount(first_geom);
        int geom = this.getNextGeometry(first_geom);
        while (geom != -1) {
            int path = this.getFirstPath(geom);
            while (path != -1) {
                this.setPathGeometry_(path, first_geom);
                path = this.getNextPath(path);
            }
            first_path_count += this.getPathCount(geom);
            first_vertex_count += this.getPointCount(geom);
            int path1 = this.getLastPath(first_geom);
            int path2 = this.getFirstPath(geom);
            if (path1 != -1) {
                this.setNextPath_(path1, path2);
            } else {
                this.setFirstPath_(first_geom, path2);
            }
            if (path2 != -1) {
                this.setPrevPath_(path2, path1);
                this.setLastPath_(first_geom, this.getLastPath(geom));
            }
            this.setFirstPath_(geom, -1);
            this.setLastPath_(geom, -1);
            int gg = geom;
            geom = this.getNextGeometry(geom);
            this.setGeometryVertexCount_(gg, 0);
            this.removeGeometry(gg);
        }
        this.setGeometryVertexCount_(first_geom, first_vertex_count);
        this.setGeometryPathCount_(first_geom, first_path_count);
    }

    public String toString() {
        int geom = this.getFirstGeometry();
        if (geom != -1) {
            StringBuilder res = new StringBuilder();
            res.append("" + this.getPointCount(geom) + " {");
            boolean firstPath = true;
            boolean hasZs = this.getVertexDescription().hasZ();
            boolean hasMs = this.getVertexDescription().hasM();
            boolean hasIDs = this.getVertexDescription().hasID();
            int path = this.getFirstPath(geom);
            while (path != -1) {
                if (!firstPath) {
                    res.append(", ");
                }
                res.append("[");
                firstPath = false;
                boolean firstVert = true;
                int vert = this.getFirstVertex(path);
                while (vert != -1) {
                    Point2D pt = this.getXY(vert);
                    if (!firstVert) {
                        res.append(", ");
                    }
                    firstVert = false;
                    res.append("(" + pt.x + " , " + pt.y);
                    if (hasZs) {
                        res.append(", z:" + this.getAttributeAsDbl(1, vert, 0));
                    }
                    if (hasMs) {
                        res.append(", m:" + this.getAttributeAsDbl(2, vert, 0));
                    }
                    if (hasIDs) {
                        res.append(", id:" + this.getAttributeAsDbl(3, vert, 0));
                    }
                    res.append(")");
                    if (res.length() > 1024) {
                        res.append("...");
                        return res.toString();
                    }
                    vert = this.getNextVertex(vert);
                }
                res.append("]");
                path = this.getNextPath(path);
            }
            res.append("}");
            return res.toString();
        }
        return "[]";
    }

    public static class SimplificatorVertexComparerX
    extends AttributeStreamOfInt32.IntComparator {
        EditShape parent;

        SimplificatorVertexComparerX(EditShape parent_) {
            this.parent = parent_;
        }

        @Override
        public int compare(int i_1, int i_2) {
            return this.parent.compareVerticesSimpleX_(i_1, i_2);
        }
    }

    public static class SimplificatorVertexComparerY
    extends AttributeStreamOfInt32.IntComparator {
        EditShape parent;

        SimplificatorVertexComparerY(EditShape parent_) {
            this.parent = parent_;
        }

        @Override
        public int compare(int i_1, int i_2) {
            return this.parent.compareVerticesSimpleY_(i_1, i_2);
        }
    }

    static final class VertexIterator {
        private EditShape m_parent;
        private int m_geometry;
        private int m_path;
        private int m_vertex;
        private int m_first_vertex;
        private int m_index;
        boolean m_b_first;
        boolean m_b_skip_multi_points;
        boolean m_selection;
        boolean m_one_geom;

        private VertexIterator(EditShape parent, int geometry, int path, int vertex, int first_vertex, int index, boolean b_skip_multi_points, boolean selection, boolean one_geom) {
            this.m_parent = parent;
            this.m_geometry = geometry;
            this.m_path = path;
            this.m_vertex = vertex;
            this.m_index = index;
            this.m_b_skip_multi_points = b_skip_multi_points;
            this.m_first_vertex = first_vertex;
            this.m_b_first = true;
            this.m_selection = selection;
            this.m_one_geom = one_geom;
        }

        private VertexIterator(VertexIterator source) {
            this.m_parent = source.m_parent;
            this.m_geometry = source.m_geometry;
            this.m_path = source.m_path;
            this.m_vertex = source.m_vertex;
            this.m_index = source.m_index;
            this.m_b_skip_multi_points = source.m_b_skip_multi_points;
            this.m_first_vertex = source.m_first_vertex;
            this.m_b_first = true;
            this.m_selection = source.m_selection;
            this.m_one_geom = source.m_one_geom;
        }

        private int moveToNextHelper_() {
            this.m_path = this.m_parent.getNextPath(this.m_path);
            this.m_index = 0;
            while (this.m_geometry != -1) {
                while (this.m_path != -1) {
                    this.m_first_vertex = this.m_vertex = this.m_parent.getFirstVertex(this.m_path);
                    if (this.m_vertex != -1) {
                        return this.m_vertex;
                    }
                    this.m_path = this.m_parent.getNextPath(this.m_path);
                }
                if (this.m_one_geom) {
                    return -1;
                }
                this.m_geometry = this.m_parent.getNextGeometry(this.m_geometry);
                if (this.m_geometry == -1) break;
                if (this.m_b_skip_multi_points && !Geometry.isMultiPath(this.m_parent.getGeometryType(this.m_geometry))) continue;
                this.m_path = this.m_parent.getFirstPath(this.m_geometry);
            }
            return -1;
        }

        public int next() {
            if (this.m_selection) {
                return this.nextSelection_();
            }
            if (this.m_b_first) {
                this.m_b_first = false;
                return this.m_vertex;
            }
            if (this.m_vertex != -1) {
                this.m_vertex = this.m_parent.getNextVertex(this.m_vertex);
                ++this.m_index;
                if (this.m_vertex != -1 && this.m_vertex != this.m_first_vertex) {
                    return this.m_vertex;
                }
                return this.moveToNextHelper_();
            }
            return -1;
        }

        private int nextSelection_() {
            while (this.m_vertex < this.m_parent.m_selected_vertices.size()) {
                int v = this.m_parent.m_selected_vertices.get(this.m_vertex++);
                if (v == -1) continue;
                this.m_path = this.m_parent.getPathFromVertex(v);
                if (this.m_one_geom && this.m_geometry != this.m_parent.getGeometryFromPath(this.m_path)) continue;
                this.m_geometry = this.m_parent.getGeometryFromPath(this.m_path);
                assert (!this.m_b_skip_multi_points || this.m_parent.getGeometryType(this.m_geometry) != 550);
                return v;
            }
            return -1;
        }

        public int currentGeometry() {
            assert (this.m_vertex != -1);
            return this.m_geometry;
        }

        public int currentPath() {
            assert (this.m_vertex != -1);
            return this.m_path;
        }
    }

    static class EditShapeBucketSortHelper
    extends ClassicSort {
        EditShape m_shape;

        EditShapeBucketSortHelper(EditShape shape) {
            this.m_shape = shape;
        }

        @Override
        public void userSort(int begin, int end, AttributeStreamOfInt32 indices) {
            this.m_shape.sortVerticesSimpleByYHelper_(indices, begin, end);
        }

        @Override
        public double getValue(int index) {
            return this.m_shape.getY(index);
        }
    }

    private static interface PathFlags_ {
        public static final int closedPath = 1;
        public static final int exteriorPath = 2;
        public static final int ringAreaValid = 4;
    }
}

