/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.ECoordinate;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.Point3D;

@HadoopSDKExcluded
final class EPoint3D {
    ECoordinate x;
    ECoordinate y;
    ECoordinate z;

    EPoint3D() {
        this.x = new ECoordinate();
        this.y = new ECoordinate();
        this.z = new ECoordinate();
    }

    EPoint3D(Point3D p) {
        this.x = new ECoordinate(p.x);
        this.y = new ECoordinate(p.y);
        this.z = new ECoordinate(p.z);
    }

    EPoint3D(ECoordinate x_, ECoordinate y_, ECoordinate z_) {
        this.x = new ECoordinate(x_);
        this.y = new ECoordinate(y_);
        this.z = new ECoordinate(z_);
    }

    ECoordinate dotProduct(EPoint3D other) {
        ECoordinate v1 = new ECoordinate();
        ECoordinate v2 = new ECoordinate();
        ECoordinate v3 = new ECoordinate();
        v1.mul(this.x, other.x);
        v2.mul(this.y, other.y);
        v3.mul(this.z, other.z);
        ECoordinate v = new ECoordinate();
        v.add(v1, v2);
        v.add(v3);
        return v;
    }

    EPoint3D crossProduct_(EPoint3D other) {
        EPoint3D res = new EPoint3D();
        res.x.mul(this.y, other.z);
        res.y.mul(this.z, other.x);
        res.z.mul(this.x, other.y);
        ECoordinate v1 = new ECoordinate();
        ECoordinate v2 = new ECoordinate();
        ECoordinate v3 = new ECoordinate();
        v1.mul(this.z, other.y);
        v2.mul(this.x, other.z);
        v3.mul(this.y, other.x);
        res.x.sub(v1);
        res.y.sub(v2);
        res.z.sub(v3);
        return res;
    }

    boolean isZero() {
        return this.x.isZero() && this.y.isZero() && this.z.isZero();
    }

    Point3D value() {
        return new Point3D(this.x.value(), this.y.value(), this.z.value());
    }
}

