/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.NthElement;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.QuadEdgeStructure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@HadoopSDKExcluded
public class DelaunayTriangulation2D {
    private Impl m_impl;

    public DelaunayTriangulation2D(int delaunay_options) {
        this.m_impl = new Impl(delaunay_options);
    }

    public int addVertex(Point2D pt, int index) {
        return this.m_impl.addVertex(pt, index);
    }

    public void addConstraint(int v1, int v2) {
        this.m_impl.addConstraint(v1, v2);
    }

    public void prepareBoundedVoronoiRegions(Envelope2D extent_of_interest) {
        this.m_impl.prepareBoundedVoronoiRegions(extent_of_interest);
    }

    public void construct(CallbackOnEqualXYIndices callback, ProgressTracker progress_tracker) {
        this.m_impl.construct(callback, progress_tracker);
    }

    public int getSym(int e) {
        return this.m_impl.getSym(e);
    }

    public int getONext(int e) {
        return this.m_impl.getONext(e);
    }

    public int getOPrev(int e) {
        return this.m_impl.getOPrev(e);
    }

    public int getDNext(int e) {
        return this.m_impl.getDNext(e);
    }

    public int getDPrev(int e) {
        return this.m_impl.getDPrev(e);
    }

    public int getRNext(int e) {
        return this.m_impl.getRNext(e);
    }

    public int getRPrev(int e) {
        return this.m_impl.getRPrev(e);
    }

    public int getLNext(int e) {
        return this.m_impl.getLNext(e);
    }

    public int getLPrev(int e) {
        return this.m_impl.getLPrev(e);
    }

    public int getOrg(int e) {
        return this.m_impl.getOrg(e);
    }

    public int getDest(int e) {
        return this.m_impl.getDest(e);
    }

    public int getIncidentEdge(int c) {
        return this.m_impl.getIncidentEdge(c);
    }

    public Point2D getXY(int c) {
        return this.m_impl.getXY(c);
    }

    public int getIndex(int c) {
        return this.m_impl.getIndex(c);
    }

    public Point2D calculateVoronoiOrgXY(int e) {
        return this.m_impl.calculateVoronoiOrgXY(e);
    }

    public Point2D calculateVoronoiDestXY(int e) {
        return this.m_impl.calculateVoronoiDestXY(e);
    }

    public int getConvexHullEdge() {
        return this.m_impl.getConvexHullEdge();
    }

    public int getClusterCount() {
        return this.m_impl.getPrimaryClusterCount();
    }

    public int getEdgeCount() {
        return this.m_impl.getPrimaryEdgeCount();
    }

    Impl getImpl_() {
        return this.m_impl;
    }

    static final class Impl {
        private ArrayList<Vertex> m_primary_vertices = new ArrayList(0);
        private QuadEdgeStructure m_quad_edge_structure;
        private QuadEdgeStructure.EdgeUserIndex m_constrained_edges;
        private ArrayList<Constraint> m_constraints;
        private Envelope2D m_env;
        private Envelope2D m_extent_of_interest;
        private Constraint m_queued_constraint;
        private int m_convex_hull_edge_count;
        private int m_le;
        private int m_axis;
        private int m_delaunay_options;
        private boolean m_b_add_vertices;
        private int m_begin;
        private XYComparer m_xy_comparer;
        private int m_progress_counter;
        private ProgressTracker m_progress_tracker;
        private CallbackOnEqualXYIndices m_callback;

        Impl(int delaunay_options) {
            this.m_quad_edge_structure = new QuadEdgeStructure(Impl.getPrimaryOptions_(delaunay_options));
            this.m_convex_hull_edge_count = 0;
            this.m_le = -1;
            this.m_axis = -1;
            this.m_delaunay_options = delaunay_options;
            this.m_b_add_vertices = true;
            this.m_callback = null;
            this.m_env = new Envelope2D();
            this.m_env.setEmpty();
            this.m_extent_of_interest = new Envelope2D();
            this.m_extent_of_interest.setEmpty();
            this.m_queued_constraint = Constraint.construct();
            this.m_queued_constraint.start_cluster = -1;
            this.m_xy_comparer = new XYComparer(this.m_primary_vertices);
            this.m_progress_counter = 0;
        }

        int addVertex(Point2D pt, int index) {
            if (!this.m_b_add_vertices) {
                throw new RuntimeException("invalid call");
            }
            if ((this.m_delaunay_options & 0x8000) != 0) {
                int v = this.addVertexFarthest_(pt, index);
                return v;
            }
            int v = this.addVertexNearest_(pt, index);
            return v;
        }

        void addConstraint(int v1, int v2) {
            if (!this.m_b_add_vertices) {
                throw new RuntimeException("invalid call");
            }
            if ((this.m_delaunay_options & 0x8000) != 0) {
                throw new RuntimeException("invalid call");
            }
            int primary_vertices_size = this.m_primary_vertices.size();
            if (v1 >= primary_vertices_size || v2 >= primary_vertices_size) {
                throw new IllegalArgumentException("");
            }
            if (v1 == v2) {
                return;
            }
            Vertex vertex_1 = this.m_primary_vertices.get(v1);
            Point2D pt_2 = this.m_primary_vertices.get((int)v2).pt;
            if (vertex_1.pt.isEqual(pt_2)) {
                return;
            }
            if (this.m_constraints == null) {
                this.m_constraints = new ArrayList(0);
            }
            if (vertex_1.head_constraint_index == -1) {
                Constraint constraint_k = Constraint.construct();
                constraint_k.end_pt.setCoords(pt_2);
                vertex_1.head_constraint_index = this.m_constraints.size();
                this.m_constraints.add(constraint_k);
            } else {
                Constraint constraint_k = Constraint.construct();
                constraint_k.end_pt.setCoords(pt_2);
                constraint_k.next_constraint_index = vertex_1.head_constraint_index;
                vertex_1.head_constraint_index = this.m_constraints.size();
                this.m_constraints.add(constraint_k);
            }
        }

        void prepareBoundedVoronoiRegions(Envelope2D extent_of_interest) {
            if ((this.m_delaunay_options & 0x8000) != 0) {
                throw new RuntimeException("invalid call");
            }
            this.m_extent_of_interest = new Envelope2D();
            this.m_extent_of_interest.setCoords(extent_of_interest);
        }

        void construct(CallbackOnEqualXYIndices callback, ProgressTracker progress_tracker) {
            if (!this.m_b_add_vertices) {
                throw new RuntimeException("invalid call");
            }
            this.m_b_add_vertices = false;
            this.m_callback = callback;
            this.m_progress_tracker = progress_tracker;
            this.construct_();
            this.m_callback = null;
            this.m_progress_tracker = null;
        }

        int getRot(int e) {
            return this.m_quad_edge_structure.getRot(e);
        }

        int getSym(int e) {
            return this.m_quad_edge_structure.getSym(e);
        }

        int getRotInv(int e) {
            return this.m_quad_edge_structure.getRotInv(e);
        }

        int getONext(int e) {
            return this.m_quad_edge_structure.getONext(e);
        }

        int getOPrev(int e) {
            return this.m_quad_edge_structure.getOPrev(e);
        }

        int getDNext(int e) {
            return this.m_quad_edge_structure.getDNext(e);
        }

        int getDPrev(int e) {
            return this.m_quad_edge_structure.getDPrev(e);
        }

        int getRNext(int e) {
            return this.m_quad_edge_structure.getRNext(e);
        }

        int getRPrev(int e) {
            return this.m_quad_edge_structure.getRPrev(e);
        }

        int getLNext(int e) {
            return this.m_quad_edge_structure.getLNext(e);
        }

        int getLPrev(int e) {
            return this.m_quad_edge_structure.getLPrev(e);
        }

        int getOrg(int e) {
            return this.m_quad_edge_structure.getPrimaryOrg(e);
        }

        int getDest(int e) {
            return this.m_quad_edge_structure.getPrimaryDest(e);
        }

        int getIncidentEdge(int c) {
            return this.m_quad_edge_structure.getPrimaryIncidentEdge(c);
        }

        int getOrgIndex(int e) {
            assert (this.m_quad_edge_structure.isPrimaryEdge(e));
            return this.getVertexIndex_(this.m_quad_edge_structure.getPrimaryOrgVertex(e));
        }

        int getDestIndex(int e) {
            assert (this.m_quad_edge_structure.isPrimaryEdge(e));
            return this.getVertexIndex_(this.m_quad_edge_structure.getPrimaryDestVertex(e));
        }

        int getIndex(int c) {
            return this.getVertexIndex_(this.m_quad_edge_structure.getPrimaryVertex(c));
        }

        Point2D getOrgXY(int e) {
            assert (this.m_quad_edge_structure.isPrimaryEdge(e));
            return this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(e));
        }

        Point2D getDestXY(int e) {
            assert (this.m_quad_edge_structure.isPrimaryEdge(e));
            return this.getOrgXY(this.m_quad_edge_structure.getSym(e));
        }

        Point2D getXY(int c) {
            return this.getXY_(this.m_quad_edge_structure.getPrimaryVertex(c));
        }

        Point2D calculateVoronoiOrgXY(int e) {
            assert (this.m_quad_edge_structure.isPrimaryEdge(e));
            int e1 = this.m_quad_edge_structure.getSym(e);
            int e2 = this.m_quad_edge_structure.getRPrev(e1);
            int e3 = this.m_quad_edge_structure.getRPrev(e2);
            int e4 = this.m_quad_edge_structure.getRPrev(e3);
            if (e4 != e1) {
                assert (this.isEdgeOnConvexHullAlgebraic(e1));
                return Point2D.construct(NumberUtils.NaN(), NumberUtils.NaN());
            }
            if (e1 == this.m_le || e2 == this.m_le || e3 == this.m_le) {
                assert (this.isEdgeOnConvexHullAlgebraic(e1));
                return Point2D.construct(NumberUtils.NaN(), NumberUtils.NaN());
            }
            assert (!this.isEdgeOnConvexHullAlgebraic(e1));
            int v1 = this.m_quad_edge_structure.getPrimaryOrgVertex(e1);
            int v2 = this.m_quad_edge_structure.getPrimaryOrgVertex(e2);
            int v3 = this.m_quad_edge_structure.getPrimaryOrgVertex(e3);
            return this.calculateCircumcenter_(v1, v2, v3);
        }

        Point2D calculateVoronoiDestXY(int e) {
            return this.calculateVoronoiOrgXY(this.getSym(e));
        }

        int getConvexHullEdge() {
            return this.m_le;
        }

        QuadEdgeStructure.ClusterUserIndex getClusterUserIndex(boolean b_dual) {
            return new QuadEdgeStructure.ClusterUserIndex(this.m_quad_edge_structure, b_dual);
        }

        QuadEdgeStructure.EdgeUserIndex getEdgeUserIndex(boolean b_dual) {
            return new QuadEdgeStructure.EdgeUserIndex(this.m_quad_edge_structure, b_dual);
        }

        QuadEdgeStructure.ClusterIterator getClusterIterator(boolean b_dual) {
            return new QuadEdgeStructure.ClusterIterator(this.m_quad_edge_structure, b_dual);
        }

        int getPrimaryClusterCount() {
            return this.m_quad_edge_structure.getPrimaryClusterCount();
        }

        int getPrimaryEdgeCount() {
            return this.m_quad_edge_structure.getPrimaryEdgeCount();
        }

        boolean isEdgeOnConvexHullAlgebraic(int e) {
            if (!this.m_quad_edge_structure.isPrimaryEdge(e)) {
                return false;
            }
            int e_rnext = this.m_quad_edge_structure.getRNext(e);
            int e_rnext_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(e_rnext);
            return !this.isRightOf_(e_rnext_vdest, e);
        }

        boolean verify() {
            if ((this.m_delaunay_options & 0x8000) != 0) {
                return this.verifyFarthest_();
            }
            return this.verifyNearest_();
        }

        Polyline getPrimaryStructureAsPolylineDbg() {
            if (this.m_quad_edge_structure.getFirstPrimaryIncidentEdge() == -1) {
                return new Polyline();
            }
            return this.getStructureAsPolylineDbg(this.m_quad_edge_structure.getFirstPrimaryIncidentEdge());
        }

        Polyline getStructureAsPolylineDbg(int start_edge) {
            Polyline p = new Polyline();
            Line l = new Line();
            boolean b_start_new_path = true;
            QuadEdgeStructure.ConnectedComponentEdgeIterator iter = new QuadEdgeStructure.ConnectedComponentEdgeIterator(this.m_quad_edge_structure, start_edge);
            int e = iter.next();
            while (e != -1) {
                Point2D pt_org = this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(e));
                Point2D pt_dest = this.getXY_(this.m_quad_edge_structure.getPrimaryDestVertex(e));
                if (!pt_org.isNaN() && !pt_dest.isNaN()) {
                    l.setStartXY(pt_org);
                    l.setEndXY(pt_dest);
                    p.addSegment(l, b_start_new_path);
                    b_start_new_path = false;
                }
                e = iter.next();
            }
            return p;
        }

        Polygon getPrimaryStructureAsPolygonDbg() {
            Polygon p = new Polygon();
            QuadEdgeStructure.EdgeUserIndex edge_user_index = new QuadEdgeStructure.EdgeUserIndex(this.m_quad_edge_structure, false);
            QuadEdgeStructure.ClusterIterator cluster_ListIterator = new QuadEdgeStructure.ClusterIterator(this.m_quad_edge_structure, false);
            while (cluster_ListIterator.next()) {
                int edge;
                int first_edge;
                int cluster = cluster_ListIterator.getCurrentCluster();
                int next_edge = first_edge = this.m_quad_edge_structure.getPrimaryIncidentEdge(cluster);
                do {
                    int visited;
                    if ((visited = edge_user_index.getIndex(edge = next_edge)) == 1) continue;
                    boolean b_start_new_path = true;
                    do {
                        if (!this.isEdgeOnConvexHullAlgebraic(edge)) {
                            if (b_start_new_path) {
                                p.startPath(this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(edge)));
                                b_start_new_path = false;
                            } else {
                                p.lineTo(this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(edge)));
                            }
                        }
                        edge_user_index.setIndex(edge, 1);
                    } while ((edge = this.m_quad_edge_structure.getRNext(edge)) != next_edge);
                } while ((next_edge = this.m_quad_edge_structure.getONext(edge)) != first_edge);
            }
            return p;
        }

        private static int getPrimaryOptions_(int delaunay_options) {
            int primary_options = 0;
            return primary_options;
        }

        private int addVertexNearest_(Point2D pt, int index) {
            Vertex vertex = Vertex.construct(pt, index);
            this.m_primary_vertices.add(vertex);
            if (this.m_env.isEmpty()) {
                this.m_env.setCoords(vertex.pt);
            } else {
                this.m_env.merge(vertex.pt);
            }
            return this.m_primary_vertices.size() - 1;
        }

        private int addVertexFarthest_(Point2D pt, int index) {
            int size = this.m_primary_vertices.size();
            Vertex vertex = Vertex.construct(pt, index);
            if (size == 0) {
                this.m_primary_vertices.add(vertex);
            } else if (size == 1) {
                Point2D pt_0 = this.m_primary_vertices.get((int)0).pt;
                if (pt_0.isEqual(vertex.pt)) {
                    throw new IllegalArgumentException("");
                }
                this.m_primary_vertices.add(vertex);
            } else {
                Point2D pt_0 = this.m_primary_vertices.get((int)0).pt;
                Point2D pt_1 = this.m_primary_vertices.get((int)1).pt;
                Point2D pt_m = this.m_primary_vertices.get((int)(size - 1)).pt;
                Point2D pt_m_prev = this.m_primary_vertices.get((int)(size - 2)).pt;
                int orient_m_p_0 = Point2D.orientationRobust(pt_m, vertex.pt, pt_0);
                if (!Impl.isClockwise_(orient_m_p_0)) {
                    throw new IllegalArgumentException("");
                }
                int orient_1_p_0 = Point2D.orientationRobust(pt_1, vertex.pt, pt_0);
                if (!Impl.isClockwise_(orient_1_p_0)) {
                    throw new IllegalArgumentException("");
                }
                int orient_m_p_m_prev = Point2D.orientationRobust(pt_m, vertex.pt, pt_m_prev);
                if (!Impl.isClockwise_(orient_m_p_m_prev)) {
                    throw new IllegalArgumentException("");
                }
                this.m_primary_vertices.add(vertex);
            }
            if (this.m_env.isEmpty()) {
                this.m_env.setCoords(vertex.pt);
            } else {
                this.m_env.merge(vertex.pt);
            }
            return this.m_primary_vertices.size() - 1;
        }

        private void construct_() {
            int size = this.m_primary_vertices.size();
            if (size == 0) {
                return;
            }
            if ((this.m_delaunay_options & 0x8000) != 0) {
                int il = this.m_begin = 0;
                int ir = this.m_primary_vertices.size() - 1;
                this.constructFarthest_(il, ir);
                return;
            }
            if (!this.m_extent_of_interest.isEmpty()) {
                Envelope2D e = new Envelope2D();
                e.setCoords(this.m_env);
                e.merge(this.m_extent_of_interest);
                double max_dim = Math.max(e.getWidth(), e.getHeight());
                double max_diameter = 1.5 * max_dim;
                double max_radius = 0.5 * max_diameter;
                double expansion = 3.0 * max_radius;
                Point2D center = e.getCenter();
                this.addVertexNearest_(new Point2D(center.x + expansion, center.y), -1);
                this.addVertexNearest_(new Point2D(center.x, center.y + expansion), -2);
                this.addVertexNearest_(new Point2D(center.x - expansion, center.y), -3);
                this.addVertexNearest_(new Point2D(center.x, center.y - expansion), -4);
            }
            int il = this.m_begin = 0;
            int ir = this.m_primary_vertices.size() - 1;
            this.constructNearest_(il, ir);
            if (this.m_constraints != null) {
                this.insertConstraints_();
            }
        }

        private void insertConstraints_() {
            assert (this.m_constraints != null);
            assert (this.checkConstraints_());
            assert (this.m_queued_constraint.start_cluster == -1);
            this.m_constrained_edges = new QuadEdgeStructure.EdgeUserIndex(this.m_quad_edge_structure, false);
            AttributeStreamOfInt32 pU = new AttributeStreamOfInt32(0);
            AttributeStreamOfInt32 pL = new AttributeStreamOfInt32(0);
            Constraint c = Constraint.construct();
            int n = this.m_constraints.size();
            for (int i = 0; i < n || this.m_queued_constraint.start_cluster != -1; ++i) {
                if (this.m_queued_constraint.start_cluster != -1) {
                    c.end_pt.setCoords(this.m_queued_constraint.end_pt);
                    c.start_cluster = this.m_queued_constraint.start_cluster;
                    this.m_queued_constraint.start_cluster = -1;
                    this.insertConstraint_(c, pU, pL);
                    --i;
                    continue;
                }
                this.insertConstraint_(this.m_constraints.get(i), pU, pL);
            }
            this.m_constraints = null;
        }

        private void insertConstraint_(Constraint constraint, AttributeStreamOfInt32 pU, AttributeStreamOfInt32 pL) {
            int cross_edge = this.getStartingCrossEdge_(constraint);
            if (cross_edge == -1) {
                return;
            }
            int incident_edge = this.m_quad_edge_structure.getPrimaryIncidentEdge(constraint.start_cluster);
            Point2D constrained_start_pt = this.getOrgXY(incident_edge);
            Point2D constrained_end_pt = constraint.end_pt;
            pU.resize(0);
            pL.resize(0);
            pU.add(this.m_quad_edge_structure.getRPrev(cross_edge));
            pL.add(this.m_quad_edge_structure.getRNext(cross_edge));
            boolean b_done = false;
            do {
                int t;
                int cross_edge_dnext;
                Point2D pivot;
                int orientation;
                if ((orientation = Point2D.orientationRobust(constrained_start_pt, pivot = this.getOrgXY(cross_edge_dnext = this.m_quad_edge_structure.getDNext(cross_edge)), constrained_end_pt)) == 0) {
                    if (!pivot.isEqual(constrained_end_pt)) {
                        this.m_queued_constraint.end_pt.setCoords(constraint.end_pt);
                        this.m_queued_constraint.start_cluster = this.m_quad_edge_structure.getPrimaryOrg(cross_edge_dnext);
                    }
                    this.m_quad_edge_structure.deletePrimaryEdge(cross_edge);
                    pU.add(this.m_quad_edge_structure.getRPrev(cross_edge_dnext));
                    pL.add(cross_edge_dnext);
                    b_done = true;
                    break;
                }
                if (orientation < 0) {
                    t = cross_edge;
                    cross_edge = cross_edge_dnext;
                    this.m_quad_edge_structure.deletePrimaryEdge(t);
                    pU.add(this.m_quad_edge_structure.getRPrev(cross_edge));
                } else {
                    t = cross_edge;
                    cross_edge = this.m_quad_edge_structure.getOPrev(cross_edge);
                    this.m_quad_edge_structure.deletePrimaryEdge(t);
                    pL.add(this.m_quad_edge_structure.getRNext(cross_edge));
                }
                assert (Point2D.orientationRobust(constrained_start_pt, this.getOrgXY(cross_edge), constrained_end_pt) < 0);
                assert (Point2D.orientationRobust(constrained_start_pt, this.getDestXY(cross_edge), constrained_end_pt) > 0);
                assert (Point2D.orientationRobust(constrained_start_pt, this.getOrgXY(cross_edge), this.getDestXY(cross_edge)) < 0);
                assert (Point2D.orientationRobust(constrained_end_pt, this.getOrgXY(cross_edge), this.getDestXY(cross_edge)) > 0);
                if (!this.isConstrained_(cross_edge)) continue;
                throw new IllegalArgumentException("non-planar constraints");
            } while (!b_done);
            int e = this.m_quad_edge_structure.connectPrimary(pU.get(pU.size() - 1), pU.get(0));
            this.setConstrained_(e);
            this.triangulatePseudoPolygonDelaunay_(pU, 0, pU.size() - 1);
            pL.reverseRange(0, pL.size(), 1);
            this.triangulatePseudoPolygonDelaunay_(pL, 0, pL.size() - 1);
        }

        private int getStartingCrossEdge_(Constraint constraint) {
            int cross_edge = -1;
            int incident_edge = this.m_quad_edge_structure.getPrimaryIncidentEdge(constraint.start_cluster);
            Point2D constrained_start_pt = this.getOrgXY(incident_edge);
            Point2D constrained_end_pt = constraint.end_pt;
            int orientation = Point2D.orientationRobust(constrained_start_pt, this.getDestXY(incident_edge), constrained_end_pt);
            int e = incident_edge;
            while ((orientation = Point2D.orientationRobust(constrained_start_pt, this.getDestXY(e), constrained_end_pt)) == 0 && (e = this.m_quad_edge_structure.getONext(e)) != incident_edge) {
            }
            if (orientation == 0) {
                throw GeometryException.GeometryInternalError();
            }
            int first_edge = e;
            do {
                assert (this.getOrgXY(e).isEqual(constrained_start_pt));
                e = orientation < 0 ? this.m_quad_edge_structure.getONext(e) : this.m_quad_edge_structure.getOPrev(e);
                Point2D pivot = this.getDestXY(e);
                int next_orientation = Point2D.orientationRobust(constrained_start_pt, pivot, constrained_end_pt);
                if (next_orientation == 0) {
                    if (!pivot.isEqual(constrained_end_pt)) {
                        this.m_queued_constraint.end_pt.setCoords(constraint.end_pt);
                        this.m_queued_constraint.start_cluster = this.m_quad_edge_structure.getPrimaryDest(e);
                    }
                    this.setConstrained_(e);
                    return -1;
                }
                if (next_orientation == orientation) continue;
                int n = cross_edge = next_orientation < 0 ? this.m_quad_edge_structure.getRNext(e) : this.m_quad_edge_structure.getDNext(e);
                assert (Point2D.orientationRobust(constrained_start_pt, this.getOrgXY(cross_edge), constrained_end_pt) < 0);
                assert (Point2D.orientationRobust(constrained_start_pt, this.getDestXY(cross_edge), constrained_end_pt) > 0);
                assert (Point2D.orientationRobust(constrained_start_pt, this.getOrgXY(cross_edge), this.getDestXY(cross_edge)) < 0);
                assert (Point2D.orientationRobust(constrained_end_pt, this.getOrgXY(cross_edge), this.getDestXY(cross_edge)) > 0);
                break;
            } while (e != first_edge);
            if (e == first_edge) {
                throw GeometryException.GeometryInternalError();
            }
            assert (cross_edge != -1);
            return cross_edge;
        }

        private void triangulatePseudoPolygonDelaunay_(AttributeStreamOfInt32 p, int il, int ir) {
            if (ir - il > 1) {
                int v1 = this.m_quad_edge_structure.getPrimaryOrgVertex(p.get(il));
                int v2 = this.m_quad_edge_structure.getPrimaryDestVertex(p.get(ir));
                int im = il + 1;
                int c = this.m_quad_edge_structure.getPrimaryOrgVertex(p.get(il + 1));
                for (int i = im + 1; i <= ir; ++i) {
                    int v = this.m_quad_edge_structure.getPrimaryOrgVertex(p.get(i));
                    if (!this.inCircle_(v2, v1, c, v)) continue;
                    c = v;
                    im = i;
                }
                if (im - 1 - il >= 1) {
                    this.m_quad_edge_structure.connectPrimary(p.get(im - 1), p.get(il));
                }
                if (ir - im >= 1) {
                    this.m_quad_edge_structure.connectPrimary(p.get(ir), p.get(im));
                }
                this.triangulatePseudoPolygonDelaunay_(p, il, im - 1);
                this.triangulatePseudoPolygonDelaunay_(p, im, ir);
            }
        }

        private void setConstrained_(int e) {
            assert (this.m_constrained_edges != null);
            this.m_constrained_edges.setIndex(e, 1);
            this.m_constrained_edges.setIndex(this.m_quad_edge_structure.getSym(e), 1);
        }

        private boolean isConstrained_(int e) {
            if (this.m_constrained_edges == null) {
                return false;
            }
            int index = this.m_constrained_edges.getIndex(e);
            assert (index == this.m_constrained_edges.getIndex(this.m_quad_edge_structure.getSym(e)));
            return index == 1;
        }

        private void constructNearest_(int il, int ir) {
            int min_num_unique = this.getMinNumberOfUniqueXY_(il, ir, 4);
            if (min_num_unique == 1) {
                int e = this.m_quad_edge_structure.makePrimaryEdge();
                int e_sym = this.m_quad_edge_structure.getSym(e);
                this.setPrimaryOrgVertex_(e, 0);
                this.setPrimaryOrgVertex_(e_sym, 0);
                this.m_le = e;
                this.m_axis = 0;
                this.m_convex_hull_edge_count = 2;
                return;
            }
            int[] le_ = new int[1];
            int[] re_ = new int[1];
            int[] axis_ = new int[1];
            le_[0] = -1;
            re_[0] = -1;
            axis_[0] = -1;
            this.m_convex_hull_edge_count = this.divideAndConquer_(this.m_env.getWidth(), this.m_env.getHeight(), il, ir, le_, re_, axis_);
            this.m_le = le_[0];
            this.m_axis = axis_[0];
        }

        private void constructFarthest_(int il, int ir) {
            this.m_convex_hull_edge_count = this.constructConvexHull_(il, ir);
            if (this.m_convex_hull_edge_count <= 3) {
                return;
            }
            AttributeStreamOfInt32 internal_edges = new AttributeStreamOfInt32(0);
            internal_edges.reserve(this.m_convex_hull_edge_count - 3);
            this.triangulateConvexHull_(internal_edges);
            assert (internal_edges.size() == this.m_convex_hull_edge_count - 3);
            this.flipEdges_(internal_edges);
        }

        private int constructConvexHull_(int il, int ir) {
            int e_0 = this.m_quad_edge_structure.makePrimaryEdge();
            int size = this.m_primary_vertices.size();
            if (size <= 2) {
                int e_0_sym = this.m_quad_edge_structure.getSym(e_0);
                this.setPrimaryOrgVertex_(e_0, 0);
                this.setPrimaryOrgVertex_(e_0_sym, size - 1);
                this.m_le = size == 1 ? e_0 : (this.m_xy_comparer.compare(0, 1) ? e_0 : e_0_sym);
                this.m_axis = 0;
                return 2;
            }
            this.m_axis = this.m_env.getWidth() <= this.m_env.getHeight() ? 0 : 1;
            double min_a = NumberUtils.positiveInf();
            double max_a = NumberUtils.negativeInf();
            double a = NumberUtils.NaN();
            int le_oprev = -1;
            int v = -1;
            int e = e_0;
            for (int i = il; i != ir - 1; ++i) {
                v = i - this.m_begin;
                this.setPrimaryOrgVertex_(e, v);
                a = this.m_primary_vertices.get((int)v).pt.get(this.m_axis);
                if (min_a > a) {
                    min_a = a;
                    le_oprev = e;
                }
                if (max_a < a) {
                    max_a = a;
                }
                int e_sym = this.m_quad_edge_structure.getSym(e);
                e = this.m_quad_edge_structure.makePrimaryEdgeAndSplice(e_sym);
            }
            v = ir - this.m_begin - 1;
            this.setPrimaryOrgVertex_(e, v);
            a = this.m_primary_vertices.get((int)v).pt.get(this.m_axis);
            if (min_a > a) {
                min_a = a;
                le_oprev = e;
            }
            if (max_a < a) {
                max_a = a;
            }
            e = this.m_quad_edge_structure.connectPrimary(e, e_0);
            v = ir - this.m_begin;
            this.setPrimaryOrgVertex_(e, v);
            a = this.m_primary_vertices.get((int)v).pt.get(this.m_axis);
            if (min_a > a) {
                min_a = a;
                le_oprev = e;
            }
            if (max_a < a) {
                max_a = a;
            }
            this.m_le = this.m_quad_edge_structure.getONext(le_oprev);
            return size;
        }

        private void triangulateConvexHull_(AttributeStreamOfInt32 internal_edges) {
            int base = this.m_quad_edge_structure.getSym(this.m_le);
            int base_rnext = this.m_quad_edge_structure.getRNext(base);
            int base_rprev = this.m_quad_edge_structure.getRPrev(base);
            int base_rnext_dest = this.m_quad_edge_structure.getDest(base_rnext);
            int base_rprev_org = this.m_quad_edge_structure.getOrg(base_rprev);
            int vi = this.m_quad_edge_structure.getPrimaryOrgVertex(base);
            int vj = this.m_quad_edge_structure.getDestVertex(base);
            Point2D pti = new Point2D();
            Point2D ptj = new Point2D();
            pti.setCoords(this.getXY_(vi));
            ptj.setCoords(this.getXY_(vj));
            Point2D ptk_l = new Point2D();
            Point2D ptk_r = new Point2D();
            while (base_rnext_dest != base_rprev_org) {
                int e;
                int vk_l = this.m_quad_edge_structure.getDestVertex(base_rnext);
                int vk_r = this.m_quad_edge_structure.getPrimaryOrgVertex(base_rprev);
                ptk_l.setCoords(this.getXY_(vk_l));
                ptk_r.setCoords(this.getXY_(vk_r));
                double dl = Point2D.sqrDistance(pti, ptk_l);
                double dr = Point2D.sqrDistance(ptj, ptk_r);
                if (dl >= dr) {
                    e = this.m_quad_edge_structure.connectPrimary(base_rnext, base);
                    base = this.m_quad_edge_structure.getSym(e);
                    base_rnext = this.m_quad_edge_structure.getRNext(base);
                    base_rnext_dest = this.m_quad_edge_structure.getDest(base_rnext);
                    vj = vk_l;
                    assert (vi == this.m_quad_edge_structure.getPrimaryOrgVertex(base));
                    ptj.setCoords(ptk_l);
                } else {
                    e = this.m_quad_edge_structure.connectPrimary(base, base_rprev);
                    base = this.m_quad_edge_structure.getSym(e);
                    base_rprev = this.m_quad_edge_structure.getRPrev(base);
                    base_rprev_org = this.m_quad_edge_structure.getOrg(base_rprev);
                    vi = vk_r;
                    assert (vj == this.m_quad_edge_structure.getDestVertex(base));
                    pti.setCoords(ptk_r);
                }
                internal_edges.add(base);
            }
        }

        private int flipEdges_(AttributeStreamOfInt32 internal_edges) {
            int num_flips = 0;
            while (internal_edges.size() > 0) {
                int e = internal_edges.getLast();
                int e_sym = this.m_quad_edge_structure.getSym(e);
                internal_edges.removeLast();
                int e_rnext = this.m_quad_edge_structure.getRNext(e);
                int e_rprev = this.m_quad_edge_structure.getRPrev(e);
                assert (e_rprev == this.m_quad_edge_structure.getRNext(e_rnext));
                assert (!this.isEdgeOnConvexHullTopologic_(e_sym));
                int e_sym_rnext = this.m_quad_edge_structure.getRNext(e_sym);
                int e_sym_rprev = this.m_quad_edge_structure.getRPrev(e_sym);
                assert (e_sym_rprev == this.m_quad_edge_structure.getRNext(e_sym_rnext));
                int e_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e);
                int e_rnext_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e_rnext);
                int e_rprev_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e_rprev);
                int e_sym_rprev_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e_sym_rprev);
                boolean b_flip = (this.m_delaunay_options & 0x8000) != 0 ? this.notInCircle_(e_vorg, e_rnext_vorg, e_rprev_vorg, e_sym_rprev_vorg) : this.inCircle_(e_vorg, e_rnext_vorg, e_rprev_vorg, e_sym_rprev_vorg);
                if (!b_flip) continue;
                this.m_quad_edge_structure.movePrimary(e, e_sym_rnext, e_rprev);
                boolean b_add_e_rnext = true;
                boolean b_add_e_rprev = true;
                boolean b_add_e_sym_rnext = true;
                boolean b_add_e_sym_rprev = true;
                int e_rnext_sym = this.m_quad_edge_structure.getSym(e_rnext);
                int e_rprev_sym = this.m_quad_edge_structure.getSym(e_rprev);
                int e_sym_rnext_sym = this.m_quad_edge_structure.getSym(e_sym_rnext);
                int e_sym_rprev_sym = this.m_quad_edge_structure.getSym(e_sym_rprev);
                if (b_add_e_rnext && this.isEdgeOnConvexHullTopologic_(e_rnext_sym)) {
                    b_add_e_rnext = false;
                }
                if (b_add_e_rprev && this.isEdgeOnConvexHullTopologic_(e_rprev_sym)) {
                    b_add_e_rprev = false;
                }
                if (b_add_e_sym_rnext && this.isEdgeOnConvexHullTopologic_(e_sym_rnext_sym)) {
                    b_add_e_sym_rnext = false;
                }
                if (b_add_e_sym_rprev && this.isEdgeOnConvexHullTopologic_(e_sym_rprev_sym)) {
                    b_add_e_sym_rprev = false;
                }
                if (this.m_constrained_edges != null) {
                    if (b_add_e_rnext && this.isConstrained_(e_rnext_sym)) {
                        b_add_e_rnext = false;
                    }
                    if (b_add_e_rprev && this.isConstrained_(e_rprev_sym)) {
                        b_add_e_rprev = false;
                    }
                    if (b_add_e_sym_rnext && this.isConstrained_(e_sym_rnext_sym)) {
                        b_add_e_sym_rnext = false;
                    }
                    if (b_add_e_sym_rprev && this.isConstrained_(e_sym_rprev_sym)) {
                        b_add_e_sym_rprev = false;
                    }
                }
                if (b_add_e_rnext) {
                    internal_edges.add(e_rnext);
                }
                if (b_add_e_rprev) {
                    internal_edges.add(e_rprev);
                }
                if (b_add_e_sym_rnext) {
                    internal_edges.add(e_sym_rnext);
                }
                if (b_add_e_sym_rprev) {
                    internal_edges.add(e_sym_rprev);
                }
                ++num_flips;
            }
            return num_flips;
        }

        private int divideAndConquer_(double env_width, double env_height, int il, int ir, int[] le_, int[] re_, int[] axis_) {
            boolean basel_sym_onext_is_valid;
            boolean basel_oprev_is_valid;
            boolean ldi_org_is_right;
            boolean rdi_org_is_left;
            assert (ir - il >= 1);
            int min_num_unique = this.getMinNumberOfUniqueXY_(il, ir, 4);
            if (min_num_unique == 2) {
                int[] i_ = new int[1];
                int[] j_ = new int[1];
                i_[0] = -1;
                j_[0] = -1;
                this.queryBaseCaseLineIterators_(il, ir, i_, j_);
                int convex_hull_edge_count = this.baseCaseLine_(i_[0] - this.m_begin, j_[0] - this.m_begin, le_, re_, axis_);
                return convex_hull_edge_count;
            }
            if (min_num_unique == 3) {
                int[] i_ = new int[1];
                int[] j_ = new int[1];
                int[] k_ = new int[1];
                i_[0] = -1;
                j_[0] = -1;
                k_[0] = -1;
                this.queryBaseCaseTriangleIterators_(il, ir, i_, j_, k_);
                int convex_hull_edge_count = this.baseCaseTriangle_(i_[0] - this.m_begin, j_[0] - this.m_begin, k_[0] - this.m_begin, le_, re_, axis_);
                return convex_hull_edge_count;
            }
            axis_[0] = env_width >= env_height ? 0 : 1;
            int[] il_ = new int[1];
            int[] ir_ = new int[1];
            int[] ml_ = new int[1];
            int[] mr_ = new int[1];
            il_[0] = il;
            ir_[0] = ir;
            this.queryDivide_(axis_[0], il_, ir_, ml_, mr_);
            Envelope2D env_l = this.getEnvelope_(il_[0], ml_[0]);
            Envelope2D env_r = this.getEnvelope_(mr_[0], ir_[0]);
            int[] ldo_ = new int[1];
            int[] ldi_ = new int[1];
            int[] rdi_ = new int[1];
            int[] rdo_ = new int[1];
            int[] axis_l_ = new int[1];
            int[] axis_r_ = new int[1];
            ldo_[0] = -1;
            ldi_[0] = -1;
            rdi_[0] = -1;
            rdo_[0] = -1;
            axis_l_[0] = -1;
            axis_r_[0] = -1;
            int convex_hull_edge_count_l = this.divideAndConquer_(env_l.getWidth(), env_l.getHeight(), il_[0], ml_[0], ldo_, ldi_, axis_l_);
            int convex_hull_edge_count_r = this.divideAndConquer_(env_r.getWidth(), env_r.getHeight(), mr_[0], ir_[0], rdi_, rdo_, axis_r_);
            int convex_hull_edge_count = convex_hull_edge_count_l + convex_hull_edge_count_r;
            if (axis_l_[0] != axis_[0]) {
                int[] lbe_ = new int[1];
                int[] lte_ = new int[1];
                lbe_[0] = -1;
                lte_[0] = -1;
                this.queryBottomTopEdges_(ldo_[0], ldi_[0], lbe_, lte_, axis_[0], false);
                assert (this.queryBottomTopEdgesDbg_(ldo_[0], ldi_[0], lbe_[0], lte_[0], axis_[0]));
                ldo_[0] = lbe_[0];
                ldi_[0] = lte_[0];
            }
            if (axis_r_[0] != axis_[0]) {
                int[] rbe_ = new int[1];
                int[] rte_ = new int[1];
                rbe_[0] = -1;
                rte_[0] = -1;
                this.queryBottomTopEdges_(rdi_[0], rdo_[0], rbe_, rte_, axis_[0], false);
                assert (this.queryBottomTopEdgesDbg_(rdi_[0], rdo_[0], rbe_[0], rte_[0], axis_[0]));
                rdi_[0] = rbe_[0];
                rdo_[0] = rte_[0];
            }
            do {
                rdi_org_is_left = false;
                ldi_org_is_right = false;
                int rdi_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(rdi_[0]);
                if (this.isLeftOf_(rdi_vorg, ldi_[0])) {
                    assert (this.m_quad_edge_structure.getPrimaryOrg(ldi_[0]) != this.m_quad_edge_structure.getPrimaryOrg(ldo_[0]));
                    rdi_org_is_left = true;
                    ldi_[0] = this.m_quad_edge_structure.getLPrev(ldi_[0]);
                    continue;
                }
                int ldi_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(ldi_[0]);
                if (!this.isRightOf_(ldi_vorg, rdi_[0])) continue;
                assert (this.m_quad_edge_structure.getPrimaryOrg(rdi_[0]) != this.m_quad_edge_structure.getPrimaryOrg(rdo_[0]));
                ldi_org_is_right = true;
                rdi_[0] = this.m_quad_edge_structure.getRNext(rdi_[0]);
            } while (rdi_org_is_left || ldi_org_is_right);
            int ldi_sym = this.m_quad_edge_structure.getSym(ldi_[0]);
            int basel = this.m_quad_edge_structure.connectPrimary(ldi_sym, rdi_[0]);
            convex_hull_edge_count += 2;
            int rdi_org = this.m_quad_edge_structure.getPrimaryOrg(rdi_[0]);
            int ldi_org = this.m_quad_edge_structure.getPrimaryOrg(ldi_[0]);
            int rdo_org = this.m_quad_edge_structure.getPrimaryOrg(rdo_[0]);
            int ldo_org = this.m_quad_edge_structure.getPrimaryOrg(ldo_[0]);
            if (rdi_org == rdo_org) {
                int basel_sym;
                assert (this.isLeftOf_(this.m_quad_edge_structure.getPrimaryDestVertex(rdo_[0]), basel));
                re_[0] = basel_sym = this.m_quad_edge_structure.getSym(basel);
            } else {
                re_[0] = rdo_[0];
            }
            if (ldi_org == ldo_org) {
                assert (this.isLeftOf_(this.m_quad_edge_structure.getPrimaryDestVertex(ldo_[0]), basel));
                le_[0] = basel;
            } else {
                le_[0] = ldo_[0];
            }
            do {
                basel_oprev_is_valid = false;
                basel_sym_onext_is_valid = false;
                int basel_sym = this.m_quad_edge_structure.getSym(basel);
                int lcand_vdest = -1;
                int lcand = this.m_quad_edge_structure.getOPrev(basel);
                basel_oprev_is_valid = this.isValid_(lcand, basel);
                if (basel_oprev_is_valid) {
                    int basel_vdest = this.m_quad_edge_structure.getPrimaryOrgVertex(basel_sym);
                    int basel_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(basel);
                    lcand_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(lcand);
                    int lcand_oprev = this.m_quad_edge_structure.getOPrev(lcand);
                    int lcand_oprev_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(lcand_oprev);
                    while (this.inCircle_(basel_vdest, basel_vorg, lcand_vdest, lcand_oprev_vdest)) {
                        assert (this.isValid_(lcand_oprev, basel));
                        int t = lcand;
                        lcand = lcand_oprev;
                        lcand_vdest = lcand_oprev_vdest;
                        lcand_oprev = this.m_quad_edge_structure.getOPrev(lcand);
                        lcand_oprev_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(lcand_oprev);
                        this.m_quad_edge_structure.deletePrimaryEdge(t);
                        ++convex_hull_edge_count;
                    }
                }
                int rcand_vdest = -1;
                int rcand = this.m_quad_edge_structure.getONext(basel_sym);
                basel_sym_onext_is_valid = this.isValid_(rcand, basel);
                if (basel_sym_onext_is_valid) {
                    int basel_vdest = this.m_quad_edge_structure.getPrimaryOrgVertex(basel_sym);
                    int basel_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(basel);
                    rcand_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(rcand);
                    int rcand_onext = this.m_quad_edge_structure.getONext(rcand);
                    int rcand_onext_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(rcand_onext);
                    while (this.inCircle_(basel_vdest, basel_vorg, rcand_vdest, rcand_onext_vdest)) {
                        assert (this.isValid_(rcand_onext, basel));
                        int t = rcand;
                        rcand = rcand_onext;
                        rcand_vdest = rcand_onext_vdest;
                        rcand_onext = this.m_quad_edge_structure.getONext(rcand);
                        rcand_onext_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(rcand_onext);
                        this.m_quad_edge_structure.deletePrimaryEdge(t);
                        ++convex_hull_edge_count;
                    }
                }
                assert (basel_oprev_is_valid == this.isValid_(lcand, basel));
                assert (basel_sym_onext_is_valid == this.isValid_(rcand, basel));
                if (!basel_oprev_is_valid && !basel_sym_onext_is_valid) break;
                boolean b_LL = false;
                if (basel_oprev_is_valid && basel_sym_onext_is_valid) {
                    int rcand_vorg;
                    int lcand_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(lcand);
                    if (this.inCircle_(lcand_vorg, lcand_vdest, rcand_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(rcand), rcand_vdest)) {
                        assert (!this.inCircle_(lcand_vorg, rcand_vdest, rcand_vorg, lcand_vdest));
                    } else {
                        b_LL = true;
                    }
                } else if (basel_oprev_is_valid) {
                    b_LL = true;
                }
                if (b_LL) {
                    basel = this.m_quad_edge_structure.connectPrimary(lcand, basel_sym);
                } else {
                    int rcand_sym = this.m_quad_edge_structure.getSym(rcand);
                    basel = this.m_quad_edge_structure.connectPrimary(basel_sym, rcand_sym);
                }
                --convex_hull_edge_count;
            } while (basel_oprev_is_valid || basel_sym_onext_is_valid);
            return convex_hull_edge_count;
        }

        private int baseCaseLine_(int vi, int vj, int[] le_, int[] re_, int[] axis_) {
            if (!this.m_xy_comparer.compare(vi, vj)) {
                int t = vi;
                vi = vj;
                vj = t;
            }
            assert (this.m_xy_comparer.compare(vi, vj));
            int a = this.m_quad_edge_structure.makePrimaryEdge();
            int a_sym = this.m_quad_edge_structure.getSym(a);
            le_[0] = a;
            re_[0] = a_sym;
            axis_[0] = 0;
            this.setPrimaryOrgVertex_(a, vi);
            this.setPrimaryOrgVertex_(a_sym, vj);
            if (this.m_constraints != null) {
                int a_org = this.m_quad_edge_structure.getPrimaryOrg(a);
                int a_sym_org = this.m_quad_edge_structure.getPrimaryOrg(a_sym);
                int head_constraint_index_i = this.m_primary_vertices.get((int)vi).head_constraint_index;
                int head_constraint_index_j = this.m_primary_vertices.get((int)vj).head_constraint_index;
                if (head_constraint_index_i != -1) {
                    this.setConstraintClusters_(head_constraint_index_i, a_org);
                }
                if (head_constraint_index_j != -1) {
                    this.setConstraintClusters_(head_constraint_index_j, a_sym_org);
                }
            }
            return 2;
        }

        private int baseCaseTriangle_(int vi, int vj, int vk, int[] le_, int[] re_, int[] axis_) {
            int t;
            if (!this.m_xy_comparer.compare(vi, vj)) {
                t = vi;
                vi = vj;
                vj = t;
            }
            if (!this.m_xy_comparer.compare(vj, vk)) {
                t = vj;
                vj = vk;
                vk = t;
            }
            if (!this.m_xy_comparer.compare(vi, vj)) {
                t = vi;
                vi = vj;
                vj = t;
            }
            assert (this.m_xy_comparer.compare(vi, vj));
            assert (this.m_xy_comparer.compare(vj, vk));
            int a = this.m_quad_edge_structure.makePrimaryEdge();
            int a_sym = this.m_quad_edge_structure.getSym(a);
            int b = this.m_quad_edge_structure.makePrimaryEdgeAndSplice(a_sym);
            int b_sym = this.m_quad_edge_structure.getSym(b);
            Point2D s1 = this.m_primary_vertices.get((int)vi).pt;
            Point2D s2 = this.m_primary_vertices.get((int)vj).pt;
            Point2D s3 = this.m_primary_vertices.get((int)vk).pt;
            int convex_hull_edge_count = -1;
            int orientation = Point2D.orientationRobust(s1, s2, s3);
            if (Impl.isCounterClockwise_(orientation)) {
                this.m_quad_edge_structure.connectPrimary(b, a);
                le_[0] = a;
                re_[0] = b_sym;
                axis_[0] = 0;
                convex_hull_edge_count = 3;
            } else if (Impl.isClockwise_(orientation)) {
                int c_sym;
                int c = this.m_quad_edge_structure.connectPrimary(b, a);
                le_[0] = c_sym = this.m_quad_edge_structure.getSym(c);
                re_[0] = c;
                axis_[0] = 0;
                convex_hull_edge_count = 3;
            } else {
                assert (Impl.isDegenerate_(orientation));
                le_[0] = a;
                re_[0] = b_sym;
                axis_[0] = 0;
                convex_hull_edge_count = 4;
            }
            this.setPrimaryOrgVertex_(a, vi);
            this.setPrimaryOrgVertex_(a_sym, vj);
            this.setPrimaryOrgVertex_(b_sym, vk);
            if (this.m_constraints != null) {
                int a_org = this.m_quad_edge_structure.getPrimaryOrg(a);
                int a_sym_org = this.m_quad_edge_structure.getPrimaryOrg(a_sym);
                int b_sym_org = this.m_quad_edge_structure.getPrimaryOrg(b_sym);
                int head_constraint_index_i = this.m_primary_vertices.get((int)vi).head_constraint_index;
                int head_constraint_index_j = this.m_primary_vertices.get((int)vj).head_constraint_index;
                int head_constraint_index_k = this.m_primary_vertices.get((int)vk).head_constraint_index;
                if (head_constraint_index_i != -1) {
                    this.setConstraintClusters_(head_constraint_index_i, a_org);
                }
                if (head_constraint_index_j != -1) {
                    this.setConstraintClusters_(head_constraint_index_j, a_sym_org);
                }
                if (head_constraint_index_k != -1) {
                    this.setConstraintClusters_(head_constraint_index_k, b_sym_org);
                }
            }
            return convex_hull_edge_count;
        }

        private void queryDivide_(int axis, int[] il_, int[] ir_, int[] ml_, int[] mr_) {
            int head_constraint_index;
            assert (this.getMinNumberOfUniqueXY_(il_[0], ir_[0], 4) == 4);
            int[] bm_ = new int[1];
            int[] em_ = new int[1];
            bm_[0] = -1;
            em_[0] = -1;
            this.queryMedianRangeWithEqualXY_(il_[0], ir_[0], axis, bm_, em_);
            if (bm_[0] == il_[0]) {
                assert (em_[0] != ir_[0]);
                if (this.m_callback != null || this.m_constraints != null) {
                    this.m_primary_vertices.get((int)em_[0]).head_constraint_index = head_constraint_index = this.reportEqualXYIndices_(il_[0], em_[0]);
                }
                il_[0] = em_[0];
                this.queryMedianRangeWithEqualXY_(il_[0], ir_[0], axis, bm_, em_);
                assert (bm_[0] != il_[0]);
                if (em_[0] == ir_[0]) {
                    if (this.m_callback != null || this.m_constraints != null) {
                        this.m_primary_vertices.get((int)bm_[0]).head_constraint_index = head_constraint_index = this.reportEqualXYIndices_(bm_[0], ir_[0]);
                    }
                    ir_[0] = bm_[0];
                    this.queryMedianRangeWithEqualXY_(il_[0], ir_[0], axis, bm_, em_);
                    assert (bm_[0] != il_[0]);
                    assert (em_[0] != ir_[0]);
                }
            } else if (em_[0] == ir_[0]) {
                assert (bm_[0] != il_[0]);
                if (this.m_callback != null || this.m_constraints != null) {
                    this.m_primary_vertices.get((int)bm_[0]).head_constraint_index = head_constraint_index = this.reportEqualXYIndices_(bm_[0], ir_[0]);
                }
                ir_[0] = bm_[0];
                this.queryMedianRangeWithEqualXY_(il_[0], ir_[0], axis, bm_, em_);
                assert (em_[0] != ir_[0]);
                if (bm_[0] == il_[0]) {
                    if (this.m_callback != null || this.m_constraints != null) {
                        this.m_primary_vertices.get((int)em_[0]).head_constraint_index = head_constraint_index = this.reportEqualXYIndices_(il_[0], em_[0]);
                    }
                    il_[0] = em_[0];
                    this.queryMedianRangeWithEqualXY_(il_[0], ir_[0], axis, bm_, em_);
                    assert (bm_[0] != il_[0]);
                    assert (em_[0] != ir_[0]);
                }
            }
            assert (il_[0] < bm_[0] && em_[0] < ir_[0]);
            int min_unique_after = this.getMinNumberOfUniqueXY_(em_[0], ir_[0], 3);
            assert (min_unique_after > 1);
            int head_constraint_index2 = -1;
            if (this.m_callback != null || this.m_constraints != null) {
                head_constraint_index2 = this.reportEqualXYIndices_(bm_[0], em_[0]);
            }
            if (min_unique_after == 2) {
                ml_[0] = bm_[0] - 1;
                mr_[0] = em_[0];
                this.m_primary_vertices.get((int)em_[0]).head_constraint_index = head_constraint_index2;
            } else {
                ml_[0] = bm_[0];
                mr_[0] = em_[0] + 1;
                this.m_primary_vertices.get((int)bm_[0]).head_constraint_index = head_constraint_index2;
            }
        }

        private void queryMedianRangeWithEqualXY_(int il, int ir, int axis, int[] bm_, int[] em_) {
            Point2D pt_v;
            MedianComparer median_comparer = new MedianComparer(axis);
            bm_[0] = Impl.partition_(this.m_primary_vertices, il, ir + 1, median_comparer);
            em_[0] = bm_[0] + 1;
            Point2D pt_m = this.m_primary_vertices.get((int)bm_[0]).pt;
            while (em_[0] != ir + 1 && (pt_v = this.m_primary_vertices.get((int)em_[0]).pt).isEqual(pt_m)) {
                em_[0] = em_[0] + 1;
            }
            em_[0] = em_[0] - 1;
        }

        private int getMinNumberOfUniqueXY_(int il, int ir, int max) {
            Point2D[] some_unique_pts = new Point2D[4];
            for (int i = 0; i < 4; ++i) {
                some_unique_pts[i] = new Point2D();
                some_unique_pts[i].setNaN();
            }
            some_unique_pts[0].setCoords(this.m_primary_vertices.get((int)il).pt);
            int count = 1;
            int max_count = Math.min(4, max);
            int i = il;
            while (count < max_count && ++i != ir + 1) {
                Point2D pt = this.m_primary_vertices.get((int)i).pt;
                if (pt.isEqual(some_unique_pts[0])) continue;
                if (count == 1) {
                    some_unique_pts[1].setCoords(pt);
                    count = 2;
                    continue;
                }
                if (pt.isEqual(some_unique_pts[1])) continue;
                if (count == 2) {
                    some_unique_pts[2].setCoords(pt);
                    count = 3;
                    continue;
                }
                if (pt.isEqual(some_unique_pts[2])) continue;
                some_unique_pts[3].setCoords(pt);
                count = 4;
            }
            return count;
        }

        private void queryBaseCaseLineIterators_(int il, int ir, int[] i_, int[] j_) {
            int count = 0;
            Point2D[] unique_pts = new Point2D[2];
            for (int i = 0; i < 2; ++i) {
                unique_pts[i] = new Point2D();
                unique_pts[i].setNaN();
            }
            int[] iterators = new int[]{-1, -1};
            int[] last = new int[]{-1, -1};
            int[] head = new int[]{-1, -1};
            int[] constraint_head = new int[]{-1, -1};
            iterators[0] = il;
            unique_pts[0].setCoords(this.m_primary_vertices.get((int)il).pt);
            last[0] = this.m_primary_vertices.get((int)il).vi;
            head[0] = last[0];
            if (this.m_constraints != null && this.m_primary_vertices.get((int)il).head_constraint_index != -1) {
                constraint_head[0] = this.m_primary_vertices.get((int)il).head_constraint_index;
            }
            ++count;
            for (int t = il + 1; t != ir + 1; ++t) {
                int index;
                Point2D pt = this.m_primary_vertices.get((int)t).pt;
                if (!pt.isEqual(unique_pts[0])) {
                    if (count == 1) {
                        iterators[1] = t;
                        unique_pts[1].setCoords(pt);
                        last[1] = this.m_primary_vertices.get((int)t).vi;
                        head[1] = last[1];
                        if (this.m_constraints != null && this.m_primary_vertices.get((int)t).head_constraint_index != -1) {
                            constraint_head[1] = this.m_primary_vertices.get((int)t).head_constraint_index;
                        }
                        count = 2;
                        continue;
                    }
                    assert (count == 2);
                    assert (pt.isEqual(unique_pts[1]));
                    if (this.m_callback == null && this.m_constraints == null) break;
                    if (this.m_callback != null) {
                        index = this.m_primary_vertices.get((int)t).vi;
                        this.m_callback.onEqualXYIndices(last[1], index);
                        last[1] = index;
                    }
                    if (this.m_constraints == null || this.m_primary_vertices.get((int)t).head_constraint_index == -1) continue;
                    if (constraint_head[1] != -1) {
                        constraint_head[1] = this.mergeConstraintListsHead1ToHead2_(this.m_primary_vertices.get((int)t).head_constraint_index, constraint_head[1]);
                        continue;
                    }
                    constraint_head[1] = this.m_primary_vertices.get((int)t).head_constraint_index;
                    continue;
                }
                if (this.m_callback != null) {
                    index = this.m_primary_vertices.get((int)t).vi;
                    this.m_callback.onEqualXYIndices(last[0], index);
                    last[0] = index;
                }
                if (this.m_constraints == null || this.m_primary_vertices.get((int)t).head_constraint_index == -1) continue;
                constraint_head[0] = constraint_head[0] != -1 ? this.mergeConstraintListsHead1ToHead2_(this.m_primary_vertices.get((int)t).head_constraint_index, constraint_head[0]) : this.m_primary_vertices.get((int)t).head_constraint_index;
            }
            if (this.m_callback != null) {
                if (last[0] != head[0]) {
                    this.m_callback.onEqualXYIndices(last[0], head[0]);
                }
                if (last[1] != head[1]) {
                    this.m_callback.onEqualXYIndices(last[1], head[1]);
                }
            }
            if (this.m_constraints != null) {
                this.m_primary_vertices.get((int)iterators[0]).head_constraint_index = constraint_head[0];
                this.m_primary_vertices.get((int)iterators[1]).head_constraint_index = constraint_head[1];
            }
            i_[0] = iterators[0];
            j_[0] = iterators[1];
        }

        private void queryBaseCaseTriangleIterators_(int il, int ir, int[] i_, int[] j_, int[] k_) {
            int count = 0;
            Point2D[] unique_pts = new Point2D[3];
            for (int i = 0; i < 3; ++i) {
                unique_pts[i] = new Point2D();
                unique_pts[i].setNaN();
            }
            int[] iterators = new int[]{-1, -1, -1};
            int[] last = new int[]{-1, -1, -1};
            int[] head = new int[]{-1, -1, -1};
            int[] constraint_head = new int[]{-1, -1, -1};
            iterators[0] = il;
            unique_pts[0].setCoords(this.m_primary_vertices.get((int)il).pt);
            last[0] = this.m_primary_vertices.get((int)il).vi;
            head[0] = last[0];
            if (this.m_constraints != null && this.m_primary_vertices.get((int)il).head_constraint_index != -1) {
                constraint_head[0] = this.m_primary_vertices.get((int)il).head_constraint_index;
            }
            ++count;
            for (int t = il + 1; t != ir + 1; ++t) {
                int index;
                Point2D pt = this.m_primary_vertices.get((int)t).pt;
                if (!pt.isEqual(unique_pts[0])) {
                    if (count == 1) {
                        iterators[1] = t;
                        unique_pts[1].setCoords(pt);
                        last[1] = this.m_primary_vertices.get((int)t).vi;
                        head[1] = last[1];
                        if (this.m_constraints != null && this.m_primary_vertices.get((int)t).head_constraint_index != -1) {
                            constraint_head[1] = this.m_primary_vertices.get((int)t).head_constraint_index;
                        }
                        count = 2;
                        continue;
                    }
                    if (!pt.isEqual(unique_pts[1])) {
                        if (count == 2) {
                            iterators[2] = t;
                            unique_pts[2].setCoords(pt);
                            last[2] = this.m_primary_vertices.get((int)t).vi;
                            head[2] = last[2];
                            if (this.m_constraints != null && this.m_primary_vertices.get((int)t).head_constraint_index != -1) {
                                constraint_head[2] = this.m_primary_vertices.get((int)t).head_constraint_index;
                            }
                            count = 3;
                            continue;
                        }
                        assert (count == 3);
                        assert (pt.isEqual(unique_pts[2]));
                        if (this.m_callback == null && this.m_constraints == null) break;
                        if (this.m_callback != null) {
                            index = this.m_primary_vertices.get((int)t).vi;
                            this.m_callback.onEqualXYIndices(last[2], index);
                            last[2] = index;
                        }
                        if (this.m_constraints == null || this.m_primary_vertices.get((int)t).head_constraint_index == -1) continue;
                        if (constraint_head[2] != -1) {
                            constraint_head[2] = this.mergeConstraintListsHead1ToHead2_(this.m_primary_vertices.get((int)t).head_constraint_index, constraint_head[2]);
                            continue;
                        }
                        constraint_head[2] = this.m_primary_vertices.get((int)t).head_constraint_index;
                        continue;
                    }
                    if (this.m_callback != null) {
                        index = this.m_primary_vertices.get((int)t).vi;
                        this.m_callback.onEqualXYIndices(last[1], index);
                        last[1] = index;
                    }
                    if (this.m_constraints == null || this.m_primary_vertices.get((int)t).head_constraint_index == -1) continue;
                    if (constraint_head[1] != -1) {
                        constraint_head[1] = this.mergeConstraintListsHead1ToHead2_(this.m_primary_vertices.get((int)t).head_constraint_index, constraint_head[1]);
                        continue;
                    }
                    constraint_head[1] = this.m_primary_vertices.get((int)t).head_constraint_index;
                    continue;
                }
                if (this.m_callback != null) {
                    index = this.m_primary_vertices.get((int)t).vi;
                    this.m_callback.onEqualXYIndices(last[0], index);
                    last[0] = index;
                }
                if (this.m_constraints == null || this.m_primary_vertices.get((int)t).head_constraint_index == -1) continue;
                constraint_head[0] = constraint_head[0] != -1 ? this.mergeConstraintListsHead1ToHead2_(this.m_primary_vertices.get((int)t).head_constraint_index, constraint_head[0]) : this.m_primary_vertices.get((int)t).head_constraint_index;
            }
            if (this.m_callback != null) {
                if (last[0] != head[0]) {
                    this.m_callback.onEqualXYIndices(last[0], head[0]);
                }
                if (last[1] != head[1]) {
                    this.m_callback.onEqualXYIndices(last[1], head[1]);
                }
                if (last[2] != head[2]) {
                    this.m_callback.onEqualXYIndices(last[2], head[2]);
                }
            }
            if (this.m_constraints != null) {
                this.m_primary_vertices.get((int)iterators[0]).head_constraint_index = constraint_head[0];
                this.m_primary_vertices.get((int)iterators[1]).head_constraint_index = constraint_head[1];
                this.m_primary_vertices.get((int)iterators[2]).head_constraint_index = constraint_head[2];
            }
            i_[0] = iterators[0];
            j_[0] = iterators[1];
            k_[0] = iterators[2];
        }

        private int reportEqualXYIndices_(int il, int ir) {
            int last;
            assert (this.m_callback != null || this.m_constraints != null);
            int head = last = this.m_primary_vertices.get((int)il).vi;
            int constraint_head = this.m_primary_vertices.get((int)il).head_constraint_index;
            for (int t = il + 1; t != ir + 1; ++t) {
                assert (this.m_primary_vertices.get((int)(t - 1)).pt.isEqual(this.m_primary_vertices.get((int)t).pt));
                if (this.m_callback != null) {
                    int index = this.m_primary_vertices.get((int)t).vi;
                    this.m_callback.onEqualXYIndices(last, index);
                    last = index;
                }
                if (this.m_constraints == null || this.m_primary_vertices.get((int)t).head_constraint_index == -1) continue;
                constraint_head = constraint_head != -1 ? this.mergeConstraintListsHead1ToHead2_(this.m_primary_vertices.get((int)t).head_constraint_index, constraint_head) : this.m_primary_vertices.get((int)t).head_constraint_index;
            }
            if (this.m_callback != null && last != head) {
                this.m_callback.onEqualXYIndices(last, head);
            }
            return constraint_head;
        }

        private int mergeConstraintListsHead1ToHead2_(int head1, int head2) {
            int next = -1;
            int index1 = head1;
            int index2 = head2;
            while (index1 != -1) {
                next = this.m_constraints.get((int)index1).next_constraint_index;
                this.linkEqualConstraintIndices_(index1, index2);
                index2 = index1;
                index1 = next;
            }
            assert (index2 != -1);
            return index2;
        }

        private void linkEqualConstraintIndices_(int constraint_index_i, int constraint_index_j) {
            assert (constraint_index_i != -1 && constraint_index_j != -1);
            assert (constraint_index_j < this.m_constraints.size());
            this.m_constraints.get((int)constraint_index_i).next_constraint_index = constraint_index_j;
        }

        private void setConstraintClusters_(int head, int start_cluster) {
            assert (head != -1);
            assert (start_cluster != -1);
            int constraint_index = head;
            do {
                this.m_constraints.get((int)constraint_index).start_cluster = start_cluster;
            } while ((constraint_index = this.m_constraints.get((int)constraint_index).next_constraint_index) != -1);
        }

        private void queryBottomTopEdges_(int le, int re, int[] be_, int[] te_, int axis, boolean b_debugging) {
            double a;
            be_[0] = -1;
            te_[0] = -1;
            int e = le;
            double min_a = NumberUtils.positiveInf();
            do {
                if (min_a > (a = this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(e)).get(axis))) {
                    min_a = a;
                    be_[0] = e;
                    continue;
                }
                if (!b_debugging) break;
            } while ((e = axis == 1 ? this.m_quad_edge_structure.getRNext(e) : this.m_quad_edge_structure.getRPrev(e)) != le);
            e = re;
            double max_a = NumberUtils.negativeInf();
            do {
                if (max_a < (a = this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(e)).get(axis))) {
                    max_a = a;
                    te_[0] = e;
                    continue;
                }
                if (!b_debugging) break;
            } while ((e = axis == 1 ? this.m_quad_edge_structure.getLNext(e) : this.m_quad_edge_structure.getLPrev(e)) != re);
        }

        private boolean queryBottomTopEdgesDbg_(int le, int re, int be, int te, int axis) {
            int[] bbe_ = new int[1];
            int[] tte_ = new int[1];
            this.queryBottomTopEdges_(le, re, bbe_, tte_, axis, true);
            double b1 = this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(bbe_[0])).get(axis);
            double b2 = this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(be)).get(axis);
            double t1 = this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(tte_[0])).get(axis);
            double t2 = this.getXY_(this.m_quad_edge_structure.getPrimaryOrgVertex(te)).get(axis);
            return b1 == b2 && t1 == t2;
        }

        private Envelope2D getEnvelope_(int il, int ir) {
            Envelope2D env = new Envelope2D();
            Point2D pt_il = this.m_primary_vertices.get((int)il).pt;
            env.setCoords(pt_il.x, pt_il.y);
            for (int i = il + 1; i != ir + 1; ++i) {
                Point2D pt_i = this.m_primary_vertices.get((int)i).pt;
                env.merge(pt_i.x, pt_i.y);
            }
            return env;
        }

        private Vertex getVertex_(int v) {
            return this.m_primary_vertices.get(v);
        }

        private Point2D getXY_(int v) {
            return this.m_primary_vertices.get((int)v).pt;
        }

        private int getVertexIndex_(int v) {
            return this.m_primary_vertices.get((int)v).vi;
        }

        private void setPrimaryOrgVertex_(int e, int vi) {
            this.m_quad_edge_structure.setPrimaryOrgVertex(e, vi);
        }

        private boolean inCircle_(int v1, int v2, int v3, int v4) {
            ++this.m_progress_counter;
            if (this.m_progress_tracker != null && this.m_progress_counter % 10000 == 0) {
                this.m_progress_counter = 0;
                this.m_progress_tracker.progress(-1, -1);
            }
            return this.inCircleNoProgress_(v1, v2, v3, v4);
        }

        private boolean inCircleNoProgress_(int v1, int v2, int v3, int v4) {
            Point2D pt_v4;
            Point2D pt_v3;
            Point2D pt_v2;
            Point2D pt_v1 = this.getXY_(v1);
            return Point2D.inCircleRobust(pt_v1, pt_v2 = this.getXY_(v2), pt_v3 = this.getXY_(v3), pt_v4 = this.getXY_(v4)) == -1;
        }

        private boolean notInCircle_(int v1, int v2, int v3, int v4) {
            ++this.m_progress_counter;
            if (this.m_progress_tracker != null && this.m_progress_counter % 10000 == 0) {
                this.m_progress_counter = 0;
                this.m_progress_tracker.progress(-1, -1);
            }
            return this.notInCircleNoProgress_(v1, v2, v3, v4);
        }

        private boolean notInCircleNoProgress_(int v1, int v2, int v3, int v4) {
            Point2D pt_v4;
            Point2D pt_v3;
            Point2D pt_v2;
            Point2D pt_v1 = this.getXY_(v1);
            return Point2D.inCircleRobust(pt_v1, pt_v2 = this.getXY_(v2), pt_v3 = this.getXY_(v3), pt_v4 = this.getXY_(v4)) == 1;
        }

        private boolean isValid_(int e, int basel) {
            return this.isLeftOf_(this.m_quad_edge_structure.getPrimaryDestVertex(e), basel);
        }

        private boolean isRightOf_(int v, int e) {
            int orientation = this.getOrientation_(v, this.m_quad_edge_structure.getPrimaryOrgVertex(e), this.m_quad_edge_structure.getPrimaryDestVertex(e));
            return orientation == -1;
        }

        private boolean isLeftOf_(int v, int e) {
            int orientation = this.getOrientation_(v, this.m_quad_edge_structure.getPrimaryOrgVertex(e), this.m_quad_edge_structure.getPrimaryDestVertex(e));
            return orientation == 1;
        }

        private int getOrientation_(int v1, int v2, int v3) {
            Point2D pt_v1 = this.getXY_(v1);
            Point2D pt_v2 = this.getXY_(v2);
            Point2D pt_v3 = this.getXY_(v3);
            return Point2D.orientationRobust(pt_v1, pt_v2, pt_v3);
        }

        private boolean isEdgeOnConvexHullTopologic_(int e) {
            int e1 = this.m_quad_edge_structure.getRPrev(e);
            int e2 = this.m_quad_edge_structure.getRPrev(e1);
            int e3 = this.m_quad_edge_structure.getRPrev(e2);
            if (e3 != e) {
                assert (this.isEdgeOnConvexHullAlgebraic(e));
                return true;
            }
            if (e == this.m_le || e1 == this.m_le || e2 == this.m_le) {
                assert (this.isEdgeOnConvexHullAlgebraic(e));
                return true;
            }
            return false;
        }

        private Point2D calculateCircumcenter_(int v1, int v2, int v3) {
            int t;
            if (this.getXY_(v1).compareX(this.getXY_(v2)) >= 0) {
                t = v1;
                v1 = v2;
                v2 = t;
            }
            if (this.getXY_(v2).compareX(this.getXY_(v3)) >= 0) {
                t = v2;
                v2 = v3;
                v3 = t;
            }
            if (this.getXY_(v1).compareX(this.getXY_(v2)) >= 0) {
                t = v1;
                v1 = v2;
                v2 = t;
            }
            Point2D pt1 = this.getXY_(v1);
            Point2D pt2 = this.getXY_(v2);
            Point2D pt3 = this.getXY_(v3);
            Point2D center = Point2D.calculateCircleCenterFromThreePoints(pt1, pt2, pt3);
            return center;
        }

        private static boolean isClockwise_(int orientation) {
            return (double)orientation < 0.0;
        }

        private static boolean isCounterClockwise_(int orientation) {
            return (double)orientation > 0.0;
        }

        private static boolean isDegenerate_(int orientation) {
            return (double)orientation == 0.0;
        }

        private static <E> int partition_(ArrayList<E> list, int first, int last, Comparator<E> comparator) {
            int lo = first;
            int hi = last;
            int n = lo + hi >> 1;
            NthElement.execute(list, first, n, last, comparator);
            E pivot_value = list.get(n);
            int store = lo;
            int pivot_dups = 0;
            for (int i = lo; i != hi; ++i) {
                if (comparator.compare(list.get(i), pivot_value) == -1) {
                    Collections.swap(list, i, store);
                    ++store;
                    continue;
                }
                if (comparator.compare(pivot_value, list.get(i)) != 0) continue;
                ++pivot_dups;
            }
            int m = store;
            for (int i = store; pivot_dups > 0 && i != hi; ++i) {
                if (comparator.compare(pivot_value, list.get(i)) != 0) continue;
                if (comparator.compare(list.get(i), list.get(store)) != 0) {
                    Collections.swap(list, i, store);
                }
                ++store;
                --pivot_dups;
            }
            return m;
        }

        private boolean checkConstraints_() {
            if (this.m_constraints == null) {
                return true;
            }
            AttributeStreamOfInt8 visited = new AttributeStreamOfInt8(0);
            visited.reserve(this.m_constraints.size());
            int n = this.m_constraints.size();
            for (int i = 0; i < n; ++i) {
                visited.add((byte)0);
            }
            int counter = 0;
            QuadEdgeStructure.ClusterIterator cluster_iterator = new QuadEdgeStructure.ClusterIterator(this.m_quad_edge_structure, false);
            while (cluster_iterator.next()) {
                int head;
                int c = cluster_iterator.getCurrentCluster();
                int e = this.m_quad_edge_structure.getPrimaryIncidentEdge(c);
                int v = this.m_quad_edge_structure.getPrimaryOrgVertex(e);
                Vertex vertex = this.getVertex_(v);
                if (vertex.head_constraint_index == -1) continue;
                int index = head = vertex.head_constraint_index;
                while (index != -1) {
                    if (visited.get(index) != 0) {
                        assert (false);
                        return false;
                    }
                    visited.set(index, (byte)1);
                    index = this.m_constraints.get((int)index).next_constraint_index;
                    ++counter;
                }
            }
            if (counter != this.m_constraints.size()) {
                assert (false);
                return false;
            }
            int n2 = this.m_constraints.size();
            for (int i = 0; i < n2; ++i) {
                if (visited.get(i) == 0) {
                    assert (false);
                    return false;
                }
                Constraint constraint = this.m_constraints.get(i);
                if (constraint.end_pt.isNaN()) {
                    assert (false);
                    return false;
                }
                if (constraint.start_cluster != -1) continue;
                assert (false);
                return false;
            }
            return true;
        }

        private boolean verifyNearest_() {
            int E;
            if (!this.isEdgeOnConvexHullAlgebraic(this.m_le)) {
                assert (false);
                return false;
            }
            int first_primary_incident_edge = this.m_quad_edge_structure.getFirstPrimaryIncidentEdge();
            QuadEdgeStructure.ConnectedComponentEdgeIterator iter = new QuadEdgeStructure.ConnectedComponentEdgeIterator(this.m_quad_edge_structure, first_primary_incident_edge);
            int hull_face = -2;
            int convex_hull_edge_count = 0;
            int e = iter.next();
            while (e != -1) {
                if (!this.isEdgeOnConvexHullAlgebraic(e)) {
                    int ei = e;
                    int f = this.m_quad_edge_structure.getDest(this.m_quad_edge_structure.getRot(e));
                    int cycle_counter = 0;
                    do {
                        int fi;
                        if ((fi = this.m_quad_edge_structure.getDest(this.m_quad_edge_structure.getRot(ei = this.m_quad_edge_structure.getRNext(ei)))) != f) {
                            return false;
                        }
                        ++cycle_counter;
                    } while (ei != e);
                    if (cycle_counter != 3) {
                        assert (false);
                        return false;
                    }
                    int e_rnext = this.m_quad_edge_structure.getRNext(e);
                    int e_rnext_rnext = this.m_quad_edge_structure.getRNext(e_rnext);
                    if (!Impl.isClockwise_(Point2D.orientationRobust(this.getOrgXY(e), this.getOrgXY(e_rnext), this.getOrgXY(e_rnext_rnext)))) {
                        assert (false);
                        return false;
                    }
                    int e_sym = this.m_quad_edge_structure.getSym(e);
                    int e_onext = this.m_quad_edge_structure.getONext(e);
                    int e_oprev = this.m_quad_edge_structure.getOPrev(e);
                    boolean e_onext_is_valid = this.isValid_(e_onext, e_sym);
                    if (!e_onext_is_valid) {
                        assert (false);
                        return false;
                    }
                    boolean e_oprev_is_valid = this.isValid_(e_oprev, e);
                    if (e_oprev_is_valid) {
                        if (!this.isConstrained_(e)) {
                            int e_oprev_vdest;
                            int e_onext_vdest;
                            int e_vdest;
                            int e_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e);
                            if (this.inCircleNoProgress_(e_vorg, e_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(e), e_onext_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(e_onext), e_oprev_vdest = this.m_quad_edge_structure.getPrimaryDestVertex(e_oprev))) {
                                assert (false);
                                return false;
                            }
                            if (this.inCircleNoProgress_(e_vdest, e_vorg, e_oprev_vdest, e_onext_vdest)) {
                                assert (false);
                                return false;
                            }
                        }
                    } else if (!this.isEdgeOnConvexHullAlgebraic(e_sym)) {
                        assert (false);
                        return false;
                    }
                } else {
                    ++convex_hull_edge_count;
                    int f = this.m_quad_edge_structure.getDest(this.m_quad_edge_structure.getRot(e));
                    if (hull_face == -2) {
                        hull_face = f;
                    }
                    if (hull_face != f) {
                        return false;
                    }
                }
                e = iter.next();
            }
            if (convex_hull_edge_count != this.m_convex_hull_edge_count) {
                assert (false);
                return false;
            }
            int primary_cluster_count = this.m_quad_edge_structure.getPrimaryClusterCount();
            int edge_count = this.m_quad_edge_structure.getCanonicalEdgeCount();
            if (edge_count != (E = 3 * (primary_cluster_count - 1) - convex_hull_edge_count)) {
                assert (false);
                return false;
            }
            return true;
        }

        private boolean verifyFarthest_() {
            int E;
            if (!this.isEdgeOnConvexHullAlgebraic(this.m_le)) {
                assert (false);
                return false;
            }
            int first_primary_incident_edge = this.m_quad_edge_structure.getFirstPrimaryIncidentEdge();
            QuadEdgeStructure.ConnectedComponentEdgeIterator iter = new QuadEdgeStructure.ConnectedComponentEdgeIterator(this.m_quad_edge_structure, first_primary_incident_edge);
            int hull_face = -2;
            int convex_hull_edge_count = 0;
            int e = iter.next();
            while (e != -1) {
                if (!this.isEdgeOnConvexHullAlgebraic(e)) {
                    int ei = e;
                    int f = this.m_quad_edge_structure.getDest(this.m_quad_edge_structure.getRot(e));
                    int cycle_counter = 0;
                    do {
                        int fi;
                        if ((fi = this.m_quad_edge_structure.getDest(this.m_quad_edge_structure.getRot(ei = this.m_quad_edge_structure.getRNext(ei)))) != f) {
                            return false;
                        }
                        ++cycle_counter;
                    } while (ei != e);
                    if (cycle_counter != 3) {
                        assert (false);
                        return false;
                    }
                    int e_rnext = this.m_quad_edge_structure.getRNext(e);
                    int e_rnext_rnext = this.m_quad_edge_structure.getRNext(e_rnext);
                    if (!Impl.isClockwise_(Point2D.orientationRobust(this.getOrgXY(e), this.getOrgXY(e_rnext), this.getOrgXY(e_rnext_rnext)))) {
                        assert (false);
                        return false;
                    }
                    int e_sym = this.m_quad_edge_structure.getSym(e);
                    if (!this.isEdgeOnConvexHullAlgebraic(e_sym)) {
                        int e_sym_rprev_vorg;
                        int e_rprev_vorg;
                        int e_rnext_vorg;
                        int e_rprev = this.m_quad_edge_structure.getRPrev(e);
                        assert (e_rprev == this.m_quad_edge_structure.getRNext(e_rnext));
                        int e_sym_rnext = this.m_quad_edge_structure.getRNext(e_sym);
                        int e_sym_rprev = this.m_quad_edge_structure.getRPrev(e_sym);
                        assert (e_sym_rprev == this.m_quad_edge_structure.getRNext(e_sym_rnext));
                        int e_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e);
                        if (this.notInCircleNoProgress_(e_vorg, e_rnext_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e_rnext), e_rprev_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e_rprev), e_sym_rprev_vorg = this.m_quad_edge_structure.getPrimaryOrgVertex(e_sym_rprev))) {
                            assert (false);
                            return false;
                        }
                    }
                } else {
                    ++convex_hull_edge_count;
                    int f = this.m_quad_edge_structure.getDest(this.m_quad_edge_structure.getRot(e));
                    if (hull_face == -2) {
                        hull_face = f;
                    }
                    if (hull_face != f) {
                        return false;
                    }
                }
                e = iter.next();
            }
            if (convex_hull_edge_count != this.m_convex_hull_edge_count) {
                assert (false);
                return false;
            }
            int primary_cluster_count = this.m_quad_edge_structure.getPrimaryClusterCount();
            int edge_count = this.m_quad_edge_structure.getCanonicalEdgeCount();
            if (edge_count != (E = 3 * (primary_cluster_count - 1) - convex_hull_edge_count)) {
                assert (false);
                return false;
            }
            return true;
        }

        static final class MedianComparer
        implements Comparator<Vertex> {
            private int m_axis;
            private int m_perp_axis;

            MedianComparer(int axis) {
                this.m_axis = axis;
                this.m_perp_axis = this.m_axis == 0 ? 1 : 0;
            }

            @Override
            public int compare(Vertex v1, Vertex v2) {
                double b2;
                double a2;
                double a1 = v1.pt.get(this.m_axis);
                if (a1 < (a2 = v2.pt.get(this.m_axis))) {
                    return -1;
                }
                if (a1 > a2) {
                    return 1;
                }
                double b1 = v1.pt.get(this.m_perp_axis);
                if (b1 < (b2 = v2.pt.get(this.m_perp_axis))) {
                    return -1;
                }
                if (b1 > b2) {
                    return 1;
                }
                return 0;
            }
        }

        static final class XYComparer {
            private ArrayList<Vertex> m_primary_vertices;

            XYComparer(ArrayList<Vertex> primary_vertices) {
                this.m_primary_vertices = primary_vertices;
            }

            boolean compare(int v1, int v2) {
                Point2D pt1 = this.m_primary_vertices.get((int)v1).pt;
                Point2D pt2 = this.m_primary_vertices.get((int)v2).pt;
                return pt1.compareX(pt2) < 0;
            }
        }

        static final class Constraint {
            Point2D end_pt;
            int start_cluster;
            int next_constraint_index;

            Constraint() {
            }

            static Constraint construct() {
                Constraint constraint = new Constraint();
                constraint.end_pt = new Point2D();
                constraint.end_pt.setNaN();
                constraint.start_cluster = -1;
                constraint.next_constraint_index = -1;
                return constraint;
            }
        }

        static final class Vertex {
            Point2D pt;
            int vi;
            int head_constraint_index;

            Vertex() {
            }

            static Vertex construct(Point2D pt, int vi) {
                Vertex vertex = new Vertex();
                vertex.pt = new Point2D(pt.x, pt.y);
                vertex.vi = vi;
                vertex.head_constraint_index = -1;
                return vertex;
            }
        }
    }

    public static final class ClusterIterator {
        private QuadEdgeStructure.ClusterIterator m_impl;

        public ClusterIterator(DelaunayTriangulation2D dt) {
            this.m_impl = dt.getImpl_().getClusterIterator(false);
        }

        public boolean next() {
            return this.m_impl.next();
        }

        public int getCurrentCluster() {
            return this.m_impl.getCurrentCluster();
        }

        public void reset() {
            this.m_impl.reset();
        }
    }

    public static final class EdgeUserIndex {
        private QuadEdgeStructure.EdgeUserIndex m_impl;

        public EdgeUserIndex(DelaunayTriangulation2D dt) {
            this.m_impl = dt.getImpl_().getEdgeUserIndex(false);
        }

        public void setIndex(int e, int value) {
            this.m_impl.setIndex(e, value);
        }

        public int getIndex(int e) {
            return this.m_impl.getIndex(e);
        }

        public void reset() {
            this.m_impl.reset();
        }
    }

    public static final class ClusterUserIndex {
        private QuadEdgeStructure.ClusterUserIndex m_impl;

        public ClusterUserIndex(DelaunayTriangulation2D dt) {
            this.m_impl = dt.getImpl_().getClusterUserIndex(false);
        }

        public void setIndex(int c, int value) {
            this.m_impl.setIndex(c, value);
        }

        public int getIndex(int c) {
            return this.m_impl.getIndex(c);
        }

        public void reset() {
            this.m_impl.reset();
        }
    }

    public static class CallbackOnEqualXYIndices {
        public void onEqualXYIndices(int i, int j) {
        }
    }

    public static interface DelaunayOptions {
        public static final int Default = 0;
        public static final int Farthest = 32768;
    }
}

