/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorOffset;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import java.util.ArrayList;

class ConstructOffset {
    private static final double pi = Math.PI;
    private static final double two_pi = Math.PI * 2;
    private static final double half_pi = 1.5707963267948966;
    private static final double sqrt2 = 1.4142135623730951;
    private static final double oneDegree = Math.PI / 180;
    private static final int BAD_SEG = 256;
    private static final int IS_END = 512;
    private static final int CLOSING_SEG = 1024;
    private ProgressTracker m_progressTracker;
    private int m_progressCounter = 0;
    private Geometry m_inputGeometry;
    private double m_distance;
    private double m_tolerance;
    private OperatorOffset.JoinType m_joins;
    private double m_miterLimit;
    private boolean m_useZ = false;
    private boolean m_useM = false;
    private ArrayList<GraphicPoint> m_srcPts;
    private int m_srcPtCount;
    private ArrayList<GraphicPoint> m_offsetPts;
    private int m_offsetPtCount;
    private MultiPath m_resultPath;
    private double m_a1;
    private double m_a2;

    private ConstructOffset(ProgressTracker progressTracker) {
        this.m_progressTracker = progressTracker;
    }

    public static Geometry execute(Geometry inputGeometry, double distance, OperatorOffset.JoinType joins, double miterLimit, double tolerance, ProgressTracker progressTracker) {
        if (inputGeometry == null) {
            throw new IllegalArgumentException();
        }
        if (inputGeometry.getDimension() < 1) {
            throw new IllegalArgumentException();
        }
        if (distance == 0.0 || inputGeometry.isEmpty()) {
            return inputGeometry;
        }
        ConstructOffset offset = new ConstructOffset(progressTracker);
        offset.m_useZ = inputGeometry.hasAttribute(1);
        offset.m_useM = inputGeometry.hasAttribute(2);
        offset.m_inputGeometry = inputGeometry;
        offset.m_distance = distance;
        offset.m_tolerance = tolerance;
        offset.m_joins = joins;
        offset.m_miterLimit = miterLimit;
        return offset._ConstructOffset();
    }

    private Geometry _OffsetLine() {
        Line line = (Line)this.m_inputGeometry;
        Point2D start = line.getStartXY();
        Point2D end = line.getEndXY();
        Point2D v = new Point2D();
        v.sub(end, start);
        v.normalize();
        v.leftPerpendicular();
        v.scale(this.m_distance);
        start.add(v);
        end.add(v);
        Line resLine = (Line)line.createInstance();
        line.setStartXY(start);
        line.setEndXY(end);
        return resLine;
    }

    private Geometry _OffsetEnvelope() {
        Envelope envelope = (Envelope)this.m_inputGeometry;
        if (this.m_distance > 0.0 && this.m_joins != OperatorOffset.JoinType.Miter) {
            Polygon poly = new Polygon();
            poly.addEnvelope(envelope, false);
            this.m_inputGeometry = poly;
            return this._ConstructOffset();
        }
        Envelope resEnv = new Envelope(envelope);
        resEnv.inflate(this.m_distance, this.m_distance);
        return resEnv;
    }

    private void buildPoint(GraphicPoint src_pt, double d, double angle, GraphicPoint dst_pt) {
        dst_pt.x = src_pt.x + d * Math.cos(angle);
        dst_pt.y = src_pt.y + d * Math.sin(angle);
        dst_pt.type = src_pt.type;
        dst_pt.z = src_pt.z;
        dst_pt.m = src_pt.m;
        dst_pt.m_next = -1;
        dst_pt.m_prev = -1;
    }

    private void addPoint(GraphicPoint pt) {
        this.m_offsetPts.add(new GraphicPoint(pt));
        ++this.m_offsetPtCount;
    }

    private void addPointByRef(GraphicPoint pt) {
        this.m_offsetPts.add(pt);
        ++this.m_offsetPtCount;
    }

    private double scal(GraphicPoint pt1, GraphicPoint pt2, GraphicPoint pt3, GraphicPoint pt4) {
        return (pt2.x - pt1.x) * (pt4.x - pt3.x) + (pt2.y - pt1.y) * (pt4.y - pt3.y);
    }

    private void addPoint(GraphicPoint offPt, int i_src) {
        GraphicPoint pt;
        if (this.m_offsetPtCount == 0) {
            this.addPoint(offPt);
            return;
        }
        int n_src = this.m_srcPtCount;
        GraphicPoint pt1 = this.m_srcPts.get(i_src == 0 ? n_src - 1 : i_src - 1);
        double s = this.scal(pt1, pt = this.m_srcPts.get(i_src), this.m_offsetPts.get(this.m_offsetPtCount - 1), offPt);
        if (s > 0.0) {
            this.addPoint(offPt);
            return;
        }
        if (s < 0.0) {
            if (this.scal(pt1, pt, pt, this.m_offsetPts.get(this.m_offsetPtCount - 1)) > 0.0) {
                GraphicPoint p = new GraphicPoint();
                int k = i_src == 0 ? n_src - 2 : (i_src == 1 ? n_src - 1 : i_src - 2);
                GraphicPoint pt0 = this.m_srcPts.get(k);
                double a = Math.atan2(pt1.y - pt0.y, pt1.x - pt0.x);
                this.buildPoint(pt1, this.m_distance, a - 1.5707963267948966, p);
                this.m_offsetPts.set(this.m_offsetPtCount - 1, new GraphicPoint(p));
                if (this.m_joins == OperatorOffset.JoinType.Bevel || this.m_joins == OperatorOffset.JoinType.Miter) {
                    p.x = (p.x + pt1.x) * 0.5;
                    p.y = (p.y + pt1.y) * 0.5;
                    this.addPoint(p);
                    this.buildPoint(pt1, this.m_distance, this.m_a1 + 1.5707963267948966, p);
                    GraphicPoint p_ = new GraphicPoint(p);
                    p_.x = (p_.x + pt1.x) * 0.5;
                    p_.y = (p_.y + pt1.y) * 0.5;
                    p_.type |= 0x100;
                    this.addPointByRef(p_);
                    this.addPoint(p);
                } else {
                    this.buildPoint(pt1, this.m_distance, this.m_a1 + 1.5707963267948966, p);
                    p.type |= 0x100;
                    this.addPoint(p);
                }
                this.addPoint(offPt, i_src);
            } else {
                GraphicPoint p = new GraphicPoint();
                this.buildPoint(pt, this.m_distance, this.m_a1 + 1.5707963267948966, p);
                this.addPoint(p);
                if (this.m_joins == OperatorOffset.JoinType.Bevel || this.m_joins == OperatorOffset.JoinType.Miter) {
                    p.x = (p.x + pt.x) * 0.5;
                    p.y = (p.y + pt.y) * 0.5;
                    this.addPoint(p);
                    this.buildPoint(pt, this.m_distance, this.m_a2 - 1.5707963267948966, p);
                    GraphicPoint p_ = new GraphicPoint(p);
                    p_.x = (p_.x + pt.x) * 0.5;
                    p_.y = (p_.y + pt.y) * 0.5;
                    p_.type |= 0x100;
                    this.addPointByRef(p_);
                    this.addPoint(p);
                } else {
                    this.buildPoint(pt, this.m_distance, this.m_a2 - 1.5707963267948966, p);
                    p.type |= 0x100;
                    this.addPoint(p);
                }
            }
        }
    }

    private boolean buildOffset() {
        GraphicPoint p = new GraphicPoint();
        int n = this.m_srcPtCount;
        this.m_offsetPtCount = 0;
        double flattenTolerance = this.m_tolerance * 0.5;
        double a1_0 = 0.0;
        double a2_0 = 0.0;
        for (int i = 0; i < n; ++i) {
            boolean bAddSegment;
            double r;
            this.progress();
            GraphicPoint pt = this.m_srcPts.get(i);
            GraphicPoint pt1 = i == 0 ? this.m_srcPts.get(n - 1) : this.m_srcPts.get(i - 1);
            GraphicPoint pt2 = i == n - 1 ? this.m_srcPts.get(0) : this.m_srcPts.get(i + 1);
            double dx1 = pt1.x - pt.x;
            double dy1 = pt1.y - pt.y;
            double dx2 = pt2.x - pt.x;
            double dy2 = pt2.y - pt.y;
            double a1 = Math.atan2(dy1, dx1);
            double a2 = Math.atan2(dy2, dx2);
            this.m_a1 = a1;
            this.m_a2 = a2;
            if (i == 0) {
                a1_0 = a1;
                a2_0 = a2;
            }
            double cross_product = dx1 * dy2 - dx2 * dy1;
            double saved_a2 = a2;
            if (a2 < a1) {
                a2 += Math.PI * 2;
            }
            if (cross_product * this.m_distance > 0.0) {
                if (this.m_joins == OperatorOffset.JoinType.Bevel || this.m_joins == OperatorOffset.JoinType.Miter) {
                    this.buildPoint(pt, this.m_distance, a1 + 1.5707963267948966, p);
                    this.addPoint(p);
                    double ratio = 0.001;
                    p.x = pt.x + (p.x - pt.x) * 0.001;
                    p.y = pt.y + (p.y - pt.y) * 0.001;
                    this.addPoint(p);
                    this.buildPoint(pt, this.m_distance, a2 - 1.5707963267948966, p);
                    GraphicPoint p_ = new GraphicPoint(p);
                    p_.x = pt.x + (p_.x - pt.x) * 0.001;
                    p_.y = pt.y + (p_.y - pt.y) * 0.001;
                    p_.type |= 0x100;
                    this.addPointByRef(p_);
                    this.addPoint(p);
                    continue;
                }
                r = (a2 - a1) * 0.5;
                double d = this.m_distance / Math.abs(Math.sin(r));
                this.buildPoint(pt, d, (a1 + a2) * 0.5, p);
                this.addPoint(p, i);
                continue;
            }
            if ((pt.type & 0x200) != 0) {
                double a;
                double da;
                r = 1.0 - flattenTolerance / Math.abs(this.m_distance);
                int na = 1;
                double d = da = this.m_distance < 0.0 ? -Math.PI : Math.PI;
                if (r > -1.0 && r < 1.0) {
                    a = Math.acos(r) * 2.0;
                    if (a < Math.PI / 180) {
                        a = Math.PI / 180;
                    }
                    if ((na = (int)(Math.PI / a + 1.5)) > 1) {
                        da /= (double)na;
                    }
                }
                if (na <= 1) {
                    na = 2;
                    da /= 2.0;
                }
                a = a1 + 1.5707963267948966;
                this.buildPoint(pt, this.m_distance, a, p);
                if (i == 0) {
                    p.type |= 0x400;
                }
                this.addPoint(p, i);
                double d2 = this.m_distance / Math.cos(da / 2.0);
                this.buildPoint(pt, d2, a += da / 2.0, p);
                p.type |= 0x400;
                this.addPoint(p);
                while (--na > 0) {
                    this.buildPoint(pt, d2, a += da, p);
                    p.type |= 0x400;
                    this.addPoint(p);
                }
                this.buildPoint(pt, this.m_distance, a2 - 1.5707963267948966, p);
                p.type |= 0x400;
                this.addPoint(p);
                continue;
            }
            if (this.m_joins == OperatorOffset.JoinType.Bevel) {
                this.buildPoint(pt, this.m_distance, a1 + 1.5707963267948966, p);
                this.addPoint(p, i);
                this.buildPoint(pt, this.m_distance, a2 - 1.5707963267948966, p);
                this.addPoint(p);
                continue;
            }
            if (this.m_joins == OperatorOffset.JoinType.Round) {
                r = 1.0 - flattenTolerance / Math.abs(this.m_distance);
                long na = 1L;
                double da = a2 - 1.5707963267948966 - (a1 + 1.5707963267948966);
                if (r > -1.0 && r < 1.0) {
                    double a = Math.acos(r) * 2.0;
                    if (a < Math.PI / 180) {
                        a = Math.PI / 180;
                    }
                    if ((na = (long)(Math.abs(da) / a + 1.5)) > 1L) {
                        da /= (double)na;
                    }
                }
                double d = this.m_distance / Math.cos(da * 0.5);
                double a = a1 + 1.5707963267948966 + da * 0.5;
                this.buildPoint(pt, d, a, p);
                this.addPoint(p, i);
                while (--na > 0L) {
                    this.buildPoint(pt, d, a += da, p);
                    this.addPoint(p);
                }
                continue;
            }
            if (this.m_joins == OperatorOffset.JoinType.Miter) {
                double d;
                double r2;
                double bevelDistance;
                double d2;
                double dx12 = pt1.x - pt.x;
                double dx22 = pt2.x - pt.x;
                double dy12 = pt1.y - pt.y;
                double dy22 = pt2.y - pt.y;
                double d1 = Math.sqrt(dx12 * dx12 + dy12 * dy12);
                double cosa = (dx12 * dx22 + dy12 * dy22) / d1 / (d2 = Math.sqrt(dx22 * dx22 + dy22 * dy22));
                if (cosa > 0.99999999) {
                    this.buildPoint(pt, 1.4142135623730951 * this.m_distance, a2 - 0.7853981633974483, p);
                    this.addPoint(p, i);
                    this.buildPoint(pt, 1.4142135623730951 * this.m_distance, a2 + 0.7853981633974483, p);
                    this.addPoint(p);
                    continue;
                }
                double distanceFromCorner = Math.abs(this.m_distance / Math.sin(Math.acos(cosa) * 0.5));
                if (distanceFromCorner > (bevelDistance = Math.abs(this.m_miterLimit * this.m_distance))) {
                    r2 = (a2 - a1) * 0.5;
                    d = this.m_distance / Math.abs(Math.sin(r2));
                    this.buildPoint(pt, d, (a1 + a2) * 0.5, p);
                    Point2D corner = new Point2D(p.x, p.y);
                    Point2D through = new Point2D(pt.x, pt.y);
                    Point2D delta = new Point2D();
                    delta.sub(corner, through);
                    Point2D midPoint = new Point2D();
                    midPoint.scaleAdd(bevelDistance / delta.length(), delta, through);
                    double sideLength = Math.sqrt(distanceFromCorner * distanceFromCorner - this.m_distance * this.m_distance);
                    double halfWidth = (distanceFromCorner - bevelDistance) * Math.abs(this.m_distance) / sideLength;
                    if (this.m_distance > 0.0) {
                        delta.leftPerpendicular();
                    } else {
                        delta.rightPerpendicular();
                    }
                    delta.scale(halfWidth / delta.length());
                    Point2D from = new Point2D();
                    from.add(midPoint, delta);
                    Point2D to = new Point2D();
                    to.sub(midPoint, delta);
                    p.x = from.x;
                    p.y = from.y;
                    this.addPoint(p, i);
                    p.x = to.x;
                    p.y = to.y;
                    this.addPoint(p);
                    continue;
                }
                r2 = (a2 - a1) * 0.5;
                d = this.m_distance / Math.abs(Math.sin(r2));
                this.buildPoint(pt, d, (a1 + a2) * 0.5, p);
                this.addPoint(p, i);
                continue;
            }
            a2 = saved_a2;
            if (this.m_distance > 0.0) {
                if (a2 > a1) {
                    a2 -= Math.PI * 2;
                }
                bAddSegment = a1 - a2 < 1.5707963267948966;
            } else {
                if (a2 < a1) {
                    a2 += Math.PI * 2;
                }
                boolean bl = bAddSegment = a2 - a1 < 1.5707963267948966;
            }
            if (bAddSegment) {
                double d = this.m_distance * 1.4142135623730951;
                double a = d < 0.0 ? a1 + 0.7853981633974483 : a1 + 2.356194490192345;
                this.buildPoint(pt, d, a, p);
                this.addPoint(p, i);
                a = d < 0.0 ? a2 - 0.7853981633974483 : a2 - 2.356194490192345;
                this.buildPoint(pt, d, a, p);
                this.addPoint(p);
                continue;
            }
            double r3 = (a2 - a1) * 0.5;
            double d = this.m_distance / Math.abs(Math.sin(r3));
            if (a2 < a1) {
                a2 += Math.PI * 2;
            }
            this.buildPoint(pt, d, (a1 + a2) / 2.0, p);
            this.addPoint(p, i);
        }
        this.m_a1 = a1_0;
        this.m_a2 = a2_0;
        this.addPoint(this.m_offsetPts.get(0), 0);
        this.m_offsetPts.set(0, new GraphicPoint(this.m_offsetPts.get(this.m_offsetPtCount - 1)));
        return this.removeBadSegsFast();
    }

    private void addPart(int iStart, int cPts) {
        if (cPts < 2) {
            return;
        }
        for (int i = 0; i < cPts; ++i) {
            this.progress();
            GraphicPoint pt = this.m_offsetPts.get(iStart + i);
            if (i != 0) {
                if (this.m_useZ) {
                    this.m_resultPath.lineTo(pt.x, pt.y, pt.z);
                } else {
                    this.m_resultPath.lineTo(pt.x, pt.y);
                }
            } else if (this.m_useZ) {
                this.m_resultPath.startPath(pt.x, pt.y, pt.z);
            } else {
                this.m_resultPath.startPath(pt.x, pt.y);
            }
            if (!this.m_useM) continue;
            int idx = this.m_resultPath.getPointCount() - 1;
            this.m_resultPath.setAttribute(2, idx, 0, pt.m);
        }
    }

    private void _OffsetPath(MultiPath multiPath, int pathIndex, MultiPath resultingPath) {
        int endVertex;
        int startVertex;
        this.m_offsetPts = new ArrayList();
        this.m_resultPath = resultingPath;
        Point2D dummy = new Point2D();
        if (multiPath.isClosedPath(pathIndex)) {
            Point2D ptStart = multiPath.getXY(startVertex);
            for (endVertex = multiPath.getPathEnd(pathIndex); endVertex > startVertex; --endVertex) {
                multiPath.getXY(endVertex - 1, dummy);
                if (!dummy.isEqual(ptStart)) break;
            }
            if (endVertex - startVertex >= 2) {
                this.m_srcPtCount = endVertex - startVertex;
                this.m_srcPts = new ArrayList(this.m_srcPtCount);
                for (int i = startVertex; i < endVertex; ++i) {
                    this.progress();
                    multiPath.getXY(i, dummy);
                    this.m_srcPts.add(GraphicPoint.construct(dummy, this.m_useZ ? multiPath.getAttributeAsDbl(1, i, 0) : 0.0, this.m_useM ? multiPath.getAttributeAsDbl(2, i, 0) : 0.0));
                }
                if (this.buildOffset()) {
                    this.addPart(0, this.m_offsetPtCount - 1);
                }
            }
        } else {
            Point2D ptStart = multiPath.getXY(startVertex);
            for (startVertex = multiPath.getPathStart(pathIndex); startVertex < endVertex - 1; ++startVertex) {
                multiPath.getXY(startVertex + 1, dummy);
                if (!dummy.isEqual(ptStart)) break;
            }
            Point2D ptEnd = multiPath.getXY(endVertex - 1);
            while (startVertex < endVertex - 1) {
                multiPath.getXY(endVertex - 2, dummy);
                if (!dummy.isEqual(ptEnd)) break;
                --endVertex;
            }
            if (endVertex - startVertex >= 2) {
                this.m_srcPtCount = (endVertex - startVertex) * 2 - 2;
                GraphicPoint[] srcPts = new GraphicPoint[this.m_srcPtCount];
                GraphicPoint pt = GraphicPoint.construct(ptStart, this.m_useZ ? multiPath.getAttributeAsDbl(1, startVertex, 0) : 0.0, this.m_useM ? multiPath.getAttributeAsDbl(2, startVertex, 0) : 0.0);
                pt.type |= 0x600;
                srcPts[0] = pt;
                int direct = 1;
                int reverse = this.m_srcPtCount - 1;
                int i = startVertex + 1;
                while (i < endVertex - 1) {
                    this.progress();
                    multiPath.getXY(i, dummy);
                    srcPts[direct] = pt = GraphicPoint.construct(dummy, this.m_useZ ? multiPath.getAttributeAsDbl(1, i, 0) : 0.0, this.m_useM ? multiPath.getAttributeAsDbl(2, i, 0) : 0.0);
                    pt = new GraphicPoint(pt);
                    pt.type |= 0x400;
                    srcPts[reverse] = pt;
                    ++i;
                    ++direct;
                    --reverse;
                }
                multiPath.getXY(endVertex - 1, dummy);
                pt = GraphicPoint.construct(dummy, this.m_useZ ? multiPath.getAttributeAsDbl(1, endVertex - 1, 0) : 0.0, this.m_useM ? multiPath.getAttributeAsDbl(2, endVertex - 1, 0) : 0.0);
                pt.type |= 0x200;
                srcPts[direct] = pt;
                this.m_srcPts = new ArrayList(this.m_srcPtCount);
                for (GraphicPoint p : srcPts) {
                    this.m_srcPts.add(p);
                }
                srcPts = null;
                if (this.buildOffset()) {
                    int iEnd;
                    if (this.m_offsetPts.size() >= 2) {
                        boolean prevClosed;
                        int iStart = -1;
                        iEnd = -1;
                        boolean bl = prevClosed = (this.m_offsetPts.get((int)(this.m_offsetPtCount - 1)).type & 0x400) != 0;
                        if (!prevClosed) {
                            iStart = 0;
                        }
                        for (int i2 = 1; i2 < this.m_offsetPtCount; ++i2) {
                            boolean closed;
                            this.progress();
                            boolean bl2 = closed = (this.m_offsetPts.get((int)i2).type & 0x400) != 0;
                            if (!closed) {
                                if (prevClosed) {
                                    iStart = i2 - 1;
                                }
                            } else if (!prevClosed && (iEnd = i2 - 1) - iStart + 1 > 1) {
                                this.addPart(iStart, iEnd - iStart + 1);
                            }
                            prevClosed = closed;
                        }
                        if (!prevClosed && (iEnd = this.m_offsetPtCount - 1) - iStart + 1 > 1) {
                            this.addPart(iStart, iEnd - iStart + 1);
                        }
                    } else {
                        int iStart = 0;
                        iEnd = this.m_offsetPtCount - 1;
                        if (iStart >= 0 && iEnd - iStart >= 1) {
                            this.addPart(iStart, iEnd - iStart + 1);
                        }
                    }
                }
            }
        }
        this.m_srcPts = null;
        this.m_srcPtCount = 0;
        this.m_offsetPts = null;
        this.m_offsetPtCount = 0;
    }

    private boolean removeBadSegsFast() {
        boolean bWrong = false;
        for (int i = 0; i < this.m_offsetPtCount; ++i) {
            this.progress();
            GraphicPoint pt = this.m_offsetPts.get(i);
            pt.m_next = i + 1;
            pt.m_prev = i - 1;
        }
        this.m_offsetPts.get((int)0).m_prev = this.m_offsetPtCount - 2;
        this.m_offsetPts.get((int)(this.m_offsetPtCount - 2)).m_next = 0;
        int w = 0;
        for (int i = 0; i < this.m_offsetPtCount; ++i) {
            if ((this.m_offsetPts.get((int)w).type & 0x100) != 0) {
                int wNext = this.deleteClosedSeg(w);
                if (wNext != -1) {
                    w = wNext;
                    continue;
                }
                bWrong = true;
                break;
            }
            w = this.m_offsetPts.get((int)w).m_next;
        }
        if (bWrong) {
            return false;
        }
        this.compressOffsetArray(w);
        return true;
    }

    private int deleteClosedSeg(int seg) {
        int n = this.m_offsetPtCount - 1;
        int ip0 = seg;
        for (int i = 1; i <= n - 2; ++i) {
            int ip = ip0 = this.m_offsetPts.get((int)ip0).m_next;
            int im = seg;
            for (int j = 1; j <= i; ++j) {
                int rSegNext;
                this.progress();
                im = this.m_offsetPts.get((int)im).m_prev;
                if ((this.m_offsetPts.get((int)im).type & 0x100) == 0 && (this.m_offsetPts.get((int)ip).type & 0x100) == 0 && (rSegNext = this.handleClosedIntersection(im, ip)) != -1) {
                    return rSegNext;
                }
                ip = this.m_offsetPts.get((int)ip).m_prev;
            }
        }
        return -1;
    }

    private int handleClosedIntersection(int im, int ip) {
        boolean fi;
        GraphicPoint pt_4;
        GraphicPoint pt_3;
        GraphicPoint pt_2;
        GraphicPoint pt_1 = this.m_offsetPts.get(this.m_offsetPts.get((int)im).m_prev);
        if (!this.sectGraphicRect(pt_1, pt_2 = this.m_offsetPts.get(im), pt_3 = this.m_offsetPts.get(this.m_offsetPts.get((int)ip).m_prev), pt_4 = this.m_offsetPts.get(ip))) {
            return -1;
        }
        IntersectionInfo ii = new IntersectionInfo();
        if (((pt_2.x - pt_1.x) * (pt_4.y - pt_3.y) - (pt_2.y - pt_1.y) * (pt_4.x - pt_3.x)) * this.m_distance < 0.0 && (fi = this.findIntersection(pt_1, pt_2, pt_3, pt_4, ii)) && !ii.atExistingPt) {
            double epsilon = 1.0E-8;
            double len1 = Math.sqrt((pt_2.x - pt_1.x) * (pt_2.x - pt_1.x) + (pt_2.y - pt_1.y) * (pt_2.y - pt_1.y));
            double dx1 = (pt_2.x - pt_1.x) / len1;
            double dy1 = (pt_2.y - pt_1.y) / len1;
            double len2 = Math.sqrt((pt_4.x - pt_3.x) * (pt_4.x - pt_3.x) + (pt_4.y - pt_3.y) * (pt_4.y - pt_3.y));
            double dx2 = (pt_4.x - pt_3.x) / len2;
            double dy2 = (pt_4.y - pt_3.y) / len2;
            boolean c = false;
            GraphicPoint pt = new GraphicPoint(ii.pt);
            pt.x += (dx1 + dx2) * 1.0E-8;
            pt.y += (dy1 + dy2) * 1.0E-8;
            GraphicPoint pt1 = pt_3;
            GraphicPoint pt2 = ii.pt;
            int i = this.m_offsetPts.get((int)im).m_prev;
            while (true) {
                if (pt2.y > pt.y != pt1.y > pt.y && pt.x < (pt1.x - pt2.x) * (pt.y - pt2.y) / (pt1.y - pt2.y) + pt2.x) {
                    c = !c;
                }
                pt1 = pt2;
                i = this.m_offsetPts.get((int)i).m_next;
                if (i == ip) break;
                pt2 = this.m_offsetPts.get(i);
            }
            if (c) {
                return -1;
            }
            int prev_0 = this.m_offsetPts.get((int)im).m_prev;
            ii.pt.type = pt_2.type;
            ii.pt.m_next = ip;
            ii.pt.m_prev = prev_0;
            this.m_offsetPts.set(im, new GraphicPoint(ii.pt));
            this.m_offsetPts.get((int)ip).m_prev = im;
            return ip;
        }
        return -1;
    }

    private boolean sectGraphicRect(GraphicPoint pt1, GraphicPoint pt2, GraphicPoint pt3, GraphicPoint pt4) {
        return Math.max(pt1.x, pt2.x) >= Math.min(pt3.x, pt4.x) && Math.max(pt3.x, pt4.x) >= Math.min(pt1.x, pt2.x) && Math.max(pt1.y, pt2.y) >= Math.min(pt3.y, pt4.y) && Math.max(pt3.y, pt4.y) >= Math.min(pt1.y, pt2.y);
    }

    private boolean findIntersection(GraphicPoint bp_1, GraphicPoint bp_2, GraphicPoint bp_3, GraphicPoint bp_4, IntersectionInfo intersectionInfo) {
        intersectionInfo.atExistingPt = false;
        double i = (bp_2.y - bp_1.y) * (bp_4.x - bp_3.x) - (bp_2.x - bp_1.x) * (bp_4.y - bp_3.y);
        double j = (bp_3.y - bp_1.y) * (bp_2.x - bp_1.x) - (bp_3.x - bp_1.x) * (bp_2.y - bp_1.y);
        double r = i == 0.0 ? 2.0 : j / i;
        if (r >= 0.0 && r <= 1.0) {
            double r1 = r;
            i = (bp_4.y - bp_3.y) * (bp_2.x - bp_1.x) - (bp_4.x - bp_3.x) * (bp_2.y - bp_1.y);
            j = (bp_1.y - bp_3.y) * (bp_4.x - bp_3.x) - (bp_1.x - bp_3.x) * (bp_4.y - bp_3.y);
            r = i == 0.0 ? 2.0 : j / i;
            if (r >= 0.0 && r <= 1.0) {
                intersectionInfo.pt = new GraphicPoint();
                intersectionInfo.pt.x = bp_1.x + r * (bp_2.x - bp_1.x);
                intersectionInfo.pt.y = bp_1.y + r * (bp_2.y - bp_1.y);
                if (this.m_useZ) {
                    intersectionInfo.pt.z = bp_3.z + r1 * (bp_4.z - bp_3.z);
                }
                if (this.m_useM) {
                    intersectionInfo.pt.m = bp_3.m + r1 * (bp_4.m - bp_3.m);
                }
                if (!(r1 != 0.0 && r1 != 1.0 || r != 0.0 && r != 1.0)) {
                    intersectionInfo.atExistingPt = true;
                }
                return (r1 != 0.0 && r1 != 1.0 || !(r > 0.0) || !(r < 1.0)) && (r != 0.0 && r != 1.0 || !(r1 > 0.0) || !(r1 < 1.0));
            }
        }
        return false;
    }

    private void compressOffsetArray(int i0_) {
        int i0 = i0_;
        while (this.m_offsetPts.get((int)i0).m_prev < i0) {
            i0 = this.m_offsetPts.get((int)i0).m_prev;
        }
        int j = 0;
        int i = i0;
        do {
            GraphicPoint pt = this.m_offsetPts.get(i);
            this.m_offsetPts.set(j, new GraphicPoint(pt));
            i = pt.m_next;
            ++j;
        } while (i != i0);
        this.m_offsetPts.set(j, new GraphicPoint(this.m_offsetPts.get(0)));
        this.m_offsetPtCount = j + 1;
    }

    private void _OffsetMultiPath(MultiPath resultingPath) {
        MultiPath multiPath = (MultiPath)this.m_inputGeometry;
        SegmentIterator segmentIterator = multiPath.querySegmentIterator();
        segmentIterator.resetToFirstPath();
        int pathIndex = -1;
        while (segmentIterator.nextPath()) {
            this._OffsetPath(multiPath, ++pathIndex, resultingPath);
        }
    }

    private Geometry _ConstructOffset() {
        int gt = this.m_inputGeometry.getType().value();
        if (gt == 322) {
            return this._OffsetLine();
        }
        if (gt == 197) {
            return this._OffsetEnvelope();
        }
        if (Geometry.isSegment(gt)) {
            Polyline poly = new Polyline();
            poly.addSegment((Segment)this.m_inputGeometry, true);
            this.m_inputGeometry = poly;
            return this._ConstructOffset();
        }
        if (gt == 1607) {
            Polyline polyline = new Polyline();
            this._OffsetMultiPath(polyline);
            return polyline;
        }
        if (gt == 1736) {
            Polygon polygon = new Polygon();
            this._OffsetMultiPath(polygon);
            return polygon;
        }
        throw new GeometryException("not implemented");
    }

    private void progress() {
        if ((++this.m_progressCounter & 0xFFF) == 0) {
            ProgressTracker.checkAndThrow(this.m_progressTracker);
            this.m_progressCounter = 0;
        }
    }

    private static class IntersectionInfo {
        GraphicPoint pt = null;
        boolean atExistingPt = false;

        private IntersectionInfo() {
        }
    }

    private static class GraphicPoint {
        double x;
        double y;
        int m_next = -1;
        int m_prev = -1;
        double z;
        double m;
        int type;

        GraphicPoint() {
        }

        GraphicPoint(GraphicPoint pt) {
            this.x = pt.x;
            this.y = pt.y;
            this.type = pt.type;
            this.m = pt.m;
            this.z = pt.z;
            this.m_prev = pt.m_prev;
            this.m_next = pt.m_next;
        }

        static GraphicPoint construct(Point2D r, double z, double m) {
            GraphicPoint pt = new GraphicPoint();
            pt.x = r.x;
            pt.y = r.y;
            pt.m_next = -1;
            pt.m_prev = -1;
            pt.z = z;
            pt.m = m;
            pt.type = 0;
            return pt;
        }
    }
}

