/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.CompositeGeographicTransformation;
import com.esri.core.geometry.GeographicTransformation;
import com.esri.core.geometry.GeographicTransformationImpl;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.sde.sdk.pe.engine.PeGTTransformations;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeGeogtran;
import com.esri.sde.sdk.pe.factory.PeGTlistExtendedEntry;
import com.esri.sde.sdk.pe.factory.PeGTlistExtendedGTs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@HadoopSDKExcluded
class CompositeGeographicTransformationImpl
extends CompositeGeographicTransformation {
    private static final long serialVersionUID = 2L;
    List<GeographicTransformation> m_transforms;
    boolean m_bReadonly = false;

    CompositeGeographicTransformationImpl() {
        this.m_transforms = new ArrayList<GeographicTransformation>(3);
    }

    CompositeGeographicTransformationImpl(List<GeographicTransformation> transforms) {
        this.m_transforms = transforms;
    }

    @Override
    public boolean isMutable() {
        return !this.m_bReadonly;
    }

    @Override
    public void copyTo(CompositeGeographicTransformation _dst) {
        CompositeGeographicTransformationImpl dst = (CompositeGeographicTransformationImpl)_dst;
        if (dst.m_bReadonly) {
            throw new GeometryException("CompositeGeographicTransformation is read-only");
        }
        for (int i = 0; i < this.m_transforms.size(); ++i) {
            dst.m_transforms.add(this.m_transforms.get(i).copy());
        }
    }

    static CompositeGeographicTransformationImpl createImpl(PeGTlistExtendedEntry gtTransformEx) {
        CompositeGeographicTransformationImpl compositeGT = null;
        int steps = gtTransformEx.getSteps();
        if (steps != 0) {
            compositeGT = new CompositeGeographicTransformationImpl();
            PeGTlistExtendedGTs[] gts = gtTransformEx.getEntries();
            for (int i = 0; i < steps; ++i) {
                GeographicTransformationImpl g = new GeographicTransformationImpl((PeGeogtran)gts[i].getGeogtran().clone());
                if (gts[i].getDirection() != 0) {
                    g.invert();
                }
                compositeGT.add(g);
            }
        }
        return compositeGT;
    }

    @Override
    public int count() {
        return this.m_transforms.size();
    }

    @Override
    public GeographicTransformation getGeogTran(int index) {
        return this.m_transforms.get(index);
    }

    @Override
    public void setGeogTran(int index, GeographicTransformation tran) {
        if (this.m_bReadonly) {
            throw new GeometryException("CompositeGeographicTransformation is read-only");
        }
        this.m_transforms.set(index, tran.copy());
    }

    @Override
    public void add(GeographicTransformation tran) {
        if (this.m_bReadonly) {
            throw new GeometryException("CompositeGeographicTransformation is read-only");
        }
        this.m_transforms.add(tran.copy());
    }

    @Override
    public void clear() {
        if (this.m_bReadonly) {
            throw new GeometryException("CompositeGeographicTransformation is read-only");
        }
        this.m_transforms.clear();
    }

    @Override
    public void remove(int index) {
        if (this.m_bReadonly) {
            throw new GeometryException("CompositeGeographicTransformation is read-only");
        }
        this.m_transforms.remove(index);
    }

    @Override
    public CompositeGeographicTransformation getInverse() {
        CompositeGeographicTransformationImpl inverse = this._clone();
        for (int i = 0; i < inverse.count(); ++i) {
            ((GeographicTransformationImpl)inverse.getGeogTran(i)).invert();
        }
        Collections.reverse(inverse.m_transforms);
        return inverse;
    }

    public CompositeGeographicTransformationImpl _clone() {
        CompositeGeographicTransformationImpl copy = new CompositeGeographicTransformationImpl();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public CompositeGeographicTransformation copy() {
        return this._clone();
    }

    public int transform(double[][] coords, int count, double inUnitFactor, double outUnitFactor) {
        if (coords.length < count) {
            throw new GeometryException("invalid Argument");
        }
        double eps = 3.552713678800501E-15;
        double prevUnitFactor = inUnitFactor;
        for (int i = 0; i < this.m_transforms.size(); ++i) {
            GeographicTransformationImpl gt = (GeographicTransformationImpl)this.m_transforms.get(i);
            if (gt.getPeGeogtran() == null) continue;
            boolean invert = gt.isInverted();
            int direction = invert ? 1 : 0;
            double factor1 = prevUnitFactor;
            PeGeogcs inGCS1 = invert ? gt.getPeGeogtran().getGeogcs2() : gt.getPeGeogtran().getGeogcs1();
            double factor2 = inGCS1.getUnit().getUnitFactor();
            double conv = factor1 / factor2;
            if (Math.abs(conv - 1.0) > 3.552713678800501E-15) {
                for (int j = 0; j < count; ++j) {
                    double[] dArray = coords[j];
                    dArray[0] = dArray[0] * conv;
                    double[] dArray2 = coords[j];
                    dArray2[1] = dArray2[1] * conv;
                }
            }
            PeGTTransformations.geogToGeog((PeGeogtran)gt.getPeGeogtran(), (int)count, (double[][])coords, null, (int)direction);
            PeGeogcs inGCS2 = invert ? gt.getPeGeogtran().getGeogcs1() : gt.getPeGeogtran().getGeogcs2();
            prevUnitFactor = inGCS2.getUnit().getUnitFactor();
        }
        double factor1 = prevUnitFactor;
        double factor2 = outUnitFactor;
        double conv = factor1 / factor2;
        if (Math.abs(conv - 1.0) > 3.552713678800501E-15) {
            for (int j = 0; j < count; ++j) {
                double[] dArray = coords[j];
                dArray[0] = dArray[0] * conv;
                double[] dArray3 = coords[j];
                dArray3[1] = dArray3[1] * conv;
            }
        }
        return count;
    }

    @Override
    public boolean referencesMissingData() {
        if (this.m_transforms.size() == 0) {
            return false;
        }
        int n = this.m_transforms.size();
        for (int i = 0; i < n; ++i) {
            if (!this.m_transforms.get(i).referencesMissingData()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.m_transforms.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int n = this.m_transforms.size();
        for (int i = 0; i < n; ++i) {
            if (result.length() > 0) {
                result.append(" + ");
            }
            result.append(this.m_transforms.get(i).getName());
        }
        return result.toString();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.m_transforms.size(); ++i) {
            hash = hash * 37 + this.m_transforms.get(i).hashCode();
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CompositeGeographicTransformationImpl o = (CompositeGeographicTransformationImpl)other;
        if (this.m_transforms.size() != o.m_transforms.size()) {
            return false;
        }
        for (int i = 0; i < this.m_transforms.size(); ++i) {
            if (this.m_transforms.get(i).equals(o.m_transforms.get(i))) continue;
            return false;
        }
        return true;
    }

    void setReadonly() {
        this.m_bReadonly = true;
    }

    public String toString() {
        String snippet = this.toString();
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }
}

