/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.IndexHashTable;
import com.esri.core.geometry.IndexMultiList;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.StridedIndexTypeCollection;

final class Clusterer {
    private Point2D m_origin = new Point2D();
    private double m_sqr_tolerance;
    private double m_cell_size;
    private double m_inv_cell_size;
    private int m_geometry;
    private int[] m_bucket_array = new int[4];
    private int[] m_bucket_hash = new int[4];
    private int m_hash_values = -1;
    private int m_new_clusters = -1;
    private ProgressTracker m_progress_tracker;
    int m_progress_counter = 0;
    private EditShape m_shape;
    private IndexMultiList m_clusters;
    private ClusterHashFunction m_hash_function;
    private IndexHashTable m_hash_table;

    Clusterer(ProgressTracker progress_tracker) {
        progress_tracker = this.m_progress_tracker;
    }

    static boolean executeNonReciprocal(EditShape shape, double tolerance, int geometry, ProgressTracker progress_tracker) {
        Clusterer clusterer = new Clusterer(progress_tracker);
        clusterer.m_shape = shape;
        clusterer.m_sqr_tolerance = tolerance * tolerance;
        clusterer.m_cell_size = 2.0 * tolerance;
        clusterer.m_inv_cell_size = 1.0 / clusterer.m_cell_size;
        clusterer.m_geometry = geometry;
        clusterer.m_origin.setNaN();
        return clusterer.clusterNonReciprocal_();
    }

    static boolean isClusterCandidate_(double x_1, double y1, double x2, double y2, double sqr_tolerance) {
        double dx = x_1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy <= sqr_tolerance;
    }

    static MultiPoint clusterPoints2D(MultiPoint multiPoint, boolean useMAsWeight, double tolerance, boolean reserved) {
        if (reserved) {
            throw new IllegalArgumentException();
        }
        EditShape editShape = new EditShape();
        editShape.addGeometry(multiPoint);
        if (useMAsWeight && multiPoint.hasAttribute(2)) {
            EditShape.VertexIterator vi = editShape.queryVertexIterator();
            int vertex = vi.next();
            while (vertex != -1) {
                double m = editShape.getAttributeAsDbl(2, vertex, 0);
                if (!(m >= 1.0)) {
                    throw new IllegalArgumentException();
                }
                editShape.setWeight(vertex, m);
                vertex = vi.next();
            }
        }
        Clusterer.executeNonReciprocal(editShape, tolerance, -1, null);
        return (MultiPoint)editShape.getGeometry(editShape.getFirstGeometry());
    }

    static int hashFunction_(int xi, int yi) {
        int h = NumberUtils.hash(xi);
        return NumberUtils.hash(h, yi);
    }

    private void collectClusterCandidates_(int xyindex, AttributeStreamOfInt32 candidates) {
        Point2D pointOfInterest = new Point2D();
        this.m_shape.getXY(xyindex, pointOfInterest);
        double x_0 = pointOfInterest.x - this.m_origin.x;
        double x = x_0 * this.m_inv_cell_size;
        double y0 = pointOfInterest.y - this.m_origin.y;
        double y = y0 * this.m_inv_cell_size;
        int xi = (int)x;
        int yi = (int)y;
        int bucket_count = 0;
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                int hash = Clusterer.hashFunction_(xi + dx, yi + dy);
                int bucket_ptr = this.m_hash_table.getFirstInBucket(hash);
                if (bucket_ptr == -1) continue;
                this.m_bucket_array[bucket_count] = bucket_ptr;
                this.m_bucket_hash[bucket_count] = hash;
                ++bucket_count;
            }
        }
        block2: for (int j = bucket_count - 1; j >= 1; --j) {
            int bucket_ptr = this.m_bucket_array[j];
            for (int i = j - 1; i >= 0; --i) {
                if (bucket_ptr != this.m_bucket_array[i]) continue;
                this.m_bucket_hash[i] = -1;
                if (j == --bucket_count) continue block2;
                this.m_bucket_hash[j] = this.m_bucket_hash[bucket_count];
                this.m_bucket_array[j] = this.m_bucket_array[bucket_count];
                continue block2;
            }
        }
        for (int i = 0; i < bucket_count; ++i) {
            this.collectNearestNeighbourCandidates_(xyindex, this.m_bucket_hash[i], pointOfInterest, this.m_bucket_array[i], candidates);
        }
    }

    private void collectNearestNeighbourCandidates_(int xyindex, int hash, Point2D pointOfInterest, int bucket_ptr, AttributeStreamOfInt32 candidates) {
        Point2D pt = new Point2D();
        int node = bucket_ptr;
        while (node != -1) {
            int xyind = this.m_hash_table.getElement(node);
            if (xyindex != xyind && (hash == -1 || this.m_shape.getUserIndex(xyind, this.m_hash_values) == hash)) {
                this.m_shape.getXY(xyind, pt);
                if (Clusterer.isClusterCandidate_(pointOfInterest.x, pointOfInterest.y, pt.x, pt.y, this.m_sqr_tolerance)) {
                    candidates.add(node);
                }
            }
            node = this.m_hash_table.getNextInBucket(node);
        }
    }

    private boolean mergeClusters_(int vertex1, int vertex2, boolean update_hash) {
        int cluster_1 = this.m_shape.getUserIndex(vertex1, this.m_new_clusters);
        int cluster_2 = this.m_shape.getUserIndex(vertex2, this.m_new_clusters);
        assert (cluster_1 != StridedIndexTypeCollection.impossibleIndex2());
        assert (cluster_2 != StridedIndexTypeCollection.impossibleIndex2());
        if (cluster_1 == -1) {
            cluster_1 = this.m_clusters.createList();
            this.m_clusters.addElement(cluster_1, vertex1);
            this.m_shape.setUserIndex(vertex1, this.m_new_clusters, cluster_1);
        }
        if (cluster_2 == -1) {
            this.m_clusters.addElement(cluster_1, vertex2);
        } else {
            this.m_clusters.concatenateLists(cluster_1, cluster_2);
        }
        this.m_shape.setUserIndex(vertex2, this.m_new_clusters, StridedIndexTypeCollection.impossibleIndex2());
        boolean res = this.mergeVertices_(vertex1, vertex2);
        if (update_hash) {
            int hash = this.m_hash_function.calculate_hash_from_vertex(vertex1);
            this.m_shape.setUserIndex(vertex1, this.m_hash_values, hash);
        }
        return res;
    }

    static boolean mergeVertices(Point pt_1, Point pt_2, double w_1, int rank_1, double w_2, int rank_2, Point pt_res, double[] w_res, int[] rank_res) {
        assert (!pt_1.isEmpty() && !pt_2.isEmpty());
        boolean res = pt_1.equals(pt_2);
        if (rank_1 > rank_2) {
            pt_res = pt_1;
            if (w_res != null) {
                rank_res[0] = rank_1;
                w_res[0] = w_1;
            }
            return res;
        }
        if (rank_2 > rank_1) {
            pt_res = pt_2;
            if (w_res != null) {
                rank_res[0] = rank_1;
                w_res[0] = w_1;
            }
            return res;
        }
        pt_1.copyTo(pt_res);
        Point2D pt2d = new Point2D();
        Clusterer.mergeVertices2D(pt_1.getXY(), pt_2.getXY(), w_1, rank_1, w_2, rank_2, pt2d, w_res, rank_res);
        pt_res.setXY(pt2d);
        return res;
    }

    static boolean mergeVertices2D(Point2D pt_1, Point2D pt_2, double w_1, int rank_1, double w_2, int rank_2, Point2D pt_res, double[] w_res, int[] rank_res) {
        double w = w_1 + w_2;
        boolean r = false;
        double x = pt_1.x;
        if (pt_1.x != pt_2.x) {
            if (rank_1 == rank_2) {
                x = (pt_1.x * w_1 + pt_2.x * w_2) / w;
            }
            r = true;
        }
        double y = pt_1.y;
        if (pt_1.y != pt_2.y) {
            if (rank_1 == rank_2) {
                y = (pt_1.y * w_1 + pt_2.y * w_2) / w;
            }
            r = true;
        }
        if (rank_1 != rank_2) {
            if (rank_1 > rank_2) {
                if (w_res != null) {
                    rank_res[0] = rank_1;
                    w_res[0] = w_1;
                }
                pt_res = pt_1;
            } else {
                if (w_res != null) {
                    rank_res[0] = rank_2;
                    w_res[0] = w_2;
                }
                pt_res = pt_2;
            }
        } else {
            pt_res.setCoords(x, y);
            if (w_res != null) {
                w_res[0] = w;
                rank_res[0] = rank_1;
            }
        }
        return r;
    }

    boolean mergeVertices_(int vert_1, int vert_2) {
        Point2D pt_1 = new Point2D();
        this.m_shape.getXY(vert_1, pt_1);
        Point2D pt_2 = new Point2D();
        this.m_shape.getXY(vert_2, pt_2);
        double w_1 = this.m_shape.getWeight(vert_1);
        double w_2 = this.m_shape.getWeight(vert_2);
        double w = w_1 + w_2;
        int r = 0;
        double x = pt_1.x;
        if (pt_1.x != pt_2.x) {
            x = (pt_1.x * w_1 + pt_2.x * w_2) / w;
            ++r;
        }
        double y = pt_1.y;
        if (pt_1.y != pt_2.y) {
            y = (pt_1.y * w_1 + pt_2.y * w_2) / w;
            ++r;
        }
        if (r > 0) {
            this.m_shape.setXY(vert_1, x, y);
        }
        this.m_shape.setWeight(vert_1, w);
        return r != 0;
    }

    boolean clusterNonReciprocal_() {
        this.progress_(true);
        int point_count = this.m_shape.getTotalPointCount();
        Envelope2D env = this.m_shape.getEnvelope2D();
        this.m_origin = env.getLowerLeft();
        double dim = Math.max(env.getHeight(), env.getWidth());
        double mincell = dim / (double)(NumberUtils.intMax() - 1);
        if (this.m_cell_size < mincell) {
            this.m_cell_size = mincell;
            this.m_inv_cell_size = 1.0 / this.m_cell_size;
        }
        this.m_clusters = new IndexMultiList();
        this.m_clusters.reserveLists(this.m_shape.getTotalPointCount() / 3 + 1);
        this.m_clusters.reserveNodes(this.m_shape.getTotalPointCount() / 3 + 1);
        this.m_hash_values = this.m_shape.createUserIndex();
        this.m_new_clusters = this.m_shape.createUserIndex();
        this.m_hash_function = new ClusterHashFunction(this.m_shape, this.m_origin, this.m_sqr_tolerance, this.m_inv_cell_size, this.m_hash_values);
        this.m_hash_table = new IndexHashTable(4 * point_count / 3, this.m_hash_function);
        this.m_hash_table.reserveElements(this.m_shape.getTotalPointCount());
        boolean b_clustered = false;
        EditShape.VertexIterator vi = this.m_shape.queryVertexIteratorOnSelection(this.m_geometry);
        int vertex = vi.next();
        while (vertex != -1) {
            this.progress_();
            assert (vertex != -1);
            int hash = this.m_hash_function.calculate_hash_from_vertex(vertex);
            this.m_shape.setUserIndex(vertex, this.m_hash_values, hash);
            this.m_hash_table.addElement(vertex, hash);
            assert (this.m_shape.getUserIndex(vertex, this.m_new_clusters) == -1);
            vertex = vi.next();
        }
        AttributeStreamOfInt32 candidates = new AttributeStreamOfInt32(0);
        candidates.reserve(10);
        EditShape.VertexIterator vi2 = this.m_shape.queryVertexIteratorOnSelection(this.m_geometry);
        int vertex2 = vi2.next();
        while (vertex2 != -1) {
            if (this.m_shape.getUserIndex(vertex2, this.m_new_clusters) != StridedIndexTypeCollection.impossibleIndex2()) {
                boolean clustered;
                int hash = this.m_shape.getUserIndex(vertex2, this.m_hash_values);
                this.m_hash_table.deleteElement(vertex2, hash);
                boolean hash_changed = false;
                do {
                    this.collectClusterCandidates_(vertex2, candidates);
                    if (candidates.size() == 0) break;
                    clustered = false;
                    int ncandidates = candidates.size();
                    for (int candidate_index = 0; candidate_index < ncandidates; ++candidate_index) {
                        this.progress_();
                        int cluster_node = candidates.get(candidate_index);
                        int other_vertex = this.m_hash_table.getElement(cluster_node);
                        this.m_hash_table.deleteNode(cluster_node);
                        boolean update_hash_value = candidate_index + 1 == ncandidates;
                        clustered |= this.mergeClusters_(vertex2, other_vertex, update_hash_value);
                    }
                    hash_changed |= clustered;
                    b_clustered |= clustered;
                    candidates.clear(false);
                } while (clustered);
                if (hash_changed) {
                    hash = this.m_shape.getUserIndex(vertex2, this.m_hash_values);
                }
                this.m_hash_table.addElement(vertex2, hash);
            }
            vertex2 = vi2.next();
        }
        if (b_clustered) {
            this.applyClusterPositions_();
        }
        this.m_hash_table = null;
        this.m_hash_function = null;
        this.m_shape.removeUserIndex(this.m_hash_values);
        this.m_shape.removeUserIndex(this.m_new_clusters);
        return b_clustered;
    }

    private void applyClusterPositions_() {
        Point2D cluster_pt = new Point2D();
        int list = this.m_clusters.getFirstList();
        while (list != -1) {
            int node = this.m_clusters.getFirst(list);
            assert (node != -1);
            int vertex = this.m_clusters.getElement(node);
            this.m_shape.getXY(vertex, cluster_pt);
            node = this.m_clusters.getNext(node);
            while (node != -1) {
                int vertex_1 = this.m_clusters.getElement(node);
                this.m_shape.setXY(vertex_1, cluster_pt);
                node = this.m_clusters.getNext(node);
            }
            list = this.m_clusters.getNextList(list);
        }
    }

    private void progress_() {
        this.progress_(false);
    }

    private void progress_(boolean bnow) {
        ++this.m_progress_counter;
        if (bnow || (this.m_progress_counter & 0xFFF) == 0) {
            this.m_progress_counter = 0;
            ProgressTracker.checkAndThrow(this.m_progress_tracker);
        }
    }

    static class ClusterCandidate {
        public int vertex;
        double distance;

        ClusterCandidate() {
        }
    }

    final class ClusterHashFunction
    extends IndexHashTable.HashFunction {
        EditShape m_shape;
        double m_sqr_tolerance;
        double m_inv_cell_size;
        Point2D m_origin = new Point2D();
        Point2D m_pt = new Point2D();
        Point2D m_pt_2 = new Point2D();
        int m_hash_values;

        public ClusterHashFunction(EditShape shape, Point2D origin, double sqr_tolerance, double inv_cell_size, int hash_values) {
            this.m_shape = shape;
            this.m_sqr_tolerance = sqr_tolerance;
            this.m_inv_cell_size = inv_cell_size;
            this.m_origin = origin;
            this.m_hash_values = hash_values;
            this.m_pt.setNaN();
            this.m_pt_2.setNaN();
        }

        int calculate_hash(int element) {
            return this.calculate_hash_from_vertex(element);
        }

        int dbg_calculate_hash_from_xy(double x, double y) {
            double dx = x - this.m_origin.x;
            int xi = (int)(dx * this.m_inv_cell_size + 0.5);
            double dy = y - this.m_origin.y;
            int yi = (int)(dy * this.m_inv_cell_size + 0.5);
            return Clusterer.hashFunction_(xi, yi);
        }

        int calculate_hash_from_vertex(int vertex) {
            this.m_shape.getXY(vertex, this.m_pt);
            double dx = this.m_pt.x - this.m_origin.x;
            int xi = (int)(dx * this.m_inv_cell_size + 0.5);
            double dy = this.m_pt.y - this.m_origin.y;
            int yi = (int)(dy * this.m_inv_cell_size + 0.5);
            return Clusterer.hashFunction_(xi, yi);
        }

        @Override
        public int getHash(int element) {
            return this.m_shape.getUserIndex(element, this.m_hash_values);
        }

        @Override
        public boolean equal(int element_1, int element_2) {
            int xyindex_1 = element_1;
            int xyindex_2 = element_2;
            this.m_shape.getXY(xyindex_1, this.m_pt);
            this.m_shape.getXY(xyindex_2, this.m_pt_2);
            return Clusterer.isClusterCandidate_(this.m_pt.x, this.m_pt.y, this.m_pt_2.x, this.m_pt_2.y, this.m_sqr_tolerance);
        }

        @Override
        public int getHash(Object element_descriptor) {
            return 0;
        }

        @Override
        public boolean equal(Object element_descriptor, int element) {
            return false;
        }
    }
}

