/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.SpatialTree2D;
import java.util.ArrayList;
import java.util.List;

@HadoopSDKExcluded
public class BufferVerifier {
    public static MultiPoint verifyBuffer(Polygon buffer, Geometry geometry, double distance, double err_, Double max_dev_out, Point2D bad_point_out) {
        Envelope2D env;
        double d;
        double sqr_min_distance;
        Point2D pt;
        SegmentIterator segIter;
        MultiVertexGeometry mp_src;
        MultiPoint bad_points = new MultiPoint();
        if (buffer.isEmpty() && geometry.isEmpty()) {
            return bad_points;
        }
        Geometry rr = geometry;
        if (geometry.getType().value() == 550) {
            MultiPoint mp = new MultiPoint();
            mp.add((Point)geometry);
            rr = mp;
        }
        if (geometry.getType().value() == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geometry, false);
            rr = polygon;
        }
        if (geometry.isEmpty()) {
            throw new IllegalArgumentException("empty input");
        }
        if (buffer.isEmpty()) {
            throw new IllegalArgumentException("empty input");
        }
        SpatialTree2D buffer_tree = new SpatialTree2D();
        Polygon mp_buf = buffer;
        ArrayList<SpatialTree2D.ElementDescriptor> elems = new ArrayList<SpatialTree2D.ElementDescriptor>();
        SegmentIterator segIter2 = mp_buf.querySegmentIterator();
        while (segIter2.nextPath()) {
            while (segIter2.hasNextSegment()) {
                Element_descriptor_no_extent_on_leaves v = new Element_descriptor_no_extent_on_leaves();
                v.data = (Segment)segIter2.nextSegment().copy();
                Envelope2D e = new Envelope2D();
                v.data.queryLooseEnvelope2D(e);
                v.extent = e;
                elems.add(v);
            }
        }
        SpatialTree2D.bulkLoad(buffer_tree, elems, null);
        ArrayList<SpatialTree2D.Node> helper = new ArrayList<SpatialTree2D.Node>();
        double max_dev = 0.0;
        Point2D max_pt = new Point2D(0.0, 0.0);
        if (!Geometry.isPoint(rr.getType().value())) {
            mp_src = (MultiPath)rr;
            segIter = ((MultiPath)mp_src).querySegmentIterator();
            int count = 0;
            while (segIter.nextPath()) {
                while (segIter.hasNextSegment()) {
                    Segment seg = segIter.nextSegment();
                    for (int i = 0; i < 10; ++i) {
                        pt = new Point2D();
                        seg.getCoord2D((double)i / 9.0, pt);
                        Envelope2D env2 = new Envelope2D();
                        env2.setCoords(pt);
                        sqr_min_distance = NumberUtils.doubleMax();
                        NNVisitorForBufferer v = new NNVisitorForBufferer(pt, sqr_min_distance, count);
                        buffer_tree.visitLeavesNearest(env2, NumberUtils.NaN(), helper, v);
                        count = v.count;
                        sqr_min_distance = v.sqr_min_distance;
                        d = Math.sqrt(sqr_min_distance);
                        if (!(d < Math.abs(distance) - 2.0 * err_)) continue;
                        bad_points.add(pt);
                        double e = Math.abs(d - Math.abs(distance));
                        if (!(e > max_dev)) continue;
                        max_dev = e;
                        max_pt = pt;
                    }
                }
            }
            assert (count >= 0);
        } else {
            mp_src = (MultiPoint)rr;
            int count = 0;
            int n = ((MultiPoint)mp_src).getPointCount();
            for (int i = 0; i < n; ++i) {
                Point2D pt2 = ((MultiPoint)mp_src).getXY(i);
                env = new Envelope2D();
                env.setCoords(pt2);
                double sqr_min_distance2 = NumberUtils.doubleMax();
                NNVisitorForBufferer v = new NNVisitorForBufferer(pt2, sqr_min_distance2, count);
                buffer_tree.visitLeavesNearest(env, Double.NaN, helper, v);
                count = v.count;
                sqr_min_distance2 = v.sqr_min_distance;
                double d2 = Math.sqrt(sqr_min_distance2);
                if (!(d2 < Math.abs(distance) - 2.0 * err_)) continue;
                bad_points.add(pt2);
                double e = Math.abs(d2 - Math.abs(distance));
                if (!(e > max_dev)) continue;
                max_dev = e;
                max_pt = pt2;
            }
            assert (count >= 0);
        }
        buffer_tree.clear();
        SpatialTree2D input_tree = new SpatialTree2D();
        if (!Geometry.isPoint(rr.getType().value())) {
            MultiPath mp_src2 = (MultiPath)rr;
            ArrayList<SpatialTree2D.ElementDescriptor> elems2 = new ArrayList<SpatialTree2D.ElementDescriptor>();
            SegmentIterator segIter3 = mp_src2.querySegmentIterator();
            while (segIter3.nextPath()) {
                while (segIter3.hasNextSegment()) {
                    Element_descriptor_no_extent_on_leaves v = new Element_descriptor_no_extent_on_leaves();
                    v.data = (Segment)segIter3.nextSegment().copy();
                    env = new Envelope2D();
                    v.data.queryLooseEnvelope2D(env);
                    v.extent = env;
                    elems2.add(v);
                }
            }
            SpatialTree2D.bulkLoad(input_tree, elems2, null);
        }
        segIter = mp_buf.querySegmentIterator();
        int count = 0;
        while (segIter.nextPath()) {
            while (segIter.hasNextSegment()) {
                Segment seg = segIter.nextSegment();
                for (int i = 0; i < 10; ++i) {
                    pt = new Point2D();
                    seg.getCoord2D((double)i / 9.0, pt);
                    Envelope2D env3 = new Envelope2D();
                    env3.setCoords(pt);
                    sqr_min_distance = NumberUtils.doubleMax();
                    NNVisitorForBufferer v = new NNVisitorForBufferer(pt, sqr_min_distance, count);
                    input_tree.visitLeavesNearest(env3, NumberUtils.NaN(), helper, v);
                    count = v.count;
                    sqr_min_distance = v.sqr_min_distance;
                    d = Math.sqrt(sqr_min_distance);
                    double dev = Math.abs(d - Math.abs(distance));
                    if (dev > max_dev) {
                        max_dev = dev;
                        max_pt = pt;
                    }
                    if (!(dev > 2.0 * err_)) continue;
                    bad_points.add(pt);
                }
            }
        }
        assert (count >= 0);
        input_tree.clear();
        if (!bad_points.isEmpty()) {
            bad_points.add(max_pt);
        }
        if (max_dev_out != null) {
            max_dev_out = max_dev;
        }
        if (bad_point_out != null) {
            bad_point_out.setCoords(max_pt);
        }
        return bad_points;
    }

    static class NNVisitorForBufferer
    implements SpatialTree2D.NNVisitor {
        Point2D pt;
        double sqr_min_distance;
        int count;

        NNVisitorForBufferer(Point2D p, double smd, int c) {
            this.count = c;
            this.sqr_min_distance = smd;
            this.pt = p;
        }

        @Override
        public double visit(SpatialTree2D.LeafNode leaf, double sqr_radius) {
            double mind = NumberUtils.doubleMax();
            for (Segment elm : (Segment[])leaf.data) {
                ++this.count;
                double tt = elm.getClosestCoordinate(this.pt, false);
                double d = Point2D.sqrDistance(elm.getCoord2D(tt), this.pt);
                if (!(d < mind)) continue;
                mind = d;
            }
            if (mind < this.sqr_min_distance) {
                this.sqr_min_distance = mind;
            }
            return mind;
        }
    }

    private static class Element_descriptor_no_extent_on_leaves
    implements SpatialTree2D.ElementDescriptor {
        Envelope2D extent;
        Segment data;

        private Element_descriptor_no_extent_on_leaves() {
        }

        @Override
        public void queryCenter(Point2D center) {
            this.extent.queryCenter(center);
        }

        @Override
        public void queryExtent(Envelope2D e) {
            e.setCoords(this.extent);
        }

        @Override
        public Object generateLeafNodeData(List<SpatialTree2D.ElementDescriptor> elements) {
            Segment[] segs = new Segment[elements.size()];
            int i = 0;
            for (SpatialTree2D.ElementDescriptor e : elements) {
                segs[i++] = ((Element_descriptor_no_extent_on_leaves)e).data;
            }
            return segs;
        }
    }
}

