/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AreaUnit;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.Unit;
import com.esri.sde.sdk.pe.engine.PeAreaunit;
import com.esri.sde.sdk.pe.engine.PeObject;
import com.esri.sde.sdk.pe.factory.PeFactory;

@HadoopSDKExcluded
final class AreaUnitImpl
extends AreaUnit {
    PeAreaunit m_peUnit;
    private int m_wkid;

    public AreaUnitImpl(PeAreaunit peUnit) {
        this.m_peUnit = (PeAreaunit)peUnit.clone();
        this.m_factor = this.m_peUnit.getUnitFactor();
        this.m_wkid = PeFactory.getCode((PeObject)this.m_peUnit);
        if (this.m_wkid < 0) {
            this.m_wkid = 0;
        }
    }

    @Override
    public String getName() {
        return this.m_peUnit.getName();
    }

    @Override
    public String getDisplayName() {
        return this.m_peUnit.getDisplay();
    }

    @Override
    public String getPluralDisplayName() {
        return this.m_peUnit.getPlural();
    }

    @Override
    public String getAbbreviation() {
        return this.m_peUnit.getAbbr();
    }

    @Override
    public int getID() {
        return this.m_wkid;
    }

    @Override
    public double getConversionFactor(Unit dstUnit) {
        if (dstUnit.getUnitType() != Unit.UnitType.Area) {
            throw new GeometryException("invalid call");
        }
        return this.getUnitToBaseFactor() / dstUnit.getUnitToBaseFactor();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AreaUnitImpl)) {
            return false;
        }
        AreaUnitImpl impl = (AreaUnitImpl)other;
        return impl.m_peUnit.isEqual(this.m_peUnit);
    }

    public String toString() {
        String snippet = this.m_peUnit.toString();
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }
}

