/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MathUtils;

@AndroidSDKPublic
@HadoopSDKExcluded
public final class AngleUtils {
    public static final double degree_to_radian_factor = Math.PI / 180;
    public static final double radian_to_degree_factor = 57.29577951308232;

    public static double convertTo360Range(double deg) {
        double degrees = deg;
        if (degrees >= -360.0 && degrees < 720.0) {
            if (degrees < 0.0) {
                degrees += 360.0;
            } else if (degrees >= 360.0) {
                degrees -= 360.0;
            }
            return degrees;
        }
        if ((degrees = MathUtils.FMod(degrees, 360.0)) < 0.0) {
            degrees += 360.0;
        }
        return degrees;
    }

    public static double convertTo180Range(double deg) {
        double degrees = deg;
        if ((degrees = AngleUtils.convertTo360Range(degrees)) > 180.0) {
            degrees -= 360.0;
        }
        return degrees;
    }

    public static double convertToNegative360Range(double deg) {
        double degrees = deg;
        degrees = AngleUtils.convertTo360Range(degrees) - 360.0;
        return degrees;
    }

    public static double convertToRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double convertToDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static double shorterArcDistance(double degreesFrom, double degreesTo) {
        return AngleUtils.convertTo180Range(degreesTo - degreesFrom);
    }

    public static double longerArcDistance(double degrees_from, double degrees_to) {
        double da = AngleUtils.shorterArcDistance(degrees_from, degrees_to);
        if (da >= 0.0) {
            return da - 360.0;
        }
        if (da < 0.0) {
            return da + 360.0;
        }
        return 0.0;
    }

    public static double interpolateAlongShorterArc(double degreesFrom, double degreesTo, double t) {
        return degreesFrom + AngleUtils.shorterArcDistance(degreesFrom, degreesTo) * t;
    }

    public static double interpolateAlongLongerArc(double degreesFrom, double degreesTo, double t) {
        return degreesFrom + AngleUtils.longerArcDistance(degreesFrom, degreesTo) * t;
    }

    public static boolean equalAngles(double degrees_1, double degrees_2, double eps) {
        return Math.abs(AngleUtils.shorterArcDistance(degrees_1, degrees_2)) <= eps * (Math.abs(degrees_1) + Math.abs(degrees_2)) + eps;
    }

    public static double counterClockwiseDistance(double degreesFrom, double degreesTo) {
        double da = AngleUtils.convertTo180Range(degreesTo - degreesFrom);
        return da <= 0.0 ? 360.0 + da : da;
    }

    public static double clockwiseDistance(double degreesFrom, double degreesTo) {
        double da = AngleUtils.convertTo180Range(degreesTo - degreesFrom);
        return da <= 0.0 ? da : da - 360.0;
    }
}

