/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.shaded.jackson.databind.ser.std;

import com.cloudera.livy.shaded.jackson.core.JsonGenerationException;
import com.cloudera.livy.shaded.jackson.core.JsonGenerator;
import com.cloudera.livy.shaded.jackson.databind.JavaType;
import com.cloudera.livy.shaded.jackson.databind.JsonMappingException;
import com.cloudera.livy.shaded.jackson.databind.JsonNode;
import com.cloudera.livy.shaded.jackson.databind.SerializerProvider;
import com.cloudera.livy.shaded.jackson.databind.annotation.JacksonStdImpl;
import com.cloudera.livy.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.cloudera.livy.shaded.jackson.databind.ser.std.NonTypedScalarSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class BooleanSerializer
extends NonTypedScalarSerializerBase<Boolean> {
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(Boolean.class);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeBoolean(value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectBooleanFormat(typeHint);
        }
    }
}

