/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.client.http;

import com.cloudera.livy.Job;
import com.cloudera.livy.JobHandle;
import com.cloudera.livy.LivyClient;
import com.cloudera.livy.client.common.HttpMessages;
import com.cloudera.livy.client.common.Serializer;
import com.cloudera.livy.client.http.HttpConf;
import com.cloudera.livy.client.http.JobHandleImpl;
import com.cloudera.livy.client.http.LivyConnection;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HttpClient
implements LivyClient {
    private final HttpConf config;
    private final LivyConnection conn;
    private final int sessionId;
    private final ScheduledExecutorService executor;
    private final Serializer serializer;
    private boolean stopped;

    HttpClient(URI uri, HttpConf httpConf) {
        this.config = httpConf;
        this.stopped = false;
        Matcher m = Pattern.compile("(.*)/sessions/([0-9]+)").matcher(uri.getPath());
        try {
            if (m.matches()) {
                URI base = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), m.group(1), uri.getQuery(), uri.getFragment());
                this.conn = new LivyConnection(base, httpConf);
                this.sessionId = Integer.parseInt(m.group(2));
                this.conn.post(null, HttpMessages.SessionInfo.class, "/%d/connect", this.sessionId);
            } else {
                HashMap<String, String> sessionConf = new HashMap<String, String>();
                for (Map.Entry<String, String> e : this.config) {
                    sessionConf.put(e.getKey(), e.getValue());
                }
                HttpMessages.CreateClientRequest create = new HttpMessages.CreateClientRequest(sessionConf);
                this.conn = new LivyConnection(uri, httpConf);
                this.sessionId = this.conn.post((Object)create, HttpMessages.SessionInfo.class, (String)"/", (Object[])new Object[0]).id;
            }
        }
        catch (Exception e) {
            throw this.propagate(e);
        }
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "HttpClient-" + HttpClient.this.sessionId);
                t.setDaemon(true);
                return t;
            }
        });
        this.serializer = new Serializer(new Class[0]);
    }

    public <T> JobHandle<T> submit(Job<T> job) {
        return this.sendJob("submit-job", job);
    }

    public <T> Future<T> run(Job<T> job) {
        return this.sendJob("run-job", job);
    }

    public synchronized void stop(boolean shutdownContext) {
        if (!this.stopped) {
            this.executor.shutdownNow();
            try {
                if (shutdownContext) {
                    this.conn.delete(Map.class, "/%s", this.sessionId);
                }
            }
            catch (Exception e) {
                throw this.propagate(e);
            }
            finally {
                try {
                    this.conn.close();
                }
                catch (Exception exception) {}
            }
            this.stopped = true;
        }
    }

    public Future<?> uploadJar(File jar) {
        return this.uploadResource(jar, "upload-jar", "jar");
    }

    public Future<?> addJar(URI uri) {
        return this.addResource("add-jar", uri);
    }

    public Future<?> uploadFile(File file) {
        return this.uploadResource(file, "upload-file", "file");
    }

    public Future<?> addFile(URI uri) {
        return this.addResource("add-file", uri);
    }

    private Future<?> uploadResource(final File file, final String command, final String paramName) {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HttpClient.this.conn.post(file, Void.class, paramName, "/%d/%s", HttpClient.this.sessionId, command);
                return null;
            }
        };
        return this.executor.submit(task);
    }

    private Future<?> addResource(final String command, final URI resource) {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HttpMessages.AddResource msg = new HttpMessages.AddResource(resource.toString());
                HttpClient.this.conn.post(msg, Void.class, "/%d/%s", HttpClient.this.sessionId, command);
                return null;
            }
        };
        return this.executor.submit(task);
    }

    private <T> JobHandleImpl<T> sendJob(String command, Job<T> job) {
        ByteBuffer serializedJob = this.serializer.serialize(job);
        JobHandleImpl handle = new JobHandleImpl(this.config, this.conn, this.sessionId, this.executor, this.serializer);
        handle.start(command, serializedJob);
        return handle;
    }

    private RuntimeException propagate(Exception cause) {
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }

    int getSessionId() {
        return this.sessionId;
    }
}

