/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.rules;

import com.baomidou.mybatisplus.toolkit.StringUtils;

public enum NamingStrategy {
    nochange,
    underline_to_camel;


    public static String underlineToCamel(String name) {
        String[] camels;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        String tempName = name;
        if (StringUtils.isCapitalMode((String)name) || StringUtils.isMixedMode((String)name)) {
            tempName = name.toLowerCase();
        }
        StringBuilder result = new StringBuilder();
        for (String camel : camels = tempName.split("_")) {
            if (StringUtils.isEmpty((CharSequence)camel)) continue;
            if (result.length() == 0) {
                result.append(camel);
                continue;
            }
            result.append(NamingStrategy.capitalFirst(camel));
        }
        return result.toString();
    }

    public static String removePrefix(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        int idx = name.indexOf("_");
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefix(String name, String[] prefix) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        if (null != prefix) {
            for (String pf : prefix) {
                if (!name.toLowerCase().matches("^" + pf.toLowerCase() + ".*")) continue;
                return name.substring(pf.length());
            }
        }
        return name;
    }

    public static String removePrefixAndCamel(String name, String[] tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

