/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.nonxa.JtaAwareNonXaConnection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;

class AtomikosNonXAParticipant
implements Participant,
Serializable {
    private boolean readOnly;
    private ArrayList heuristicMessages = new ArrayList();
    private transient JtaAwareNonXaConnection connection;

    public AtomikosNonXAParticipant(JtaAwareNonXaConnection connection, String name) {
        this.connection = connection;
        this.heuristicMessages.add(new StringHeuristicMessage("Non-XA resource '" + name + "': warning: this resource does not support two-phase commit"));
    }

    public boolean recover() throws SysException {
        return true;
    }

    public void setCascadeList(Dictionary allParticipants) throws SysException {
    }

    public void setGlobalSiblingCount(int count) {
    }

    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 1;
        return ret;
    }

    public HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        if (this.isRecovered()) {
            if (!this.readOnly) {
                throw new HeurRollbackException(this.getHeuristicMessages());
            }
        } else {
            try {
                this.connection.transactionTerminated(true);
            }
            catch (Exception e) {
                Configuration.logWarning((String)"Error in non-XA commit", (Throwable)e);
                throw new HeurMixedException(this.getHeuristicMessages());
            }
        }
        return this.getHeuristicMessages();
    }

    private boolean isRecovered() {
        return this.connection == null;
    }

    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        if (!this.isRecovered()) {
            try {
                this.connection.transactionTerminated(false);
            }
            catch (Exception e) {
                Configuration.logWarning((String)"Error in non-XA rollback", (Throwable)e);
                throw new HeurMixedException(this.getHeuristicMessages());
            }
        }
        return this.getHeuristicMessages();
    }

    public void forget() {
    }

    public HeuristicMessage[] getHeuristicMessages() {
        HeuristicMessage[] ret = new HeuristicMessage[]{};
        ret = this.heuristicMessages.toArray(ret);
        return ret;
    }

    public String getURI() {
        return null;
    }

    void addHeuristicMessage(HeuristicMessage msg) {
        this.heuristicMessages.add(msg);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

