/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.ClassNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParserClassNode
extends ClassNode {
    private final Class<?> parentClass;
    private final Type parentType;
    private final List<MethodNode> constructors;
    private final Map<String, RuleMethod> ruleMethods;
    private byte[] classCode;
    private Class<?> extendedClass;

    public ParserClassNode(@NotNull Class<?> parentClass) {
        if (parentClass == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ParserClassNode.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this.constructors = new ArrayList<MethodNode>();
        this.ruleMethods = new TreeMap<String, RuleMethod>();
        this.parentClass = parentClass;
        this.parentType = Type.getType(parentClass);
    }

    public Class<?> getParentClass() {
        return this.parentClass;
    }

    public Type getParentType() {
        return this.parentType;
    }

    public List<MethodNode> getConstructors() {
        return this.constructors;
    }

    public Map<String, RuleMethod> getRuleMethods() {
        return this.ruleMethods;
    }

    public byte[] getClassCode() {
        return this.classCode;
    }

    public void setClassCode(byte[] classCode) {
        this.classCode = classCode;
    }

    public Class<?> getExtendedClass() {
        return this.extendedClass;
    }

    public void setExtendedClass(Class<?> extendedClass) {
        this.extendedClass = extendedClass;
    }
}

