/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.HashSet;
import java.util.List;
import lombok.ast.libs.org.parboiled.asm.ClassWriter;
import lombok.ast.libs.org.parboiled.asm.MethodVisitor;
import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.FieldInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.FieldNode;
import lombok.ast.libs.org.parboiled.asm.tree.InsnList;
import lombok.ast.libs.org.parboiled.asm.tree.InsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.VarInsnNode;
import lombok.ast.libs.org.parboiled.transform.AsmUtils;
import lombok.ast.libs.org.parboiled.transform.InstructionGraphNode;
import lombok.ast.libs.org.parboiled.transform.InstructionGroup;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GroupClassGenerator
implements Opcodes,
RuleMethodProcessor,
Types {
    private static final Object lock = new Object();
    private final boolean forceCodeBuilding;
    protected ParserClassNode classNode;
    protected RuleMethod method;

    protected GroupClassGenerator(boolean forceCodeBuilding) {
        this.forceCodeBuilding = forceCodeBuilding;
    }

    @Override
    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.GroupClassGenerator.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.GroupClassGenerator.process(...) corresponds to @NotNull parameter and must not be null");
        }
        this.classNode = classNode;
        this.method = method;
        for (InstructionGroup group : method.getGroups()) {
            if (!this.appliesTo(group.getRoot())) continue;
            this.loadGroupClass(group);
        }
    }

    protected abstract boolean appliesTo(InstructionGraphNode var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroupClass(InstructionGroup group) {
        this.createGroupClassType(group);
        String className = group.getGroupClassType().getClassName();
        ClassLoader classLoader = this.classNode.getParentClass().getClassLoader();
        Object object = lock;
        synchronized (object) {
            Class<?> groupClass = AsmUtils.findLoadedClass(className, classLoader);
            if (groupClass == null || this.forceCodeBuilding) {
                byte[] groupClassCode = this.generateGroupClassCode(group);
                group.setGroupClassCode(groupClassCode);
                if (groupClass == null) {
                    AsmUtils.loadClass(className, groupClassCode, classLoader);
                }
            }
        }
    }

    private void createGroupClassType(InstructionGroup group) {
        String s = this.classNode.name;
        String groupClassInternalName = s.substring(0, this.classNode.name.lastIndexOf(47)) + '/' + group.getName();
        group.setGroupClassType(Type.getObjectType(groupClassInternalName));
    }

    protected byte[] generateGroupClassCode(InstructionGroup group) {
        ClassWriter classWriter = new ClassWriter(1);
        this.generateClassBasics(group, classWriter);
        this.generateFields(group, classWriter);
        this.generateConstructor(classWriter);
        this.generateMethod(group, classWriter);
        return classWriter.toByteArray();
    }

    private void generateClassBasics(InstructionGroup group, ClassWriter cw) {
        cw.visit(49, 17, group.getGroupClassType().getInternalName(), null, this.getBaseType().getInternalName(), null);
        cw.visitSource(this.classNode.sourceFile, null);
    }

    protected abstract Type getBaseType();

    private void generateFields(InstructionGroup group, ClassWriter cw) {
        for (FieldNode field : group.getFields()) {
            cw.visitField(4097, field.name, field.desc, null, null);
        }
    }

    private void generateConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/String;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.getBaseType().getInternalName(), "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected abstract void generateMethod(InstructionGroup var1, ClassWriter var2);

    protected void fixContextSwitches(InstructionGroup instructionGroup) {
        List<InstructionGraphNode> list = instructionGroup.getNodes();
        InsnList insnList = instructionGroup.getInstructions();
        for (int i = list.size() - 1; i >= 0; --i) {
            InstructionGraphNode instructionGraphNode = list.get(i);
            if (!instructionGraphNode.isContextSwitch()) continue;
            String string = ((MethodInsnNode)instructionGraphNode.getInstruction()).name;
            this.insertContextSwitch(insnList, GroupClassGenerator.getFirstOfSubtree(insnList, instructionGraphNode, new HashSet<InstructionGraphNode>()).getInstruction(), string);
            String string2 = string.startsWith("UP") ? string.replace("UP", "DOWN") : string.replace("DOWN", "UP");
            this.insertContextSwitch(insnList, instructionGraphNode.getInstruction(), string2);
            insnList.remove(instructionGraphNode.getInstruction());
        }
    }

    private void insertContextSwitch(InsnList instructions, AbstractInsnNode firstInsn, String contextSwitchType) {
        instructions.insertBefore(firstInsn, new VarInsnNode(25, 0));
        instructions.insertBefore(firstInsn, new VarInsnNode(25, 1));
        instructions.insertBefore(firstInsn, new MethodInsnNode(182, this.getBaseType().getInternalName(), contextSwitchType, CONTEXT_SWITCH_DESC));
        instructions.insertBefore(firstInsn, new VarInsnNode(58, 1));
    }

    protected void insertSetContextCalls(InstructionGroup instructionGroup, int n) {
        InsnList insnList = instructionGroup.getInstructions();
        for (InstructionGraphNode instructionGraphNode : instructionGroup.getNodes()) {
            AbstractInsnNode abstractInsnNode;
            if (instructionGraphNode.isCallOnContextAware()) {
                abstractInsnNode = instructionGraphNode.getInstruction();
                if (instructionGraphNode.getPredecessors().size() > 1) {
                    AbstractInsnNode abstractInsnNode2 = instructionGraphNode.getPredecessors().get(0).getInstruction();
                    insnList.insert(abstractInsnNode2, new VarInsnNode(58, ++n));
                    insnList.insert(abstractInsnNode2, new InsnNode(89));
                    insnList.insertBefore(abstractInsnNode, new VarInsnNode(25, n));
                } else {
                    insnList.insertBefore(abstractInsnNode, new InsnNode(89));
                }
                insnList.insertBefore(abstractInsnNode, new VarInsnNode(25, 1));
                insnList.insertBefore(abstractInsnNode, new MethodInsnNode(185, CONTEXT_AWARE.getInternalName(), "setContext", "(" + CONTEXT_DESC + ")V"));
                continue;
            }
            if (!instructionGraphNode.isCaptureGet()) continue;
            abstractInsnNode = (MethodInsnNode)instructionGraphNode.getInstruction();
            insnList.insertBefore(abstractInsnNode, new VarInsnNode(25, 1));
            ((MethodInsnNode)abstractInsnNode).desc = '(' + CONTEXT_DESC + ")Ljava/lang/Object;";
        }
    }

    protected void convertXLoads(InstructionGroup group) {
        String owner = group.getGroupClassType().getInternalName();
        for (InstructionGraphNode node : group.getNodes()) {
            if (!node.isXLoad()) continue;
            VarInsnNode insn = (VarInsnNode)node.getInstruction();
            FieldNode field = group.getFields().get(insn.var);
            group.getInstructions().insert(insn, new FieldInsnNode(180, owner, field.name, field.desc));
            group.getInstructions().set(insn, new VarInsnNode(25, 0));
        }
    }

    private static InstructionGraphNode getFirstOfSubtree(InsnList instructions, InstructionGraphNode node, HashSet<InstructionGraphNode> covered) {
        InstructionGraphNode first = node;
        if (!covered.contains(node)) {
            covered.add(node);
            for (InstructionGraphNode predecessor : node.getPredecessors()) {
                InstructionGraphNode firstOfPred = GroupClassGenerator.getFirstOfSubtree(instructions, predecessor, covered);
                if (instructions.indexOf(first.getInstruction()) <= instructions.indexOf(firstOfPred.getInstruction())) continue;
                first = firstOfPred;
            }
        }
        return first;
    }
}

