/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import java.util.Arrays;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.support.InputBuffer;
import org.jetbrains.annotations.NotNull;

public class MutableInputBuffer
implements InputBuffer {
    private final InputBuffer buffer;
    private int[] inserts = new int[0];
    private char[] chars = new char[0];

    public MutableInputBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    public int getLength() {
        return this.buffer.getLength() + this.chars.length;
    }

    public char charAt(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j >= 0) {
            return this.chars[j];
        }
        return this.buffer.charAt(index + (j + 1));
    }

    public InputBuffer.Position getPosition(int index) {
        return this.buffer.getPosition(this.fix(index));
    }

    public String extractLine(int lineNumber) {
        return this.buffer.extractLine(lineNumber);
    }

    @NotNull
    public String extract(int start, int end) {
        String string = this.buffer.extract(this.fix(start), this.fix(end));
        if (string == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.MutableInputBuffer.extract must not return null");
        }
        return string;
    }

    private int fix(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j < 0) {
            j = -(j + 1);
        }
        return index - j;
    }

    public void insertChar(int index, char c) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j < 0) {
            j = -(j + 1);
        }
        char[] newChars = new char[this.chars.length + 1];
        System.arraycopy(this.chars, 0, newChars, 0, j);
        newChars[j] = c;
        System.arraycopy(this.chars, j, newChars, j + 1, this.chars.length - j);
        this.chars = newChars;
        int[] newInserts = new int[this.inserts.length + 1];
        System.arraycopy(this.inserts, 0, newInserts, 0, j);
        newInserts[j] = index;
        for (int i = j; i < this.inserts.length; ++i) {
            newInserts[i + 1] = this.inserts[i] + 1;
        }
        this.inserts = newInserts;
    }

    public char undoCharInsertion(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        Preconditions.checkArgument(j >= 0, "Cannot undo a non-existing insertion");
        char removedChar = this.chars[j];
        char[] newChars = new char[this.chars.length - 1];
        System.arraycopy(this.chars, 0, newChars, 0, j);
        System.arraycopy(this.chars, j + 1, newChars, j, newChars.length - j);
        this.chars = newChars;
        int[] newInserts = new int[this.inserts.length - 1];
        System.arraycopy(this.inserts, 0, newInserts, 0, j);
        for (int i = j + 1; i < this.inserts.length; ++i) {
            newInserts[i - 1] = this.inserts[i] - 1;
        }
        this.inserts = newInserts;
        return removedChar;
    }
}

