/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.ads;

import com.alibaba.dubbo.config.ProviderConfig;
import com.allcam.common.ads.AdsPlatServiceConfig;
import com.allcam.common.constant.system.Platform;
import com.allcam.common.model.PlatformInfo;
import com.allcam.common.service.plat.PlatformDataService;
import com.allcam.common.system.context.SpringContextHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class AdsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AdsUtils.class);
    private static final Map<String, PlatformInfo> GROUP_PLATFORM_MAP = new ConcurrentHashMap<String, PlatformInfo>();

    public static <T> T getAdsService(Class<T> serviceClass) {
        return (T)SpringContextHolder.getDubboService(serviceClass);
    }

    public static <T> T getAdsService(Class<T> serviceClass, String identify) {
        Assert.hasText((String)identify, (String)"identify is empty string.");
        if (AdsPlatServiceConfig.useCommonService(AdsUtils.genPlatformType(identify), serviceClass)) {
            return AdsUtils.getAdsService(serviceClass);
        }
        return (T)SpringContextHolder.getDubboService(serviceClass, (String)AdsUtils.getAdsGroupById(identify));
    }

    public static String getAdsGroupById(String identify) {
        LOG.debug("get service group by identify[{}]", (Object)identify);
        Assert.hasText((String)identify, (String)"identify is empty.");
        Pair<Platform, String> plat = AdsUtils.genPlatform(identify);
        Platform platform = (Platform)plat.getKey();
        Assert.isTrue((platform != Platform.OTHER ? 1 : 0) != 0, (String)"the found platform from identify is OTHER(not recognized)");
        return platform.getName() + "_" + (String)plat.getValue();
    }

    public static Pair<Platform, String> genPlatform(String identify) {
        int platIndex = 12;
        int snIndex = platIndex + 2;
        String platType = identify.substring(platIndex, snIndex);
        String platSN = identify.substring(snIndex, snIndex + 2);
        return new Pair((Object)Platform.of((int)Integer.parseInt(platType)), (Object)platSN);
    }

    public static int genPlatformType(String identify) {
        int platIndex = 12;
        int snIndex = platIndex + 2;
        String platType = identify.substring(platIndex, snIndex);
        return Integer.parseInt(platType);
    }

    public static PlatformInfo getAdapterPlatform() {
        ProviderConfig dubboConfig = (ProviderConfig)SpringContextHolder.getBean(ProviderConfig.class);
        Assert.notNull((Object)dubboConfig, (String)"get dubbo provider config from spring context fail.");
        return AdsUtils.getPlatformByGroup(dubboConfig.getGroup());
    }

    public static PlatformInfo getPlatformByGroup(String group) {
        LOG.debug("get platform by group[{}]", (Object)group);
        Assert.hasText((String)group, (String)"group is empty.");
        PlatformInfo platformInfo = GROUP_PLATFORM_MAP.get(group);
        if (null == platformInfo) {
            String[] platParam = group.split("_");
            Assert.isTrue((platParam.length == 2 ? 1 : 0) != 0, (String)"group illegal.");
            Platform platform = Platform.of((String)platParam[0]);
            Assert.isTrue((platform != Platform.OTHER ? 1 : 0) != 0, (String)"the found platform from group is OTHER(not recognized)");
            PlatformDataService platformDataService = (PlatformDataService)SpringContextHolder.getDubboService(PlatformDataService.class);
            platformInfo = platformDataService.getPlatformByGroup(platform.getType(), platParam[1]);
            Assert.notNull((Object)platformInfo, (String)"platform not found by this group");
            GROUP_PLATFORM_MAP.put(group, platformInfo);
        }
        return platformInfo;
    }

    @Deprecated
    public static PlatformInfo getPlatfromByGroup(String group) {
        return AdsUtils.getPlatformByGroup(group);
    }
}

