/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.mas.core;

import com.allcam.mas.bean.CruiseDelRequest;
import com.allcam.mas.bean.CruiseDelResponse;
import com.allcam.mas.bean.CruiseListRequest;
import com.allcam.mas.bean.CruiseListResponse;
import com.allcam.mas.bean.CruisePresetAddRequest;
import com.allcam.mas.bean.CruisePresetAddResponse;
import com.allcam.mas.bean.CruisePresetGetRequest;
import com.allcam.mas.bean.CruisePresetGetResponse;
import com.allcam.mas.bean.CruisePresetModRequest;
import com.allcam.mas.bean.CruisePresetModResponse;
import com.allcam.mas.bean.DevListRequest;
import com.allcam.mas.bean.DevListResponse;
import com.allcam.mas.bean.GetMasLiveUrlRequest;
import com.allcam.mas.bean.GetMasRecordUrlRequest;
import com.allcam.mas.bean.LiveBrowseRequest;
import com.allcam.mas.bean.LiveBrowseResponse;
import com.allcam.mas.bean.LivePicShortcutRequest;
import com.allcam.mas.bean.LiveRecordStartReruest;
import com.allcam.mas.bean.LiveRecordStartResponse;
import com.allcam.mas.bean.PicShortcutRequest;
import com.allcam.mas.bean.PlaybackRecordStartRequest;
import com.allcam.mas.bean.PtzControlRequest;
import com.allcam.mas.bean.PtzControlResponse;
import com.allcam.mas.bean.PtzPosGetRequest;
import com.allcam.mas.bean.PtzPosGetResponse;
import com.allcam.mas.bean.PtzPosSetRequest;
import com.allcam.mas.bean.PtzPosSetResponse;
import com.allcam.mas.bean.RecordListRequest;
import com.allcam.mas.bean.RecordListResponse;
import com.allcam.mas.bean.RecordShortcutRequest;
import com.allcam.mas.bean.RecordShortcutResponse;
import com.allcam.mas.bean.RecordTaskDetailRequest;
import com.allcam.mas.bean.RecordTaskDetailResponse;
import com.allcam.mas.bean.RecordTaskListRequest;
import com.allcam.mas.bean.RecordTaskListResponse;
import com.allcam.mas.bean.RecordUrlRequest;
import com.allcam.mas.bean.RecordUrlResponse;
import com.allcam.mas.bean.TaskStatusListRequest;
import com.allcam.mas.bean.TaskStatusListResponse;
import com.allcam.mas.bean.TerminatedTaskRequest;
import com.allcam.mas.bean.TerminatedTaskResponse;
import com.allcam.mas.bean.TranscodeConfigureRequest;
import com.allcam.mas.bean.TranscodeConfigureResponse;
import com.allcam.mas.bean.TranscodeServerStatusRequest;
import com.allcam.mas.bean.TranscodeServerStatusResponse;
import com.allcam.mas.bean.TranscodeTempletListRequest;
import com.allcam.mas.bean.TranscodeTempletListResponse;
import com.allcam.mas.core.AcHttpDigest;
import com.allcam.mas.core.MasConfig;
import com.allcam.mas.core.MasRequestException;
import com.allcam.mas.http.HttpConfig;
import com.allcam.mas.http.HttpService;
import com.allcam.mas.json.HttpJsonHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasService {
    private static final Logger LOG = LoggerFactory.getLogger(MasService.class);
    private static final MasService INSTANCE = new MasService();
    private static final String API_DEV_LIST = "api/dev/list";
    private static final String API_TRANSCODE_TEMPLATE_LIST = "api/transcode/templateList";
    private static final String API_TRANSCODE_CONFIG = "api/transcode/configure";
    private static final String API_TRANSCODE_TERMINATED_TASK = "api/transcode/terminatedTask";
    private static final String API_TRANSCODE_TASK_STATUS_LIST = "api/transcode/taskStatusList";
    private static final String API_TRANSCODE_SERVER_STATUS = "api/transcode/serverStatus";
    private static final String API_MEDIA_LIVE = "api/media/live";
    private static final String API_MEDIA_LIVE_SHORTCUT_PIC = "api/media/live/shortcut/pic";
    private static final String API_RECORD_LIST = "api/record/list";
    private static final String API_RECORD_URL = "api/record/url";
    private static final String API_RECORD_SHORTCUT_RECORD = "api/record/shortcut/record";
    private static final String API_RECORD_SHORTCUT_PIC = "api/record/shortcut/pic";
    private static final String API_MEDIA_RECORD_LIVE = "api/media/record/live";
    private static final String API_MEDIA_RECORD_PLAYBACK = "api/media/record/playback";
    private static final String API_MEDIA_RECORD_TASK_LIST = "api/media/record/task/list";
    private static final String API_MEDIA_RECORD_TASK_DETAIL = "api/media/record/task/detail";
    private static final String API_PTZ_CONTROL = "api/ptz/control";
    private static final String API_PTZ_POS_GET = "api/ptz/pos/get";
    private static final String API_PTZ_POS_SET = "api/ptz/pos/set";
    private static final String API_CRUISE_LIST = "api/cruise/list";
    private static final String API_CRUISE_DEL = "api/cruise/del";
    private static final String API_CRUISE_PRESET_GET = "api/cruise/preset/get";
    private static final String API_CRUISE_PRESET_ADD = "api/cruise/preset/add";
    private static final String API_CRUISE_PRESET_MOD = "api/cruise/preset/mod";
    private static final String API_MEDIA_LIVE_CAMERATRANSCODE = "api/media/live/cameratranscode";
    private static final String API_RECORD_URL_CAMERATRANSCODE = "api/record/url/cameratranscode";
    private HttpJsonHandler jsonHandler;

    public static MasService getInstance() {
        return INSTANCE;
    }

    public void init(MasConfig config) {
        if (config == null) {
            throw new NullPointerException("mas config cannot be null.");
        }
        String host = config.getHost();
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new NullPointerException("mas host cannot be null.");
        }
        String httpUrl = host.startsWith("http") ? host : (0 == config.getPort() || 80 == config.getPort() ? "http://" + config.getHost() + "/" : "http://" + config.getHost() + ":" + config.getPort() + "/");
        HttpConfig.Builder hcBuilder = new HttpConfig.Builder().httpUrl(httpUrl).httpDigest(new AcHttpDigest()).timeout(config.getHttpTimeout());
        HttpService httpService = new HttpService(hcBuilder.build());
        this.jsonHandler = new HttpJsonHandler(httpService);
    }

    public LiveBrowseResponse getMasLiveUrl(GetMasLiveUrlRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        request.setMsgMark(API_MEDIA_LIVE_CAMERATRANSCODE);
        LiveBrowseResponse response = this.jsonHandler.post(request, LiveBrowseResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public LiveBrowseResponse getMasRecordUrl(GetMasRecordUrlRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        request.setMsgMark(API_RECORD_URL_CAMERATRANSCODE);
        LiveBrowseResponse response = this.jsonHandler.post(request, LiveBrowseResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public DevListResponse getDevList(DevListRequest request) throws MasRequestException {
        DevListResponse response;
        request.setMsgMark(API_DEV_LIST);
        if (request.getPageNo() == null) {
            request.setPageNo(1);
        }
        if (request.getPageSize() == null) {
            request.setPageSize(1000);
        }
        if ((response = this.jsonHandler.post(request, DevListResponse.class)).success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public TranscodeTempletListResponse getTransTempletList() throws MasRequestException {
        TranscodeTempletListRequest request = new TranscodeTempletListRequest();
        request.setMsgMark(API_TRANSCODE_TEMPLATE_LIST);
        TranscodeTempletListResponse response = this.jsonHandler.post(request, TranscodeTempletListResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public TranscodeConfigureResponse transcodeConfig(TranscodeConfigureRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (StringUtils.isBlank((CharSequence)request.getTempletId())) {
            throw new IllegalArgumentException("templet id is blank");
        }
        request.setMsgMark(API_TRANSCODE_CONFIG);
        TranscodeConfigureResponse response = this.jsonHandler.post(request, TranscodeConfigureResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public TerminatedTaskResponse transcodeTerminatedTask(TerminatedTaskRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        request.setMsgMark(API_TRANSCODE_TERMINATED_TASK);
        TerminatedTaskResponse response = this.jsonHandler.post(request, TerminatedTaskResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public TaskStatusListResponse getTaskStatusList() throws MasRequestException {
        TaskStatusListRequest request = new TaskStatusListRequest();
        request.setMsgMark(API_TRANSCODE_TASK_STATUS_LIST);
        TaskStatusListResponse response = this.jsonHandler.post(request, TaskStatusListResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public TranscodeServerStatusResponse getTransServerStatus() throws MasRequestException {
        TranscodeServerStatusRequest request = new TranscodeServerStatusRequest();
        request.setMsgMark(API_TRANSCODE_SERVER_STATUS);
        TranscodeServerStatusResponse response = this.jsonHandler.post(request, TranscodeServerStatusResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public LiveBrowseResponse getCameraLiveUrl(LiveBrowseRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        request.setMsgMark(API_MEDIA_LIVE);
        LiveBrowseResponse response = this.jsonHandler.post(request, LiveBrowseResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public RecordShortcutResponse getShortcutLivePicUrl(LivePicShortcutRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        request.setMsgMark(API_MEDIA_LIVE_SHORTCUT_PIC);
        RecordShortcutResponse response = this.jsonHandler.post(request, RecordShortcutResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public RecordListResponse getRecordList(RecordListRequest request) throws MasRequestException {
        RecordListResponse response;
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        request.setMsgMark(API_RECORD_LIST);
        if (request.getPageNo() == null) {
            request.setPageNo(1);
        }
        if (request.getPageSize() == null) {
            request.setPageSize(50);
        } else if (request.getPageSize() > 5000) {
            request.setPageSize(5000);
        }
        if (request.getRecordMethod() == null) {
            request.setRecordMethod(0);
        }
        if ((response = this.jsonHandler.post(request, RecordListResponse.class)).success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public RecordUrlResponse getRecordUrl(RecordUrlRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (StringUtils.isBlank((CharSequence)request.getBeginTime()) || StringUtils.isBlank((CharSequence)request.getEndTime())) {
            throw new IllegalArgumentException("beginTime or endTime is blank");
        }
        request.setMsgMark(API_RECORD_URL);
        RecordUrlResponse response = this.jsonHandler.post(request, RecordUrlResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public RecordShortcutResponse getShortcutRecordUrl(RecordShortcutRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (StringUtils.isBlank((CharSequence)request.getBeginTime()) || StringUtils.isBlank((CharSequence)request.getEndTime())) {
            throw new IllegalArgumentException("beginTime or endTime is blank");
        }
        if (60 < request.getDuration() || 1 > request.getDuration()) {
            throw new IllegalArgumentException("duration must be between 0 and 60");
        }
        request.setMsgMark(API_RECORD_SHORTCUT_RECORD);
        RecordShortcutResponse response = this.jsonHandler.post(request, RecordShortcutResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public RecordShortcutResponse getShortcutRecordPicUrl(PicShortcutRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (StringUtils.isBlank((CharSequence)request.getBeginTime()) || StringUtils.isBlank((CharSequence)request.getEndTime())) {
            throw new IllegalArgumentException("beginTime or endTime is blank");
        }
        request.setMsgMark(API_RECORD_SHORTCUT_PIC);
        RecordShortcutResponse response = this.jsonHandler.post(request, RecordShortcutResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public LiveRecordStartResponse startLiveRecord(LiveRecordStartReruest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (60 > request.getDuration() || 3600 < request.getDuration()) {
            throw new IllegalArgumentException("duration must be between 60 and 3600");
        }
        request.setMsgMark(API_MEDIA_RECORD_LIVE);
        LiveRecordStartResponse response = this.jsonHandler.post(request, LiveRecordStartResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public LiveRecordStartResponse startPlaybackRecord(PlaybackRecordStartRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (60 > request.getDuration() || 3600 < request.getDuration()) {
            throw new IllegalArgumentException("duration must be between 60 and 3600");
        }
        request.setMsgMark(API_MEDIA_RECORD_PLAYBACK);
        LiveRecordStartResponse response = this.jsonHandler.post(request, LiveRecordStartResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public RecordTaskListResponse getRecordTaskList(RecordTaskListRequest request) throws MasRequestException {
        request.setMsgMark(API_MEDIA_RECORD_TASK_LIST);
        RecordTaskListResponse response = this.jsonHandler.post(request, RecordTaskListResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public RecordTaskDetailResponse getRecordTask(RecordTaskDetailRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getTaskId())) {
            throw new IllegalArgumentException("task id is empty");
        }
        request.setMsgMark(API_MEDIA_RECORD_TASK_DETAIL);
        RecordTaskDetailResponse response = this.jsonHandler.post(request, RecordTaskDetailResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public PtzControlResponse ptzControl(PtzControlRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId()) || StringUtils.isBlank((CharSequence)request.getOpCode())) {
            throw new IllegalArgumentException("cameraId or opCode is blank");
        }
        if (StringUtils.isBlank((CharSequence)request.getParam1()) || StringUtils.isBlank((CharSequence)request.getParam2())) {
            throw new IllegalArgumentException("param1 or param2 is blank");
        }
        request.setMsgMark(API_PTZ_CONTROL);
        PtzControlResponse response = this.jsonHandler.post(request, PtzControlResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public PtzPosGetResponse ptzPosGet(PtzPosGetRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        request.setMsgMark(API_PTZ_POS_GET);
        PtzPosGetResponse response = this.jsonHandler.post(request, PtzPosGetResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public PtzPosSetResponse ptzPosSet(PtzPosSetRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId()) || StringUtils.isBlank((CharSequence)request.getOpCode())) {
            throw new IllegalArgumentException("cameraId or opCode is blank");
        }
        request.setMsgMark(API_PTZ_POS_SET);
        PtzPosSetResponse response = this.jsonHandler.post(request, PtzPosSetResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public CruiseListResponse cruiseList(CruiseListRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("cruiseType id is blank");
        }
        request.setMsgMark(API_CRUISE_LIST);
        CruiseListResponse response = this.jsonHandler.post(request, CruiseListResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public CruiseDelResponse cruiseDel(CruiseDelRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCamreraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (StringUtils.isBlank((CharSequence)request.getCruiseType()) || StringUtils.isBlank((CharSequence)request.getCruiseNo())) {
            throw new IllegalArgumentException("cruiseType or cruiseNo is blank");
        }
        request.setMsgMark(API_CRUISE_DEL);
        CruiseDelResponse response = this.jsonHandler.post(request, CruiseDelResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public CruisePresetGetResponse cruisePresetGet(CruisePresetGetRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId()) || StringUtils.isBlank((CharSequence)request.getCruiseNo())) {
            throw new IllegalArgumentException("cameraId or cruiseNo is blank");
        }
        request.setMsgMark(API_CRUISE_PRESET_GET);
        CruisePresetGetResponse response = this.jsonHandler.post(request, CruisePresetGetResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public CruisePresetAddResponse cruisePresetAdd(CruisePresetAddRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (request.getCruiseTrackInfo() == null) {
            throw new IllegalArgumentException("cruiseTrackInfo is null");
        }
        request.setMsgMark(API_CRUISE_PRESET_ADD);
        CruisePresetAddResponse response = this.jsonHandler.post(request, CruisePresetAddResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }

    public CruisePresetModResponse cruisePresetMod(CruisePresetModRequest request) throws MasRequestException {
        if (StringUtils.isBlank((CharSequence)request.getCameraId())) {
            throw new IllegalArgumentException("camera id is blank");
        }
        if (request.getCruiseTrackInfo() == null) {
            throw new IllegalArgumentException("cruiseTrackInfo is null");
        }
        request.setMsgMark(API_CRUISE_PRESET_MOD);
        CruisePresetModResponse response = this.jsonHandler.post(request, CruisePresetModResponse.class);
        if (response.success()) {
            return response;
        }
        throw new MasRequestException(response.getResultCode(), response.getResultDesc());
    }
}

