/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.mas.core;

import org.apache.commons.lang3.StringUtils;

public class MasConfig {
    private String host;
    private int port;
    private int httpTimeout;
    private String username;
    private String password;

    private MasConfig() {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static class Builder {
        private MasConfig config = new MasConfig();

        public MasConfig build() {
            if (StringUtils.isBlank((CharSequence)this.config.host)) {
                this.config.host = "";
            }
            if (this.config.port == 0) {
                this.config.port = 10010;
            }
            if (this.config.httpTimeout == 0) {
                this.config.httpTimeout = 30;
            }
            return this.config;
        }

        public Builder host(String host) {
            this.config.host = host;
            return this;
        }

        public Builder port(int port) {
            this.config.port = port;
            return this;
        }

        public Builder httpTimeout(int timeout) {
            this.config.httpTimeout = timeout;
            return this;
        }

        public Builder username(String username) {
            this.config.username = username;
            return this;
        }

        public Builder password(String password) {
            this.config.password = password;
            return this;
        }
    }
}

