/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLPaser {
    public static final Logger LOG = LoggerFactory.getLogger(XMLPaser.class);

    public static String toXml(Object object) {
        if (null == object) {
            return "";
        }
        try {
            Persister serializer = new Persister();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
            serializer.write(object, (OutputStream)byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception e) {
            LOG.error("toXml fail.", (Throwable)e);
            return "";
        }
    }

    public static <T> T fromXml(String xmlString, Class<T> type) {
        if (null == xmlString) {
            return null;
        }
        try {
            return XMLPaser.fromXml(xmlString.getBytes(StandardCharsets.UTF_8), type);
        }
        catch (Exception e) {
            LOG.error("fromXml fail.", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromXml(byte[] xmlBytes, Class<T> type) {
        try {
            Persister serializer = new Persister();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlBytes);
            return (T)serializer.read(type, (InputStream)is);
        }
        catch (Exception e) {
            LOG.error("fromXml fail.", (Throwable)e);
            return null;
        }
    }

    public static String changeStrToXml(Object str) {
        String tempStr = null == str ? "" : str.toString();
        tempStr = tempStr.replaceAll("[&]", "&amp;");
        tempStr = tempStr.replaceAll("[<]", "&lt;");
        tempStr = tempStr.replaceAll("[>]", "&gt;");
        tempStr = tempStr.replaceAll("[']", "&apos;");
        tempStr = tempStr.replaceAll("[\"]", "&quot;");
        tempStr = tempStr.replaceAll("[(]", "&#40;");
        tempStr = tempStr.replaceAll("[)]", "&#41;");
        tempStr = tempStr.replaceAll("[%]", "&#37;");
        tempStr = tempStr.replaceAll("[+]", "&#43;");
        tempStr = tempStr.replaceAll("[-]", "&#45;");
        return tempStr;
    }

    public static String changeXmlToStr(String xmlStr) {
        if (StringUtils.isBlank((CharSequence)xmlStr)) {
            return "";
        }
        xmlStr = xmlStr.replaceAll("&amp;", "&");
        xmlStr = xmlStr.replaceAll("&lt;", "<");
        xmlStr = xmlStr.replaceAll("&gt;", ">");
        xmlStr = xmlStr.replaceAll("&apos;", "'");
        xmlStr = xmlStr.replaceAll("&quot;", "\"");
        xmlStr = xmlStr.replaceAll("&#40;", "(");
        xmlStr = xmlStr.replaceAll("&#41;", ")");
        xmlStr = xmlStr.replaceAll("&#37;", "%");
        xmlStr = xmlStr.replaceAll("&#43;", "+");
        xmlStr = xmlStr.replaceAll("&#45;", "-");
        return xmlStr;
    }
}

