/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.http;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCustomSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SSLCustomSocketFactory.class);
    public static final String KEY_PASS = "Allcam_https";

    public static SSLSocketFactory getSocketFactory(String certPath) {
        return SSLCustomSocketFactory.getSocketFactory(certPath, KEY_PASS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SSLSocketFactory getSocketFactory(String certPath, String keyPass) {
        try (FileInputStream ins = new FileInputStream(certPath);){
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(ins, keyPass.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (Throwable e) {
            LOG.error("getSocketFactory fail: ", e);
            return null;
        }
    }
}

