/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.http;

import com.allcam.acs.http.HttpConfig;
import com.allcam.acs.http.HttpDigest;
import com.allcam.acs.utils.StringUtil;
import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class HttpAuthenticator
implements Authenticator {
    private HttpConfig httpConfig;

    HttpAuthenticator(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public Request authenticate(Route route, Response response) throws IOException {
        if (null == response || response.priorResponse() != null) {
            return null;
        }
        String authStr = response.header("WWW-Authenticate");
        String nonce = StringUtil.getValueFromHeader(authStr, "nonce=");
        String opaque = StringUtil.getValueFromHeader(authStr, "opaque=");
        Request lastReq = response.request();
        if (null == lastReq) {
            return null;
        }
        String url = lastReq.url().toString();
        return lastReq.newBuilder().header("Authorization", this.buildDigest(nonce, opaque, url)).build();
    }

    private String buildDigest(String nonce, String opaque, String url) {
        HttpDigest digest = this.httpConfig.httpDigest;
        if (null == digest) {
            return "";
        }
        return digest.buildDigest(this.httpConfig.un, this.httpConfig.userName, this.httpConfig.password, nonce, opaque, url);
    }
}

