/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.core;

import com.allcam.acs.core.AcHttpDigest;
import com.allcam.acs.core.AcsConfig;
import com.allcam.acs.core.api.ApiInit;
import com.allcam.acs.core.api.FunctionInfo;
import com.allcam.acs.http.HttpConfig;
import com.allcam.acs.http.HttpService;
import com.allcam.acs.json.HttpJsonHandler;
import com.allcam.common.base.BaseRequest;
import com.allcam.common.base.BaseResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcsService {
    private static final Logger LOG = LoggerFactory.getLogger(AcsService.class);
    private static final AcsService INSTANCE = new AcsService();
    private HttpJsonHandler jsonHandler;

    public static AcsService getInstance() {
        return INSTANCE;
    }

    public void init(AcsConfig config) {
        if (config == null) {
            throw new NullPointerException("ai config cannot be null.");
        }
        String host = config.getHost();
        String httpUrl = StringUtils.isBlank((CharSequence)host) ? "http://zhsapp.rongyu360.com/" : (host.startsWith("http") ? host : (0 == config.getPort() || 80 == config.getPort() ? "http://" + config.getHost() + "/" : "http://" + config.getHost() + ":" + config.getPort() + "/"));
        HttpConfig.Builder hcBuilder = new HttpConfig.Builder().httpUrl(httpUrl).httpDigest(new AcHttpDigest()).timeout(config.getHttpTimeout());
        if (StringUtils.isBlank((CharSequence)config.getAppId())) {
            hcBuilder.un("username").userName(config.getUsername()).password(config.getPassword());
        } else {
            hcBuilder.un("appId").userName(config.getAppId()).password(config.getAppSecret());
        }
        HttpService httpService = new HttpService(hcBuilder.build());
        this.jsonHandler = new HttpJsonHandler(httpService);
        this.loadApiMapping();
    }

    private void loadApiMapping() {
        ApiInit.initApiFromFile();
    }

    public <T extends BaseResponse> T request(BaseRequest request) {
        Class<?> rClass;
        FunctionInfo function = ApiInit.getFunctionInfo(request.getClass().getName());
        if (null == function) {
            throw new IllegalArgumentException("request not mapping to api.");
        }
        try {
            rClass = Class.forName(function.getRespClass());
        }
        catch (Exception e) {
            throw new IllegalStateException("class config fail, class not found by name.");
        }
        return (T)this.jsonHandler.post(function.getUrl(), request, rClass);
    }
}

